/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.biz.load;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.bo.MethodCollection;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.bo.ParameterCollection;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.openapi.util.json.JSONUtils;
import com.kingdee.eas.csinterface.biz.ProjectInfo;
import com.kingdee.eas.csinterface.biz.exception.EIPException;
import com.kingdee.eas.csinterface.biz.exception.ParametersNotCompatibleException;
import com.kingdee.eas.csinterface.biz.handler.IPostProcessHandler;
import com.kingdee.eas.csinterface.biz.handler.IPreProcessHandler;
import com.kingdee.eas.csinterface.biz.load.IDataLoader;
import com.kingdee.eas.csinterface.biz.log.MonitorLogManager;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.LineResult;
import com.kingdee.eas.framework.Result;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class AbstractDataLoader
implements IDataLoader {
    private Logger logger = Logger.getLogger(AbstractDataLoader.class);

    public String preHandle(String data, ProjectInfo projectInfo) {
        String preHandleName = projectInfo.getPreHandler();
        if (StringUtils.isEmpty((String)preHandleName)) {
            return data;
        }
        try {
            IPreProcessHandler preHandler = (IPreProcessHandler)Class.forName(preHandleName).newInstance();
            String newData = preHandler.process(data);
            if (newData != null) {
                return newData;
            }
            return data;
        }
        catch (Exception e) {
            this.logger.error((Object)"\u3010EIP\u3011\u6570\u636e\u524d\u7f6e\u5904\u7406\u5f02\u5e38", (Throwable)e);
            throw new EIPException("\u3010EIP\u3011\u6570\u636e\u524d\u7f6e\u5904\u7406\u5f02\u5e38");
        }
    }

    public void postHandle(List<String> successIds, ProjectInfo projectInfo) {
        String postHandleName = projectInfo.getPostHandler();
        try {
            IPostProcessHandler postHandler = (IPostProcessHandler)Class.forName(postHandleName).newInstance();
            postHandler.process(successIds);
        }
        catch (Exception e) {
            this.logger.error((Object)"\u3010EIP\u3011\u6570\u636e\u540e\u7f6e\u5904\u7406\u5f02\u5e38", (Throwable)e);
        }
    }

    public MethodInfo getMethodInfoFromEntryInfo(String methodName, EntityObjectInfo eo, String action) throws BOSException {
        JSONObject methods = JSONObject.parseObject((String)methodName);
        methodName = methods.getString(action);
        MethodInfo methodInfo = null;
        MethodCollection mc = eo.getAllMethodsRuntime();
        for (int i = 0; i < mc.size(); ++i) {
            MethodInfo mi = mc.get(i);
            if (!mi.toString().trim().equals(methodName.trim())) continue;
            methodInfo = mi;
            break;
        }
        if (methodInfo == null) {
            throw new BOSException("eip error.Fail to find the method on metadata.BusinessObjectInfo: " + eo + " methodName: " + methodName);
        }
        return methodInfo;
    }

    public List<Object> getParamsValue(MethodInfo method, Class<IObjectCollection> objectCollectionClass, String data) throws BOSException {
        ParameterCollection pc = method.getParameters();
        if (pc.size() != 1) {
            throw new ParametersNotCompatibleException();
        }
        ArrayList<Object> paramsValue = new ArrayList<Object>();
        IObjectCollection collection = (IObjectCollection)JSONUtils.convertJsonToObject((String)data, objectCollectionClass);
        String baseType = method.getParameters().get(0).getParameterType().getBaseType();
        if ("com.kingdee.eas.framework.CoreBaseInfo".equals(baseType)) {
            for (int i = 0; i < collection.size(); ++i) {
                paramsValue.add(collection.getObject(i));
            }
        } else if ("com.kingdee.eas.framework.CoreBaseCollection".equals(baseType)) {
            CoreBaseCollection objCol = new CoreBaseCollection();
            objCol.addObjectCollection(collection);
            paramsValue.add(objCol);
        } else {
            throw new ParametersNotCompatibleException();
        }
        return paramsValue;
    }

    public List<String> parseResult(Object[] results) {
        int count = 0;
        ArrayList<String> success = new ArrayList<String>();
        ArrayList<String> fail = new ArrayList<String>();
        for (Object result : results) {
            if (result instanceof IObjectPK) {
                ++count;
                success.add(result.toString());
                continue;
            }
            if (!(result instanceof Result)) continue;
            Result real = (Result)result;
            for (int i = 0; i < real.size(); ++i) {
                ++count;
                LineResult lineResult = real.getLineResult(i);
                if (lineResult.isSucess()) {
                    success.add(lineResult.getPk().toString());
                    continue;
                }
                fail.add(lineResult.getException().getMessage());
            }
        }
        StringBuilder msg = new StringBuilder("\u96c6\u6210\u603b\u6570\uff1a").append(count).append("\n");
        if (!success.isEmpty()) {
            msg.append("\u96c6\u6210\u6210\u529f\u6570\uff1a").append(success.size()).append("\n").append("\u76ee\u6807id\uff1a").append(this.toString(success)).append("\n");
        }
        if (!fail.isEmpty()) {
            msg.append("\u96c6\u6210\u5931\u8d25\u6570\uff1a").append(fail.size()).append("\n").append("\u5931\u8d25\u539f\u56e0").append(this.toString(fail)).append("\n");
        }
        MonitorLogManager.success(msg.toString());
        return success;
    }

    private String toString(List<String> list) {
        StringBuilder sb = new StringBuilder();
        for (String l : list) {
            sb.append("[").append(l).append("]").append(",");
        }
        return sb.toString();
    }
}

