/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.biz.log;

import com.kingdee.bos.Context;
import com.kingdee.eas.csinterface.basedatasyn.app.util.EIPConfiguration;
import com.kingdee.eas.csinterface.biz.DataSourceInfo;
import com.kingdee.eas.csinterface.biz.ProjectInfo;
import com.kingdee.eas.csinterface.biz.app.ActionType;
import com.kingdee.eas.csinterface.biz.context.EIPContext;
import com.kingdee.eas.csinterface.monitor.MonitorLogFactory;
import com.kingdee.eas.csinterface.monitor.MonitorLogInfo;
import com.kingdee.eas.csinterface.monitor.MonitorlogType;
import com.kingdee.eas.csinterface.util.MessageSender;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public class MonitorLogManager {
    private static final Logger logger = Logger.getLogger(MonitorLogManager.class);
    private static final ThreadLocal<MonitorLogInfo> threadMonitor = new ThreadLocal();

    private MonitorLogManager() {
    }

    public static void enter(ActionType type) {
        EIPContext eipCtx = EIPContext.getInstance();
        Context ctx = eipCtx.getContext();
        MonitorLogInfo monitorLogInfo = new MonitorLogInfo();
        monitorLogInfo.setStartTime(new Timestamp(System.currentTimeMillis()));
        monitorLogInfo.setLogType(ActionType.BASEDATAMAPPING.equals((Object)type) ? MonitorlogType.baseDataAutoMatch : MonitorlogType.easBillMapping);
        monitorLogInfo.setOperator(ctx.getUserName());
        monitorLogInfo.setOperatorType(ActionType.BASEDATAMAPPING.equals((Object)type) ? "\u81ea\u52a8\u5339\u914d\u503c\u6620\u5c04" : "\u751f\u6210\u76ee\u6807\u5355\u636e");
        String operatorSource = (String)eipCtx.get("operatorSource");
        monitorLogInfo.setOperatorSource(operatorSource == null ? "Schdule Task" : operatorSource);
        monitorLogInfo.setStatus("\u6b63\u5728\u8fd0\u884c");
        monitorLogInfo.setRpcPort(System.getProperty("EAS_RPC_PORT"));
        String serverName = System.getProperty("cas.client.serverName");
        if (!StringUtils.isEmpty((String)serverName)) {
            String[] serverInfo = serverName.split(":");
            if (serverInfo.length == 2) {
                monitorLogInfo.setServerIp(serverInfo[0]);
                monitorLogInfo.setHttpPort(serverInfo[1]);
            } else if (serverInfo.length == 1) {
                monitorLogInfo.setServerIp(serverInfo[0]);
            }
        }
        monitorLogInfo.setServerName(System.getProperty("EAS_INSTANCE_NAME"));
        String summary = "(" + monitorLogInfo.getServerName() + ")" + monitorLogInfo.getOperatorType();
        monitorLogInfo.setSummary(summary.length() > 255 ? summary.substring(0, 254) + "\u2026" : summary);
        monitorLogInfo.setServerTag(EIPConfiguration.Instance().getServerTag());
        threadMonitor.set(monitorLogInfo);
    }

    public static void enterProject(ProjectInfo projectInfo) {
        MonitorLogInfo monitorLogInfo = threadMonitor.get();
        monitorLogInfo.setBillNumber(projectInfo.getNumber() + "(" + projectInfo.getName() + ")");
        monitorLogInfo.setSrcWhere(projectInfo.getSrcFilter());
        String content = "\u4f20\u8f93\u65b9\u6848\u7f16\u7801\uff1a" + projectInfo.getNumber() + "\n";
        MonitorLogManager.enterContent(content);
    }

    public static void enterDataSource(DataSourceInfo dataSourceInfo) {
        String content = "\u4f20\u8f93\u6570\u636e\u6e90\u7f16\u7801\uff1a" + dataSourceInfo.getNumber() + "\n" + "\u4f20\u8f93\u4e3b\u89c6\u56fe\uff1a" + dataSourceInfo.getMainView() + "\n";
        MonitorLogManager.enterContent(content);
    }

    public static void enterContent(String content) {
        MonitorLogInfo monitorLogInfo = threadMonitor.get();
        String con = monitorLogInfo.getContent();
        if (StringUtils.isEmpty((String)con)) {
            con = "";
        }
        monitorLogInfo.setContent(con + content);
    }

    public static void warn(String msg) {
        MonitorLogInfo monitorLogInfo = threadMonitor.get();
        if (msg != null) {
            MonitorLogManager.enterContent(msg);
        }
        monitorLogInfo.setStatus("\u8b66\u544a");
    }

    public static void success(String msg) {
        MonitorLogInfo monitorLogInfo = threadMonitor.get();
        if (msg != null) {
            MonitorLogManager.enterContent(msg);
        }
        monitorLogInfo.setStatus("\u6210\u529f");
    }

    public static void error(String msg, String trace) {
        MonitorLogInfo monitorLogInfo = threadMonitor.get();
        if (msg != null) {
            MonitorLogManager.enterContent(msg);
        }
        if (trace != null) {
            monitorLogInfo.setStackTrace(trace);
        }
        monitorLogInfo.setStatus("\u5f02\u5e38");
    }

    public static void exit() {
        Context ctx = EIPContext.getInstance().getContext();
        MonitorLogInfo monitorLogInfo = threadMonitor.get();
        monitorLogInfo.setDuration(MonitorLogManager.getDurationDesc(System.currentTimeMillis() - monitorLogInfo.getStartTime().getTime()));
        try {
            MonitorLogFactory.getLocalInstance(ctx).save((CoreBaseInfo)monitorLogInfo);
        }
        catch (Exception e) {
            logger.error((Object)"\u4fdd\u5b58\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
        }
        MessageSender.getInstance().send(ctx, monitorLogInfo);
        threadMonitor.set(null);
    }

    private static String getDurationDesc(long t) {
        long hour = t / 3600000L;
        long left = t % 3600000L;
        long minus = left / 60000L;
        long second = (left %= 60000L) / 1000L;
        return hour + "\u65f6" + minus + "\u5206" + second + "\u79d2" + (left %= 1000L) + "\u6beb\u79d2";
    }
}

