/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.data;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.csinterface.billmapping.app.util.TempTableUtil;
import com.kingdee.eas.csinterface.common.DIPException;
import com.kingdee.eas.csinterface.data.model.StructuredDataModel;
import com.kingdee.eas.csinterface.data.model.StructuredTableData;
import com.kingdee.eas.csinterface.data.process.DataProcessFactory;
import com.kingdee.eas.csinterface.data.process.IBatchProcessor;
import com.kingdee.eas.csinterface.data.process.IRowProcessor;
import com.kingdee.eas.csinterface.data.process.impl.BaseDataConvertBatchProcessor;
import com.kingdee.eas.csinterface.data.process.impl.MidBillDataFilterProcessor;
import com.kingdee.eas.csinterface.data.process.impl.MidBillSaveBatchProcessor;
import com.kingdee.eas.csinterface.data.process.impl.TypeConversionProcessor;
import com.kingdee.eas.csinterface.data.provider.DataProviderStrategy;
import com.kingdee.eas.csinterface.data.provider.FlatData;
import com.kingdee.eas.csinterface.data.provider.IDataProvider;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionInfo;
import com.kingdee.eas.csinterface.syncdatabase.DBType;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DataExtractor {
    private static final Logger logger = Logger.getLogger(DataExtractor.class);
    private IDataProvider dataProvider;
    private StructuredDataModel dataModel;
    private FlatData flatData;
    private StructuredTableData structuredTableData;
    private static final List<IRowProcessor> defaultRowProcessors;
    private static final List<IBatchProcessor> defaultBatchProcessors;
    public static boolean isNewType;
    private List<IRowProcessor> rowProcessors;
    private List<IBatchProcessor> batchProcessors;

    public DataExtractor(IDataProvider dataProvider, StructuredDataModel dataModel, List<IRowProcessor> rowProcessors, List<IBatchProcessor> batchProcessors) {
        if (dataProvider == null || dataModel == null) {
            throw new NullPointerException();
        }
        this.dataProvider = dataProvider;
        this.dataModel = dataModel;
        this.rowProcessors = rowProcessors == null ? defaultRowProcessors : rowProcessors;
        this.batchProcessors = batchProcessors == null ? defaultBatchProcessors : batchProcessors;
    }

    public DataExtractor(IDataProvider dataProvider, StructuredDataModel dataModel) {
        this(dataProvider, dataModel, null, null);
    }

    public DataExtractor(String dataProviderID, StructuredDataModel dataModel) throws DIPException {
        this(DataProviderStrategy.findDataProvider(dataProviderID), dataModel, null, null);
    }

    public FlatData getFlatData() {
        return this.flatData;
    }

    public StructuredTableData getStructuredTableData() {
        return this.structuredTableData;
    }

    public static StructuredTableData importStructuredTableData(Context ctx, StructuredDataModel dataModel, StructuredTableData structuredTableData, boolean transformType) throws DIPException {
        if (structuredTableData.getFirstTableRows().size() > 0) {
            LinkedList<IRowProcessor> rowProcessors = new LinkedList<IRowProcessor>();
            LinkedList<IBatchProcessor> batchProcessors = new LinkedList<IBatchProcessor>();
            rowProcessors.addAll(defaultRowProcessors);
            batchProcessors.addAll(defaultBatchProcessors);
            if (transformType) {
                rowProcessors.add(new TypeConversionProcessor());
            }
            StructuredTableData succeedStructuredTableData = DataProcessFactory.process(ctx, structuredTableData, dataModel, rowProcessors, batchProcessors);
            return succeedStructuredTableData;
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public void extract(Context ctx, Map param, boolean save) throws DIPException, BOSException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 33[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int getBatchSize(List<Object> listPks, int headpkCount, int pageSize) {
        if (isNewType) {
            return (headpkCount - 1) / pageSize + 1;
        }
        return (listPks.size() - 1) / pageSize + 1;
    }

    private DBType fillParamInfo(Map param, String pkTableName, int pageSize, boolean save) throws DIPException {
        Object subPks = null;
        ConnectionInfo conInfo = (ConnectionInfo)this.dataModel.getProperty("srcDBConn");
        DBType dbType = conInfo.getDBType();
        param.put("DBTYPE", dbType);
        param.put("pkTableName", pkTableName);
        param.put("srcCon", this.dataProvider.getConnection());
        param.put("srcConName", conInfo.getInstance().toString());
        param.put("pageSize", pageSize);
        param.put("tempTableName", TempTableUtil.getTempTableName((DBType)dbType, (String)pkTableName));
        param.put("isBillGetSrcData", save);
        param.put("i", 0);
        param.put("SUB_PKS", subPks);
        param.put("save", save);
        return dbType;
    }

    static {
        isNewType = true;
        defaultRowProcessors = new ArrayList<IRowProcessor>();
        defaultBatchProcessors = new ArrayList<IBatchProcessor>();
        defaultBatchProcessors.add(new MidBillDataFilterProcessor());
        defaultBatchProcessors.add(new BaseDataConvertBatchProcessor());
        defaultBatchProcessors.add(new MidBillSaveBatchProcessor());
    }
}

