/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.data.process.impl;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.eas.csinterface.bizbill.metadata.info.DIPMetadata;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.DBUtils;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.UictUtils;
import com.kingdee.eas.csinterface.common.DIPException;
import com.kingdee.eas.csinterface.data.model.DataRow;
import com.kingdee.eas.csinterface.data.model.DataTable;
import com.kingdee.eas.csinterface.data.model.StructuredDataModel;
import com.kingdee.eas.csinterface.data.model.StructuredTableData;
import com.kingdee.eas.csinterface.data.process.IBatchProcessor;
import com.kingdee.eas.csinterface.monitor.app.MonitorManager;
import com.kingdee.eas.csinterface.monitor.app.SrcToMidBillMonitorLogInfo;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;

public class MidBillDataFilterProcessor
implements IBatchProcessor {
    @Override
    public String getProcessorID() {
        return "MidBillDataFilterProcessor";
    }

    @Override
    public StructuredTableData process(Context ctx, StructuredTableData structuredTableData, StructuredDataModel structuredDataModel) throws DIPException {
        StructuredTableData structuredTableData2;
        StructuredDataModel.TableModel headerModel = structuredDataModel.getPriorityTables()[0];
        List headDataRows = structuredTableData.getFirstTableRows();
        if (headDataRows == null || headDataRows.size() <= 0) {
            return structuredTableData;
        }
        StringBuffer headIds = new StringBuffer();
        for (int i = 0; i < headDataRows.size(); ++i) {
            if (i > 0) {
                headIds.append(",");
            }
            headIds.append("?");
        }
        DIPMetadata dm = new DIPMetadata(structuredDataModel.getModelName());
        String headId = this.getDBFieldNameOfHeaderId(structuredDataModel, dm);
        String headerTableName = DIPMetadata.getShortName(dm.getHeaderTablePK());
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet rs = null;
        try {
            connection = DBUtils.getConnection(ctx);
            preparedStatement = connection.prepareStatement("select " + headId + " from " + headerTableName + " where " + headId + " in (" + headIds.toString() + ")");
            for (int i = 0; i < headDataRows.size(); ++i) {
                preparedStatement.setObject(i + 1, ((DataRow)headDataRows.get(i)).getValues().get(headerModel.pkColumn.name));
            }
            rs = preparedStatement.executeQuery();
            Object pkVal = null;
            StructuredTableData filteredTableData = (StructuredTableData)structuredTableData.clone();
            DataTable headDataTable = filteredTableData.getFirstDataTable();
            int billCount = headDataTable.size();
            List repeatedHeadPKS = MonitorManager.getCurrentSrcToMidBill().getHeadpks();
            while (rs.next()) {
                pkVal = rs.getObject(1);
                if (!headDataTable.remove(pkVal)) {
                    throw new DIPException("\u8fc7\u6ee4\u91cd\u590d\u6570\u636e\u5931\u8d25\uff1a\u5185\u5b58\u6570\u636e\u65e0\u6cd5\u5220\u9664\u4e3b\u952e\u503c='" + pkVal + "'\u7684\u6570\u636e\u884c");
                }
                if (pkVal == null) continue;
                repeatedHeadPKS.add(pkVal.toString());
            }
            SrcToMidBillMonitorLogInfo srcToMidBillMonitorLogInfo = MonitorManager.getCurrentSrcToMidBill();
            srcToMidBillMonitorLogInfo.addFilteredBillCount(billCount - headDataTable.size());
            srcToMidBillMonitorLogInfo.setHeadpks(repeatedHeadPKS);
            structuredTableData2 = filteredTableData;
        }
        catch (Exception e) {
            try {
                throw new DIPException("\u67e5\u8be2\u4e2d\u95f4\u8868\u6570\u636e\u5931\u8d25\uff1a" + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, preparedStatement, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)preparedStatement, (Connection)connection);
        return structuredTableData2;
    }

    private String getDBFieldNameOfHeaderId(StructuredDataModel structuredDataModel, DIPMetadata dm) {
        StructuredDataModel.TableModel headerModel = structuredDataModel.getPriorityTables()[0];
        String mappingHeaderName = headerModel.pkColumn.destName;
        EntityObjectInfo entityInfo = UictUtils.loadEntity((IMetaDataPK)new MetaDataPK(dm.getHeaderEntityPK()));
        PropertyCollection pcs = entityInfo.getProperties();
        PropertyInfo pInfo = (PropertyInfo)pcs.getObject((Object)mappingHeaderName);
        ColumnInfo headerIdColumnInfo = pInfo.getMappingField();
        return headerIdColumnInfo.getName();
    }
}

