/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.data.provider.db;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.csinterface.common.DIPException;
import com.kingdee.eas.csinterface.data.DataColumn;
import com.kingdee.eas.csinterface.data.model.DataRow;
import com.kingdee.eas.csinterface.data.model.StructuredDataModel;
import com.kingdee.eas.csinterface.data.model.StructuredTableData;
import com.kingdee.eas.csinterface.data.provider.FlatData;
import com.kingdee.eas.csinterface.data.provider.IDataProvider;
import com.kingdee.eas.csinterface.data.snapshot.ChangefulBillData;
import com.kingdee.eas.csinterface.data.util.MiddleBillDataProviderThread;
import com.kingdee.eas.csinterface.monitor.app.FeedBackManager;
import com.kingdee.eas.csinterface.monitor.app.MonitorManager;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionInfo;
import com.kingdee.eas.csinterface.syncdatabase.DBType;
import com.kingdee.eas.csinterface.utils.KSQLUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;

public class MiddleBillDataProviderNew
implements IDataProvider {
    private static final Logger logger = Logger.getLogger(MiddleBillDataProviderNew.class);
    public static final int MAX_FETCH_SIZE = 1000;
    public static final int DEFAULT_FETCH_SIZE = 500;
    private Connection connection;
    private PreparedStatement readingStatement;
    private PreparedStatement readingStatement1;
    private PreparedStatement readingStatement2;
    private PreparedStatement writePkBackStatment;
    private StructuredDataModel dataModel;
    private DataColumn[] flatDataColumns;
    private String pkTableName;
    private String srcViewName;
    private String srcWhere;
    private int pageSize;
    private StringBuffer queryString;
    private int realPageSize;
    private int headpkIndex;
    private String[] sortedChangefulFields;
    private boolean isOracle;

    public MiddleBillDataProviderNew(StructuredDataModel dataModel) {
        this.dataModel = dataModel;
        this.srcWhere = StringUtils.trim((String)((String)this.dataModel.getProperty("srcWhere")));
        this.srcViewName = (String)this.dataModel.getProperty("srcViewName");
        this.pkTableName = (String)this.dataModel.getProperty("pkTableName");
        StructuredDataModel.TableModel[] tableModels = dataModel.getPriorityTables();
        ArrayList<DataColumn> flatDataColumns = new ArrayList<DataColumn>();
        for (int i = 0; i < tableModels.length; ++i) {
            for (int j = 0; j < tableModels[i].columns.length; ++j) {
                DataColumn column = new DataColumn(tableModels[i].columns[j].name, tableModels[i].columns[j].alias);
                flatDataColumns.add(column);
            }
        }
        this.flatDataColumns = flatDataColumns.toArray(new DataColumn[0]);
        this.isOracle = ((ConnectionInfo)this.dataModel.getProperty("srcDBConn")).getDBType().equals((Object)DBType.Oracle);
        this.sortedChangefulFields = ChangefulBillData.getSortedChangefulFields(dataModel);
    }

    @Override
    public void open() throws DIPException {
        try {
            ConnectionInfo connectionInfo = (ConnectionInfo)this.dataModel.getProperty("srcDBConn");
            this.connection = KSQLUtil.getConnection(connectionInfo);
            this.connection.setAutoCommit(true);
        }
        catch (Exception e) {
            throw new DIPException("\u6253\u5f00\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25:" + e.getMessage(), e);
        }
        try {
            ChangefulBillData.addHashCodeColumnIfNeed(this.connection, this.pkTableName);
            ChangefulBillData.addCreateTimeColumnIfNeed(this.connection, this.pkTableName);
        }
        catch (SQLException e) {
            throw new DIPException(e.getMessage(), e);
        }
    }

    @Override
    public Connection getConnection() throws DIPException {
        return this.connection;
    }

    @Override
    public FlatData fetchData(Map param) throws DIPException {
        if (this.pageSize <= 0) {
            try {
                Object pageSize = param.get("pageSize");
                this.pageSize = pageSize == null ? 500 : Integer.parseInt(pageSize.toString());
                this.pageSize = this.pageSize > 1000 ? 500 : this.pageSize;
            }
            catch (Exception e) {
                this.pageSize = 500;
            }
        }
        List subPks = null;
        String filterString = null;
        if (param != null && (subPks = (List)param.get("SUB_PKS")) != null) {
            filterString = StringUtils.arrayToString((Object[])subPks.toArray(), (String)",");
        }
        ResultSet rs1 = null;
        ResultSet rs2 = null;
        Object headpkVal = null;
        Object lastHeadpkVal = null;
        Object headpkValEntry = null;
        ChangefulBillData changefulBillData = null;
        StructuredDataModel.TableModel[] tableModels = this.dataModel.getPriorityTables();
        FlatData flatData = new FlatData(this.flatDataColumns);
        int headCount = tableModels[0].columns.length;
        int entryCount = tableModels[1].columns.length;
        StringBuffer queryString1 = this.initQueryString1(filterString);
        StringBuffer queryString2 = this.initQueryString2(filterString);
        ExecutorService exec = Executors.newFixedThreadPool(2);
        try {
            rs1 = exec.submit(new MiddleBillDataProviderThread(filterString, queryString1, this.connection)).get();
            rs2 = exec.submit(new MiddleBillDataProviderThread(filterString, queryString2, this.connection)).get();
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
            throw new DIPException("get data error", e1);
        }
        catch (ExecutionException e1) {
            e1.printStackTrace();
            throw new DIPException("get data error", e1);
        }
        exec.shutdown();
        try {
            Boolean flag = false;
            FlatData.FlatDataRow flatDataRow2 = flatData.createFlatDataRow();
            block14: while (rs1.next()) {
                headpkVal = rs1.getObject(this.headpkIndex);
                if (headpkVal == null) {
                    throw new NullPointerException("headpk column value is null!");
                }
                FlatData.FlatDataRow flatDataRow = flatData.createFlatDataRow();
                for (int rs1Column = 1; rs1Column <= headCount; ++rs1Column) {
                    Object obj1 = rs1.getObject(rs1Column);
                    if (obj1 instanceof BigDecimal) {
                        obj1 = ((BigDecimal)obj1).toPlainString();
                    }
                    flatDataRow.set(rs1Column - 1, obj1);
                }
                int rs1ColumnNew = 1;
                if (flag.booleanValue()) {
                    if (changefulBillData != null) {
                        changefulBillData.appendFieldBytes(rs1, rs2);
                    }
                    FlatData.FlatDataRow flatDataRow3 = null;
                    try {
                        flatDataRow3 = (FlatData.FlatDataRow)flatDataRow2.deepClone();
                    }
                    catch (Exception e) {
                        logger.info((Object)(flatDataRow + "\u5bf9\u8c61\u590d\u5236\u5f02\u5e38\uff01"), (Throwable)e);
                        throw new DIPException(flatDataRow + "\u5bf9\u8c61\u590d\u5236\u5f02\u5e38!", e);
                    }
                    while (rs1ColumnNew <= headCount) {
                        Object obj1 = rs1.getObject(rs1ColumnNew);
                        if (obj1 instanceof BigDecimal) {
                            obj1 = ((BigDecimal)obj1).toPlainString();
                        }
                        flatDataRow3.set(rs1ColumnNew - 1, obj1);
                        ++rs1ColumnNew;
                    }
                    flatData.addDataRow(flatDataRow3);
                    flag = false;
                }
                while (rs2.next()) {
                    int rs2Column;
                    headpkValEntry = rs2.getObject(this.headpkIndex);
                    if (!headpkValEntry.equals(lastHeadpkVal)) {
                        if (changefulBillData != null) {
                            changefulBillData.snapshot();
                            flatData.putBillDataHashCode(lastHeadpkVal, changefulBillData.getNewHashCode());
                        }
                        lastHeadpkVal = headpkValEntry;
                        if (this.sortedChangefulFields != null && this.sortedChangefulFields.length != 0) {
                            changefulBillData = new ChangefulBillData(this.sortedChangefulFields, this.isOracle, true);
                        }
                    }
                    if (headpkVal.equals(headpkValEntry)) {
                        FlatData.FlatDataRow flatDataRow1 = null;
                        if (changefulBillData != null) {
                            changefulBillData.appendFieldBytes(rs1, rs2);
                        }
                        try {
                            flatDataRow1 = (FlatData.FlatDataRow)flatDataRow.deepClone();
                        }
                        catch (Exception e) {
                            logger.info((Object)(flatDataRow + "\u5bf9\u8c61\u590d\u5236\u5f02\u5e38!"), (Throwable)e);
                            throw new DIPException(flatDataRow + "\u5bf9\u8c61\u590d\u5236\u5f02\u5e38\uff01", e);
                        }
                        while (rs2Column <= entryCount) {
                            Object obj2 = rs2.getObject(rs2Column + 1);
                            if (obj2 instanceof BigDecimal) {
                                obj2 = ((BigDecimal)obj2).toPlainString();
                            }
                            flatDataRow1.set(headCount + rs2Column - 1, obj2);
                            ++rs2Column;
                        }
                        flatData.addDataRow(flatDataRow1);
                        continue;
                    }
                    flatDataRow2 = flatData.createFlatDataRow();
                    for (rs2Column = 1; rs2Column <= entryCount; ++rs2Column) {
                        Object obj2 = rs2.getObject(rs2Column + 1);
                        if (obj2 instanceof BigDecimal) {
                            obj2 = ((BigDecimal)obj2).toPlainString();
                        }
                        flatDataRow2.set(headCount + rs2Column - 1, obj2);
                    }
                    flag = true;
                    continue block14;
                }
            }
            if (changefulBillData != null) {
                changefulBillData.snapshot();
                flatData.putBillDataHashCode(headpkVal, changefulBillData.getNewHashCode());
            }
            FlatData flatData2 = flatData;
            return flatData2;
        }
        catch (SQLException e) {
            logger.info((Object)("::::SQL\uff1a" + this.queryString));
            throw new DIPException("\u8bfb\u53d6\u6570\u636e\u5f02\u5e38: " + e.getMessage() + (StringUtils.isEmpty((String)filterString) ? "" : "\uff0c\u7528\u6237\u5b9a\u5236\u67e5\u8be2\u6761\u4ef6\u4e3a\uff1a\u201c" + filterString + "\u201d"), e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs1);
            SQLUtils.cleanup((ResultSet)rs2);
        }
    }

    private StringBuffer initQueryString1(String filterString) {
        StructuredDataModel.TableModel[] tableModels = this.dataModel.getPriorityTables();
        StructuredDataModel.TableModel header = tableModels[0];
        StructuredDataModel.TableModel entry = tableModels[1];
        StringBuffer sqlBuf1 = new StringBuffer();
        sqlBuf1.append("select distinct ");
        String headPkName = null;
        int colNum = 0;
        for (int i = 0; i < header.columns.length; ++i) {
            if (colNum > 0) {
                sqlBuf1.append(", ");
            }
            if (header.columns[i].isPk) {
                headPkName = header.columns[i].name;
                this.headpkIndex = i + 1;
            }
            sqlBuf1.append("v1.").append(header.columns[i].name);
            ++colNum;
        }
        sqlBuf1.append(" from ").append(this.srcViewName).append(" as v1");
        sqlBuf1.append(" where v1.").append(headPkName).append(" in (");
        sqlBuf1.append(filterString);
        sqlBuf1.append(") order by v1.").append(headPkName).append(" asc");
        return sqlBuf1;
    }

    private StringBuffer initQueryString2(String filterString) {
        StructuredDataModel.TableModel[] tableModels = this.dataModel.getPriorityTables();
        StructuredDataModel.TableModel header = tableModels[0];
        StructuredDataModel.TableModel entry = tableModels[1];
        StringBuffer sqlBuf2 = new StringBuffer();
        sqlBuf2.append("select distinct ");
        String headPkName = null;
        String entryPkName = null;
        int colNum = 0;
        int i = 0;
        if (i < header.columns.length) {
            if (header.columns[i].isPk) {
                headPkName = header.columns[i].name;
                this.headpkIndex = i + 1;
            }
            sqlBuf2.append("v1.").append(header.columns[i].name);
            ++colNum;
        }
        for (i = 0; i < entry.columns.length; ++i) {
            if (colNum > 0) {
                sqlBuf2.append(", ");
            }
            if (entry.columns[i].isPk) {
                entryPkName = entry.columns[i].name;
            }
            sqlBuf2.append("v1.").append(entry.columns[i].name);
        }
        sqlBuf2.append(" from ").append(this.srcViewName).append(" as v1");
        sqlBuf2.append(" where v1.").append(headPkName).append(" in (");
        sqlBuf2.append(filterString);
        sqlBuf2.append(") order by v1.").append(headPkName).append(", v1.").append(entryPkName).append(" asc");
        return sqlBuf2;
    }

    private void initQueryString(String filterString) {
        int i;
        StructuredDataModel.TableModel[] tableModels = this.dataModel.getPriorityTables();
        StructuredDataModel.TableModel header = tableModels[0];
        StructuredDataModel.TableModel entry = tableModels[1];
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("select distinct ");
        String headPkName = null;
        String entryPkName = null;
        int colNum = 0;
        for (i = 0; i < header.columns.length; ++i) {
            if (colNum > 0) {
                sqlBuf.append(", ");
            }
            if (header.columns[i].isPk) {
                headPkName = header.columns[i].name;
                this.headpkIndex = i + 1;
            }
            sqlBuf.append("v1.").append(header.columns[i].name);
            ++colNum;
        }
        for (i = 0; i < entry.columns.length; ++i) {
            if (colNum > 0) {
                sqlBuf.append(", ");
            }
            if (entry.columns[i].isPk) {
                entryPkName = entry.columns[i].name;
            }
            sqlBuf.append("v1.").append(entry.columns[i].name);
        }
        sqlBuf.append(" from ").append(this.srcViewName).append(" as v1");
        sqlBuf.append(" where v1.").append(headPkName).append(" in (");
        sqlBuf.append(filterString);
        sqlBuf.append(") order by v1.").append(headPkName).append(", v1.").append(entryPkName).append(" asc");
        this.queryString = sqlBuf;
    }

    @Override
    public List<Object> findAllHeadPks(Map param) throws BOSException {
        ArrayList<Object> result = new ArrayList<Object>();
        String filterString = null;
        if (param != null) {
            filterString = (String)param.get("filter");
        }
        StringBuilder sqlBuf = new StringBuilder();
        String headPkName = null;
        StructuredDataModel.TableModel[] tableModels = this.dataModel.getPriorityTables();
        StructuredDataModel.TableModel header = tableModels[0];
        for (int i = 0; i < header.columns.length; ++i) {
            if (!header.columns[i].isPk) continue;
            headPkName = header.columns[i].name;
        }
        int pageSize = this.getPageSize(param);
        if (pageSize == 0) {
            sqlBuf.append(" select top 0 v3.").append(headPkName).append(" from (");
        } else {
            sqlBuf.append(" select  v3.").append(headPkName).append(" from (");
        }
        sqlBuf.append("select v2.").append(headPkName).append(" from ").append(this.srcViewName).append(" as v2").append(" where 1=1");
        if (!StringUtils.isEmpty((String)this.srcWhere)) {
            if (StringUtils.startsWithIgnoreCase((String)this.srcWhere, (String)"where")) {
                this.srcWhere = this.srcWhere.replaceAll("^(?im)where", "");
            }
            if (this.srcWhere.matches("(?im)^and.*")) {
                sqlBuf.append(" ").append(this.srcWhere);
            } else {
                sqlBuf.append(" and (").append(this.srcWhere).append(")");
            }
        }
        if (!StringUtils.isEmpty((String)filterString)) {
            if (!(filterString = filterString.trim()).matches("(?im)^and.*")) {
                sqlBuf.append(" and ");
            }
            sqlBuf.append(" (").append(filterString).append(" ) ");
        }
        if (!"and".equalsIgnoreCase(sqlBuf.substring(sqlBuf.length() - 3, sqlBuf.length()))) {
            sqlBuf.append(" and");
        }
        sqlBuf.append(" not exists(select 1 from ").append(this.pkTableName).append(" as p").append(" where v2.").append(headPkName).append(" = p.headpk").append(")");
        sqlBuf.append(" group by v2.").append(headPkName);
        sqlBuf.append(") as v3");
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            statement = this.connection.prepareStatement(sqlBuf.toString(), 1003, 1007);
            rs = statement.executeQuery();
            while (rs.next()) {
                result.add("'" + rs.getString(1) + "'");
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, statement);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement);
        return result;
    }

    @Override
    public boolean hasNext() {
        return this.realPageSize >= this.pageSize;
    }

    @Override
    public void close() throws DIPException {
        SQLUtils.cleanup((Statement)this.writePkBackStatment);
        SQLUtils.cleanup((Statement)this.readingStatement);
        SQLUtils.cleanup((Connection)this.connection);
    }

    @Override
    public String getProviderID() {
        return this.toString();
    }

    @Override
    public String getDescription() {
        return "HD\u5355\u636e\u6570\u636e\u6e90";
    }

    @Override
    public void feedbackFinishStructured(FlatData succeedFlatData, StructuredTableData structuredTableData) throws DIPException {
        this.realPageSize = structuredTableData == null || structuredTableData.getFirstTableRows() == null ? 0 : structuredTableData.getFirstTableRows().size();
    }

    @Override
    public void feedbackFinish(StructuredTableData structuredTableData, StructuredTableData succeedStructuredTableData) throws DIPException {
        if (succeedStructuredTableData == null || succeedStructuredTableData.getFirstTableRows() == null) {
            return;
        }
        Map<Object, String> billDataHashCodeMap = succeedStructuredTableData.getBillDataHashCodeMap();
        List headDataRows = succeedStructuredTableData.getFirstTableRows();
        if (headDataRows != null && headDataRows.size() > 0) {
            String pkColumn = ((DataRow)headDataRows.get((int)0)).pkColumn;
            int count = 0;
            try {
                if (this.writePkBackStatment == null) {
                    this.writePkBackStatment = this.connection.prepareStatement("insert into " + this.pkTableName + "(" + "headpk" + "," + "hashCode" + "," + "createTime" + ") values (?,?,?)");
                }
                Date now = new Date();
                Timestamp time = new Timestamp(now.getTime());
                for (int i = 0; i < headDataRows.size(); ++i) {
                    Object headpk = ((DataRow)headDataRows.get(i)).getValues().get(pkColumn);
                    this.writePkBackStatment.setObject(1, headpk);
                    this.writePkBackStatment.setString(2, billDataHashCodeMap.get(headpk));
                    this.writePkBackStatment.setObject(3, time);
                    this.writePkBackStatment.executeUpdate();
                    ++count;
                }
                MonitorManager.getCurrentSrcToMidBill().addWriteBackCount(count);
            }
            catch (SQLException e) {
                throw new DIPException("\u53cd\u5199\u589e\u91cf\u8868\u65f6\u5931\u8d25:" + e.getMessage(), e);
            }
            finally {
                try {
                    logger.info((Object)("EIP\u6210\u529f\u53cd\u5199" + count + "\u6761\u589e\u91cf\u8868\u6570\u636e"));
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public void feedbackFinish(List<String> list) throws DIPException {
        if (list == null || list.size() == 0) {
            return;
        }
        int count = 0;
        try {
            if (this.writePkBackStatment == null) {
                this.writePkBackStatment = this.connection.prepareStatement("insert into " + this.pkTableName + "(" + "headpk" + "," + "hashCode" + "," + "createTime" + ") values (?,?,?)");
            }
            Date now = new Date();
            Timestamp time = new Timestamp(now.getTime());
            for (int i = 0; i < list.size(); ++i) {
                String headpk = list.get(i);
                this.writePkBackStatment.setObject(1, headpk);
                this.writePkBackStatment.setString(2, null);
                this.writePkBackStatment.setObject(3, time);
                this.writePkBackStatment.executeUpdate();
                ++count;
            }
            MonitorManager.getCurrentSrcToMidBill().addWriteBackCount(count);
        }
        catch (SQLException e) {
            throw new DIPException("\u53cd\u5199\u589e\u91cf\u8868\u65f6\u5931\u8d25:" + e.getMessage(), e);
        }
        finally {
            try {
                logger.info((Object)("EIP\u6210\u529f\u53cd\u5199" + count + "\u6761\u589e\u91cf\u8868\u6570\u636e"));
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getBillCount(StructuredTableData structuredTableData, String filterString) throws BOSException {
        StructuredDataModel.TableModel[] tableModels = this.dataModel.getPriorityTables();
        StructuredDataModel.TableModel header = tableModels[0];
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("select count(*) as total, count(distinct ");
        String headPkName = null;
        for (int i = 0; i < header.columns.length; ++i) {
            if (!header.columns[i].isPk) continue;
            headPkName = header.columns[i].name;
            sqlBuf.append("v1.").append(header.columns[i].name).append(") as bill ");
            break;
        }
        sqlBuf.append(" from ").append(this.srcViewName).append(" as v1");
        sqlBuf.append(" where v1.").append(headPkName).append(" in (");
        sqlBuf.append(" select v3.").append(headPkName).append(" from (");
        sqlBuf.append("select v2.").append(headPkName).append(" from ").append(this.srcViewName).append(" as v2").append(" where 1=1");
        if (!StringUtils.isEmpty((String)this.srcWhere)) {
            if (StringUtils.startsWithIgnoreCase((String)this.srcWhere, (String)"where")) {
                this.srcWhere = this.srcWhere.replaceAll("^(?im)where", "");
            }
            if (this.srcWhere.matches("(?im)^and.*")) {
                sqlBuf.append(" ").append(this.srcWhere);
            } else {
                sqlBuf.append(" and ").append(this.srcWhere);
            }
        }
        if (!StringUtils.isEmpty((String)filterString)) {
            if (!(filterString = filterString.trim()).matches("(?im)^and.*")) {
                sqlBuf.append(" and ");
            }
            sqlBuf.append(filterString);
        }
        if (!"and".equalsIgnoreCase(sqlBuf.substring(sqlBuf.length() - 3, sqlBuf.length()))) {
            sqlBuf.append(" and");
        }
        sqlBuf.append(" not exists(select 1 from ").append(this.pkTableName).append(" as p").append(" where v2.").append(headPkName).append(" = p.headpk").append(")");
        sqlBuf.append(" group by v2.").append(headPkName);
        sqlBuf.append(") as v3)");
        ResultSet rs = null;
        PreparedStatement readingStatement = null;
        logger.info((Object)("(EIP)\u6267\u884cKSQL\uff1a" + sqlBuf.toString()));
        System.out.println("(EIP)\u6267\u884cKSQL\uff1a" + sqlBuf.toString());
        try {
            readingStatement = this.connection.prepareStatement(sqlBuf.toString(), 1003, 1007);
            rs = readingStatement.executeQuery();
            while (rs.next()) {
                structuredTableData.setTotalCount(rs.getInt("total"));
                structuredTableData.setBillCount(rs.getInt("bill"));
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)("(EIP)\u6267\u884cKSQL\u5f02\u5e38\uff0cSQL\uff1a" + sqlBuf.toString()));
                System.out.println(e.getMessage() + "---------(EIP)\u6267\u884cKSQL\u5f02\u5e38\uff0cSQL\uff1a" + sqlBuf.toString());
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, readingStatement);
                throw throwable;
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)readingStatement);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)readingStatement);
    }

    @Override
    public int getPageSize(Map param) {
        if (this.pageSize <= 0) {
            try {
                Object pageSize = param.get("pageSize");
                this.pageSize = pageSize == null ? 500 : Integer.parseInt(pageSize.toString());
                this.pageSize = this.pageSize > 1000 ? 500 : this.pageSize;
            }
            catch (Exception e) {
                this.pageSize = 500;
            }
        }
        return this.pageSize;
    }

    @Override
    public void doMidFeedBack(Context ctx, List pks) throws Exception {
        FeedBackManager.doMidFeedBack((Context)ctx, (List)pks, (StructuredDataModel)this.dataModel);
    }

    @Override
    public int dealHeadpks(Map param) throws BOSException {
        return 0;
    }
}

