/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.monitor.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.rpc.RpcProxy;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.csinterface.basedatasyn.client.BaseDataSynPreCheckLogListUI;
import com.kingdee.eas.csinterface.monitor.IMonitorServiceUIFacade;
import com.kingdee.eas.csinterface.monitor.MonitorLogFactory;
import com.kingdee.eas.csinterface.monitor.MonitorLogInfo;
import com.kingdee.eas.csinterface.monitor.client.AbstractMonitorLogListUI;
import com.kingdee.eas.csinterface.monitor.client.MonitorLogDeleteUI;
import com.kingdee.eas.csinterface.util.BtnEASPivot;
import com.kingdee.eas.csinterface.util.EIPUIClassParamUtil;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class MonitorLogListUI
extends AbstractMonitorLogListUI {
    private static final Logger logger = CoreUIObject.getLogger(MonitorLogListUI.class);

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    public void onLoad() throws Exception {
        Object param;
        super.onLoad();
        Object menuName = this.getUIContext().get("MainMenuName");
        if (menuName != null && !StringUtils.isEmpty((String)menuName.toString())) {
            super.setUITitle(menuName.toString());
        }
        if ((param = this.getUIContext().get("UIClassParam")) != null && !param.equals("") && ("k3MonitorLog".equalsIgnoreCase(param.toString()) || "commonReportMonitorLog".equalsIgnoreCase(param.toString()) || "commonBillMappingMonitorLog".equalsIgnoreCase(param.toString()))) {
            this.btnShowPreCheckLog.setVisible(false);
        }
        BtnEASPivot.btnInVisible(this);
        this.btnDeleteHistory.setEnabled(true);
    }

    protected String[] getNotOrderColumns() {
        return new String[]{"content", "stackTrace"};
    }

    protected void execQuery() {
        super.execQuery();
    }

    protected void beforeExcutQuery(EntityViewInfo ev) {
        EIPUIClassParamUtil.setFilterByUIParamValue(this.getUIContext(), "logType", "logType", ev, "logType", null, "AND");
        Object filterValue = this.getUIContext().get("EIPfilter");
        if (filterValue != null) {
            FilterInfo filter = ev.getFilter();
            if (filter == null) {
                filter = new FilterInfo();
            }
            try {
                filter.mergeFilter((FilterInfo)filterValue, "AND");
                ev.setFilter(filter);
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
        }
        super.beforeExcutQuery(ev);
    }

    @Override
    public void deleteHistory_actionPerformed(ActionEvent e) throws Exception {
        super.deleteHistory_actionPerformed(e);
        Map uiContext = this.getUIContext();
        uiContext.put("Owner", this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(MonitorLogDeleteUI.class.getName(), uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    protected String getKeyFieldName() {
        return "id";
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return MonitorLogFactory.getRemoteInstance();
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        EntityViewInfo view = (EntityViewInfo)dataObject;
        if (view.getSorter() == null || view.getSorter().size() == 0) {
            SorterItemCollection sorterColl = new SorterItemCollection();
            SorterItemInfo orderTimeSorter = new SorterItemInfo("lastUpdateTime");
            orderTimeSorter.setSortType(SortType.DESCEND);
            sorterColl.add(orderTimeSorter);
            view.setSorter(sorterColl);
        }
        super.setDataObject(dataObject);
    }

    private String getSelectedId() {
        ArrayList ids = this.getSelectedIdValues();
        if (ids != null && ids.size() > 0) {
            return (String)ids.get(0);
        }
        return null;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        HashMap<String, String> uiContext = new HashMap<String, String>();
        HashMap dataObjects = new HashMap();
        uiContext.put("ID", this.getSelectedId());
        IUIWindow uiWindow = uiFactory.create("com.kingdee.eas.csinterface.monitor.client.MonitorLogEditUI", uiContext, dataObjects, OprtState.EDIT);
        uiWindow.show();
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        HashMap<String, String> uiContext = new HashMap<String, String>();
        HashMap dataObjects = new HashMap();
        uiContext.put("ID", this.getSelectedId());
        IUIWindow uiWindow = uiFactory.create("com.kingdee.eas.csinterface.monitor.client.MonitorLogEditUI", uiContext, dataObjects, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    protected IObjectValue createNewData() {
        MonitorLogInfo objectValue = new MonitorLogInfo();
        return objectValue;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    @Override
    public void preCheckLogAction_actionPerformed(ActionEvent e) throws Exception {
        super.preCheckLogAction_actionPerformed(e);
        Map uiContext = this.getUIContext();
        uiContext.put("Owner", this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(BaseDataSynPreCheckLogListUI.class.getName(), uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    public void btnDumpAction_actionPerformed(ActionEvent e) throws Exception {
        String[] selectIds = this.getSelectedIdValues().toArray(new String[0]);
        if (selectIds.length > 0) {
            if (MsgBox.showConfirm2((String)"\u96c6\u6210\u76d1\u63a7\u65e5\u5fd7\u8f6c\u50a8\u4ee5\u540e\u5c06\u4f5c\u4e3a\u5386\u53f2\u6570\u636e\uff0c\u65e0\u6cd5\u66f4\u6539\u3002\u7ee7\u7eed\u6267\u884c\u8f6c\u50a8\u64cd\u4f5c\u5417\uff1f") != 0) {
                return;
            }
            try {
                int i = ((IMonitorServiceUIFacade)RpcProxy.wrapRequired(IMonitorServiceUIFacade.class)).moveToHistory(selectIds);
                if (i != selectIds.length) {
                    MsgBox.showInfo((String)("\u8f6c\u50a8" + selectIds.length + "\u6761\u96c6\u6210\u76d1\u63a7\u65e5\u5fd7\uff0c\u5176\u4e2d\uff1a" + i + "\u6761\u6210\u529f\uff0c" + (selectIds.length - i) + "\u6761\u5931\u8d25\uff01"));
                } else {
                    MsgBox.showInfo((String)"\u9009\u5b9a\u96c6\u6210\u76d1\u63a7\u65e5\u5fd7\u8f6c\u50a8\u6210\u529f\uff01");
                }
                this.refreshList();
            }
            catch (Exception ex) {
                ByteArrayOutputStream bao = new ByteArrayOutputStream();
                PrintStream ps = new PrintStream(bao);
                ex.printStackTrace(ps);
                String msg = bao.toString();
                MsgBox.showConfirm3a((String)"\u8f6c\u50a8\u96c6\u6210\u76d1\u63a7\u65e5\u5fd7\u5931\u8d25\uff01", (String)msg);
            }
        }
    }
}

