/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.monitor.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.DynamicBillTemplateCollection;
import com.kingdee.eas.csinterface.IDynamicBillTemplate;
import com.kingdee.eas.csinterface.bizbill.metadata.info.DIPMetadata;
import com.kingdee.eas.csinterface.monitor.AbstractSubMonitorLogInfo;
import com.kingdee.eas.csinterface.monitor.SubMonitorLogCollection;
import com.kingdee.eas.csinterface.monitor.SubMonitorLogFactory;
import com.kingdee.eas.csinterface.monitor.SubMonitorLogInfo;
import com.kingdee.eas.csinterface.monitor.client.AbstractSubMonitorLogUI;
import com.kingdee.eas.framework.CoreBaseCollection;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class SubMonitorLogUI
extends AbstractSubMonitorLogUI {
    private static final Logger logger = CoreUIObject.getLogger(SubMonitorLogUI.class);
    public static final Map<String, String> typeMap = new HashMap<String, String>();

    public void onLoad() throws Exception {
        this.focusText.setVisible(true);
        this.focusText.setSize(0, 0);
        this.focusText.requestFocusInWindow();
        super.onLoad();
        Map context = this.getUIContext();
        String monitorLogId = context.get("monitorLogId").toString();
        String status = context.get("status").toString();
        String operatorType = context.get("operatorType").toString();
        String result = null;
        result = "\u751f\u6210\u76ee\u6807\u5355\u636e".equalsIgnoreCase(operatorType) ? this.drawMidToDest(monitorLogId) : this.drawBaseDataSyn(monitorLogId);
        this.detailLog.setText(result);
        this.detailLog.setEditable(true);
        this.detailLog.setEnabled(true);
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionClose_actionPerformed(ActionEvent e) throws Exception {
        super.actionClose_actionPerformed(e);
        this.destroyWindow();
    }

    private String drawBaseDataSyn(String monitorLogId) throws EASBizException, BOSException {
        HashMap subLogMap = (HashMap)SubMonitorLogFactory.getRemoteInstance().getDetailByMonitor(monitorLogId);
        StringBuffer content = new StringBuffer();
        int count = 0;
        for (String planNumber : subLogMap.keySet()) {
            if (count > 0) {
                content.append("\n**************************************************************************************");
            }
            ++count;
            SubMonitorLogCollection coll = (SubMonitorLogCollection)((Object)subLogMap.get(planNumber));
            Iterator it = coll.iterator();
            boolean isFirst = true;
            while (it.hasNext()) {
                SubMonitorLogInfo logInfo = (SubMonitorLogInfo)it.next();
                boolean isMainTable = logInfo.isMainTable();
                String displayName = "\u7f16\u7801(ID)";
                String type = typeMap.get(logInfo.getCmd());
                String success = logInfo.getSuccess() == null ? "" : logInfo.getSuccess();
                String failure = logInfo.getFailure() == null ? "" : logInfo.getFailure();
                int existCount = logInfo.getExistCount();
                if (!isFirst) {
                    content.append("\n-------------------------------\n");
                }
                if (isFirst) {
                    isFirst = false;
                    content.append("\n\u65b9\u6848\u7f16\u7801\uff1a").append(planNumber).append("\n");
                }
                content.append("\n\u8868\u540d\uff1a").append(logInfo.getTableName());
                content.append("\n").append(type + "\u5931\u8d25" + displayName + "\uff0c\u603b\u6761\u6570\uff1a" + logInfo.getFailureCount() + "\uff1a\n").append(failure);
                content.append("\n").append(type + "\u6210\u529f" + displayName + "\uff0c\u603b\u6761\u6570\uff1a" + logInfo.getSuccessCount() + "\uff1a\n").append(success);
                if (existCount <= 0) continue;
                content.append("\n").append("\u5df2\u5b58\u5728\u603b\u6761\u6570\uff1a" + existCount + "\n");
            }
        }
        return content.toString();
    }

    private String drawMidToDest(String monitorLogId) throws BOSException {
        Serializable temp;
        int i;
        CoreBaseCollection coll = SubMonitorLogFactory.getRemoteInstance().getCollection("where monitorLogId='" + monitorLogId + "'");
        HashSet<String> midIds = new HashSet<String>();
        for (int i2 = 0; i2 < coll.size(); ++i2) {
            SubMonitorLogInfo temp2 = (SubMonitorLogInfo)coll.get(i2);
            midIds.add(temp2.getPlanNumber());
        }
        StringBuffer content = new StringBuffer();
        String billNumber = this.getUIContext().get("billNumber").toString();
        billNumber = billNumber.substring(0, billNumber.indexOf("("));
        HashMap<String, String> idHeadpkMap = new HashMap<String, String>();
        DIPMetadata dm = new DIPMetadata(billNumber);
        MetaDataPK pk = MetaDataPK.create((String)dm.getHeaderEntityPK());
        IDynamicBillTemplate template = (IDynamicBillTemplate)BOSObjectFactory.createRemoteCommonBOSObject((IMetaDataPK)pk);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo info = new FilterInfo();
        info.getFilterItems().add(new FilterItemInfo("id", midIds, CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("headpk"));
        ev.setSelector(sic);
        ev.setFilter(info);
        DynamicBillTemplateCollection colls = template.getDynamicBillTemplateCollection(ev);
        for (i = 0; i < colls.size(); ++i) {
            temp = colls.get(i);
            idHeadpkMap.put(temp.getId().toString(), temp.get("headpk").toString());
        }
        for (i = 0; i < coll.size(); ++i) {
            temp = (SubMonitorLogInfo)coll.get(i);
            String midID = ((AbstractSubMonitorLogInfo)temp).getPlanNumber();
            if (i > 0) {
                content.append("\n--------------------------------------------------\n");
            }
            content.append("headpk\u4e3a\uff1a" + (String)idHeadpkMap.get(midID) + "  \u751f\u6210\u51ed\u8bc1\u5931\u8d25   \u539f\u56e0:\n").append(((AbstractSubMonitorLogInfo)temp).getFailure());
        }
        return content.toString();
    }

    static {
        typeMap.put("add", "\u65b0\u589e");
        typeMap.put("update", "\u66f4\u65b0");
        typeMap.put("del", "\u5220\u9664");
    }
}

