/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.planmanager.converter;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.csinterface.converter.core.MarshallingContext;
import com.kingdee.eas.csinterface.converter.core.UnmarshallingContext;
import com.kingdee.eas.csinterface.planmanager.converter.AbstractDataBaseInfoConverter;
import com.kingdee.eas.csinterface.syncdatabase.ApplicationScopeType;
import com.kingdee.eas.csinterface.syncdatabase.AssistAccountTypeEntryCollection;
import com.kingdee.eas.csinterface.syncdatabase.AssistAccountTypeEntryInfo;
import com.kingdee.eas.csinterface.syncdatabase.AssistAccountTypeInfo;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataTypeInfo;
import com.kingdee.eas.csinterface.util.JDomB9Utils;
import com.kingdee.util.StringUtils;
import java.util.Iterator;
import java.util.List;
import org.jdom2.Element;

public class AssistAccountTypeInfoConverter
extends AbstractDataBaseInfoConverter {
    private String[] headerStrFields = new String[]{"number", "srcID", "srcDisplay", "srcTable"};
    private String[] entryStrFields = new String[]{"srcID", "srcDisplay", "destID", "destDisplay"};

    @Override
    public boolean canConvert(Class type) {
        return AssistAccountTypeInfo.class == type;
    }

    @Override
    public Object marshal(Object source, MarshallingContext context) {
        AssistAccountTypeInfo info = (AssistAccountTypeInfo)source;
        Element root = new Element(info.getClass().getName());
        this.addChild(root, "FID", info.getId().toString());
        this.addChild(root, "number", info.getNumber());
        this.addChild(root, "srcID", info.getSrcID());
        this.addChild(root, "srcDisplay", info.getSrcDisplay());
        this.addChild(root, "srcTable", info.getSrcTable());
        this.addChild(root, "applicationScope", info.getApplicationScope().getName());
        this.marshalEntrys(root, info);
        return root;
    }

    private void marshalEntrys(Element root, AssistAccountTypeInfo info) {
        Element entryRoot = JDomB9Utils.addChild(root, "entrys");
        Iterator iterator = info.getEntrys().iterator();
        while (iterator.hasNext()) {
            Element entry = JDomB9Utils.addChild(entryRoot, "entry");
            AssistAccountTypeEntryInfo entryInfo = (AssistAccountTypeEntryInfo)iterator.next();
            String tmpValue = "";
            for (int i = 0; i < this.entryStrFields.length; ++i) {
                tmpValue = entryInfo.getString(this.entryStrFields[i]);
                tmpValue = StringUtils.equals((String)tmpValue, (String)"true") ? "1" : tmpValue;
                tmpValue = StringUtils.equals((String)tmpValue, (String)"false") ? "0" : tmpValue;
                this.addChild(entry, this.entryStrFields[i], tmpValue);
            }
            BaseDataTypeInfo baseDataTypeInfo = entryInfo.getBaseDataType();
            if (null == baseDataTypeInfo) continue;
            this.addChild(entry, "baseDataTypeFID", baseDataTypeInfo.getId().toString());
        }
    }

    @Override
    public Object unmarshal(Object source, UnmarshallingContext context) {
        Element data = (Element)source;
        AssistAccountTypeInfo info = new AssistAccountTypeInfo();
        List children = data.getChildren();
        for (int i = 0; i < this.headerStrFields.length; ++i) {
            info.setString(this.headerStrFields[i], this.getElementTextByName(children, this.headerStrFields[i]));
        }
        String FID = this.getElementTextByName(children, "FID");
        info.setApplicationScope(ApplicationScopeType.getEnum(this.getElementTextByName(children, "applicationScope")));
        info.put("assistAccountTypeFID_TO_BE_REPLACED", FID);
        this.unmarshalEntrys(info, children);
        return info;
    }

    private void unmarshalEntrys(AssistAccountTypeInfo info, List<Element> children) {
        Element entryRoot = this.getElementByName(children, "entrys");
        if (null == entryRoot) {
            return;
        }
        AssistAccountTypeEntryCollection entryCollection = new AssistAccountTypeEntryCollection();
        List entryList = entryRoot.getChildren("entry");
        for (Element entry : entryList) {
            AssistAccountTypeEntryInfo entryInfo = new AssistAccountTypeEntryInfo();
            for (int i = 0; i < this.entryStrFields.length; ++i) {
                String value = this.getElementTextByName(entry, this.entryStrFields[i]);
                entryInfo.setString(this.entryStrFields[i], value);
            }
            try {
                EntityViewInfo ev = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("name", (Object)entryInfo.getDestDisplay(), CompareType.EQUALS));
                ev.setFilter(filter);
                AsstActTypeCollection coll = AsstActTypeFactory.getRemoteInstance().getAsstActTypeCollection(ev);
                if (coll != null && coll.size() > 0) {
                    entryInfo.setDestID(coll.get(0).getId().toString());
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            String FID = this.getElementTextByName(entry, "baseDataTypeFID");
            entryInfo.put("baseDataTypeFID_TO_BE_REPLACED", FID);
            entryCollection.add(entryInfo);
        }
        info.getEntrys().addCollection(entryCollection);
    }
}

