/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.planmanager.converter;

import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynColumnInfo;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynTypeMapFactory;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynTypeMapInfo;
import com.kingdee.eas.csinterface.converter.core.MarshallingContext;
import com.kingdee.eas.csinterface.converter.core.UnmarshallingContext;
import com.kingdee.eas.csinterface.planmanager.converter.AbstractDataBaseInfoConverter;
import com.kingdee.util.StringUtils;
import java.util.List;
import org.jdom2.Element;

public class BaseDataSynColumnInfoConverter
extends AbstractDataBaseInfoConverter {
    @Override
    public boolean canConvert(Class type) {
        return BaseDataSynColumnInfo.class == type;
    }

    @Override
    public Object marshal(Object source, MarshallingContext context) {
        BaseDataSynColumnInfo info = (BaseDataSynColumnInfo)source;
        Element root = new Element(info.getClass().getName());
        this.addChild(root, "FID", info.getId().toString());
        this.addChild(root, "colName", info.getColName());
        this.addChild(root, "colAlias", info.getColAlias());
        this.addChild(root, "pkField", BaseDataSynColumnInfoConverter.changeBooleanToString(info.isPkField()));
        this.addChild(root, "needSyn", BaseDataSynColumnInfoConverter.changeBooleanToString(info.isNeedSyn()));
        this.addChild(root, "needUpdateSyn", BaseDataSynColumnInfoConverter.changeBooleanToString(info.isNeedUpdateSyn()));
        this.addChild(root, "changeful", BaseDataSynColumnInfoConverter.changeBooleanToString(info.isChangeful()));
        this.addChild(root, "pkTime", BaseDataSynColumnInfoConverter.changeBooleanToString(info.isPkTime()));
        this.addChild(root, "parent", info.getParent() != null ? info.getParent().getId().toString() : "");
        this.addChild(root, "tableName", info.getTableName());
        this.addChild(root, "colDataType", info.getColDataType());
        this.addChild(root, "srcColDataLength", info.getSrcColDataLength());
        this.addChild(root, "srcColDataPrecision", info.getSrcColDataPrecision());
        this.addChild(root, "srcColDataScale", info.getSrcColDataScale());
        this.addChild(root, "srcColNullable", info.getSrcColNullable());
        this.addChild(root, "baseDataSynTypeMap", info.getBaseDataSynTypeMap() == null ? "" : info.getBaseDataSynTypeMap().getId().toString());
        this.addChild(root, "defaultValue", info.getDefaultValue());
        this.addChild(root, "destColName", info.getDestColName());
        this.addChild(root, "destColAlias", info.getDestColAlias());
        this.addChild(root, "destColDataType", info.getDestColDataType());
        this.addChild(root, "destColDataLength", info.getDestColDataLength());
        this.addChild(root, "destColDataPrecision", info.getDestColDataPrecision());
        this.addChild(root, "destColDataScale", info.getDestColDataScale());
        this.addChild(root, "destColNullable", info.getDestColNullable());
        return root;
    }

    @Override
    public Object unmarshal(Object source, UnmarshallingContext context) {
        Element data = (Element)source;
        BaseDataSynColumnInfo info = new BaseDataSynColumnInfo();
        List children = data.getChildren();
        info.setColName(this.getElementTextByName(children, "colName"));
        info.setColAlias(this.getElementTextByName(children, "colAlias"));
        info.setPkField(BaseDataSynColumnInfoConverter.changeStringToBoolean(this.getElementTextByName(children, "pkField")));
        info.setNeedSyn(BaseDataSynColumnInfoConverter.changeStringToBoolean(this.getElementTextByName(children, "needSyn")));
        info.setNeedUpdateSyn(BaseDataSynColumnInfoConverter.changeStringToBoolean(this.getElementTextByName(children, "needUpdateSyn")));
        info.setChangeful(BaseDataSynColumnInfoConverter.changeStringToBoolean(this.getElementTextByName(children, "changeful")));
        info.setPkTime(BaseDataSynColumnInfoConverter.changeStringToBoolean(this.getElementTextByName(children, "pkTime")));
        info.setColDataType(this.getElementTextByName(children, "colDataType"));
        info.setTableName(this.getElementTextByName(children, "tableName"));
        info.setSrcColDataLength(BaseDataSynColumnInfoConverter.changeStringToInt(this.getElementTextByName(children, "srcColDataLength")));
        info.setSrcColDataPrecision(BaseDataSynColumnInfoConverter.changeStringToInt(this.getElementTextByName(children, "srcColDataPrecision")));
        info.setSrcColDataScale(BaseDataSynColumnInfoConverter.changeStringToInt(this.getElementTextByName(children, "srcColDataScale")));
        info.setSrcColNullable(this.getElementTextByName(children, "srcColNullable"));
        BaseDataSynTypeMapInfo map = null;
        if (!StringUtils.isEmpty((String)this.getElementTextByName(children, "baseDataSynTypeMap"))) {
            try {
                map = BaseDataSynTypeMapFactory.getRemoteInstance().getBaseDataSynTypeMapInfo("where id='" + this.getElementTextByName(children, "baseDataSynTypeMap") + "'");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        info.setBaseDataSynTypeMap(map);
        info.setDefaultValue(this.getElementTextByName(children, "defaultValue"));
        info.setDestColName(this.getElementTextByName(children, "destColName"));
        info.setDestColAlias(this.getElementTextByName(children, "destColAlias"));
        info.setDestColDataType(this.getElementTextByName(children, "destColDataType"));
        info.setDestColDataLength(BaseDataSynColumnInfoConverter.changeStringToInt(this.getElementTextByName(children, "destColDataLength")));
        info.setDestColDataPrecision(BaseDataSynColumnInfoConverter.changeStringToInt(this.getElementTextByName(children, "destColDataPrecision")));
        info.setDestColDataScale(BaseDataSynColumnInfoConverter.changeStringToInt(this.getElementTextByName(children, "destColDataScale")));
        info.setDestColNullable(this.getElementTextByName(children, "destColNullable"));
        return info;
    }

    public static String changeBooleanToString(Boolean value) {
        return value != false ? "1" : "0";
    }

    public static Boolean changeStringToBoolean(String value) {
        return StringUtils.equals((String)value, (String)"1");
    }

    public static int changeStringToInt(String value) {
        int resValue = 0;
        try {
            resValue = Integer.valueOf(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return resValue;
    }
}

