/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.reportmapping.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.analysis.util.editor.EditorStyleModel;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.dom.stmt.SqlStmt;
import com.kingdee.bos.sql.parser.Lexer;
import com.kingdee.bos.sql.parser.SqlStmtParser;
import com.kingdee.bos.sql.parser.TokenList;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.CryptoUtil;
import com.kingdee.bos.util.SimpleTimer;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.EJBAccessFactory;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.PermissionUtils;
import com.kingdee.eas.base.permission.UserException;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.RefCheckerFactory;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.csinterface.reportmapping.client.AbstractFMIsqlUI;
import com.kingdee.eas.csinterface.reportmapping.client.DateTimePickerEditor;
import com.kingdee.eas.csinterface.reportmapping.client.IntTextEditor;
import com.kingdee.eas.csinterface.reportmapping.client.NumberTextEditor;
import com.kingdee.eas.csinterface.reportmapping.client.SqlResult;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionInfo;
import com.kingdee.eas.csinterface.utils.DataBaseType;
import com.kingdee.eas.csinterface.utils.KSQLUtil;
import com.kingdee.eas.fm.common.EnvUtils;
import com.kingdee.eas.fm.common.FMIsqlFacadeFactory;
import com.kingdee.eas.fm.common.IFMIsqlFacade;
import com.kingdee.eas.fm.common.StringSerializer;
import com.kingdee.eas.fm.common.client.FMISQLEditorStyleModel;
import com.kingdee.eas.fm.common.client.FMIsqlOptional;
import com.kingdee.eas.fm.common.client.FMIsqlSearchTableUI;
import com.kingdee.eas.fm.common.client.FMIsqlUIHandler;
import com.kingdee.eas.fm.common.client.KDTMenuManager;
import com.kingdee.eas.fm.common.client.SQLStmtInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.ScriptUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BoxLayout;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import junit.framework.TestFailure;
import junit.framework.TestResult;
import org.apache.log4j.Logger;
import org.mozilla.javascript.Undefined;

public class FMIsqlUI
extends AbstractFMIsqlUI {
    private static final Logger logger = CoreUIObject.getLogger(FMIsqlUI.class);
    private static Map hmTableAndColumn = new HashMap();
    private static int maxCount = 25;
    private static Map tableAlias = new HashMap();
    private static Pattern tableAliasPattern = Pattern.compile("as\\p{Space}[a-zA-Z]+,");
    private static StringBuffer sb = new StringBuffer("/*dialect*/ ");
    private static String SQLCACHEFILE;
    private static KDPopupMenu kdp;
    private int cursorPosition = 0;
    private CaretListenerSelf cls = null;

    public boolean destroyWindow() {
        try {
            StringSerializer.saveToFile((String)this.txtScript.getText(), (String)SQLCACHEFILE);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return super.destroyWindow();
    }

    public FMIsqlUI() throws Exception {
        boolean b = this.isLogin();
        if (!b) {
            this.abort();
        }
        KeyStroke ctlcStroke = KeyStroke.getKeyStroke(67, 2, true);
        this.txtAbout.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FMIsqlUI.this.txtAbout.copy();
            }
        }, ctlcStroke, 2);
        this.txtScript.setStyleModel((EditorStyleModel)new FMISQLEditorStyleModel());
        if (this.txtScript.getText().length() < 1000) {
            this.txtScript.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    int cursorPos = FMIsqlUI.this.txtScript.getCaret().getDot();
                    if (cursorPos == 0) {
                        return;
                    }
                    String simbol = FMIsqlUI.this.txtScript.getText().substring(cursorPos - 1, cursorPos);
                    if (",".equals(simbol) || " ".equals(simbol)) {
                        String patterStr = FMIsqlUI.this.txtScript.getText().substring(cursorPos - 5, cursorPos);
                        Pattern tableAliasPattern = Pattern.compile("as\\p{Space}[a-zA-Z]+" + simbol);
                        Matcher m = tableAliasPattern.matcher(patterStr);
                        if (m.matches()) {
                            String alias = patterStr.substring(patterStr.indexOf(" "), patterStr.lastIndexOf(simbol)).trim();
                            String tmpFront = FMIsqlUI.this.txtScript.getText().substring(0, FMIsqlUI.this.txtScript.getText().lastIndexOf(patterStr)).trim();
                            String tableName = tmpFront.substring(tmpFront.lastIndexOf(" ")).trim();
                            tableAlias.put(alias.trim().toLowerCase(), tableName.trim().toLowerCase());
                        }
                    } else if (".".equals(simbol)) {
                        // empty if block
                    }
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                }
            });
        }
    }

    private boolean isLogin() throws EASBizException {
        UserInfo userInfo = ContextHelperFactory.getRemoteInstance().getCurrentUser();
        if (Administrator.isSuperCUAdmin((IObjectPK)new ObjectUuidPK(userInfo.getId()))) {
            return true;
        }
        if ("00000000-0000-0000-0000-00000000000013B7DE7F".equals(userInfo.getId().toString())) {
            return true;
        }
        try {
            userInfo = UserFactory.getRemoteInstance().getUserByID((IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-00000000000013B7DE7F"));
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        JPasswordField pwd = new JPasswordField();
        Object[] message = new Object[]{EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"49_FMIsqlUI"), pwd};
        int res = JOptionPane.showConfirmDialog((Component)((Object)this), message, " ", 2, 3);
        if (res != 0) {
            return false;
        }
        char[] pwdChar = pwd.getPassword();
        StringBuilder builder = new StringBuilder();
        builder.append(pwdChar);
        Arrays.fill((char[])pwdChar, (char)' ');
        return PermissionUtils.matchPassword((UserInfo)userInfo, (String)builder.toString());
    }

    public static boolean matchPassword(UserInfo userInfo, String password) throws EASBizException {
        if (StringUtils.isEmpty((String)password)) {
            return StringUtils.isEmpty((String)userInfo.getPassword());
        }
        return FMIsqlUI.encrypt(userInfo.getId().toString(), password).equals(userInfo.getPassword());
    }

    public static String encrypt(String userID, String password) throws EASBizException {
        try {
            return CryptoUtil.encrypt((String)(userID + password.trim()));
        }
        catch (Exception e) {
            throw new UserException(UserException.ENCRYPT_FAIL);
        }
    }

    @Override
    public void actionExecute_actionPerformed(ActionEvent e) throws Exception {
        super.actionExecute_actionPerformed(e);
        String sql = this.getSql();
        if (FMIsqlUI.isEmpty(sql)) {
            return;
        }
        this.executeSQL(sql, true);
    }

    public static boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    @Override
    public void actionExcuteDialect_actionPerformed(ActionEvent e) throws Exception {
        this.excuteDialect(e);
    }

    private void excuteDialect(ActionEvent e) throws Exception {
        super.actionExecute_actionPerformed(e);
        String sql = this.getSql();
        if (FMIsqlUI.isEmpty(sql)) {
            return;
        }
        sql = "/*dialect*/ ".intern() + sql;
        this.executeSQL(sql, true);
    }

    @Override
    public void actionExcutePlan_actionPerformed(ActionEvent e) throws Exception {
        long now = System.currentTimeMillis();
        this.executeSQL("delete from plan_table ", true);
        String sqlHeader = "/*dialect*/ explain plan set statement_id = '" + now + "' for ";
        String sql = this.getSql();
        sql = sqlHeader + sql;
        this.executeSQL(sql, true);
        this.executeSQL(sb.toString(), true);
    }

    @Override
    public void actionFill_actionPerformed(ActionEvent e) throws Exception {
        try {
            String sql = this.getSql();
            this.cursorPosition = this.txtScript.getCaret().getDot();
            String otherTextFront = sql.substring(0, this.cursorPosition);
            String prefix = FMIsqlUI.getpreFix(otherTextFront);
            int fillType = this.getFillType(otherTextFront);
            kdp = new KDPopupMenu();
            switch (fillType) {
                case 0: {
                    this.fillColumns(sql);
                    break;
                }
                case 1: {
                    this.fillExtendsColumns(sql);
                    break;
                }
                case 2: {
                    this.fillTables(prefix);
                    break;
                }
                default: {
                    this.fillTables(prefix);
                }
            }
            kdp.show((Component)((Object)this), 300, 400);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    private int getFillType(String otherTextFront) {
        int fillYype = -1;
        fillYype = otherTextFront.substring(this.cursorPosition - 1, this.cursorPosition).equals(".") ? 0 : (this.isFillTable(otherTextFront) ? 2 : 1);
        return fillYype;
    }

    private boolean isFillTable(String otherTextFront) {
        String prefix = FMIsqlUI.getpreFix(otherTextFront);
        String[] allTableName = ((FMISQLEditorStyleModel)this.txtScript.getStyleModel()).getAllTableName();
        for (int i = 0; i < allTableName.length; ++i) {
            if (!allTableName[i].toLowerCase(Locale.ENGLISH).startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    static String getpreFix(String otherTextFront) {
        int i;
        if (otherTextFront.endsWith(".")) {
            String alias = otherTextFront.substring(otherTextFront.lastIndexOf(" "), otherTextFront.lastIndexOf("."));
            String tableName = (String)tableAlias.get(alias.toLowerCase().trim());
            return tableName == null ? "" : tableName.trim().toLowerCase();
        }
        for (i = otherTextFront.length() - 1; i >= 0 && Character.isJavaIdentifierPart(otherTextFront.charAt(i)); --i) {
        }
        return otherTextFront.substring(i + 1, otherTextFront.length());
    }

    private void fillExtendsColumns(String sql) {
        String tmpSub = sql.substring(0, this.cursorPosition);
        String columnPrefix = tmpSub.substring(tmpSub.lastIndexOf(".") + 1).toLowerCase(Locale.ENGLISH);
        String tableName = tmpSub.substring(tmpSub.lastIndexOf(" "), tmpSub.lastIndexOf(".")).trim();
        logger.debug((Object)tableName);
        Set allColumns = this.getAllColumn(tableName);
        String[] allColumnsArray = allColumns.toArray(new String[allColumns.size()]);
        int count = 0;
        KDMenuItem tmpMenuItem = new KDMenuItem("....");
        kdp.add((JMenuItem)tmpMenuItem);
        for (int i = 0; i < allColumnsArray.length; ++i) {
            if (!allColumnsArray[i].startsWith(columnPrefix)) continue;
            tmpMenuItem = new KDMenuItem(allColumnsArray[i]);
            kdp.add((JMenuItem)tmpMenuItem);
            tmpMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.action(e);
                }

                private void action(ActionEvent e) {
                    String str = e.getActionCommand();
                    if (str.equals("....")) {
                        return;
                    }
                    String sql = FMIsqlUI.this.txtScript.getText();
                    String otherTextFront = sql.substring(0, FMIsqlUI.this.cursorPosition).trim();
                    String otherTextLatter = sql.substring(FMIsqlUI.this.cursorPosition).trim();
                    String positionStr = new StringBuffer(otherTextFront).replace(otherTextFront.lastIndexOf(".") + 1, FMIsqlUI.this.cursorPosition, str).toString().toLowerCase();
                    FMIsqlUI.this.txtScript.setText(positionStr.trim() + "\n" + otherTextLatter.trim());
                    FMIsqlUI.this.txtScript.setCaretPosition(positionStr.length());
                }
            });
            if (++count > maxCount) break;
        }
    }

    private void fillTables(String prefix) {
        String[] allTableName = ((FMISQLEditorStyleModel)this.txtScript.getStyleModel()).getAllTableName();
        int count = 0;
        for (int i = 0; i < allTableName.length; ++i) {
            String tmp = allTableName[i].toLowerCase(Locale.ENGLISH);
            if (!tmp.startsWith(prefix)) continue;
            KDMenuItem tmpMenuItem = new KDMenuItem(tmp);
            kdp.add((JMenuItem)tmpMenuItem);
            tmpMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.action(e);
                }

                private void action(ActionEvent e) {
                    String str = e.getActionCommand();
                    if (str.equals("....")) {
                        return;
                    }
                    String sql = FMIsqlUI.this.txtScript.getText();
                    String otherTextFront = sql.substring(0, FMIsqlUI.this.cursorPosition).trim();
                    String otherTextLatter = sql.substring(FMIsqlUI.this.cursorPosition).trim();
                    String key = otherTextFront.substring(otherTextFront.lastIndexOf(" ")).toLowerCase().trim();
                    key = key.replaceAll(key, str).trim();
                    String positionStr = otherTextFront.substring(0, otherTextFront.lastIndexOf(" ")) + " " + key.toLowerCase();
                    FMIsqlUI.this.txtScript.setText(positionStr.trim() + "\n" + otherTextLatter.trim());
                    FMIsqlUI.this.txtScript.setCaretPosition(positionStr.length());
                }
            });
            if (++count < maxCount) continue;
            tmpMenuItem = new KDMenuItem("....");
            kdp.add((JMenuItem)tmpMenuItem);
            break;
        }
    }

    private void fillColumns(String sql) {
        String tmpSub = sql.substring(0, this.cursorPosition - 1);
        String tableName = tmpSub.substring(tmpSub.lastIndexOf(" ")).trim();
        Set allColumns = this.getAllColumn(tableName);
        String[] allColumnsArray = allColumns.toArray(new String[allColumns.size()]);
        int count = 0;
        KDMenuItem tmpMenuItem = new KDMenuItem("....");
        kdp.add((JMenuItem)tmpMenuItem);
        for (int i = 0; i < allColumnsArray.length; ++i) {
            tmpMenuItem = new KDMenuItem(allColumnsArray[i]);
            kdp.add((JMenuItem)tmpMenuItem);
            tmpMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.action(e);
                }

                private void action(ActionEvent e) {
                    String str = e.getActionCommand();
                    if (str.equals("....")) {
                        return;
                    }
                    String sql = FMIsqlUI.this.txtScript.getText();
                    String otherTextFront = sql.substring(0, FMIsqlUI.this.cursorPosition).trim();
                    String otherTextLatter = sql.substring(FMIsqlUI.this.cursorPosition).trim();
                    String key = otherTextFront.substring(otherTextFront.lastIndexOf(" ")).toLowerCase().trim();
                    key = key.replaceAll(key, key + str).trim();
                    String positionStr = otherTextFront.substring(0, otherTextFront.lastIndexOf(" ")) + " " + key.toLowerCase();
                    FMIsqlUI.this.txtScript.setText(positionStr.trim() + "\n" + otherTextLatter.trim());
                    FMIsqlUI.this.txtScript.setCaretPosition(positionStr.length());
                }
            });
            if (++count >= maxCount) break;
        }
    }

    private Set getAllColumn(String tableName) {
        Set allColumns = new HashSet();
        if (hmTableAndColumn.containsKey(tableName)) {
            allColumns = (Set)hmTableAndColumn.get(tableName);
        } else {
            try {
                String tableNameReal = (String)tableAlias.get(tableName.toLowerCase().trim());
                if (tableNameReal == null) {
                    tableNameReal = tableName;
                }
                allColumns = FMIsqlFacadeFactory.getRemoteInstance().fetchAllColumnsByTableName(tableNameReal);
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                SysUtil.abort((Throwable)e);
            }
            hmTableAndColumn.put(tableName, allColumns);
        }
        return allColumns;
    }

    private void executeSQL(String sql, boolean tryToEditable) throws BOSException, EASBizException, SQLException {
        SimpleTimer st = new SimpleTimer();
        IFMIsqlFacade isql = FMIsqlFacadeFactory.getRemoteInstance();
        SqlResult rs = null;
        try {
            rs = this._executeSql(sql);
        }
        catch (BOSException exp) {
            this.fillException((Exception)((Object)exp));
        }
        long time = st.getTime();
        if (rs != null) {
            this.showResult(rs, sql, tryToEditable);
        }
        this.scrpRowsets.repaint();
        this.txtMsg.insert("\ncomplete! use time:" + time + "\tend time " + new Date(), 0);
    }

    public static String isPassed(String sql) {
        String[] forbidden = new String[]{"REPLACE", "ALTER", "DROP", "DECLARE", "DELETE", "UPDATE", "GRANT", "REVOKE"};
        String upperCaseSQL = sql.toUpperCase();
        for (int i = 0; i < forbidden.length; ++i) {
            String token = forbidden[i];
            if (upperCaseSQL.indexOf(token + " ") <= -1) continue;
            return token;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SqlResult _executeSql(String sql) throws BOSException, EASBizException {
        SqlResult sqlRst;
        block13: {
            if (FMIsqlUI.isEmpty(sql)) {
                return null;
            }
            String forbidden = FMIsqlUI.isPassed(sql);
            if (forbidden != null) {
                MsgBox.showInfo((String)("\u6267\u884c\u8bed\u53e5\u5305\u542b\u654f\u611f\u5173\u952e\u5b57\uff08" + forbidden + "\uff09\uff0c\u8bf7\u4fee\u6539\u3002"));
                SysUtil.abort();
            }
            Connection conn = null;
            Statement state = null;
            Connection con = null;
            ResultSet rs = null;
            sqlRst = new SqlResult();
            try {
                ConnectionInfo connection = (ConnectionInfo)this.conn.getValue();
                if (null != connection) {
                    DataBaseType dbType = DataBaseType.getInstance(connection.getDBType().getName());
                    try {
                        try {
                            con = KSQLUtil.getKSQLConnection(dbType, connection.getIP(), connection.getPort(), connection.getInstance(), connection.getUsername(), connection.getPassword());
                        }
                        catch (Exception e) {
                            throw new Exception("\u83b7\u53d6\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25\uff01\u8bf7\u68c0\u67e5\u3010\u6e90\u7cfb\u7edf\u6570\u636e\u5e93\u8fde\u63a5\u3011\u7684\u914d\u7f6e\u3002");
                        }
                        state = con.createStatement();
                        System.out.println("executeQuery ksql :" + sql);
                        boolean s = state.execute(sql);
                        sqlRst.setUpdateCount(state.getUpdateCount());
                        do {
                            if ((rs = state.getResultSet()) == null) continue;
                            JdbcRowSet jdbcRS = new JdbcRowSet();
                            jdbcRS.populate(rs, 6500);
                            sqlRst.getRowSets().add(jdbcRS);
                            SQLUtils.cleanup((ResultSet)rs);
                        } while (state.getMoreResults());
                    }
                    catch (Exception ex) {
                        try {
                            Throwable cause = ex.getCause();
                            String msg = cause == null ? ex.getMessage() : ex.getCause().getMessage();
                            this.txtMsg.insert("\r\n" + msg, 0);
                            ex.printStackTrace();
                        }
                        catch (Throwable throwable) {
                            SQLUtils.cleanup(null, state, con);
                            throw throwable;
                        }
                        SQLUtils.cleanup(null, (Statement)state, (Connection)con);
                        break block13;
                    }
                    SQLUtils.cleanup(null, (Statement)state, (Connection)con);
                    break block13;
                }
                MsgBox.showInfo((String)"\u8bf7\u5148\u9009\u62e9\u3010\u6e90\u7cfb\u7edf\u6570\u636e\u5e93\u8fde\u63a5\u3011");
                this.conn.requestFocus();
            }
            finally {
                SQLUtils.cleanup(rs, state, conn);
            }
        }
        return sqlRst;
    }

    private void showResult(SqlResult rs, String sql, boolean tryToEditable) throws SQLException {
        SQLStmtInfo sqlStmtInfo;
        String nsql = sql;
        if (sql.startsWith("/*dialect*/")) {
            nsql = sql.substring("/*dialect*/".length());
        }
        try {
            Lexer lexer = new Lexer(nsql);
            TokenList _tokList = new TokenList(lexer);
            SqlStmt sqlStmt = new SqlStmtParser(_tokList).stmt();
            sqlStmtInfo = FMIsqlUIHandler.getSQLStmtInfo((SqlStmt)sqlStmt);
        }
        catch (ParserException pe) {
            sqlStmtInfo = new SQLStmtInfo();
            sqlStmtInfo.canAudoUpdate = false;
            sqlStmtInfo.isSelect = false;
        }
        List rowSets = rs.getRowSets();
        if (rowSets == null || rowSets.size() <= 0) {
            this.tabMain.setSelectedComponent((Component)this.scrpMsg);
        } else if (rowSets.size() > 1) {
            KDPanel pan = new KDPanel();
            pan.setLayout((LayoutManager)new BoxLayout((Container)pan, 1));
            pan.setSize(this.scrpRowsets.getSize());
            this.scrpRowsets.getViewport().add((Component)pan);
            for (int i = 0; i < rowSets.size(); ++i) {
                KDTable table = new KDTable();
                KDTMenuManager tableMenuMgr = new KDTMenuManager(table);
                tableMenuMgr.setTempFile(EnvUtils.getTempDir());
                table.getSelectManager().setSelectMode(15);
                table.getDataRequestManager().setDataRequestMode(0);
                FMIsqlUI.fillData(table, (IRowSet)rowSets.get(i), sqlStmtInfo);
                table.setEditable(tryToEditable && sqlStmtInfo.canAudoUpdate);
                table.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

                    public void editStopped(KDTEditEvent e) {
                        FMIsqlUI.this.table_editStopped(e);
                    }
                });
                pan.add((Component)table);
            }
            this.tabMain.setSelectedComponent((Component)this.scrpRowsets);
        } else if (rowSets.size() == 1) {
            KDTable table = new KDTable();
            KDTMenuManager tableMenuMgr = new KDTMenuManager(table);
            tableMenuMgr.setTempFile(EnvUtils.getTempDir());
            table.getSelectManager().setSelectMode(15);
            table.getDataRequestManager().setDataRequestMode(0);
            FMIsqlUI.fillData(table, (IRowSet)rowSets.get(0), sqlStmtInfo);
            table.setEditable(tryToEditable && sqlStmtInfo.canAudoUpdate);
            table.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

                public void editStopped(KDTEditEvent e) {
                    FMIsqlUI.this.table_editStopped(e);
                }
            });
            this.scrpRowsets.getViewport().add((Component)table);
            this.scrpRowsets.getViewport().setLayout(new GridLayout(rowSets.size(), 1));
            this.tabMain.setSelectedComponent((Component)this.scrpRowsets);
        }
        if (rs.getUpdateCount() > 0) {
            this.txtMsg.insert("\nupdate Count:" + rs.getUpdateCount(), 0);
        }
    }

    protected void table_editStopped(KDTEditEvent e) {
    }

    public void fillException(Exception exp) {
        logger.error((Object)"", (Throwable)exp);
        this.txtMsg.insert(exp.getMessage(), 0);
        this.tabMain.setSelectedComponent((Component)this.scrpMsg);
    }

    public static void fillData(KDTable tblMain, IRowSet rs, SQLStmtInfo sqlStmtInfo) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        FMIsqlUI.fillHeader(tblMain, meta, sqlStmtInfo);
        FMIsqlUI.fillBody(tblMain, rs, sqlStmtInfo);
    }

    public static void fillBody(KDTable tblMain, IRowSet rs, SQLStmtInfo sqlStmtInfo) throws SQLException {
        int c = rs.getMetaData().getColumnCount();
        while (rs.next()) {
            IRow row = tblMain.addRow();
            for (int i = 0; i < c; ++i) {
                Object object = rs.getObject(i + 1);
                row.getCell(i).setValue(object);
                if (object instanceof Timestamp) {
                    row.getCell(i).setEditor((ICellEditor)DateTimePickerEditor.getInstance());
                }
                if (object instanceof Integer) {
                    row.getCell(i).setEditor((ICellEditor)IntTextEditor.getInstance());
                }
                if (!(object instanceof BigDecimal)) continue;
                if (BigDecimal.ZERO.compareTo((BigDecimal)object) == 0) {
                    row.getCell(i).setValue((Object)BigDecimal.ZERO);
                }
                row.getCell(i).setEditor((ICellEditor)NumberTextEditor.getInstance());
            }
        }
    }

    public static void fillHeader(KDTable tblMain, ResultSetMetaData meta, SQLStmtInfo sqlStmtInfo) throws SQLException {
        tblMain.setUserObject((Object)sqlStmtInfo);
        int c = meta.getColumnCount();
        IRow row = tblMain.addHeadRow();
        for (int i = 0; i < c; ++i) {
            tblMain.addColumn();
            row.getCell(i).setValue((Object)meta.getColumnName(i + 1));
        }
    }

    private String getSql() {
        String txt = this.txtScript.getSelectedText();
        if (FMIsqlUI.isEmpty(txt)) {
            txt = this.txtScript.getText();
        }
        return txt;
    }

    public void onLoad() throws Exception {
        URL url;
        super.onLoad();
        this.btnShowTables.setVisible(false);
        if (new File(SQLCACHEFILE).exists()) {
            this.txtScript.setText(StringSerializer.loadFromFile((String)SQLCACHEFILE));
        }
        if ((url = this.getPage()) != null) {
            this.txtAbout.setPage(url);
        } else {
            this.txtAbout.setText(FMIsqlUIHandler.getAboutInfo());
        }
        this.actionUUIDSearches.setEnabled(true);
    }

    private URL getPage() {
        return ((Object)((Object)this)).getClass().getClassLoader().getResource("com/kingdee/eas/fm/common/client/isqlhtml.htm");
    }

    @Override
    public void actionGCClient_actionPerformed(ActionEvent e) throws Exception {
        super.actionGCClient_actionPerformed(e);
        String rst = null;
        rst = FMIsqlUI.gc();
        if (rst != null) {
            this.txtMsg.insert("\nresult :\n" + rst.toString(), 0);
            this.tabMain.setSelectedComponent((Component)this.scrpMsg);
        }
    }

    @Override
    public void actionGCServer_actionPerformed(ActionEvent e) throws Exception {
        super.actionGCServer_actionPerformed(e);
        IFMIsqlFacade facade = FMIsqlFacadeFactory.getRemoteInstance();
        String rst = null;
        try {
            rst = facade.gc();
        }
        catch (BOSException exp) {
            this.fillException((Exception)((Object)exp));
        }
        if (rst != null) {
            this.txtMsg.insert("\nresult :\n" + rst.toString(), 0);
            this.tabMain.setSelectedComponent((Component)this.scrpMsg);
        }
    }

    @Override
    public void actionRunScriptClient_actionPerformed(ActionEvent e) throws Exception {
        super.actionRunScriptClient_actionPerformed(e);
        Object rst = null;
        String sql = this.getSql();
        if (FMIsqlUI.isEmpty(sql)) {
            return;
        }
        try {
            rst = ScriptUtil.evalExpr((String)sql, null);
        }
        catch (Exception exp) {
            this.fillException(exp);
        }
        if (rst != null) {
            if (rst instanceof Undefined) {
                Undefined new_name = (Undefined)rst;
                rst = new_name.readResolve();
            }
            if (rst instanceof TestResult) {
                TestResult trst = (TestResult)rst;
                Enumeration er = trst.errors();
                while (er.hasMoreElements()) {
                    TestFailure n = (TestFailure)er.nextElement();
                    this.txtMsg.insert("\nresult :\n" + n.trace(), 0);
                }
            }
            this.txtMsg.insert("\nresult :\n" + rst.toString(), 0);
            this.tabMain.setSelectedComponent((Component)this.scrpMsg);
        }
    }

    @Override
    public void actionRunScriptServer_actionPerformed(ActionEvent e) throws Exception {
        super.actionRunScriptServer_actionPerformed(e);
        IFMIsqlFacade facade = FMIsqlFacadeFactory.getRemoteInstance();
        Object rst = null;
        try {
            String script = this.getSql();
            rst = facade.runScript(script);
        }
        catch (Exception exp) {
            this.fillException(exp);
        }
        if (rst != null) {
            this.txtMsg.insert("\nresult :\n" + rst.toString(), 0);
            this.tabMain.setSelectedComponent((Component)this.scrpMsg);
        }
    }

    @Override
    public void actionOptional_actionPerformed(ActionEvent e) throws Exception {
        super.actionOptional_actionPerformed(e);
        FMIsqlOptional.showDialogWindow().getDbType();
    }

    @Override
    public void actionTransSql_actionPerformed(ActionEvent e) throws Exception {
        super.actionTransSql_actionPerformed(e);
        IFMIsqlFacade facade = FMIsqlFacadeFactory.getRemoteInstance();
        StringBuffer sb = new StringBuffer();
        String script = this.getSql();
        sb.append("ksql:\n" + script);
        sb.append("\n");
        String rst = null;
        try {
            rst = facade.transSql(script, 1);
            sb.append("DB2_UDB:\n" + rst);
            sb.append("\n");
            rst = facade.transSql(script, 3);
        }
        catch (Exception exp) {
            this.fillException(exp);
        }
        try {
            sb.append("MS_SQL_Server:\n" + rst);
            sb.append("\n");
            rst = facade.transSql(script, 2);
        }
        catch (Exception exp) {
            this.fillException(exp);
        }
        try {
            sb.append("Oracle:\n" + rst);
            sb.append("\n");
            rst = facade.transSql(script, 7);
        }
        catch (Exception exp) {
            this.fillException(exp);
        }
        try {
            sb.append("Oracle9:\n" + rst);
            sb.append("\n");
        }
        catch (Exception exp) {
            this.fillException(exp);
        }
        if (sb != null) {
            this.txtMsg.insert("\nresult :\n" + sb.toString(), 0);
            this.tabMain.setSelectedComponent((Component)this.scrpMsg);
        }
    }

    @Override
    public void actionShowTableDef_actionPerformed(ActionEvent e) throws Exception {
        String tblName = JOptionPane.showInputDialog((Component)((Object)this), EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"51_FMIsqlUI"), this.txtScript.getSelectedText());
        if (tblName != null && tblName.trim().length() > 0) {
            this.executeSQL("SHOW COLUMNS FROM " + tblName.trim().toUpperCase(), false);
        }
    }

    @Override
    public void actionShowTables_actionPerformed(ActionEvent e) throws Exception {
        super.actionShowTables_actionPerformed(e);
        this.executeSQL("SHOW TABLES", false);
    }

    @Override
    public void actionEntitySearch_actionPerformed(ActionEvent e) throws Exception {
        UIContext ctx = new UIContext((Object)this.getUIContext());
        ctx.put((Object)"Owner", (Object)this);
        IUIWindow searchUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(FMIsqlSearchTableUI.class.getName(), (Map)ctx);
        searchUI.show();
        FMIsqlSearchTableUI ui = (FMIsqlSearchTableUI)searchUI.getUIObject();
        if (ui.isOK()) {
            String value = ui.getTextToSearch();
            StringBuffer sb = new StringBuffer();
            sb.append(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"52_FMIsqlUI"));
            sb.append("where FAlias like '%").append(value).append("%'");
            this.executeSQL(sb.toString(), false);
        }
    }

    @Override
    public void actionUUIDSearches_actionPerformed(ActionEvent e) throws Exception {
        String uuid = JOptionPane.showInputDialog((Component)((Object)this), EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"53_FMIsqlUI"), "");
        if ("".equals(uuid) || uuid == null) {
            return;
        }
        BOSObjectType bosType = null;
        try {
            bosType = BOSUuid.read((String)uuid).getType();
        }
        catch (Exception ex) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"54_FMIsqlUI"));
            SysUtil.abort();
        }
        if (bosType == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"55_FMIsqlUI"));
            SysUtil.abort();
        }
        String msg = FMIsqlFacadeFactory.getRemoteInstance().wholeSearchs(uuid);
        UIContext uic = new UIContext((Object)this);
        if (msg.length() > 0) {
            MsgBox.showInfo((String)msg);
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"56_FMIsqlUI"));
        }
    }

    @Override
    public void actionShowByUUID_actionPerformed(ActionEvent e) throws Exception {
        int ret;
        String uuid = JOptionPane.showInputDialog((Component)((Object)this), EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"53_FMIsqlUI"), "");
        if (uuid == null || uuid.trim().length() <= 0) {
            return;
        }
        uuid = uuid.trim();
        BOSObjectType bosType = null;
        try {
            bosType = BOSUuid.read((String)uuid).getType();
        }
        catch (Exception ex) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"54_FMIsqlUI"));
            SysUtil.abort();
        }
        if (bosType == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"55_FMIsqlUI"));
            SysUtil.abort();
        }
        EntityObjectInfo entityInfo = EJBAccessFactory.createRemoteInstance().getEntityInfo(bosType);
        String tableName = FMIsqlFacadeFactory.getRemoteInstance().getTableNameByBosType(bosType);
        if (entityInfo == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"55_FMIsqlUI"));
            SysUtil.abort();
        }
        StringBuffer sb = new StringBuffer();
        sb.append(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"57_FMIsqlUI")).append(entityInfo.getAlias()).append("\n");
        sb.append(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"58_FMIsqlUI")).append(entityInfo.getFullName()).append("\n");
        DataTableInfo tableInfo = entityInfo.getTable();
        String table = tableInfo == null ? EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"111_FMIsqlUI") : tableInfo.getName();
        sb.append(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"59_FMIsqlUI")).append(tableName).append("\n\n\n\n");
        sb.append(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"60_FMIsqlUI"));
        if (table != null && (ret = JOptionPane.showConfirmDialog((Component)((Object)this), sb.toString(), EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"61_FMIsqlUI"), 0)) == 0) {
            this.executeSQL("select * from " + tableName + " where FID='" + uuid + "'", true);
        }
    }

    @Override
    public void actioShowTableByUUid_actionPerformed(ActionEvent e) throws Exception {
        String uuid = JOptionPane.showInputDialog((Component)((Object)this), EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"53_FMIsqlUI"), "");
        if (uuid == null || uuid.trim().length() <= 0) {
            return;
        }
        uuid = uuid.trim();
        BOSObjectType bosType = null;
        try {
            bosType = BOSUuid.read((String)uuid).getType();
        }
        catch (Exception ex) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"54_FMIsqlUI"));
            SysUtil.abort();
        }
        if (bosType == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"55_FMIsqlUI"));
            SysUtil.abort();
        }
        EntityObjectInfo entityInfo = EJBAccessFactory.createRemoteInstance().getEntityInfo(bosType);
        String tableName = FMIsqlFacadeFactory.getRemoteInstance().getTableNameByBosType(bosType);
        if (entityInfo == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"55_FMIsqlUI"));
            SysUtil.abort();
        }
        String tablenametxt = "select * from " + tableName + " where fid ='" + uuid + "'";
        JOptionPane.showInputDialog((Component)((Object)this), "--------" + tablenametxt + "--------", tablenametxt);
    }

    public void caretUpdate(CaretEvent e) {
    }

    @Override
    public void actionRebuildEntityRef_actionPerformed(ActionEvent e) throws Exception {
        boolean result = RefCheckerFactory.getRemoteInstance().rebuildReference();
        if (result) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"62_FMIsqlUI"));
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"63_FMIsqlUI"));
        }
    }

    public static String gc() {
        Runtime runtime = Runtime.getRuntime();
        double d = (double)runtime.totalMemory() / 1048576.0;
        double d1 = (double)runtime.maxMemory() / 1048576.0;
        double d2 = (double)runtime.freeMemory() / 1048576.0;
        double d3 = d - d2;
        System.gc();
        System.gc();
        System.gc();
        Thread.yield();
        double d4 = (double)runtime.totalMemory() / 1048576.0;
        double d5 = (double)runtime.maxMemory() / 1048576.0;
        double d6 = (double)runtime.freeMemory() / 1048576.0;
        double d7 = d4 - d6;
        NumberFormat numberformat = NumberFormat.getNumberInstance();
        numberformat.setMaximumFractionDigits(3);
        StringBuffer sb = new StringBuffer(100);
        sb.append("Memory Usage in MegaBytes");
        sb.append("Before Garbage Collection:\n\tMaximum Allowable Memory Size:\t\t");
        sb.append(numberformat.format(d1));
        sb.append("\n");
        sb.append("\tMemory Allocated:\t\t\t");
        sb.append(numberformat.format(d));
        sb.append("\n");
        sb.append("\tMemory Used:\t\t\t\t");
        sb.append(numberformat.format(d3));
        sb.append("\n");
        sb.append("\tMemory Available:\t\t\t");
        sb.append(numberformat.format(d2));
        sb.append("\n");
        sb.append("\n");
        sb.append("After Garbage Collection:\n");
        sb.append("\tMaximum Allowable Memory Size:\t\t");
        sb.append(numberformat.format(d5));
        sb.append("\n");
        sb.append("\tMemory Allocated:\t\t\t");
        sb.append(numberformat.format(d4));
        sb.append("\n");
        sb.append("\tMemory Used:\t\t\t\t");
        sb.append(numberformat.format(d7));
        sb.append("\n");
        sb.append("\tMemory Available:\t\t\t");
        sb.append(numberformat.format(d6));
        return sb.toString();
    }

    static {
        sb.append("select '| Operation                  |  Name              |  Rows | Bytes|  Cost  |  TQ  |IN-OUT| PQ Distrib | Pstart| Pstop |'  as \"Plan Table\" from dual  ");
        sb.append("union all                                                                                                                                                   ");
        sb.append("select '----------------------------------------------------------------------------------------------------------------------' from dual                   ");
        sb.append("                                                                                                                                                            ");
        sb.append(" union all                                                                                                                                                  ");
        sb.append("                                                                                                                                                            ");
        sb.append("select * from                                                                                                                                               ");
        sb.append("(select /*+ no_merge */                                                                                                                                     ");
        sb.append("       rpad('| '||substr(lpad(' ',1*(level-1))||operation||                                                                                                 ");
        sb.append("            decode(options, null,'',' '||options), 1, 28), 29, ' ')||'|'||                                                                                  ");
        sb.append("       rpad(substr(decode(substr(object_name, 1, 7), 'SYS_LE_', null, object_name)                                                                          ");
        sb.append("                   ||' ',1, 19), 20, ' ')||'|'||                                                                                                            ");
        sb.append("       lpad(decode(cardinality,null,'  ',                                                                                                                   ");
        sb.append("                decode(sign(cardinality-1000), -1, cardinality||' ',                                                                                        ");
        sb.append("                decode(sign(cardinality-1000000), -1, trunc(cardinality/1000)||'K',                                                                         ");
        sb.append("                decode(sign(cardinality-1000000000), -1, trunc(cardinality/1000000)||'M',                                                                   ");
        sb.append("                       trunc(cardinality/1000000000)||'G')))), 7, ' ') || '|' ||                                                                            ");
        sb.append("       lpad(decode(bytes,null,' ',                                                                                                                          ");
        sb.append("                decode(sign(bytes-1024), -1, bytes||' ',                                                                                                    ");
        sb.append("                decode(sign(bytes-1048576), -1, trunc(bytes/1024)||'K',                                                                                     ");
        sb.append("                decode(sign(bytes-1073741824), -1, trunc(bytes/1048576)||'M',                                                                               ");
        sb.append("                       trunc(bytes/1073741824)||'G')))), 6, ' ') || '|' ||                                                                                  ");
        sb.append("       lpad(decode(cost,null,' ',                                                                                                                           ");
        sb.append("                decode(sign(cost-10000000), -1, cost||' ',                                                                                                  ");
        sb.append("                decode(sign(cost-1000000000), -1, trunc(cost/1000000)||'M',                                                                                 ");
        sb.append("                       trunc(cost/1000000000)||'G'))), 8, ' ') || '|' ||                                                                                    ");
        sb.append("       lpad(decode(object_node,null,' ',                                                                                                                    ");
        sb.append("              substr(object_node,length(object_node)-3,1) || ',' ||                                                                                         ");
        sb.append("              substr(object_node,length(object_node)-1,2))||' ', 6, ' ') || '|' ||                                                                          ");
        sb.append("       lpad(decode(other_tag, null,' ',                                                                                                                     ");
        sb.append("            decode(other_tag,'PARALLEL_TO_SERIAL', ' P->S',                                                                                                 ");
        sb.append("            decode(other_tag, 'PARALLEL_TO_PARALLEL', ' P->P',                                                                                              ");
        sb.append("            decode(other_tag, 'PARALLEL_COMBINED_WITH_PARENT', ' PCWP',                                                                                     ");
        sb.append("            decode(other_tag, 'PARALLEL_FROM_SERIAL', ' S->P',                                                                                              ");
        sb.append("            decode(other_tag, 'PARALLEL_COMBINED_WITH_CHILD', ' PCWC',                                                                                      ");
        sb.append("                   decode(other_tag,null,' ',other_tag)))))))||' ', 6, ' ') || '|' ||                                                                       ");
        sb.append("       rpad(' '||decode(distribution, null,' ',                                                                                                             ");
        sb.append("          decode(distribution, 'PARTITION (ROWID)', 'PART (RID)',                                                                                           ");
        sb.append("          decode(distribution, 'PARTITION (KEY)', 'PART (KEY)',                                                                                             ");
        sb.append("          decode(distribution, 'ROUND-ROBIN', 'RND-ROBIN',                                                                                                  ");
        sb.append("          decode(distribution, 'BROADCAST', 'BROADCAST', distribution))))), 12, ' ') || '|' ||                                                              ");
        sb.append("       lpad(decode(partition_start, 'ROW LOCATION', 'ROWID',                                                                                                ");
        sb.append("            decode(partition_start, 'KEY', 'KEY', decode(partition_start,                                                                                   ");
        sb.append("            'KEY(INLIST)', 'KEY(I)', decode(substr(partition_start, 1, 6),                                                                                  ");
        sb.append("            'NUMBER', substr(substr(partition_start, 8, 10), 1,                                                                                             ");
        sb.append("            length(substr(partition_start, 8, 10))-1),                                                                                                      ");
        sb.append("            decode(partition_start,null,' ',partition_start)))))||' ', 7, ' ')|| '|' ||                                                                     ");
        sb.append("       lpad(decode(partition_stop, 'ROW LOCATION', 'ROW L',                                                                                                 ");
        sb.append("          decode(partition_stop, 'KEY', 'KEY', decode(partition_stop,                                                                                       ");
        sb.append("          'KEY(INLIST)', 'KEY(I)', decode(substr(partition_stop, 1, 6),                                                                                     ");
        sb.append("          'NUMBER', substr(substr(partition_stop, 8, 10), 1,                                                                                                ");
        sb.append("          length(substr(partition_stop, 8, 10))-1),                                                                                                         ");
        sb.append("          decode(partition_stop,null,' ',partition_stop)))))||' ', 7, ' ')||'|' as \"Explain plan\"                                                           ");
        sb.append("from plan_table                                                                                                                                             ");
        sb.append("start with id=0 and timestamp = (select max(timestamp) from plan_table                                                                                      ");
        sb.append("                                 where id=0 and nvl(statement_id, ' ') not like 'SYS_LE%')                                                                  ");
        sb.append("                and nvl(statement_id, ' ') not like 'SYS_LE%'                                                                                               ");
        sb.append("connect by (prior id = parent_id                                                                                                                            ");
        sb.append("        and prior nvl(statement_id, ' ') = nvl(statement_id, ' ')                                                                                           ");
        sb.append("        and prior timestamp <= timestamp)                                                                                                                   ");
        sb.append("        or                                                                                                                                                  ");
        sb.append("       (prior nvl(object_name, ' ') like 'SYS_LE%' and prior nvl(object_name, ' ') = nvl(statement_id, ' ')                                                 ");
        sb.append("        and id = 0 and prior timestamp <= timestamp)                                                                                                        ");
        sb.append("order siblings by id, position)                                                                                                                             ");
        sb.append("                                                                                                                                                            ");
        sb.append("                                                                                                                                                            ");
        sb.append("union all                                                                                                                                                   ");
        sb.append("select '----------------------------------------------------------------------------------------------------------------------' from dual                   ");
        SQLCACHEFILE = EnvUtils.getUserHome() + EnvUtils.getFileSeparator() + "iEIPsql.eas";
        kdp = new KDPopupMenu();
    }

    class CaretListenerSelf
    implements CaretListener {
        CaretListenerSelf() {
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            FMIsqlUI.this.cursorPosition = e.getDot();
            logger.debug((Object)(FMIsqlUI.this.cursorPosition + "==============="));
        }
    }
}

