/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.schedule.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.csinterface.schedule.ScheduleFactory;
import com.kingdee.eas.csinterface.schedule.client.AbstractWSScheduleListUI;
import com.kingdee.eas.csinterface.schedule.util.CronExpTranslation;
import com.kingdee.eas.csinterface.util.BtnEASPivot;
import com.kingdee.eas.csinterface.util.MyKDTableUtil;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class WSScheduleListUI
extends AbstractWSScheduleListUI {
    private static final Logger logger = CoreUIObject.getLogger(WSScheduleListUI.class);
    private Map<String, Boolean> scheduleStatusMap = new HashMap<String, Boolean>();
    private static final int STATUS_DISABLED = 1;
    private static final int STATUS_ENABLED = 2;
    private static final int STATUS_BATCH_ENABLED = 3;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        BtnEASPivot.btnInVisible(this);
        this.switchButtonsStatus(-1);
        this.enableScheduleButton.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        this.disableScheduleButton.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.disableScheduleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List selectedIds = WSScheduleListUI.this.getSelectedIds();
                if (selectedIds.size() == 0) {
                    return;
                }
                StringBuffer errorMsg = new StringBuffer();
                for (String selectedId : selectedIds) {
                    if (selectedId == null) continue;
                    try {
                        ScheduleFactory.getRemoteInstance().disableSchedule(selectedId);
                    }
                    catch (Exception exp) {
                        errorMsg.append(selectedId + ":" + exp.getMessage() + ";");
                    }
                }
                if (errorMsg.length() > 0) {
                    MsgBox.showError((String)("\u7981\u7528\u8c03\u5ea6\u7b56\u7565\u5931\u8d25:" + errorMsg.toString()));
                }
                try {
                    WSScheduleListUI.this.refreshList();
                    if (WSScheduleListUI.this.tblMain.getRowCount() > 0) {
                        KDTableUtil.setSelectedRow((KDTable)WSScheduleListUI.this.tblMain, (int)0);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.enableScheduleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List selectedIds = WSScheduleListUI.this.getSelectedIds();
                if (selectedIds.size() == 0) {
                    return;
                }
                StringBuffer errorMsg = new StringBuffer();
                for (String selectedId : selectedIds) {
                    if (selectedId == null) continue;
                    try {
                        ScheduleFactory.getRemoteInstance().enableSchedule(selectedId);
                    }
                    catch (Exception exp) {
                        errorMsg.append(selectedId + ":" + exp.getMessage() + ";");
                    }
                }
                if (errorMsg.length() > 0) {
                    MsgBox.showError((String)("\u542f\u7528\u8c03\u5ea6\u7b56\u7565\u5931\u8d25:" + errorMsg.toString()));
                }
                try {
                    WSScheduleListUI.this.refreshList();
                    if (WSScheduleListUI.this.tblMain.getRowCount() > 0) {
                        KDTableUtil.setSelectedRow((KDTable)WSScheduleListUI.this.tblMain, (int)0);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.tblMain.getSelectManager().addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                ArrayList ids = WSScheduleListUI.this.getSelectedIdValues();
                if (ids != null && !ids.isEmpty()) {
                    if (ids.size() > 1) {
                        WSScheduleListUI.this.switchButtonsStatus(3);
                    } else {
                        boolean enable = (Boolean)WSScheduleListUI.this.scheduleStatusMap.get(ids.get(0));
                        WSScheduleListUI.this.switchButtonsStatus(enable ? 1 : 2);
                        if (WSScheduleListUI.this.enableScheduleButton.isEnabled()) {
                            WSScheduleListUI.this.btnEdit.setEnabled(true);
                        }
                    }
                }
            }
        });
        this.enableScheduleButton.setEnabled(true);
        this.disableScheduleButton.setEnabled(true);
        this.btnEdit.setEnabled(true);
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        try {
            int idIndex = -1;
            int descriptionIndex = -1;
            int timerRuleExpresssionIndex = -1;
            int enabledIndex = -1;
            int timerStartDateIndex = -1;
            ResultSetMetaData metaData = rowSet.getMetaData();
            for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                String columnName = metaData.getColumnName(i);
                if ("id".equalsIgnoreCase(columnName)) {
                    idIndex = i;
                    continue;
                }
                if ("description".equalsIgnoreCase(columnName)) {
                    descriptionIndex = i;
                    continue;
                }
                if ("timerRuleExpresssion".equalsIgnoreCase(columnName)) {
                    timerRuleExpresssionIndex = i;
                    continue;
                }
                if ("enabled".equalsIgnoreCase(columnName)) {
                    enabledIndex = i;
                    continue;
                }
                if (!"timerStartDate".equalsIgnoreCase(columnName)) continue;
                timerStartDateIndex = i;
            }
            rowSet.beforeFirst();
            while (rowSet.next()) {
                String timerRuleExpresssion = rowSet.getString(timerRuleExpresssionIndex);
                if (StringUtils.isEmpty((String)timerRuleExpresssion)) continue;
                timerRuleExpresssion = timerRuleExpresssion.replaceAll("[^:]+:", "").trim();
                rowSet.updateString(descriptionIndex, new CronExpTranslation(rowSet.getDate(timerStartDateIndex), timerRuleExpresssion).parse());
                rowSet.updateString(timerRuleExpresssionIndex, timerRuleExpresssion);
                this.scheduleStatusMap.put(rowSet.getString(idIndex), rowSet.getBoolean(enabledIndex));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    protected void beforeExcutQuery(EntityViewInfo ev) {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("actionType", (Object)String.valueOf(1024), CompareType.EQUALS));
        try {
            ev.getFilter().mergeFilter(filterInfo, "AND");
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        super.beforeExcutQuery(ev);
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    private String getSelectedId() {
        ArrayList ids = this.getSelectedIdValues();
        if (ids != null && ids.size() > 0) {
            return (String)ids.get(0);
        }
        return null;
    }

    private List<String> getSelectedIds() {
        ArrayList<String> selectedIds = new ArrayList<String>();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        Object id = "";
        for (int i = 0; i < selectRows.length; ++i) {
            try {
                id = MyKDTableUtil.getTableCellValue(this.tblMain, selectRows[i], "id");
                selectedIds.add(id.toString());
                continue;
            }
            catch (Exception e2) {
                MsgBox.showInfo((String)e2.getMessage());
                e2.printStackTrace();
            }
        }
        return selectedIds;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
    }

    private void switchButtonsStatus(int status) {
        switch (status) {
            case 1: {
                this.btnEdit.setEnabled(false);
                this.btnRemove.setEnabled(false);
                this.enableScheduleButton.setEnabled(false);
                this.disableScheduleButton.setEnabled(true);
                break;
            }
            case 2: {
                this.btnEdit.setEnabled(true);
                this.btnRemove.setEnabled(true);
                this.enableScheduleButton.setEnabled(true);
                this.disableScheduleButton.setEnabled(false);
                break;
            }
            case 3: {
                this.btnEdit.setEnabled(false);
                this.btnRemove.setEnabled(false);
                this.enableScheduleButton.setEnabled(true);
                this.disableScheduleButton.setEnabled(true);
                break;
            }
            default: {
                this.btnEdit.setEnabled(false);
                this.btnRemove.setEnabled(false);
                this.enableScheduleButton.setEnabled(false);
                this.disableScheduleButton.setEnabled(false);
            }
        }
    }

    protected String getEditUIName() {
        return "com.kingdee.eas.csinterface.schedule.client.WSScheduleEditUI";
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ScheduleFactory.getRemoteInstance();
    }
}

