/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.syncdatabase.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.util.StringUtil;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.csinterface.billmapping.BillMappingCollection;
import com.kingdee.eas.csinterface.billmapping.BillMappingFactory;
import com.kingdee.eas.csinterface.billmapping.BillMappingInfo;
import com.kingdee.eas.csinterface.billmapping.IBillMapping;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataTypeInfo;
import com.kingdee.eas.csinterface.syncdatabase.CheckDataMapFacadeFactory;
import com.kingdee.eas.csinterface.syncdatabase.ExportType;
import com.kingdee.eas.csinterface.syncdatabase.client.AbstractCheckDataMapActionUI;
import com.kingdee.eas.csinterface.syncdatabase.client.CheckDataMapExportUI;
import com.kingdee.eas.csinterface.syncdatabase.client.util.SearchDialogFactoryUtil;
import com.kingdee.eas.csinterface.syncdatabase.util.BaseDataTypeRuleFilter;
import com.kingdee.eas.csinterface.syncdatabase.util.BillMappingBaseDataBean;
import com.kingdee.eas.csinterface.util.Export2FileUtil;
import com.kingdee.eas.csinterface.util.ILongTimeTask2;
import com.kingdee.eas.csinterface.util.LongTimeDialog2;
import com.kingdee.eas.csinterface.util.ThrowableHelper;
import com.kingdee.eas.csinterface.util.UITools2;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JTextField;
import jxl.Workbook;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import org.apache.log4j.Logger;

public class CheckDataMapActionUI
extends AbstractCheckDataMapActionUI {
    private static final Logger logger = CoreUIObject.getLogger(CheckDataMapActionUI.class);
    private List<BillMappingBaseDataBean> result = null;
    private Map<String, Map<String, List<String>>> structResult = null;
    private Map<String, String> billIdNameMap = new HashMap<String, String>();
    private Map<String, String> baseDataIdNameMap = new HashMap<String, String>();
    private Map<String, Map<String, Map<String, String>>> numberNameMap;
    private Map<String, CoreBaseInfo> billMap = new HashMap<String, CoreBaseInfo>();
    private Map<String, CoreBaseInfo> baseDataMap = new HashMap<String, CoreBaseInfo>();
    private Integer exportType;
    private Boolean filterRepeatData;
    private File exportPath = null;
    public static int SHEET_BILL_COUNT = 10;
    public static int Excel_MAX_LINE = 60000;
    private SearchDialogFactoryUtil choseSearchDialog;
    private SearchDialogFactoryUtil resultSearchDialog;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initChoseTable();
        this.initResultTable();
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
    }

    private void initResultTable() {
        this.kdEntrysResult.checkParsed();
        KDCheckBox check = new KDCheckBox();
        check.setName("isSelected");
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JCheckBox)check);
        this.kdEntrysResult.getColumn("isSelected").setEditor((ICellEditor)editor);
        KDTextField billMappingName = new KDTextField();
        billMappingName.setName("billMappingName");
        billMappingName.setEditable(false);
        KDTDefaultCellEditor nameEdit = new KDTDefaultCellEditor((JTextField)billMappingName);
        this.kdEntrysResult.getColumn("billMappingName").setEditor((ICellEditor)nameEdit);
        KDTextField baseDataType = new KDTextField();
        baseDataType.setName("baseDataType");
        baseDataType.setEditable(false);
        KDTDefaultCellEditor baseData = new KDTDefaultCellEditor((JTextField)baseDataType);
        this.kdEntrysResult.getColumn("baseDataType").setEditor((ICellEditor)baseData);
        KDTextField info = new KDTextField();
        info.setName("info");
        info.setEditable(false);
        KDTDefaultCellEditor infoEdit = new KDTDefaultCellEditor((JTextField)info);
        this.kdEntrysResult.getColumn("info").setEditor((ICellEditor)infoEdit);
    }

    private void initChoseTable() {
        try {
            this.kdEntrysChose.checkParsed();
            KDCheckBox check = new KDCheckBox();
            check.setName("isSelected");
            KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JCheckBox)check);
            this.kdEntrysChose.getColumn("isSelected").setEditor((ICellEditor)editor);
            KDTextField billMappingName = new KDTextField();
            billMappingName.setName("billMappingName");
            billMappingName.setEditable(false);
            KDTDefaultCellEditor nameEdit = new KDTDefaultCellEditor((JTextField)billMappingName);
            this.kdEntrysChose.getColumn("billMappingName").setEditor((ICellEditor)nameEdit);
            IBillMapping billMapping = BillMappingFactory.getRemoteInstance();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("published", (Object)true, CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("srcDBConn.id", null, CompareType.NOTEQUALS));
            view.setFilter(filterInfo);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("srcDBConn.*"));
            view.setSelector(sic);
            BillMappingCollection coll = billMapping.getBillMappingCollection(view);
            coll.sort("number");
            for (int i = 0; i < coll.size(); ++i) {
                BillMappingInfo info = coll.get(i);
                IRow newRow = this.kdEntrysChose.addRow();
                newRow.getCell("id").setValue((Object)info.getId().toString());
                newRow.getCell("isSelected").setValue((Object)false);
                newRow.getCell("billMappingName").setValue((Object)info.getBillMappingName());
                this.billIdNameMap.put(info.getId().toString(), info.getBillMappingName());
                this.billMap.put(info.getId().toString(), (CoreBaseInfo)info);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
    }

    @Override
    protected void kdEntrysChose_editStart(KDTEditEvent e) throws Exception {
        this.exportTypeSelect.requestFocusInWindow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void start_clicked(MouseEvent e) throws Exception {
        try {
            final ArrayList<String> billMappingIds = new ArrayList<String>();
            for (int i = 0; i < this.kdEntrysChose.getRowCount(); ++i) {
                IRow row = this.kdEntrysChose.getRow(i);
                Boolean isSelected = (Boolean)row.getCell("isSelected").getValue();
                if (!isSelected.equals(true)) continue;
                String billMappingId = (String)row.getCell("id").getValue();
                billMappingIds.add(billMappingId);
            }
            if (billMappingIds.isEmpty()) {
                MsgBox.showInfo((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u5355\u636e\u6620\u5c04!");
                SysUtil.abort();
            }
            this.clearKdTableResult();
            this.result = new ArrayList<BillMappingBaseDataBean>();
            final LongTimeDialog2 dialog = UITools2.getDialog((Component)((Object)this), "\u5904\u7406\u4e2d", "\u8bf7\u7a0d\u540e");
            dialog.setLongTimeTask(new ILongTimeTask2(){
                private Exception exception;
                String excMsg = "";

                @Override
                public Object exec() throws Exception {
                    try {
                        int sum = billMappingIds.size();
                        for (int i = 0; i < sum; ++i) {
                            dialog.updateMsg("\u6b63\u5728\u6267\u884c" + Integer.valueOf(i * 100 / sum) + "%(" + i + "/" + sum + ")   " + (String)CheckDataMapActionUI.this.billIdNameMap.get(billMappingIds.get(i)));
                            ArrayList billmappingId = new ArrayList();
                            billmappingId.add(billMappingIds.get(i));
                            List resultList = CheckDataMapFacadeFactory.getRemoteInstance().checkDataMapByBillMapping(billmappingId);
                            CheckDataMapActionUI.this.result.addAll(resultList);
                        }
                        CheckDataMapActionUI.this.initKdTableResult();
                        MsgBox.showInfo((String)"\u6267\u884c\u6210\u529f");
                        return "success";
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.exception = e;
                        return this.excMsg;
                    }
                }

                @Override
                public void afterExec(Object result) throws Exception {
                    if (this.exception != null) {
                        Exception ca = this.exception;
                        MsgBox.showDetailAndOK((Component)((Object)CheckDataMapActionUI.this), (String)"\u6267\u884c\u5931\u8d25!", (String)ThrowableHelper.toString((Throwable)ca), (int)1);
                    }
                }
            });
            dialog.show();
        }
        catch (Exception e0) {
            e0.printStackTrace();
        }
    }

    private void clearKdTableResult() {
        if (this.result != null) {
            this.result.clear();
        }
        this.kdEntrysResult.removeRows();
    }

    private void initKdTableResult() {
        if (this.result == null) {
            return;
        }
        this.structResult = new HashMap<String, Map<String, List<String>>>();
        StringBuilder errorMsg = new StringBuilder();
        for (int i = 0; i < this.result.size(); ++i) {
            BillMappingBaseDataBean billMappingBaseDataBean = this.result.get(i);
            if (!StringUtil.isEmpty((String)billMappingBaseDataBean.getErrorMsg())) {
                errorMsg.append("\u5355\u636e" + billMappingBaseDataBean.getBillMapping().getBillMappingName() + ":" + billMappingBaseDataBean.getErrorMsg()).append("\n");
                continue;
            }
            BillMappingInfo billMapping = billMappingBaseDataBean.getBillMapping();
            Map<CoreBaseInfo, List<String>> dataMap = billMappingBaseDataBean.getDataMapping();
            HashMap<String, List<String>> dataTypeMap = new HashMap<String, List<String>>();
            if (dataMap != null && !dataMap.isEmpty()) {
                for (CoreBaseInfo info : dataMap.keySet()) {
                    IRow newRow = this.kdEntrysResult.addRow();
                    newRow.getCell("id").setValue((Object)billMapping.getId().toString());
                    newRow.getCell("isSelected").setValue((Object)true);
                    newRow.getCell("billMappingName").setValue((Object)billMapping.getBillMappingName());
                    newRow.getCell("baseDataTypeID").setValue((Object)info.getId().toString());
                    newRow.getCell("baseDataType").setValue(info.get("name"));
                    newRow.getCell("info").setValue((Object)("\u672a\u914d\u7f6e\u7684\u5171\u6709" + dataMap.get(info).size() + "\u4e2a"));
                    this.baseDataIdNameMap.put(info.getId().toString(), (String)info.get("name"));
                    this.baseDataMap.put(info.getId().toString(), info);
                    if (dataTypeMap.containsKey(info.getId().toString())) {
                        ((List)dataTypeMap.get(info.getId().toString())).addAll((Collection)dataMap.get(info));
                        continue;
                    }
                    dataTypeMap.put(info.getId().toString(), dataMap.get(info));
                }
            }
            this.structResult.put(billMapping.getId().toString(), dataTypeMap);
        }
        if (!StringUtil.isEmpty((String)errorMsg.toString())) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)"\u90e8\u5206\u5931\u8d25!", (String)errorMsg.toString(), (int)1);
        }
    }

    @Override
    protected void export_MouseClicked(MouseEvent e) throws Exception {
        this.exportToExcel_mouseClick(e);
    }

    protected void exportToExcel_mouseClick(MouseEvent e) throws Exception {
        Boolean flag = false;
        for (int i = 0; i < this.kdEntrysResult.getRowCount(); ++i) {
            Boolean isSelected = (Boolean)this.kdEntrysResult.getRow(i).getCell("isSelected").getValue();
            if (!isSelected.booleanValue()) continue;
            flag = true;
            break;
        }
        if (!flag.booleanValue()) {
            MsgBox.showInfo((String)"\u6ca1\u6709\u8981\u5bfc\u51fa\u7684\u6570\u636e!");
            return;
        }
        ExportType type = (ExportType)((Object)this.exportTypeSelect.getSelectedItem());
        this.exportType = type.equals((Object)ExportType.exportByBill) ? Integer.valueOf(0) : Integer.valueOf(1);
        this.exportPath = Export2FileUtil.getExportFileWithOutsOverrideTip((Component)((Object)this), "\u5bf9\u5e94\u5173\u7cfb\u5bfc\u51fa", "\u4fdd\u5b58", new String[]{"xls"}, "Excel 1997\u62162003\u7248\u672c", null);
        if (null == this.exportPath) {
            return;
        }
        if (!this.exportPath.exists()) {
            try {
                this.exportPath.mkdirs();
            }
            catch (Exception e1) {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)e1.getMessage(), (String)e1.getMessage(), (int)1);
                SysUtil.abort();
            }
        }
        Calendar date = Calendar.getInstance();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd_HHmmss");
        String name = format.format(date.getTime());
        File file = new File(this.exportPath.toString() + File.separator + name);
        file.mkdir();
        this.exportPath = file;
        this.export();
    }

    private void export() {
        Map<String, List<String>> exportMap = this.generateExportMap();
        if (this.exportType.compareTo(0) == 0) {
            this.numberNameMap = this.obtainBaseDataNameByNumber(exportMap, 0);
            this.exportByBill(exportMap);
        } else {
            this.numberNameMap = this.obtainBaseDataNameByNumber(exportMap, 1);
            this.exportByType(exportMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Map<String, Map<String, String>>> obtainBaseDataNameByNumber(Map<String, List<String>> exportMap, int type) {
        HashMap<String, Map<String, Map<String, String>>> result = new HashMap<String, Map<String, Map<String, String>>>();
        try {
            Iterator<String> ite = exportMap.keySet().iterator();
            if (type == 0) {
                while (ite.hasNext()) {
                    String billId = ite.next();
                    List<String> baseDataTyeIdList = exportMap.get(billId);
                    for (String baseDataTypeId : baseDataTyeIdList) {
                        BaseDataTypeInfo baseDataTypeInfo = (BaseDataTypeInfo)this.baseDataMap.get(baseDataTypeId);
                        List<String> noMapSet = this.structResult.get(billId).get(baseDataTypeId);
                        if (noMapSet == null || noMapSet.isEmpty()) continue;
                        BillMappingInfo billMappingInfo = (BillMappingInfo)this.billMap.get(billId);
                        Map<String, String> map = BaseDataTypeRuleFilter.getNumberNameMap(baseDataTypeInfo, noMapSet, billMappingInfo.getSrcDBConn());
                        HashMap<String, Map<String, String>> noMapByBill = new HashMap<String, Map<String, String>>();
                        noMapByBill.put(billId, map);
                        if (result.containsKey(baseDataTypeId)) {
                            ((Map)result.get(baseDataTypeId)).putAll(noMapByBill);
                            continue;
                        }
                        result.put(baseDataTypeId, noMapByBill);
                    }
                }
            } else {
                while (ite.hasNext()) {
                    String baseDataTypeId = ite.next();
                    BaseDataTypeInfo baseDataTypeInfo = (BaseDataTypeInfo)this.baseDataMap.get(baseDataTypeId);
                    List<String> billMappingIdList = exportMap.get(baseDataTypeId);
                    for (String billId : billMappingIdList) {
                        List<String> noMapSet = this.structResult.get(billId).get(baseDataTypeId);
                        if (noMapSet.isEmpty()) continue;
                        BillMappingInfo billMappingInfo = (BillMappingInfo)this.billMap.get(billId);
                        Map<String, String> map = BaseDataTypeRuleFilter.getNumberNameMap(baseDataTypeInfo, noMapSet, billMappingInfo.getSrcDBConn());
                        HashMap<String, Map<String, String>> noMapByBill = new HashMap<String, Map<String, String>>();
                        noMapByBill.put(billId, map);
                        if (result.containsKey(baseDataTypeId)) {
                            ((Map)result.get(baseDataTypeId)).putAll(noMapByBill);
                            continue;
                        }
                        result.put(baseDataTypeId, noMapByBill);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return result;
    }

    private void exportByType(final Map<String, List<String>> exportMap) {
        final LongTimeDialog2 dialog = UITools2.getDialog((Component)((Object)this), "\u6b63\u5728\u5bfc\u51fa", "\u8bf7\u7a0d\u540e");
        dialog.setLongTimeTask(new ILongTimeTask2(){
            private Exception exception;
            String excMsg = "";

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object exec() throws Exception {
                try {
                    Iterator ite = exportMap.keySet().iterator();
                    int sum = exportMap.keySet().size();
                    int i = 1;
                    while (ite.hasNext()) {
                        String key = (String)ite.next();
                        List list = (List)exportMap.get(key);
                        File file = new File(CheckDataMapActionUI.this.exportPath, ((String)CheckDataMapActionUI.this.baseDataIdNameMap.get(key)).concat(".xls"));
                        if (!file.exists()) {
                            file.createNewFile();
                        }
                        WritableWorkbook workBook = Workbook.createWorkbook((File)file);
                        dialog.updateMsg("\u6b63\u5728\u5bfc\u51faExcel " + Integer.valueOf(i * 100 / sum) + "%(" + i + "/" + sum + ")");
                        int pageSize = (list.size() - 1) / SHEET_BILL_COUNT + 1;
                        for (int j = 0; j < pageSize; ++j) {
                            List result = null;
                            result = j == pageSize - 1 ? list.subList(j * SHEET_BILL_COUNT, list.size()) : list.subList(j * SHEET_BILL_COUNT, (j + 1) * SHEET_BILL_COUNT);
                            CheckDataMapActionUI.this.writeToExcelByType(workBook, key, result, j);
                        }
                        ++i;
                        workBook.write();
                        workBook.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.exception = e;
                }
                return this.excMsg;
            }

            @Override
            public void afterExec(Object result) throws Exception {
                if (this.exception == null) {
                    MsgBox.showDetailAndOK((Component)((Object)CheckDataMapActionUI.this), (String)("\u5bfc\u51faExcel\u6210\u529f!\n\u5bfc\u51fa\u7684\u6587\u4ef6\u5939\u8def\u5f84:" + CheckDataMapActionUI.this.exportPath), (String)("\u5bfc\u51faExcel\u6210\u529f!\n\u5bfc\u51fa\u7684\u6587\u4ef6\u5939\u8def\u5f84:" + CheckDataMapActionUI.this.exportPath), (int)1);
                } else {
                    MsgBox.showDetailAndOK((Component)((Object)CheckDataMapActionUI.this), (String)"\u5bfc\u51faExcel\u5931\u8d25!", (String)ThrowableHelper.toString(this.exception), (int)1);
                }
            }
        });
        dialog.show();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToExcelByType(WritableWorkbook workBook, String type, List<String> result, int sheetIndex) {
        try {
            String sheetName = this.baseDataIdNameMap.get(type);
            if (sheetIndex > 0) {
                sheetName = sheetName + "(" + sheetIndex + ")";
            }
            WritableSheet sheet = workBook.createSheet(sheetName, sheetIndex);
            Label billTip = new Label(0, 0, "\u5355\u636e\u540d\u79f0:");
            sheet.addCell((WritableCell)billTip);
            Label valueTip = new Label(0, 1, "\u503c\u5217\u8868:");
            sheet.addCell((WritableCell)valueTip);
            for (int i = 0; i < result.size(); ++i) {
                String billId = result.get(i);
                Map<String, List<String>> dataMap = this.structResult.get(billId);
                List<String> list = dataMap.get(type);
                Collections.sort(list);
                int columnCount = sheet.getColumns();
                this.writeToExcelByColumn(sheet, list, billId, columnCount, type);
            }
        }
        catch (RowsExceededException e) {
            e.printStackTrace();
        }
        catch (WriteException e) {
            e.printStackTrace();
        }
    }

    private void writeToExcelByColumn(WritableSheet sheet, List<String> list, String billId, int columnCount, String type) throws RowsExceededException, WriteException {
        String billName = this.billIdNameMap.get(billId);
        Label billTip = new Label(columnCount, 0, billName);
        sheet.addCell((WritableCell)billTip);
        int pageSize = (list.size() - 1) / Excel_MAX_LINE + 1;
        sheet.mergeCells(columnCount, 0, columnCount + pageSize * 2 - 1, 0);
        for (int i = 0; i < pageSize; ++i) {
            List<String> result = null;
            result = i == pageSize - 1 ? list.subList(i * Excel_MAX_LINE, list.size()) : list.subList(i * Excel_MAX_LINE, (i + 1) * Excel_MAX_LINE);
            for (int j = 0; j < result.size(); ++j) {
                sheet.setColumnView(columnCount + i * 2, 20);
                sheet.setColumnView(columnCount + i * 2 + 1, 20);
                Label number = new Label(columnCount + i * 2, j + 1, result.get(j));
                sheet.addCell((WritableCell)number);
                Label name = new Label(columnCount + i * 2 + 1, j + 1, this.numberNameMap.get(type) == null ? "" : this.numberNameMap.get(type).get(billId).get(result.get(j)));
                sheet.addCell((WritableCell)name);
            }
        }
    }

    private void exportByBill(final Map<String, List<String>> exportMap) {
        final LongTimeDialog2 dialog = UITools2.getDialog((Component)((Object)this), "\u6b63\u5728\u5bfc\u51fa", "\u8bf7\u7a0d\u540e");
        dialog.setLongTimeTask(new ILongTimeTask2(){
            private Exception exception;
            String excMsg = "";

            @Override
            public Object exec() throws Exception {
                try {
                    Iterator ite = exportMap.keySet().iterator();
                    int sum = exportMap.keySet().size();
                    int i = 1;
                    while (ite.hasNext()) {
                        String key = (String)ite.next();
                        List list = (List)exportMap.get(key);
                        File file = new File(CheckDataMapActionUI.this.exportPath, ((String)CheckDataMapActionUI.this.billIdNameMap.get(key)).concat(".xls"));
                        if (!file.exists()) {
                            file.createNewFile();
                        }
                        WritableWorkbook workBook = Workbook.createWorkbook((File)file);
                        dialog.updateMsg("\u6b63\u5728\u5bfc\u51faExcel" + Integer.valueOf(i * 100 / sum) + "%(" + i + "/" + sum + ")");
                        Map dataTypeMap = (Map)CheckDataMapActionUI.this.structResult.get(key);
                        for (String str : list) {
                            List result = (List)dataTypeMap.get(str);
                            Collections.sort(result);
                            int sheetIndex = workBook.getNumberOfSheets();
                            CheckDataMapActionUI.this.writeToExcelByBill(key, str, result, workBook, sheetIndex, 0);
                        }
                        ++i;
                        workBook.write();
                        workBook.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.exception = e;
                }
                return this.excMsg;
            }

            @Override
            public void afterExec(Object result) throws Exception {
                if (this.exception == null) {
                    MsgBox.showDetailAndOK((Component)((Object)CheckDataMapActionUI.this), (String)("\u5bfc\u51faExcel\u6210\u529f!\n\u5bfc\u51fa\u8def\u5f84:" + CheckDataMapActionUI.this.exportPath), (String)("\u5bfc\u51faExcel\u6210\u529f!\n\u5bfc\u51fa\u8def\u5f84:" + CheckDataMapActionUI.this.exportPath), (int)1);
                } else {
                    MsgBox.showDetailAndOK((Component)((Object)CheckDataMapActionUI.this), (String)"\u5bfc\u51faExcel\u5931\u8d25!", (String)ThrowableHelper.toString(this.exception), (int)1);
                }
            }
        });
        dialog.show();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToExcelByBill(String billId, String str, List<String> result, WritableWorkbook workBook, int sheetIndex, int nameIndex) {
        try {
            String sheetName = this.baseDataIdNameMap.get(str);
            if (nameIndex > 0) {
                sheetName = sheetName + "(" + nameIndex + ")";
            }
            WritableSheet sheet = workBook.createSheet(sheetName, sheetIndex);
            int rowCount = sheet.getRows();
            sheet.setColumnView(0, 20);
            sheet.setColumnView(1, 30);
            for (int i = 0; i < result.size(); ++i) {
                if (i > Excel_MAX_LINE - 1) {
                    this.writeToExcelByBill(billId, str, result.subList(i, result.size()), workBook, sheetIndex + 1, nameIndex + 1);
                    break;
                }
                Label number = new Label(0, i + rowCount, result.get(i));
                sheet.addCell((WritableCell)number);
                Label name = new Label(1, i + rowCount, this.numberNameMap.get(str) == null ? "" : this.numberNameMap.get(str).get(billId).get(result.get(i)));
                sheet.addCell((WritableCell)name);
            }
        }
        catch (RowsExceededException e) {
            e.printStackTrace();
        }
        catch (WriteException e) {
            e.printStackTrace();
        }
    }

    private Map<String, List<String>> generateExportMap() {
        HashMap<String, List<String>> exportMap = new HashMap<String, List<String>>();
        for (int i = 0; i < this.kdEntrysResult.getRowCount(); ++i) {
            List<String> list;
            IRow row = this.kdEntrysResult.getRow(i);
            Boolean isSelected = (Boolean)row.getCell("isSelected").getValue();
            if (!isSelected.booleanValue()) continue;
            String billMappingID = (String)row.getCell("id").getValue();
            String baseDataTypeID = (String)row.getCell("baseDataTypeID").getValue();
            if (this.exportType.compareTo(0) == 0) {
                list = (ArrayList<String>)exportMap.get(billMappingID);
                if (list == null) {
                    list = new ArrayList<String>();
                    list.add(baseDataTypeID);
                    exportMap.put(billMappingID, list);
                    continue;
                }
                list.add(baseDataTypeID);
                continue;
            }
            if (this.exportType.compareTo(1) != 0) continue;
            list = (List)exportMap.get(baseDataTypeID);
            if (list == null) {
                list = new ArrayList();
                list.add(billMappingID);
                exportMap.put(baseDataTypeID, list);
                continue;
            }
            list.add(billMappingID);
        }
        return exportMap;
    }

    @Override
    protected void kdtEntrysResult_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getColIndex() == this.kdEntrysResult.getColumnIndex("info")) {
            int rowIndex = e.getRowIndex();
            String billMappingId = (String)this.kdEntrysResult.getRow(rowIndex).getCell("id").getValue();
            String baseDataTypeId = (String)this.kdEntrysResult.getRow(rowIndex).getCell("baseDataTypeID").getValue();
            BaseDataTypeInfo baseDataTypeInfo = (BaseDataTypeInfo)this.baseDataMap.get(baseDataTypeId);
            BillMappingInfo billMappingInfo = (BillMappingInfo)this.billMap.get(billMappingId);
            List<String> noMapSet = this.structResult.get(billMappingId).get(baseDataTypeId);
            Map<String, String> result = BaseDataTypeRuleFilter.getNumberNameMap(baseDataTypeInfo, noMapSet, billMappingInfo.getSrcDBConn());
            ArrayList<String> dataMap = new ArrayList<String>();
            for (String str : noMapSet) {
                StringBuffer sb = new StringBuffer();
                sb.append(str).append("(").append(result.get(str) == null ? "" : result.get(str)).append(")");
                dataMap.add(sb.toString());
            }
            CheckDataMapExportUI checkDataMapExportUI = new CheckDataMapExportUI();
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"billMappingName", (Object)this.billIdNameMap.get(billMappingId));
            uiContext.put((Object)"baseDataTypeName", (Object)this.baseDataIdNameMap.get(baseDataTypeId));
            uiContext.put((Object)"dataMap", dataMap);
            IUIWindow iWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(((Object)((Object)checkDataMapExportUI)).getClass().getName(), (Map)uiContext, null, OprtState.ADDNEW);
            checkDataMapExportUI = (CheckDataMapExportUI)iWindow.getUIObject();
            checkDataMapExportUI.getUIWindow().show();
        }
    }

    @Override
    protected void cSelectAll_actionPerformed(ActionEvent e) throws Exception {
        for (int i = 0; i < this.kdEntrysChose.getRowCount(); ++i) {
            this.kdEntrysChose.getRow(i).getCell("isSelected").setValue((Object)true);
        }
    }

    @Override
    protected void cDisSelectAll_actionPerformed(ActionEvent e) throws Exception {
        for (int i = 0; i < this.kdEntrysChose.getRowCount(); ++i) {
            this.kdEntrysChose.getRow(i).getCell("isSelected").setValue((Object)false);
        }
    }

    @Override
    protected void rSeleclAll_actionPerformed(ActionEvent e) throws Exception {
        for (int i = 0; i < this.kdEntrysResult.getRowCount(); ++i) {
            this.kdEntrysResult.getRow(i).getCell("isSelected").setValue((Object)true);
        }
    }

    @Override
    protected void rDisSelectAll_actionPerforme(ActionEvent e) throws Exception {
        for (int i = 0; i < this.kdEntrysResult.getRowCount(); ++i) {
            this.kdEntrysResult.getRow(i).getCell("isSelected").setValue((Object)false);
        }
    }

    @Override
    protected void kdEntrysResult_editStoping(KDTEditEvent e) throws Exception {
        this.exportTypeSelect.requestFocusInWindow();
    }

    @Override
    protected void findRowButton_actionPerformed(MouseEvent e) throws Exception {
        if (this.choseSearchDialog == null) {
            this.choseSearchDialog = new SearchDialogFactoryUtil((Component)((Object)this), this.kdEntrysChose, "billMappingName");
        }
        this.choseSearchDialog.showFindNextDialog();
    }

    @Override
    protected void resultSearchBtn_actionPerformed(MouseEvent e) throws Exception {
        ExportType type = (ExportType)((Object)this.exportTypeSelect.getSelectedItem());
        if (this.resultSearchDialog == null) {
            this.resultSearchDialog = type.equals((Object)ExportType.exportByBill) ? new SearchDialogFactoryUtil((Component)((Object)this), this.kdEntrysResult, "billMappingName") : new SearchDialogFactoryUtil((Component)((Object)this), this.kdEntrysResult, "baseDataType");
        } else if (type.equals((Object)ExportType.exportByBill)) {
            this.resultSearchDialog.setColumn("billMappingName");
        } else {
            this.resultSearchDialog.setColumn("baseDataType");
        }
        this.resultSearchDialog.showFindNextDialog();
    }
}

