/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.syncdatabase.client.util;

import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.csinterface.syncdatabase.FeildDataType;
import com.kingdee.eas.csinterface.syncdatabase.client.util.CSInterfaceFilterObj;
import com.kingdee.eas.framework.CoreBaseInfo;

public class CSInterfaceFilterParse {
    CSInterfaceFilterObj[] csInterfaceFilter = null;
    public static String[] LEFTBRACKET = new String[]{"(", "((", "(((", "(((("};
    public static String[] RIGHTBRACKET = new String[]{")", "))", ")))", "))))"};
    public static String[] COMPAREALIA = new String[]{"\u7c7b\u4f3c", "\u5927\u4e8e", "\u5927\u4e8e \u7b49\u4e8e", "\u7b49\u4e8e", "\u5c0f\u4e8e", " \u5c0f\u4e8e\u7b49\u4e8e", "\u4e3a\u7a7a", "\u4e0d\u4e3a\u7a7a", "\u5305\u542b"};
    public static String[] COMPARENAME = new String[]{"like", ">", ">=", "=", "<", "<=", "is null", "is not null", "include"};
    public static String[] RELATIONALIA = new String[]{"  ", "\u4e14", "\u6216"};
    public static String[] RELATIONNAME = new String[]{"  ", "and", "or"};

    public CSInterfaceFilterParse(CSInterfaceFilterObj[] csInterface) {
        this.csInterfaceFilter = csInterface;
    }

    public FilterInfo getEvByCSInterfaceFilter(CSInterfaceFilterObj[] cs) {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filterColl = filter.getFilterItems();
        int n = cs.length;
        for (int i = 0; i < n; ++i) {
            filterColl.add(this.getFilterIntemInfo(cs[i]));
        }
        filter.setMaskString(this.getMaskString(cs));
        return filter;
    }

    private String getMaskString(CSInterfaceFilterObj[] cs) {
        StringBuffer maskStrBuff = new StringBuffer();
        int n = cs.length;
        for (int i = 0; i < n; ++i) {
            maskStrBuff.append(cs[i].getLeftBracket());
            maskStrBuff.append("#");
            maskStrBuff.append(i);
            maskStrBuff.append(" ");
            if (i != n) {
                maskStrBuff.append(cs[i].getRelationName());
                maskStrBuff.append(" ");
            }
            maskStrBuff.append(cs[i].getRightBracket());
        }
        return maskStrBuff.toString();
    }

    private FilterItemInfo getFilterIntemInfo(CSInterfaceFilterObj cSInterfaceFilter) {
        FilterItemInfo filterItemInfo = new FilterItemInfo();
        filterItemInfo.setPropertyName(cSInterfaceFilter.getFeildName());
        filterItemInfo.setCompareValue(cSInterfaceFilter.getValue());
        filterItemInfo.setCompareType(this.getCompareType(cSInterfaceFilter.getCompareName()));
        return filterItemInfo;
    }

    private CompareType getCompareType(String compareName) {
        if (compareName.equals(COMPARENAME[0])) {
            return CompareType.LIKE;
        }
        if (compareName.equals(COMPARENAME[1])) {
            return CompareType.GREATER;
        }
        if (compareName.equals(COMPARENAME[2])) {
            return CompareType.GREATER_EQUALS;
        }
        if (compareName.equals(COMPARENAME[3])) {
            return CompareType.EQUALS;
        }
        if (compareName.equals(COMPARENAME[4])) {
            return CompareType.LESS;
        }
        if (compareName.equals(COMPARENAME[5])) {
            return CompareType.LESS_EQUALS;
        }
        if (compareName.equals(COMPARENAME[6])) {
            return CompareType.IS;
        }
        if (compareName.equals(COMPARENAME[7])) {
            return CompareType.ISNOT;
        }
        if (compareName.equals(COMPARENAME[8])) {
            return CompareType.INCLUDE;
        }
        return null;
    }

    private Object getValue(CSInterfaceFilterObj cSInterfaceFilter) {
        if (cSInterfaceFilter.feildType.equals((Object)FeildDataType.BASEDATA)) {
            if (cSInterfaceFilter.getValue() == null) {
                return null;
            }
            Object[] obj = (Object[])cSInterfaceFilter.getValue();
            return this.getArrayObjectIDs(obj);
        }
        if (cSInterfaceFilter.feildType.equals((Object)FeildDataType.DATE)) {
            if (cSInterfaceFilter.getValue() == null) {
                return null;
            }
            return "{" + cSInterfaceFilter.getValue() + "}";
        }
        return cSInterfaceFilter.getValue();
    }

    private String getArrayObjectIDs(Object[] obj) {
        StringBuffer idsBuf = new StringBuffer();
        for (int i = 0; i < obj.length; ++i) {
            idsBuf.append(((CoreBaseInfo)obj[0]).getId());
            idsBuf.append(",");
        }
        return idsBuf.toString();
    }
}

