/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.syncdatabase.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataTypeCollection;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataTypeFactory;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataTypeInfo;
import com.kingdee.eas.csinterface.syncdatabase.MultiToMultiMapMergeEntryListInfo;
import com.kingdee.eas.csinterface.syncdatabase.util.BaseDataTypeRuleFilter;
import com.kingdee.eas.csinterface.util.ImportUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BaseDataMultiToMultiMapHelper {
    public static String[] split(String data) {
        return BaseDataMultiToMultiMapHelper.split(data, ',');
    }

    public static String[] split(String data, char splitChar) {
        ArrayList<String> result = new ArrayList<String>();
        if (StringUtils.isEmpty((String)data)) {
            return result.toArray(new String[0]);
        }
        Pattern p = Pattern.compile("([^" + splitChar + "]*)" + splitChar);
        Matcher m = p.matcher(data);
        while (m.find()) {
            String line = m.group(1);
            result.add(line);
        }
        return result.toArray(new String[0]);
    }

    public static String[] tranlate(Context ctx, String[] srcValues, String[] baseDataType) throws EASBizException, BOSException {
        if (srcValues == null || baseDataType == null) {
            throw new BOSException("\u66ff\u6362\u89c4\u5219\u8f6c\u5316\u53c2\u6570\u4e3a\u7a7a");
        }
        if (srcValues.length != baseDataType.length) {
            throw new BOSException("\u66ff\u6362\u89c4\u5219\u8f6c\u5316\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u957f\u5ea6\u4e0d\u76f8\u7b49");
        }
        BaseDataTypeInfo info = null;
        String[] result = srcValues;
        for (int i = 0; i < baseDataType.length; ++i) {
            EntityViewInfo view = ImportUtil.getEntityViewInfo4Equal("name", baseDataType[i]);
            BaseDataTypeCollection collection = BaseDataTypeFactory.getLocalInstance(ctx).getBaseDataTypeCollection(view);
            if (collection.size() > 0) {
                info = collection.get(0);
            }
            if (info == null) {
                throw new BOSException("\u66ff\u6362\u89c4\u5219\u8f6c\u5316\u67e5\u4e0d\u5230\u76f8\u5e94\u7684\u7c7b\u578b\u6620\u5c04\uff1a" + baseDataType[i]);
            }
            String replaceRule = info.getRule();
            if (!BaseDataTypeRuleFilter.matchReplace(replaceRule)) continue;
            String[] rule = replaceRule.split("\\?");
            result[i] = srcValues[i].replace(rule[0], rule[1]);
        }
        return result;
    }

    public static void tranlate(Context ctx, CoreBaseCollection coll) throws EASBizException, BOSException {
        if (coll == null) {
            return;
        }
        for (int i = 0; i < coll.size(); ++i) {
            MultiToMultiMapMergeEntryListInfo info = (MultiToMultiMapMergeEntryListInfo)coll.get(i);
            String[] srcFieldValues = BaseDataMultiToMultiMapHelper.split(info.getSrcFieldValue());
            String[] srcFieldTypes = BaseDataMultiToMultiMapHelper.split(info.getSrcFieldType());
            srcFieldValues = BaseDataMultiToMultiMapHelper.tranlate(ctx, srcFieldValues, srcFieldTypes);
            StringBuilder sb = new StringBuilder();
            for (String str : srcFieldValues) {
                sb.append(str).append(",");
            }
            info.setSrcFieldValue(sb.toString());
        }
    }
}

