/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.common.DCInfo;
import com.kingdee.eas.base.uiframe.client.LoginHelper;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewOrgF7;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.MetadataUtils;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class CommonUtil {
    private static final Logger logger = CoreUIObject.getLogger(CommonUtil.class);

    public static IObjectPK convert2PK(String id) {
        ObjectUuidPK pk = new ObjectUuidPK(id);
        return pk;
    }

    public static IObjectPK convert2PK(BOSUuid id) {
        if (id == null) {
            return null;
        }
        ObjectUuidPK pk = new ObjectUuidPK(id);
        return pk;
    }

    public static boolean isBlankLineData(String[] lineData) {
        return 0 == CommonUtil.strLength(lineData[0]) && 0 == CommonUtil.strLength(lineData[1]) && 0 == CommonUtil.strLength(lineData[2]) && 0 == CommonUtil.strLength(lineData[3]);
    }

    public static int strLength(String data) {
        if (null == data) {
            return -1;
        }
        return data.trim().length();
    }

    public static OrgType getOrgTypeByQueryName(String queryName) {
        try {
            EntityObjectInfo info = CommonUtil.getEntityObjectInfo(queryName);
            String orgTypeStr = info.getExtendedProperty("OrgType");
            if (StringUtils.isEmpty((String)orgTypeStr)) {
                return OrgType.NONE;
            }
            return OrgType.getEnum((String)orgTypeStr);
        }
        catch (Exception e) {
            e.printStackTrace();
            SysUtil.abort((Throwable)e);
            return null;
        }
    }

    public static String getEntityName(String queryName) throws BOSException {
        EntityObjectInfo info = CommonUtil.getEntityObjectInfo(queryName);
        return info.getFullName();
    }

    public static EntityObjectInfo getEntityObjectInfo(String queryName) throws BOSException {
        MetaDataPK pk;
        IMetaDataLoader loader = MetadataUtils.getMDloader();
        QueryInfo queryInfo = loader.getQueryNoConfigure((IMetaDataPK)(pk = MetaDataPK.create((String)queryName)));
        if (queryInfo == null) {
            throw new BOSException("the query\uff1a" + queryName + " is not exist");
        }
        SubObjectInfo subObjectInfo = queryInfo.getMainObject();
        EntityObjectInfo info = (EntityObjectInfo)subObjectInfo.get("entityRef");
        return info;
    }

    private static NewOrgF7 getKDPromptSelector(OrgType orgType, CoreUI ui) {
        NewOrgF7 orgf7 = new NewOrgF7((IUIObject)ui);
        orgf7.setOrgTypes(new OrgType[]{orgType});
        orgf7.setIsCUFilter(true);
        orgf7.setShowAssistantOrg(true);
        return orgf7;
    }

    public static void initOrgUnitF7(Context ctx, OrgType orgType, KDBizPromptBox f7, CoreUI ui) {
        if (-1 == orgType.getValue()) {
            f7.setValue(null);
            f7.setEnabled(false);
        } else {
            NewOrgF7 orgf7 = CommonUtil.getKDPromptSelector(orgType, ui);
            f7.setSelector((KDPromptSelector)orgf7);
            OrgUnitInfo orgUnitInfo = SysContext.getSysContext().getCurrentOrgUnit(orgType);
            f7.setValue((Object)orgUnitInfo);
            f7.setEnabled(true);
            System.out.println(orgUnitInfo);
        }
    }

    public static void fillOrgUnitF7(Context ctx, OrgType orgType, KDBizPromptBox f7, CoreUI ui, String orgId) {
        CommonUtil.initOrgUnitF7(ctx, orgType, f7, ui);
        if (StringUtils.isEmpty((String)orgId) || -1 == orgType.getValue()) {
            return;
        }
        try {
            OrgUnitInfo orgUnitInfo = NewOrgViewHelper.getOrgUnitInfo((Context)ctx, (String)orgId, (OrgType)orgType);
            f7.setData((Object)orgUnitInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ICoreBase getCoreBaseInstance(Context ctx, String id) throws BOSException {
        BOSObjectType bosType = BOSUuid.getBOSObjectType((String)id, (boolean)true);
        if (bosType == null) {
            logger.error((Object)("\u96c6\u6210\u5e73\u53f0id\u8f6cBOSType\u5f02\u5e38\uff0cid='" + id + "'"));
        }
        ICoreBase coreBase = (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)bosType);
        return coreBase;
    }

    public static ICoreBase getCoreBaseInstanceByQueryName(Context ctx, String queryName) throws BOSException {
        EntityObjectInfo info = CommonUtil.getEntityObjectInfo(queryName);
        BOSObjectType bosType = info.getType();
        ICoreBase coreBase = (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)bosType);
        return coreBase;
    }

    public static String getErrorMsg(Exception e) {
        String errorMsg = e.getMessage();
        if (e.getCause() != null) {
            errorMsg = e.getCause().getMessage();
        }
        return errorMsg;
    }

    public static int getCurrentLoginDBType() throws Exception {
        int dbType = 2;
        String obj = SysContext.getSysContext().getDCNumber();
        ArrayList dcList = LoginHelper.getDCList();
        boolean flag = false;
        for (int i = 0; i < dcList.size(); ++i) {
            DCInfo info = (DCInfo)dcList.get(i);
            if (!info.getNumber().equals(obj)) continue;
            dbType = info.getDBType();
            flag = true;
            break;
        }
        if (flag) {
            return dbType;
        }
        throw new Exception("\u65e0\u6cd5\u8bc6\u522b\u5f53\u524d\u767b\u9646\u7684\u6570\u636e\u5e93\u7c7b\u578b");
    }
}

