/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.util;

import com.kingdee.eas.csinterface.util.IOUtils;
import java.io.FileInputStream;
import java.io.InputStream;
import jxl.Sheet;
import jxl.Workbook;

public class ExcelHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Workbook getWorkbook(String fileName) throws Exception {
        Workbook workbook;
        FileInputStream inputStream = null;
        try {
            Workbook workbook2;
            inputStream = new FileInputStream(fileName);
            workbook = workbook2 = Workbook.getWorkbook((InputStream)inputStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeInputStreamQuietly(inputStream);
            throw throwable;
        }
        IOUtils.closeInputStreamQuietly(inputStream);
        return workbook;
    }

    public static Sheet getWorkbookSheet(String fileName, int sheetIndex) throws Exception {
        return ExcelHelper.getWorkbook(fileName).getSheet(sheetIndex);
    }

    public static String[][] getStringData(String fileName, int sheetIndex, int startRowIndex, int endRowIndex, int startColumnIndex, int endColumnIndex) throws Exception {
        Sheet sheet = ExcelHelper.getWorkbook(fileName).getSheet(sheetIndex);
        int rowCount = sheet.getRows();
        int cloCount = sheet.getColumns();
        if (0 == rowCount || 0 == cloCount) {
            return new String[0][0];
        }
        if (startRowIndex < 0) {
            startRowIndex = 0;
        }
        if (endRowIndex < 0 || endRowIndex >= rowCount) {
            endRowIndex = rowCount - 1;
        }
        if (startColumnIndex < 0) {
            startColumnIndex = 0;
        }
        if (endColumnIndex < 0 || endColumnIndex >= cloCount) {
            endColumnIndex = cloCount - 1;
        }
        String[][] data = new String[endRowIndex - startRowIndex + 1][endColumnIndex - startColumnIndex + 1];
        for (int i = startRowIndex; i <= endRowIndex; ++i) {
            for (int j = startColumnIndex; j <= endColumnIndex; ++j) {
                data[i][j] = sheet.getCell(j, i).getContents();
            }
        }
        return data;
    }
}

