/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;

public class IOUtils {
    public static void writeInt(OutputStream out, int len) throws IOException {
        byte[] lengthBytes = new byte[]{(byte)(len >>> 24 & 0xFF), (byte)(len >>> 16 & 0xFF), (byte)(len >>> 8 & 0xFF), (byte)(len >>> 0 & 0xFF)};
        out.write(lengthBytes);
    }

    public static String readFully(InputStream inputStream, String charsetName) {
        StringWriter stringWriter = new StringWriter();
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader(inputStream, charsetName);
            IOUtils.copy(inputStreamReader, stringWriter);
            String string = stringWriter.toString();
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException("\u8bfb\u53d6\u5185\u5bb9\u5931\u8d25 , \u539f\u56e0:" + e.getMessage(), e);
        }
        finally {
            IOUtils.closeWriterQuietly(stringWriter);
            IOUtils.closeReaderQuietly(inputStreamReader);
        }
    }

    public static void write(byte[] data, OutputStream output) throws IOException {
        if (data != null) {
            output.write(data);
            output.flush();
        }
    }

    public static int copy(InputStream input, OutputStream output) throws IOException {
        long count = IOUtils.copyLarge(input, output);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    public static int copy(Reader input, Writer output) throws IOException {
        long count = IOUtils.copyLarge(input, output);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    public static long copyLarge(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static long copyLarge(Reader input, Writer output) throws IOException {
        char[] buffer = new char[4096];
        long count = 0L;
        int length = 0;
        while (-1 != (length = input.read(buffer))) {
            output.write(buffer, 0, length);
            count += (long)length;
        }
        return count;
    }

    public static void closeOutputStreamQuietly(OutputStream output) {
        try {
            if (output != null) {
                output.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void closeInputStreamQuietly(InputStream input) {
        try {
            if (input != null) {
                input.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void closeWriterQuietly(Writer writer) {
        try {
            if (writer != null) {
                writer.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void closeReaderQuietly(Reader reader) {
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Exception decompiling
     */
    public static byte[] readFileAsByteArray(String fileName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void writeToFile(byte[] data, String fileName) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(new File(fileName));
            fos.write(data);
            fos.flush();
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeOutputStreamQuietly(fos);
                throw throwable;
            }
        }
        IOUtils.closeOutputStreamQuietly(fos);
    }
}

