/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.util;

import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.framework.client.ListUiHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;

public class MyKDTableUtil {
    public static final Color LOCKED_BACKGROUND_COLOR = new Color(227, 227, 227);
    public static final Color UNLOCK_BACKGROUND_COLOR = new Color(255, 255, 255);

    public static boolean selectMultiRows(KDTable table) {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)table);
        ListUiHelper listUiHelper = new ListUiHelper();
        HashSet<String> selectIdSet = new HashSet<String>();
        for (int i = 0; i < selectRows.length && selectIdSet.size() < 2; ++i) {
            String cellValue = listUiHelper.getTableCellValue(table, selectRows[i], "id");
            selectIdSet.add(cellValue);
        }
        return selectIdSet.size() > 1;
    }

    public static String[] getSelectedListId(KDTable tblMain, String keyFieldName) {
        HashSet<String> idSet = new HashSet<String>();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)tblMain);
        for (int i = 0; i < selectRows.length; ++i) {
            int rowIndex = selectRows[i];
            String id = (String)MyKDTableUtil.getTableCellValue(tblMain, rowIndex, keyFieldName);
            idSet.add(id);
        }
        return idSet.toArray(new String[0]);
    }

    public static Object getTableCellValue(KDTable table, int rowIndex, String FieldName) {
        IRow row = table.getRow(rowIndex);
        ICell cell = row.getCell(FieldName);
        return cell.getValue();
    }

    public static void lockCell(KDTable table, int rowIndex, String cellName) {
        ICell cell = table.getRow(rowIndex).getCell(cellName);
        MyKDTableUtil.setCellLocked(cell);
        MyKDTableUtil.setCellLockedBackground(cell);
    }

    public static void setCellLocked(ICell cell) {
        if (cell != null) {
            cell.getStyleAttributes().setLocked(true);
        }
    }

    public static void setCellUnLocked(ICell cell) {
        if (cell != null) {
            cell.getStyleAttributes().setLocked(false);
        }
    }

    public static void setColumnLocked(KDTable talbe, String columnName) {
        talbe.getColumn(columnName).getStyleAttributes().setLocked(true);
    }

    public static void setColumnUnLocked(KDTable talbe, String columnName) {
        talbe.getColumn(columnName).getStyleAttributes().setLocked(false);
    }

    public static void setRowLocked(IRow row) {
        row.getStyleAttributes().setLocked(true);
    }

    public static void setColumnWidth(KDTable talbe, String columnName, int width) {
        talbe.getColumn(columnName).setWidth(width);
    }

    public static int[] getSelectedRows(KDTable table) {
        if (table.getRowCount() == 0 || table.getSelectManager().size() == 0) {
            return new int[0];
        }
        TreeSet<Integer> set = new TreeSet<Integer>();
        for (int i = 0; i < table.getSelectManager().size(); ++i) {
            IBlock block = KDTBlock.change((KDTable)table, (IBlock)table.getSelectManager().get(i));
            for (int j = block.getTop(); j <= block.getBottom(); ++j) {
                if (j < 0) continue;
                set.add(j);
            }
        }
        int[] rows = new int[set.size()];
        Iterator iter = set.iterator();
        int k = 0;
        while (iter.hasNext()) {
            rows[k++] = (Integer)iter.next();
        }
        return rows;
    }

    public static void removeRow(KDTable table, int rowIndex) {
        IObjectCollection collection;
        int index;
        Object detailData = table.getRow(rowIndex).getUserObject();
        table.removeRow(rowIndex);
        if (detailData != null && (index = MyKDTableUtil.getCollectionIndex(collection = (IObjectCollection)table.getUserObject(), (IObjectValue)detailData)) >= 0 && collection.size() > index) {
            collection.removeObject(index);
        }
    }

    public static int getCollectionIndex(IObjectCollection collection, IObjectValue obj) {
        int index = -1;
        if (collection == null) {
            return index;
        }
        for (int i = collection.size() - 1; i >= 0; --i) {
            if (obj != collection.getObject(i)) continue;
            index = i;
            return index;
        }
        return index;
    }

    public static int[] getSelectedColumns(KDTable table) {
        if (table.getSelectManager().size() == 0) {
            return new int[0];
        }
        TreeSet<Integer> set = new TreeSet<Integer>();
        for (int i = 0; i < table.getSelectManager().size(); ++i) {
            IBlock block = KDTBlock.change((KDTable)table, (IBlock)table.getSelectManager().get(i));
            for (int j = block.getLeft(); j <= block.getRight(); ++j) {
                set.add(j);
            }
        }
        int[] columns = new int[set.size()];
        Iterator iter = set.iterator();
        int k = 0;
        while (iter.hasNext()) {
            columns[k++] = (Integer)iter.next();
        }
        return columns;
    }

    public static void replaceKdtRangeRemoveMethod(final KDTable table, KDWorkButton removeButton) throws Exception {
        ActionListener[] listeners = removeButton.getActionListeners();
        if (listeners != null && listeners.length > 0) {
            for (int i = 0; i < listeners.length; ++i) {
                removeButton.removeActionListener(listeners[i]);
            }
        }
        removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                MyKDTableUtil.removeMultiRows(table);
            }
        });
    }

    private static void removeMultiRows(KDTable table) {
        if (null == table) {
            return;
        }
        int[] selectRowsIndex = MyKDTableUtil.getSelectedRows(table);
        if (0 == selectRowsIndex.length) {
            return;
        }
        Arrays.sort(selectRowsIndex);
        for (int i = selectRowsIndex.length - 1; i >= 0; --i) {
            MyKDTableUtil.removeRow(table, selectRowsIndex[i]);
        }
        Arrays.sort(selectRowsIndex);
        if (0 <= table.getRowCount()) {
            return;
        }
        int[] selectedColumnIndexs = MyKDTableUtil.getSelectedColumns(table);
        Arrays.sort(selectedColumnIndexs);
        int columnIndex = selectedColumnIndexs.length > 0 ? selectedColumnIndexs[0] : 0;
        table.getSelectManager().select(selectRowsIndex[0], columnIndex);
    }

    public static void setColumnLockedBackground(KDTable talbe, String columnName) {
        talbe.getColumn(columnName).getStyleAttributes().setBackground(LOCKED_BACKGROUND_COLOR);
    }

    public static void setColumnUnLockedBackground(KDTable talbe, String columnName) {
        talbe.getColumn(columnName).getStyleAttributes().setBackground(UNLOCK_BACKGROUND_COLOR);
    }

    public static void setRowLockedBackground(IRow row) {
        row.getStyleAttributes().setBackground(LOCKED_BACKGROUND_COLOR);
    }

    public static void setCellLockedBackground(ICell cell) {
        cell.getStyleAttributes().setBackground(LOCKED_BACKGROUND_COLOR);
    }

    public static void setCellUnLockedBackground(ICell cell) {
        cell.getStyleAttributes().setBackground(UNLOCK_BACKGROUND_COLOR);
    }

    public static void setColumnHided(KDTable talbe, String columnName) {
        talbe.getColumn(columnName).getStyleAttributes().setHided(true);
    }

    public static void setColumn2Show(KDTable talbe, String columnName) {
        talbe.getColumn(columnName).getStyleAttributes().setHided(false);
    }

    public static void removeRow(Component comp, KDTable kdtEntrys) {
        if (kdtEntrys == null) {
            return;
        }
        if (kdtEntrys.getSelectManager().size() == 0) {
            MsgBox.showInfo((Component)comp, (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        int top = kdtEntrys.getSelectManager().get().getTop();
        if (kdtEntrys.getRow(top) == null) {
            MsgBox.showInfo((Component)comp, (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        IObjectValue detailData = (IObjectValue)kdtEntrys.getRow(top).getUserObject();
        kdtEntrys.removeRow(top);
        IObjectCollection collection = (IObjectCollection)kdtEntrys.getUserObject();
        if (collection != null && detailData != null) {
            collection.removeObject(top);
        }
    }
}

