/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.agent.EipUserFactory;
import com.kingdee.eas.csinterface.agent.EipUserInfo;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynHeadFactory;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynHeadInfo;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynTreeFactory;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynTreeInfo;
import com.kingdee.eas.csinterface.cloud.CloudParser;
import com.kingdee.eas.csinterface.cloud.FileElement;
import com.kingdee.eas.csinterface.cloud.Web20AppClient;
import com.kingdee.eas.csinterface.converter.core.XMLStream;
import com.kingdee.eas.csinterface.planmanager.IPlanManager;
import com.kingdee.eas.csinterface.planmanager.PlanManagerFactory;
import com.kingdee.eas.csinterface.planmanager.PlanManagerInfo;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataFactory;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataInfo;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataTypeFactory;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataTypeInfo;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionFactory;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionInfo;
import com.kingdee.eas.csinterface.util.EncodingUtils;
import com.kingdee.eas.csinterface.webservice.WSInterfaceCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.StringUtils;

public class PlanManagerHelper {
    public static final String PLAN_RESOURCE_ID_IN_CLOUD = "test123";
    public static final String VERSION_CLOUD = "1";
    private static XMLStream xmlStream = null;

    public static String convertPlanToXML(PlanManagerInfo planManagerInfo) {
        return PlanManagerHelper.getXMLStream().toXMLString(planManagerInfo);
    }

    public static String convertPlanToXML(BaseDataSynHeadInfo basedataInfo) {
        return PlanManagerHelper.getXMLStream().toXMLString(basedataInfo);
    }

    public static String convertPlanToXML(WSInterfaceCollection interfaceColl) {
        return PlanManagerHelper.getXMLStream().toXMLString((Object)interfaceColl);
    }

    public static WSInterfaceCollection convertXMLToWSInterfaceCollection(String docXML) {
        return (WSInterfaceCollection)((Object)PlanManagerHelper.getXMLStream().fromXML(docXML));
    }

    public static PlanManagerInfo convertXMLToPlan(String docXML) {
        return (PlanManagerInfo)PlanManagerHelper.getXMLStream().fromXML(docXML);
    }

    public static BaseDataSynHeadInfo convertXMLToBaseDataPlan(String docXML) {
        return (BaseDataSynHeadInfo)PlanManagerHelper.getXMLStream().fromXML(docXML);
    }

    private static XMLStream getXMLStream() {
        if (null == xmlStream) {
            xmlStream = new XMLStream();
        }
        return xmlStream;
    }

    public static String queryPlanResource() throws BOSException {
        try {
            byte[] data = Web20AppClient.queryResourceFile(PLAN_RESOURCE_ID_IN_CLOUD, VERSION_CLOUD);
            String message = EncodingUtils.bytes2StrUTF8(data);
            return message;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static String downloadFileFromURI2StrUTF8(String uri) throws BOSException {
        try {
            byte[] data = Web20AppClient.downloadFileFromURI(uri);
            String message = EncodingUtils.bytes2StrUTF8(data);
            return message;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static byte[] uploadFile(String fileName, String filedesc, byte[] fileData) throws BOSException {
        try {
            fileName = Web20AppClient.urlEncodedUTF8(fileName);
            filedesc = Web20AppClient.urlEncodedUTF8(filedesc);
            return Web20AppClient.uploadFileByte(PLAN_RESOURCE_ID_IN_CLOUD, VERSION_CLOUD, fileName, filedesc, fileData);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static boolean isPlanExistInCloud(String targetFileName) throws BOSException {
        String resoureXML = PlanManagerHelper.queryPlanResource();
        FileElement[] fileElements = CloudParser.parseFile(resoureXML);
        for (int i = 0; i < fileElements.length; ++i) {
            if (!fileElements[i].getFilename().equals(targetFileName)) continue;
            return true;
        }
        return false;
    }

    public static String getPlanTargetFileNameInCloud(PlanManagerInfo planInfo) {
        String SEPARATOR = "_";
        String srcSysName = planInfo.getSrcsysname();
        String srcSysVersion = planInfo.getSrcsysversion();
        String srcSysBillName = planInfo.getSrcsycbillname();
        String destSysName = planInfo.getDestsysname();
        String destSysVersion = planInfo.getDestsysversion();
        String destSysBillName = planInfo.getDestsysbillname();
        String planName = planInfo.getName();
        StringBuffer sb = new StringBuffer();
        sb.append(PlanManagerHelper.replaceChar(srcSysName));
        sb.append("_");
        sb.append(PlanManagerHelper.replaceChar(srcSysVersion));
        sb.append("_");
        sb.append(PlanManagerHelper.replaceChar(srcSysBillName));
        sb.append("_");
        sb.append(PlanManagerHelper.replaceChar(destSysName));
        sb.append("_");
        sb.append(PlanManagerHelper.replaceChar(destSysVersion));
        sb.append("_");
        sb.append(PlanManagerHelper.replaceChar(destSysBillName));
        sb.append("_");
        sb.append(PlanManagerHelper.replaceChar(planName));
        return sb.toString();
    }

    private static String replaceChar(String message) {
        if (null == message) {
            return "null";
        }
        return message.replace('_', '-');
    }

    public static PlanManagerInfo getPlanManagerInfo(String id) throws EASBizException, BOSException {
        IPlanManager remoteInstance = PlanManagerFactory.getRemoteInstance();
        return remoteInstance.getPlanManagerInfo((IObjectPK)new ObjectUuidPK(id));
    }

    public static PlanManagerInfo getPlanManagerInfoWithAllValue(String id) throws EASBizException, BOSException {
        SelectorItemCollection selector = PlanManagerHelper.getExportSelectorItemCollection();
        IPlanManager remoteInstance = PlanManagerFactory.getRemoteInstance();
        return remoteInstance.getPlanManagerInfo((IObjectPK)new ObjectUuidPK(id), selector);
    }

    private static SelectorItemCollection getExportSelectorItemCollection() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("treeid.*");
        selector.add("createsourceviewsql.*");
        selector.add("bizbillmapping.*");
        selector.add("bizbillmapping.assistAccountType.*");
        selector.add("bizbillmapping.assistAccountType.entrys.*");
        selector.add("bizbillmapping.entrys.*");
        selector.add("createsourceviewsql.*");
        selector.add("botprule.*");
        selector.add("BaseDataTypMappingEntry.*");
        selector.add("BaseDataTypMappingEntry.baseDataTypeF7.*");
        selector.add("group.id");
        selector.add("group.number");
        selector.add("group.name");
        return selector;
    }

    public static BaseDataTypeInfo getBaseDataTypeInfo(String selectedID) throws EASBizException, BOSException {
        return BaseDataTypeFactory.getRemoteInstance().getBaseDataTypeInfo((IObjectPK)new ObjectUuidPK(selectedID));
    }

    public static BaseDataTypeInfo getBaseDataTypeInfo(String selectedID, SelectorItemCollection selector) throws EASBizException, BOSException {
        return BaseDataTypeFactory.getRemoteInstance().getBaseDataTypeInfo((IObjectPK)new ObjectUuidPK(selectedID), selector);
    }

    public static BaseDataInfo getBaseDataInfo(String selectedID) throws EASBizException, BOSException {
        return (BaseDataInfo)BaseDataFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(selectedID));
    }

    public static void replaceBOTMappingInfo(PlanManagerInfo planManagerInfo) throws BOSException, EASBizException {
        BOTMappingInfo orgBOTMappingInfo = planManagerInfo.getBotprule();
        if (null != orgBOTMappingInfo) {
            IBOTMapping iBotMapping = BOTMappingFactory.getRemoteInstance();
            BOTMappingInfo botMappingInfo = iBotMapping.getBOTMappingInfo((IObjectPK)new ObjectStringPK(orgBOTMappingInfo.getId().toString()));
            planManagerInfo.setBotprule(botMappingInfo);
        }
    }

    public static BaseDataSynHeadInfo getBaseDataSynHeadInfo(String selectedID) throws EASBizException, BOSException {
        return (BaseDataSynHeadInfo)BaseDataSynHeadFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(selectedID));
    }

    public static IObjectPK saveBaseDataSynHeadInfo(BaseDataSynHeadInfo info) throws EASBizException, BOSException {
        return BaseDataSynHeadFactory.getRemoteInstance().save((CoreBaseInfo)info);
    }

    public static EipUserInfo getAgent(String userId) throws EASBizException, BOSException {
        return (EipUserInfo)EipUserFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(userId));
    }

    public static ConnectionInfo getConnection(String connId) throws EASBizException, BOSException {
        return (ConnectionInfo)ConnectionFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(connId));
    }

    public static BaseDataSynTreeInfo getSimpleTreeInfoByTreeNumber(String treeNumber) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)treeNumber)) {
            return PlanManagerHelper.getDefaultSimpleTreeNode();
        }
        BaseDataSynTreeInfo treeInfo = BaseDataSynTreeFactory.getRemoteInstance().getBaseDataSynTreeInfo("where number ='" + treeNumber + "'");
        if (treeInfo == null) {
            treeInfo = PlanManagerHelper.getDefaultSimpleTreeNode();
        }
        return treeInfo;
    }

    public static BaseDataSynTreeInfo getDefaultSimpleTreeNode() throws EASBizException, BOSException {
        BaseDataSynTreeInfo treeInfo = BaseDataSynTreeFactory.getRemoteInstance().getBaseDataSynTreeInfo("where number ='JC_001'");
        return treeInfo;
    }
}

