/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.util.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.json.JsonContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class Kson {
    private static final Logger logger = Logger.getLogger(Kson.class);
    private static final ThreadLocal<JsonObject> jsonObject = new ThreadLocal();
    private static volatile Gson gson = Kson.initGson();

    public static void begin(JsonContext jsonContext) {
        JsonObject jo = jsonObject.get();
        if (jo == null) {
            jo = new JsonObject(jsonContext);
            jsonObject.set(jo);
        } else {
            jo.setContext(jsonContext);
        }
    }

    public static void end() {
        JsonObject jo = jsonObject.get();
        if (jo != null) {
            jo.setContext(jo.last);
        }
    }

    public static JsonContext getJsonContext() {
        JsonObject jo = jsonObject.get();
        if (jo != null) {
            return jo.current;
        }
        return null;
    }

    public static Context getBOSContext() {
        JsonObject jo = jsonObject.get();
        if (jo != null && jo.current != null) {
            return jo.current.getBOSContext();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Gson initGson() {
        GsonBuilder gsonBuilder = new GsonBuilder().serializeNulls().serializeSpecialFloatingPointValues().enableComplexMapKeySerialization();
        Properties properties = new Properties();
        InputStream input = null;
        try {
            input = Kson.class.getClassLoader().getResourceAsStream("com/kingdee/bos/json/gson.properties");
            if (input != null) {
                properties.load(input);
            }
        }
        catch (IOException e) {
            logger.error((Object)"load gson config error.", (Throwable)e);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    logger.error((Object)"close gson config file error.", (Throwable)e);
                }
            }
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            String type = null;
            try {
                if (key.startsWith("adapter.")) {
                    type = key.substring("adapter.".length());
                    gsonBuilder.registerTypeAdapter(Class.forName(type), Class.forName(value).newInstance());
                    continue;
                }
                if (key.startsWith("factory.")) {
                    gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)Class.forName(value).newInstance());
                    continue;
                }
                if (!key.startsWith("hierarchyAdapter.")) continue;
                type = key.substring("hierarchyAdapter.".length());
                if ("com.kingdee.bos.dao.IObjectValue".equals(type)) {
                    gsonBuilder.registerTypeHierarchyAdapter(Class.forName("com.kingdee.bos.dao.IObjectValue"), Class.forName("com.kingdee.eas.csinterface.util.gson.BosObjectTypeAdapter").newInstance());
                    continue;
                }
                gsonBuilder.registerTypeHierarchyAdapter(Class.forName(type), Class.forName(value).newInstance());
            }
            catch (Exception e) {
                logger.error((Object)("gson register adapter error. key:" + key + " value:" + value), (Throwable)e);
            }
        }
        try {
            gsonBuilder.registerTypeAdapter(IObjectValue.class, Class.forName("com.kingdee.eas.csinterface.util.gson.BosObjectTypeAdapter").newInstance());
        }
        catch (Exception exception) {
            // empty catch block
        }
        gsonBuilder.disableHtmlEscaping();
        return gsonBuilder.create();
    }

    public static Gson getGson() {
        return gson;
    }

    public static Gson resetGson() {
        Gson gs = gson;
        gson = Kson.initGson();
        return gs;
    }

    private static class JsonObject {
        JsonContext last;
        JsonContext current;

        JsonObject(JsonContext jsonContext) {
            this.current = jsonContext;
        }

        void setContext(JsonContext jsonContext) {
            this.last = this.current;
            this.current = jsonContext;
        }
    }
}

