/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.webservice.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.csinterface.util.ComponentHelper;
import com.kingdee.eas.csinterface.util.MyKDTableUtil;
import com.kingdee.eas.csinterface.util.ThrowableHelper;
import com.kingdee.eas.csinterface.webservice.RemoteServiceRegion;
import com.kingdee.eas.csinterface.webservice.RemoteServiceType;
import com.kingdee.eas.csinterface.webservice.WSServiceFactory;
import com.kingdee.eas.csinterface.webservice.WSServiceInfo;
import com.kingdee.eas.csinterface.webservice.WSServiceURLInfo;
import com.kingdee.eas.csinterface.webservice.client.AbstractWSServiceEditUI;
import com.kingdee.eas.csinterface.webservice.client.util.EditUICheckUtil;
import com.kingdee.eas.csinterface.webservice.client.util.WSSelectListener;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class WSServiceEditUI
extends AbstractWSServiceEditUI {
    private static final Logger logger = CoreUIObject.getLogger(WSServiceEditUI.class);
    private RemoteServiceType currentServiceType;
    private WSServiceURLInfo currentTreeInfo;

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        this.prompTree.setValue((Object)this.currentTreeInfo);
        super.storeFields();
        this.dataBinder.getValueObject().put("tree", (Object)this.currentTreeInfo);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        ComponentHelper.setVisible(new JComponent[]{this.btnAttachment, this.btnSubmit, this.btnFirst, this.btnPre, this.btnNext, this.btnLast, this.btnPrint, this.btnPrintPreview, this.btnTraceUp, this.btnTraceDown, this.btnWorkFlowG, this.btnCreateFrom, this.btnCreateTo, this.btnAuditResult, this.btnMultiapprove, this.btnNextPerson}, false);
        if (this.chused.isSelected()) {
            this.btnRemove.setEnabled(false);
            this.btnEdit.setEnabled(false);
        }
        if (this.chenabled.isSelected()) {
            this.btnRemove.setEnabled(false);
            this.btnCancelCancel.setEnabled(false);
            this.btnCancel.setEnabled(true);
            this.btnEdit.setEnabled(false);
        } else {
            this.btnCancel.setEnabled(false);
            this.btnCancelCancel.setEnabled(true);
        }
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.btnCancelCancel.setEnabled(false);
        }
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.currentTreeInfo = (WSServiceURLInfo)this.getUIContext().get("ParentNode");
            this.switchButton(false);
        } else {
            this.currentTreeInfo = this.editData.getTree();
            this.switchButton(this.editData.isPreset());
        }
        RemoteServiceType serviceType = this.currentTreeInfo.getServiceType();
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.editData.setServiceType(serviceType);
        }
        this.currentServiceType = this.editData.getServiceType();
        if (RemoteServiceType.Http.equals((Object)serviceType)) {
            this.contNameSpace.setVisible(false);
        } else {
            this.kdtEntrys.getColumn("region").setWidth(0);
        }
        this.editData.setTree(this.currentTreeInfo);
        this.txtServiceURL.setText(this.editData.getServiceURL());
        MyKDTableUtil.setColumnLocked(this.kdtEntrys, "preset");
        MyKDTableUtil.setColumnLockedBackground(this.kdtEntrys, "preset");
        KDWorkButton removeButton = this.kdtEntrys_detailPanel.getRemoveLinesButton();
        WSSelectListener.getInstance(this.kdtEntrys, removeButton).bindEditUISelectListener();
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        int rowCount = this.kdtEntrys.getRowCount();
        IRow row = null;
        int bodyCount = 0;
        for (int i = 0; i < rowCount; ++i) {
            row = this.kdtEntrys.getRow(i);
            RemoteServiceRegion region = (RemoteServiceRegion)((Object)row.getCell("region").getValue());
            if (!RemoteServiceRegion.Body.equals((Object)region)) continue;
            ++bodyCount;
        }
        if (bodyCount > 1) {
            MsgBox.showInfo((String)"Body\u533a\u57df\u53ea\u5141\u8bb8\u914d\u7f6e\u4e00\u884c");
            SysUtil.abort();
        }
        super.actionSave_actionPerformed(e);
        this.switchButton(this.editData.isPreset());
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.switchButton(false);
        this.resetValue();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.switchButton(this.editData.isPreset());
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
        this.switchButton(false);
        this.resetValue();
    }

    @Override
    protected IObjectValue createNewData() {
        this.resetValue();
        WSServiceInfo objectValue = new WSServiceInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        return objectValue;
    }

    private void resetValue() {
        this.chused.setSelected(false);
        this.chenabled.setSelected(false);
        this.preset.setSelected(false);
        this.chLogin.setSelected(false);
        if (this.editData != null) {
            this.editData.setServiceType(this.currentServiceType);
        }
        this.prompTree.setValue((Object)this.currentTreeInfo);
    }

    private void switchButton(boolean isPreset) {
        this.txtNumber.setEditable(!isPreset);
        this.ctxImplClass.setEditable(!isPreset);
        this.txtServiceMethod.setEditable(!isPreset);
        this.chLogin.setEnabled(!isPreset);
        if (!isPreset) {
            return;
        }
        int rowCount = this.kdtEntrys.getRowCount();
        Boolean rowPreset = false;
        for (int i = 0; i < rowCount; ++i) {
            rowPreset = (Boolean)this.kdtEntrys.getRow(i).getCell("preset").getValue();
            if (!rowPreset.booleanValue()) continue;
            MyKDTableUtil.lockCell(this.kdtEntrys, i, "region");
            MyKDTableUtil.lockCell(this.kdtEntrys, i, "number");
            MyKDTableUtil.lockCell(this.kdtEntrys, i, "returnDataType");
            MyKDTableUtil.lockCell(this.kdtEntrys, i, "isLogin");
        }
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.chenabled.setSelected(false);
        this.btnRemove.setEnabled(true);
        this.btnCancelCancel.setEnabled(true);
        this.btnCancel.setEnabled(false);
        if (!this.chused.isSelected()) {
            this.btnEdit.setEnabled(true);
        }
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        try {
            super.actionCancelCancel_actionPerformed(e);
            this.chenabled.setSelected(true);
            this.btnRemove.setEnabled(false);
            this.btnCancelCancel.setEnabled(false);
            this.btnCancel.setEnabled(true);
            this.btnEdit.setEnabled(false);
        }
        catch (Exception exp) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)exp.getMessage(), (String)ThrowableHelper.toString(exp), (int)1);
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        EditUICheckUtil.verifyInput((Object)this.txtNumber, this.contNumber);
        EditUICheckUtil.verifyInput((Object)this.txtName, this.contName);
        EditUICheckUtil.verifyInput((Object)this.txtServiceURL, this.contServiceURL);
        EditUICheckUtil.verifyInput((Object)this.txtServiceMethod, this.contServiceMethod);
        String number = this.editData.getNumber();
        FilterInfo filter = new FilterInfo();
        if (this.editData.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.editData.getId().toString(), CompareType.NOTEQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        boolean isExists = this.getBizInterface().exists(filter);
        if (isExists) {
            MsgBox.showInfo((String)"\u7f16\u7801\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\uff01");
            this.txtNumber.requestFocusInWindow();
            SysUtil.abort();
        }
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
        WSServiceURLInfo treeInfo = (WSServiceURLInfo)this.getUIContext().get("ParentNode");
        if ("ADDNEW".equals(this.getOprtState())) {
            this.editData.put("tree", treeInfo);
        }
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        return null;
    }

    @Override
    public void actionServiceTest_actionPerformed(ActionEvent e) {
        if (this.editData.getId() == null) {
            return;
        }
        String id = this.editData.getId().toString();
        IObjectPK pk = CommonUtil.convert2PK(id);
        try {
            Object result = WSServiceFactory.getRemoteInstance().testService(pk);
            MsgBox.showInfo((String)result.toString());
        }
        catch (Exception e1) {
            logger.error((Object)e);
            MsgBox.showDetailAndOK((Component)((Object)this), (String)"\u8fdc\u7a0b\u670d\u52a1\u8c03\u7528\u5931\u8d25", (String)ThrowableHelper.toString(e1), (int)0);
        }
    }

    protected void txtServiceURL_mouseRelease(MouseEvent e) throws Exception {
    }
}

