/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.portal.client;

import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.client.DiscreteAccreditParamInfo;
import com.kingdee.eas.base.permission.client.RoleDiscreteAccreditUI;
import com.kingdee.eas.base.permission.client.UserDiscreteAccreditUI;
import com.kingdee.eas.base.permission.client.helper.DiscreteAcreditHelper;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.portal.IPortalServiceFacade;
import com.kingdee.eas.portal.IPortlet;
import com.kingdee.eas.portal.IPortletRuntimeCheck;
import com.kingdee.eas.portal.PermissionCheckEnum;
import com.kingdee.eas.portal.PortalServiceFacadeFactory;
import com.kingdee.eas.portal.PortletFactory;
import com.kingdee.eas.portal.PortletInfo;
import com.kingdee.eas.portal.PortletRuntimeCheckCollection;
import com.kingdee.eas.portal.PortletRuntimeCheckFactory;
import com.kingdee.eas.portal.PortletRuntimeCheckInfo;
import com.kingdee.eas.portal.client.AbstractPortletListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class PortletListUI
extends AbstractPortletListUI {
    private static final Logger logger = CoreUIObject.getLogger(PortletListUI.class);
    private final String portletResource = "com.kingdee.eas.portal.portalPublic";
    private final String CHECK_IN_DEFINE = "checkInDefine";
    private final String CHECK_IN_RUNTIME = "checkInRuntime";
    private JMenuItem runtimeViewItem;
    private JMenuItem runtimeUserItem;

    public PortletListUI() throws Exception {
        this.ActionStart.setEnabled(false);
        this.ActionStop.setEnabled(false);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.setColumnMoveable(true);
    }

    protected void initTableParams() {
        super.initTableParams();
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAddNew.setVisible(false);
        this.btnEdit.setVisible(false);
        this.btnLocate.setVisible(false);
        this.btnPageSetup.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnQuery.setVisible(false);
        this.btnRemove.setVisible(false);
        this.btnView.setVisible(false);
        this.setButtonDefaultStyl(this.btnStart);
        this.btnStart.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        this.setButtonDefaultStyl(this.btnStop);
        this.btnStop.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.setButtonDefaultStyl(this.btnPermission);
        this.btnPermission.setIcon(EASResource.getIcon((String)"imgTbtn_distribute"));
        this.btnPermission.setEnabled(true);
        this.setButtonDefaultStyl(this.btnPermission4Runtime);
        this.btnPermission4Runtime.setIcon(EASResource.getIcon((String)"imgTbtn_assistantgeneralledger"));
        this.btnPermission4Runtime.setEnabled(true);
        this.btnDefineCheck.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnDefineNoCheck.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.btnRuntimeCheck.setIcon(EASResource.getIcon((String)"imgTbtn_audit"));
        this.btnRuntimeNoCheck.setIcon(EASResource.getIcon((String)"imgTbtn_unaudit"));
    }

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        JMenuItem item2 = new JMenuItem(EASResource.getString((String)"com.kingdee.eas.portal.portalPublic", (String)"userPermission"));
        JMenuItem item3 = new JMenuItem(EASResource.getString((String)"com.kingdee.eas.portal.portalPublic", (String)"rolePermission"));
        JMenuItem batchItem = new JMenuItem(EASResource.getString((String)"com.kingdee.eas.portal.portalPublic", (String)"batchPermission"));
        JMenuItem delItem = new JMenuItem(EASResource.getString((String)"com.kingdee.eas.portal.portalPublic", (String)"permissionMultiDelete"));
        JMenuItem viewItem = new JMenuItem(EASResource.getString((String)"com.kingdee.eas.portal.portalPublic", (String)"permissionView"));
        item2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PortletListUI.this.beforeActionPerformed(e);
                try {
                    PortletListUI.this.userPermission();
                }
                catch (Exception exc) {
                    PortletListUI.this.handUIException(exc);
                }
                finally {
                    PortletListUI.this.afterActionPerformed(e);
                }
            }
        });
        item3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PortletListUI.this.beforeActionPerformed(e);
                try {
                    PortletListUI.this.rolePermission();
                }
                catch (Exception exc) {
                    PortletListUI.this.handUIException(exc);
                }
                finally {
                    PortletListUI.this.afterActionPerformed(e);
                }
            }
        });
        batchItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PortletListUI.this.beforeActionPerformed(e);
                try {
                    PortletListUI.this.batchPermission();
                }
                catch (Exception exc) {
                    PortletListUI.this.handUIException(exc);
                }
                finally {
                    PortletListUI.this.afterActionPerformed(e);
                }
            }
        });
        delItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PortletListUI.this.beforeActionPerformed(e);
                try {
                    PortletListUI.this.delPermission();
                }
                catch (Exception exc) {
                    PortletListUI.this.handUIException(exc);
                }
                finally {
                    PortletListUI.this.afterActionPerformed(e);
                }
            }
        });
        viewItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PortletListUI.this.beforeActionPerformed(e);
                try {
                    PortletListUI.this.viewPermission();
                }
                catch (Exception exc) {
                    PortletListUI.this.handUIException(exc);
                }
                finally {
                    PortletListUI.this.afterActionPerformed(e);
                }
            }
        });
        this.btnPermission.addAssistMenuItem(viewItem);
        this.btnPermission.addAssistMenuItem(item2);
        this.btnPermission.addAssistMenuItem(item3);
        this.btnPermission.addAssistMenuItem(batchItem);
        this.btnPermission.addAssistMenuItem(delItem);
        this.runtimeViewItem = new JMenuItem(EASResource.getString((String)"com.kingdee.eas.portal.portalPublic", (String)"permission.runtime.view"));
        this.runtimeUserItem = new JMenuItem(EASResource.getString((String)"com.kingdee.eas.portal.portalPublic", (String)"permission.runtime.user"));
        JMenuItem runtimeRoleItem = new JMenuItem(EASResource.getString((String)"com.kingdee.eas.portal.portalPublic", (String)"permission.runtime.role"));
        JMenuItem runtimeBatchItem = new JMenuItem(EASResource.getString((String)"com.kingdee.eas.portal.portalPublic", (String)"permission.runtime.batch"));
        JMenuItem runtimeBatchDeleteItem = new JMenuItem(EASResource.getString((String)"com.kingdee.eas.portal.portalPublic", (String)"permission.runtime.batchdel"));
        this.runtimeViewItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PortletListUI.this.beforeActionPerformed(e);
                try {
                    PortletListUI.this.viewPermission4Runtime();
                }
                catch (Exception exc) {
                    PortletListUI.this.handUIException(exc);
                }
                finally {
                    PortletListUI.this.afterActionPerformed(e);
                }
            }
        });
        this.runtimeUserItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PortletListUI.this.beforeActionPerformed(e);
                try {
                    PortletListUI.this.userPermission4Runtime();
                }
                catch (Exception exc) {
                    PortletListUI.this.handUIException(exc);
                }
                finally {
                    PortletListUI.this.afterActionPerformed(e);
                }
            }
        });
        runtimeRoleItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PortletListUI.this.beforeActionPerformed(e);
                try {
                    PortletListUI.this.rolePermission4Runtime();
                }
                catch (Exception exc) {
                    PortletListUI.this.handUIException(exc);
                }
                finally {
                    PortletListUI.this.afterActionPerformed(e);
                }
            }
        });
        runtimeBatchItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PortletListUI.this.beforeActionPerformed(e);
                try {
                    PortletListUI.this.batchPermission4Runtime();
                }
                catch (Exception exc) {
                    PortletListUI.this.handUIException(exc);
                }
                finally {
                    PortletListUI.this.afterActionPerformed(e);
                }
            }
        });
        runtimeBatchDeleteItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PortletListUI.this.beforeActionPerformed(e);
                try {
                    PortletListUI.this.delPermission4Runtime();
                }
                catch (Exception exc) {
                    PortletListUI.this.handUIException(exc);
                }
                finally {
                    PortletListUI.this.afterActionPerformed(e);
                }
            }
        });
        this.btnPermission4Runtime.addAssistMenuItem(this.runtimeViewItem);
        this.btnPermission4Runtime.addAssistMenuItem(this.runtimeUserItem);
        this.btnPermission4Runtime.addAssistMenuItem(runtimeRoleItem);
        this.btnPermission4Runtime.addAssistMenuItem(runtimeBatchItem);
        this.btnPermission4Runtime.addAssistMenuItem(runtimeBatchDeleteItem);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.setButtonState();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        this.setButtonState();
    }

    private void setButtonState() {
    }

    @Override
    public void actionStart_actionPerformed(ActionEvent e) throws Exception {
        super.actionStart_actionPerformed(e);
        ArrayList list = this.getSelectedIdValues();
        IPortalServiceFacade portalService = PortalServiceFacadeFactory.getRemoteInstance();
        portalService.enablePortlet(list);
        portalService.refreshPortletCache();
        this.refresh(e);
    }

    @Override
    public void actionStop_actionPerformed(ActionEvent e) throws Exception {
        super.actionStop_actionPerformed(e);
        ArrayList list = this.getSelectedIdValues();
        IPortalServiceFacade portalService = PortalServiceFacadeFactory.getRemoteInstance();
        portalService.disablePortlet(list);
        portalService.refreshPortletCache();
        this.refresh(e);
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return PortletFactory.getRemoteInstance();
    }

    @Override
    public void actionPermission_actionPerformed(ActionEvent e) throws Exception {
        super.actionPermission_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"bosObjectType", (Object)new PortletInfo().getBOSType());
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(UserDiscreteAccreditUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        window.show();
    }

    @Override
    public void actionPermission4Runtime_actionPerformed(ActionEvent e) throws Exception {
        super.actionPermission4Runtime_actionPerformed(e);
        this.runtimeUserItem.doClick();
    }

    private void userPermission() throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"bosObjectType", (Object)new PortletInfo().getBOSType());
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(UserDiscreteAccreditUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        window.show();
    }

    private void userPermission4Runtime() throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"bosObjectType", (Object)new PortletRuntimeCheckInfo().getBOSType());
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(UserDiscreteAccreditUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        window.show();
    }

    private void rolePermission() throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"bosObjectType", (Object)new PortletInfo().getBOSType());
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(RoleDiscreteAccreditUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        window.show();
    }

    private void rolePermission4Runtime() throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"bosObjectType", (Object)new PortletRuntimeCheckInfo().getBOSType());
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(RoleDiscreteAccreditUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        window.show();
    }

    private void delPermission() {
        List bizObjIdList = this.getSelectedEnabledPortletIds(this.CHECK_IN_DEFINE);
        DiscreteAccreditParamInfo paramInfo = new DiscreteAccreditParamInfo();
        paramInfo.setBizObjIdList(bizObjIdList);
        paramInfo.setOperatorType("DEL");
        DiscreteAcreditHelper.showDiscreteAcredit((Object)((Object)this), (DiscreteAccreditParamInfo)paramInfo);
    }

    private void delPermission4Runtime() throws Exception {
        List bizObjIdList = this.getSelectedEnabledRuntimePortletIds();
        DiscreteAccreditParamInfo paramInfo = new DiscreteAccreditParamInfo();
        paramInfo.setBizObjIdList(bizObjIdList);
        paramInfo.setOperatorType("DEL");
        DiscreteAcreditHelper.showDiscreteAcredit((Object)((Object)this), (DiscreteAccreditParamInfo)paramInfo);
    }

    private void viewPermission() {
        DiscreteAcreditHelper.showViewDiscretePermDlg((Object)((Object)this), (BOSObjectType)new PortletInfo().getBOSType());
    }

    private void viewPermission4Runtime() {
        DiscreteAcreditHelper.showViewDiscretePermDlg((Object)((Object)this), (BOSObjectType)new PortletRuntimeCheckInfo().getBOSType());
    }

    private List getSelectedEnabledPortletIds(String checkType) {
        ArrayList<String> idList = new ArrayList<String>();
        int size = this.tblMain.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            KDTSelectBlock sb = this.tblMain.getSelectManager().get(i);
            for (int j = sb.getTop(); j <= sb.getBottom(); ++j) {
                if (((BizEnumValueInfo)this.tblMain.getRow(j).getCell("enable").getValue()).getInt() != 1 || ("checkInDefine".equals(checkType) ? ((BizEnumValueInfo)this.tblMain.getRow(j).getCell("defineCheck").getValue()).getInt() != 1 : ((BizEnumValueInfo)this.tblMain.getRow(j).getCell("runtimeCheck").getValue()).getInt() != 1)) continue;
                idList.add(this.tblMain.getRow(j).getCell("id").getValue().toString());
            }
        }
        if (idList.isEmpty()) {
            if ("checkInDefine".equals(checkType)) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.portal.portalPublic", (String)"tip.portlet.permission.check.define.selectedAreDisabled"));
            } else {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.portal.portalPublic", (String)"tip.portlet.permission.check.runtime.selectedAreDisabled"));
            }
            SysUtil.abort();
        }
        return idList;
    }

    private List getSelectedEnabledRuntimePortletIds() throws Exception {
        List portletIdList = this.getSelectedEnabledPortletIds(this.CHECK_IN_RUNTIME);
        FilterInfo filterInfo = new FilterInfo();
        StringBuffer maskString = new StringBuffer();
        for (int i = 0; i < portletIdList.size(); ++i) {
            filterInfo.getFilterItems().add(new FilterItemInfo("portlet.id", portletIdList.get(i), CompareType.EQUALS));
            maskString.append("#" + i);
            if (i == portletIdList.size() - 1) continue;
            maskString.append(" or ");
        }
        filterInfo.setMaskString(maskString.toString());
        ArrayList<Object> runtimeIdList = new ArrayList<Object>();
        IPortletRuntimeCheck portletRuntimeCheck = PortletRuntimeCheckFactory.getRemoteInstance();
        IObjectPK[] runtimePKArray = portletRuntimeCheck.getPKList(filterInfo, new SorterItemCollection());
        if (runtimePKArray != null) {
            for (int i = 0; i < runtimePKArray.length; ++i) {
                runtimeIdList.add(runtimePKArray[i].getKeyValue("id"));
            }
        }
        return runtimeIdList;
    }

    private void batchPermission() throws Exception {
        List idList = this.getSelectedEnabledPortletIds(this.CHECK_IN_DEFINE);
        DiscreteAccreditParamInfo paramInfo = new DiscreteAccreditParamInfo();
        paramInfo.setBizObjIdList(idList);
        DiscreteAcreditHelper.showDiscreteAcredit((Object)((Object)this), (DiscreteAccreditParamInfo)paramInfo);
    }

    private void batchPermission4Runtime() throws Exception {
        List idList = this.getSelectedEnabledRuntimePortletIds();
        DiscreteAccreditParamInfo paramInfo = new DiscreteAccreditParamInfo();
        paramInfo.setBizObjIdList(idList);
        DiscreteAcreditHelper.showDiscreteAcredit((Object)((Object)this), (DiscreteAccreditParamInfo)paramInfo);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    public boolean isPrepareInit() {
        return false;
    }

    @Override
    public void actionDefineCheck_actionPerformed(ActionEvent e) throws Exception {
        this.updateSelectedPermissionData(this.CHECK_IN_DEFINE, PermissionCheckEnum.CHECK);
    }

    @Override
    public void actionDefineNoCheck_actionPerformed(ActionEvent e) throws Exception {
        this.updateSelectedPermissionData(this.CHECK_IN_DEFINE, PermissionCheckEnum.UNCHECK);
    }

    @Override
    public void actionRuntimeCheck_actionPerformed(ActionEvent e) throws Exception {
        this.addRuntimeCheckData();
        this.updateSelectedPermissionData(this.CHECK_IN_RUNTIME, PermissionCheckEnum.CHECK);
    }

    @Override
    public void actionRuntimeNoCheck_actionPerformed(ActionEvent e) throws Exception {
        this.deleteRuntimeCheckData();
        this.updateSelectedPermissionData(this.CHECK_IN_RUNTIME, PermissionCheckEnum.UNCHECK);
    }

    private void addRuntimeCheckData() throws Exception {
        ArrayList idList = this.getSelectedIdValues();
        PortletRuntimeCheckCollection collection = new PortletRuntimeCheckCollection();
        for (int i = 0; i < idList.size(); ++i) {
            Object portletId = idList.get(i);
            PortletInfo portletInfo = new PortletInfo();
            portletInfo.setId(BOSUuid.read((String)portletId.toString()));
            PortletRuntimeCheckInfo checkInfo = new PortletRuntimeCheckInfo();
            checkInfo.setPortlet(portletInfo);
            collection.add(checkInfo);
        }
        IPortletRuntimeCheck portletRuntimeCheck = PortletRuntimeCheckFactory.getRemoteInstance();
        portletRuntimeCheck.addList(collection);
    }

    private void deleteRuntimeCheckData() throws Exception {
        ArrayList idList = this.getSelectedIdValues();
        FilterInfo filter = new FilterInfo();
        StringBuffer maskString = new StringBuffer();
        for (int i = 0; i < idList.size(); ++i) {
            filter.getFilterItems().add(new FilterItemInfo("portlet", idList.get(i), CompareType.EQUALS));
            maskString.append("#" + i);
            if (i == idList.size() - 1) continue;
            maskString.append(" or ");
        }
        filter.setMaskString(maskString.toString());
        IPortletRuntimeCheck portletRuntimeCheck = PortletRuntimeCheckFactory.getRemoteInstance();
        portletRuntimeCheck.delete(filter);
    }

    private void updateSelectedPermissionData(String checkType, PermissionCheckEnum checkEnum) throws Exception {
        ArrayList idList = this.getSelectedIdValues();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        StringBuffer maskString = new StringBuffer();
        for (int i = 0; i < idList.size(); ++i) {
            filter.getFilterItems().add(new FilterItemInfo("id", idList.get(i), CompareType.EQUALS));
            maskString.append("#" + i);
            if (i == idList.size() - 1) continue;
            maskString.append(" or ");
        }
        filter.setMaskString(maskString.toString());
        viewInfo.setFilter(filter);
        IPortlet portlet = PortletFactory.getRemoteInstance();
        CoreBaseCollection colls = portlet.getCollection(viewInfo);
        for (PortletInfo info : colls) {
            if ("checkInDefine".equals(checkType)) {
                info.setDefineCheck(checkEnum);
                continue;
            }
            info.setRuntimeCheck(checkEnum);
        }
        portlet.update(colls);
        this.refreshList();
    }
}

