/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.portal.web.configuration;

import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.XMLConfiguration;
import java.io.File;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.log4j.Logger;

public class PortalConfig {
    private static Logger logger = Logger.getLogger(PortalConfig.class);
    private static final String CONFIGFILE = "easWebConfig.xml";
    private static final String CONFIGITEM_INTEGRATION = "integration";
    private static final String CONFIGITEM_INFOMATIONINFO = "integrationInfo";
    private static final String CONFIGITEM_DEFAULTPAGEINFO = "defaultpage";
    private static XMLConfiguration configuration;
    private static ConfigurationItem integration;

    public static boolean isDefaultIntegrationPage() {
        String str = configuration.getConfigItem(CONFIGITEM_DEFAULTPAGEINFO).getProperty(CONFIGITEM_INTEGRATION);
        boolean b = Boolean.valueOf(str);
        return b;
    }

    public static Vector getIntegrations() {
        ConfigurationItem integrationInfoItem = integration.getChild(CONFIGITEM_INFOMATIONINFO);
        if (integrationInfoItem == null || integrationInfoItem.getProperties().size() == 0) {
            throw new RuntimeException("portal config error , no integration info!");
        }
        TreeMap integrationList = new TreeMap(integrationInfoItem.getProperties());
        int nNum = integrationList.size();
        String[] pic = new String[nNum];
        String[] name = new String[nNum];
        String[] url = new String[nNum];
        String[] target = new String[nNum];
        String strTemp = null;
        StringTokenizer st = null;
        Object[] array = integrationList.values().toArray();
        for (int i = 0; i < nNum; ++i) {
            strTemp = (String)array[i];
            st = new StringTokenizer(strTemp, "#");
            if (st.hasMoreTokens()) {
                name[i] = st.nextToken();
            }
            if (st.hasMoreTokens()) {
                url[i] = st.nextToken();
            }
            if (st.hasMoreTokens()) {
                pic[i] = st.nextToken();
            }
            if (!st.hasMoreTokens()) continue;
            target[i] = st.nextToken();
        }
        Vector<String[]> vector = null;
        if (nNum > 0) {
            vector = new Vector<String[]>();
            vector.add(name);
            vector.add(url);
            vector.add(pic);
            vector.add(target);
        }
        return vector;
    }

    public static XMLConfiguration getConfiguration() {
        return configuration;
    }

    public static ConfigurationItem getConfigurationItem(String configKey) {
        return configuration.getConfigItem(configKey);
    }

    static {
        String fileName = System.getProperty("portal.config");
        if (fileName == null) {
            throw new RuntimeException("cann't find the config file!");
        }
        File configFile = new File(fileName);
        if (configFile.exists()) {
            fileName = configFile.getParentFile().getAbsolutePath() + "/" + CONFIGFILE;
            if (!(configFile = new File(fileName)).exists()) {
                throw new RuntimeException("cann't find the config file, easWebConfig.xml:" + fileName);
            }
        } else {
            throw new RuntimeException("cann't find the config file, portal.config:" + fileName);
        }
        configuration = XMLConfiguration.getInstance((File)configFile);
        integration = configuration.getConfigItem(CONFIGITEM_INTEGRATION);
    }
}

