/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.portal.web.control;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.json.simple.JSONArray;
import com.kingdee.eas.cp.common.json.simple.JSONObject;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.portal.ColCollection;
import com.kingdee.eas.portal.ContainerPortletFacadeFactory;
import com.kingdee.eas.portal.FlagEnum;
import com.kingdee.eas.portal.IContainerPortletFacade;
import com.kingdee.eas.portal.IPortalServiceFacade;
import com.kingdee.eas.portal.LayoutInfo;
import com.kingdee.eas.portal.PageInfo;
import com.kingdee.eas.portal.PortalServiceFacadeFactory;
import com.kingdee.eas.portal.PortletExtInfo;
import com.kingdee.eas.portal.PortletInfo;
import com.kingdee.eas.portal.PortletPreferencesInfo;
import com.kingdee.eas.portal.web.configuration.AbstractPortletDefinitionsFactory;
import com.kingdee.eas.portal.web.configuration.PortletDefine;
import com.kingdee.eas.portal.web.configuration.PortletDefinitionsFactoryWrapper;
import com.kingdee.eas.portal.web.configuration.PortletMode;
import com.kingdee.eas.portal.web.control.PortalContextBean;
import com.kingdee.eas.portal.web.util.PortletUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;

public class ContainerPortletAction
extends DispatchAction {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.portal.web.control.ContainerPortletAction");

    public ActionForward listContainerPortlet(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setContentType("text/html;charset=utf-8");
        IContainerPortletFacade containerFacade = ContainerPortletFacadeFactory.getRemoteInstance();
        List list = containerFacade.getContainerPortletList();
        JSONObject reply = new JSONObject();
        JSONArray records = new JSONArray();
        JSONArray cells = null;
        int count = list.size();
        HashMap rowMap = null;
        for (int i = 0; i < count; ++i) {
            rowMap = (HashMap)list.get(i);
            cells = new JSONArray();
            cells.add(rowMap.get("id"));
            cells.add((Object)rowMap.get("portletnumber").toString());
            cells.add((Object)(rowMap.get("portletname") != null ? rowMap.get("portletname").toString() : ""));
            cells.add((Object)rowMap.get("enable").toString());
            cells.add((Object)rowMap.get("displaystyle").toString());
            cells.add(rowMap.get("description"));
            records.add((Object)cells);
        }
        reply.put((Object)"results", (Object)new Integer(count).toString());
        reply.put((Object)"records", (Object)records);
        response.getWriter().write(reply.toString());
        response.getWriter().flush();
        return null;
    }

    public ActionForward getContainerPortletById(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setContentType("text/html;charset=utf-8");
        String containerPortletId = request.getParameter("containerPortletId");
        IContainerPortletFacade containerFacade = ContainerPortletFacadeFactory.getRemoteInstance();
        HashMap rowMap = containerFacade.getContainerPortletById(containerPortletId);
        JSONObject reply = new JSONObject();
        JSONObject cells = new JSONObject();
        cells.put((Object)"code", rowMap.get("portletnumber"));
        cells.put((Object)"name_en", rowMap.get("portletname_en"));
        cells.put((Object)"name_ch", rowMap.get("portletname_ch"));
        cells.put((Object)"name_tw", rowMap.get("portletname_tw"));
        cells.put((Object)"portletCategoryName", (Object)(rowMap.get("portletcategoryname") == null ? "" : rowMap.get("portletcategoryname")));
        cells.put((Object)"portletCategoryID", (Object)(rowMap.get("portletcategoryid") == null ? "" : rowMap.get("portletcategoryid")));
        cells.put((Object)"desc", rowMap.get("description"));
        cells.put((Object)"status", rowMap.get("enable"));
        cells.put((Object)"displayStyle", rowMap.get("displaystyle"));
        cells.put((Object)"editable", rowMap.get("editable"));
        reply.put((Object)"success", (Object)"true");
        reply.put((Object)"data", (Object)cells);
        response.getWriter().write(reply.toString());
        response.getWriter().flush();
        return null;
    }

    public ActionForward getNormalPortletsList(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setContentType("text/html;charset=utf-8");
        String containerPortletId = request.getParameter("containerPortletId");
        IContainerPortletFacade containerFacade = ContainerPortletFacadeFactory.getRemoteInstance();
        String reply = containerFacade.getPortlets(containerPortletId);
        response.getWriter().write(reply);
        response.getWriter().flush();
        return null;
    }

    public ActionForward getSelectedPortletsList(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setContentType("text/html;charset=utf-8");
        String containerPortletId = request.getParameter("containerPortletId");
        JSONArray reply = new JSONArray();
        JSONObject cells = null;
        HashMap rowMap = null;
        IContainerPortletFacade containerFacade = ContainerPortletFacadeFactory.getRemoteInstance();
        List list = containerFacade.getPortletListById(containerPortletId);
        Iterator iterator = list.iterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                rowMap = (HashMap)iterator.next();
                cells = new JSONObject();
                cells.put((Object)"id", rowMap.get("portletid"));
                cells.put((Object)"text", rowMap.get("portletname"));
                cells.put((Object)"leaf", (Object)true);
                reply.add((Object)cells);
            }
        }
        response.getWriter().write(reply.toString());
        response.getWriter().flush();
        return null;
    }

    private String transEditable(String editable) {
        if ("on".equals(editable)) {
            return "true";
        }
        return "false";
    }

    public ActionForward saveContainerPortlet(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setContentType("text/html;charset=utf-8");
        String containerPortletId = request.getParameter("containerPortletId");
        String portletCategoryID = request.getParameter("portletCategoryID");
        String isCover = request.getParameter("isCover");
        String portletCode = request.getParameter("code");
        String portletName = request.getParameter("name");
        String portletName_l1 = request.getParameter("ENName");
        String portletName_l2 = request.getParameter("CHName");
        String portletName_l3 = request.getParameter("TWName");
        String status = request.getParameter("status");
        String description = request.getParameter("desc");
        String editable = request.getParameter("editable");
        editable = this.transEditable(editable);
        String displayStyle = request.getParameter("displayStyle");
        String selectedPortlets = request.getParameter("selectedPortlets");
        String[] selectedPortletIds = !StringUtils.isEmpty((String)selectedPortlets) ? selectedPortlets.split(",") : new String[]{};
        HashMap<String, Object> infoMap = new HashMap<String, Object>();
        infoMap.put("containerportletid", containerPortletId);
        infoMap.put("portletCategoryID", portletCategoryID);
        infoMap.put("portletnumber", portletCode);
        infoMap.put("portletname", portletName);
        infoMap.put("portletname_l1", portletName_l1);
        infoMap.put("portletname_l2", portletName_l2);
        infoMap.put("portletname_l3", portletName_l3);
        infoMap.put("enable", status);
        infoMap.put("description", description);
        infoMap.put("editable", editable);
        infoMap.put("displaystyle", displayStyle);
        infoMap.put("selectedportletids", selectedPortletIds);
        infoMap.put("isCover", isCover);
        IContainerPortletFacade containerFacade = ContainerPortletFacadeFactory.getRemoteInstance();
        containerFacade.saveContainerPortlet(infoMap);
        response.getWriter().println("{success:true}");
        response.getWriter().flush();
        return null;
    }

    public ActionForward deleteContainerPortletById(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setContentType("text/html;charset=utf-8");
        String containerPortletId = request.getParameter("containerPortletId");
        IContainerPortletFacade containerFacade = ContainerPortletFacadeFactory.getRemoteInstance();
        containerFacade.deleteContainerPortletById(containerPortletId);
        response.getWriter().println("{success:true}");
        response.getWriter().flush();
        return null;
    }

    public ActionForward enableContainerPortlet(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setContentType("text/html;charset=utf-8");
        String containerPortletId = request.getParameter("containerPortletId");
        IContainerPortletFacade containerFacade = ContainerPortletFacadeFactory.getRemoteInstance();
        containerFacade.enableContainerPortlet(containerPortletId);
        response.getWriter().println("{success:true}");
        response.getWriter().flush();
        return null;
    }

    public ActionForward disableContainerPortlet(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setContentType("text/html;charset=utf-8");
        String containerPortletId = request.getParameter("containerPortletId");
        IContainerPortletFacade containerFacade = ContainerPortletFacadeFactory.getRemoteInstance();
        containerFacade.disableContainerPortlet(containerPortletId);
        response.getWriter().println("{success:true}");
        response.getWriter().flush();
        return null;
    }

    private HashMap getContainerPortletAtRuntime(Context ctx, String portletInsId, String portletId) throws BOSException, EASBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        StringBuffer sb = new StringBuffer();
        sb.append("select FID, FStyle, FParentID, FEditable from T_Portal_ContainerPortlet where (FPortletPreferencesID=? and FParentID is not null)");
        sb.append(" or ((FParentID is null or FParentID='') and FPortletID=?)");
        Object[] param = new Object[]{portletInsId, portletId};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])param);
        try {
            if (rs.size() >= 2) {
                while (rs.next()) {
                    if (StringUtils.isEmpty((String)rs.getString("FParentID"))) continue;
                    map.put("containerPortletId", rs.getString("FID"));
                    map.put("style", rs.getString("FStyle"));
                    map.put("isUpdate", new Boolean(true));
                    map.put("editable", new Boolean(rs.getBoolean("FEditable")));
                }
            } else {
                rs.next();
                map.put("containerPortletId", rs.getString("FID"));
                map.put("style", rs.getString("FStyle"));
                map.put("isUpdate", new Boolean(false));
                map.put("editable", new Boolean(rs.getBoolean("FEditable")));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return map;
    }

    public ActionForward getPortletsListForShow(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setContentType("text/html;charset=utf-8");
        String portletInsId = request.getParameter("portletInsId");
        String portletId = request.getParameter("portletId");
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        IContainerPortletFacade containerFacade = ContainerPortletFacadeFactory.getRemoteInstance();
        HashMap map = this.getContainerPortletAtRuntime(ctx, portletInsId, portletId);
        List list = containerFacade.getPortletListById((String)map.get("containerPortletId"), false);
        JSONObject reply = new JSONObject();
        JSONArray ids = new JSONArray();
        JSONArray portletIds = new JSONArray();
        JSONArray names = new JSONArray();
        JSONArray portletTileNames = new JSONArray();
        HashMap rowMap = null;
        PortletDefine pDefine = null;
        AbstractPortletDefinitionsFactory as = PortletDefinitionsFactoryWrapper.getPortletDefinitionsFactory(ctx);
        Iterator iterator = list.iterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                rowMap = (HashMap)iterator.next();
                String subPortletId = (String)rowMap.get("portletid");
                if (!PortletUtil.canShow4RuntimePortlet(request, subPortletId)) {
                    logger.info((Object)("The portlet: " + subPortletId + "  not runtime permission!"));
                    continue;
                }
                ids.add(rowMap.get("id"));
                portletIds.add((Object)subPortletId);
                if (rowMap.get("portletnameext") == null) {
                    names.add((Object)(rowMap.get("portletname") == null ? " " : rowMap.get("portletname")));
                } else {
                    names.add(rowMap.get("portletnameext"));
                }
                pDefine = as.getPortletDefine(rowMap.get("portletdefineid").toString());
                if (pDefine != null && pDefine.getModes().get("view") != null) {
                    portletTileNames.add((Object)((PortletMode)pDefine.getModes().get("view")).getValue());
                    continue;
                }
                logger.info((Object)"view porlet request error!");
                portletTileNames.add((Object)"<put the error porlet info>");
            }
        }
        reply.put((Object)"ids", (Object)ids);
        reply.put((Object)"portletIds", (Object)portletIds);
        reply.put((Object)"names", (Object)names);
        reply.put((Object)"portletTileNames", (Object)portletTileNames);
        reply.put((Object)"style", (Object)((String)map.get("style")));
        response.getWriter().write(reply.toString());
        response.getWriter().flush();
        return null;
    }

    public ActionForward getPortletsListForSet(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setContentType("text/html;charset=utf-8");
        String portletInsId = request.getParameter("portletInsId");
        String portletId = request.getParameter("portletId");
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        IContainerPortletFacade containerFacade = ContainerPortletFacadeFactory.getRemoteInstance();
        HashMap map = this.getContainerPortletAtRuntime(ctx, portletInsId, portletId);
        List list = containerFacade.getPortletListById((String)map.get("containerPortletId"), false);
        JSONObject reply = new JSONObject();
        JSONArray records = new JSONArray();
        JSONArray cells = null;
        int count = list.size();
        HashMap rowMap = null;
        Iterator iterator = list.iterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                rowMap = (HashMap)iterator.next();
                String subPortletId = (String)rowMap.get("portletid");
                cells = new JSONArray();
                cells.add((Object)subPortletId);
                if (rowMap.get("portletnameext") == null) {
                    cells.add((Object)(rowMap.get("portletname") == null ? " " : rowMap.get("portletname")));
                } else {
                    cells.add(rowMap.get("portletnameext"));
                }
                if (rowMap.get("bizinsurl") != null) {
                    cells.add((Object)rowMap.get("bizinsurl").toString());
                } else {
                    cells.add((Object)"");
                }
                cells.add((Object)"");
                cells.add((Object)rowMap.get("id").toString());
                if (PortletUtil.canShow4RuntimePortlet(request, subPortletId)) {
                    cells.add((Object)"true");
                } else {
                    logger.info((Object)("getPortletsListForSet the portlet: " + subPortletId + " has no runtime permission!"));
                    cells.add((Object)"false");
                }
                records.add((Object)cells);
            }
        }
        JSONObject formParam = new JSONObject();
        formParam.put((Object)"containerPortletId", (Object)((String)map.get("containerPortletId")));
        formParam.put((Object)"style", (Object)((String)map.get("style")));
        formParam.put((Object)"isUpdate", (Object)((Boolean)map.get("isUpdate")));
        reply.put((Object)"results", (Object)new Integer(count).toString());
        reply.put((Object)"records", (Object)records);
        reply.put((Object)"formParam", (Object)formParam);
        reply.put((Object)"editable", (Object)map.get("editable").toString());
        response.getWriter().write(reply.toString());
        response.getWriter().flush();
        return null;
    }

    public ActionForward getCurrentPagePortlets(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setContentType("text/html;charset=utf-8");
        String pageIndex = request.getParameter("portalPageId");
        HttpSession session = request.getSession();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        Locale local = ctx.getLocale();
        PortalContextBean portalContextBean = (PortalContextBean)session.getAttribute("com.kingdee.portal.web.control.PORTAL_CONTEXT_BEAN");
        PageInfo currPageInfo = portalContextBean.getPageInfo(pageIndex);
        LayoutInfo layoutInfo = currPageInfo.getTab().getLayout();
        ColCollection cols = layoutInfo.getCols();
        int colNum = cols.size();
        IPortalServiceFacade service = PortalServiceFacadeFactory.getRemoteInstance();
        HashMap portletsHashMap = service.getPortlets();
        Iterator iterator = null;
        String portletId = null;
        PortletInfo portletInfo = null;
        PortletExtInfo extInfo = null;
        PortletPreferencesInfo portletInst = null;
        JSONArray reply = new JSONArray();
        JSONObject cells = null;
        for (int i = 0; i < colNum; ++i) {
            iterator = cols.get(i).getPortlets().iterator();
            while (iterator.hasNext()) {
                portletInst = (PortletPreferencesInfo)iterator.next();
                portletId = portletInst.getPortletID();
                portletInfo = (PortletInfo)portletsHashMap.get(portletId);
                if (portletInfo == null || portletInfo.getFlag() != null && portletInfo.getFlag().equals((Object)FlagEnum.CONTAINER_FLAG)) continue;
                extInfo = portletInfo.getPortletExt();
                cells = new JSONObject();
                cells.put((Object)"portletInstId", (Object)portletInst.getId().toString());
                cells.put((Object)"portletId", (Object)portletId);
                if (extInfo != null && extInfo.getTitle(local) != null) {
                    cells.put((Object)"text", (Object)extInfo.getTitle(local));
                } else {
                    cells.put((Object)"text", (Object)(portletInfo.getPortletName(local) == null ? " " : portletInfo.getPortletName(local)));
                }
                cells.put((Object)"leaf", (Object)true);
                cells.put((Object)"checked", (Object)false);
                reply.add((Object)cells);
            }
        }
        response.getWriter().write(reply.toString());
        response.getWriter().flush();
        return null;
    }

    public ActionForward savePortletsListForSet(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setContentType("text/html;charset=utf-8");
        String containerPortletId = request.getParameter("containerPortletId");
        String isUpdate = request.getParameter("isUpdate");
        String portletPreferencesID = request.getParameter("portletInsId");
        String displayStyle = request.getParameter("style");
        String selectedPortlets = request.getParameter("selectedPortlets");
        String[] selectedPortletIds = !StringUtils.isEmpty((String)selectedPortlets) ? selectedPortlets.split(",") : new String[]{};
        String newIncPortletIds = request.getParameter("newIncPortletIds");
        String[] newIncIds = !StringUtils.isEmpty((String)newIncPortletIds) ? newIncPortletIds.split(",") : new String[]{};
        HashMap<String, Object> infoMap = new HashMap<String, Object>();
        infoMap.put("containerportletid", containerPortletId);
        infoMap.put("isupdate", isUpdate);
        infoMap.put("portletpreferencesid", portletPreferencesID);
        infoMap.put("displaystyle", displayStyle);
        infoMap.put("selectedportlets", selectedPortletIds);
        infoMap.put("newIncIds", newIncIds);
        IContainerPortletFacade containerFacade = ContainerPortletFacadeFactory.getRemoteInstance();
        containerFacade.savePortletsListForSet(infoMap);
        response.getWriter().println("{success:true}");
        response.getWriter().flush();
        return null;
    }
}

