/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.portal.web.control;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.usermonitor.UserMonitorSessionInfo;
import com.kingdee.eas.base.usermonitor.UserMonitorStateEnum;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.portal.IPortalServiceFacade;
import com.kingdee.eas.portal.PortalServiceFacadeFactory;
import com.kingdee.eas.portal.PortletInfo;
import com.kingdee.eas.portal.PortletParameterCollection;
import com.kingdee.eas.portal.PortletParameterInfo;
import com.kingdee.eas.portal.web.configuration.PortletDefine;
import com.kingdee.eas.portal.web.configuration.PortletMode;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class PortletBroadcastAction
extends Action {
    private static final String SUCC = "success";
    private static final String ERR = "error";
    private static final String ERR_MSG_KEY = "errorInfo";

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        this.addUserMonitorInfo(ctx, request);
        String portletId = request.getParameter("portletId");
        String portletInsId = request.getParameter("portletInsId");
        IPortalServiceFacade service = PortalServiceFacadeFactory.getRemoteInstance();
        HashMap portletsHashMap = service.getPortlets();
        PortletInfo portlet = (PortletInfo)portletsHashMap.get(portletId);
        if (portlet == null) {
            request.setAttribute(ERR_MSG_KEY, (Object)("the portlet[" + portletId + "] does not exists!"));
            return mapping.findForward(ERR);
        }
        PortletDefine pDefine = service.getPortletDefine(portlet.getPortletDefineId());
        String action = "view";
        if (pDefine == null || pDefine.getModes().get(action) == null) {
            request.setAttribute(ERR_MSG_KEY, (Object)("cant get porlet definitions from xml for portletId[" + portletId + "]"));
            return mapping.findForward(ERR);
        }
        request.setAttribute("tilesName", (Object)((PortletMode)pDefine.getModes().get(action)).getValue());
        request.setAttribute("javax.portlet.title.", (Object)((String)portlet.get("portletname_" + ctx.getLocale().toString())));
        request.setAttribute("p_p_id", (Object)portletId);
        request.setAttribute("new_portal_portlet_instance_id", (Object)portletInsId);
        PortletParameterCollection collection = portlet.getParams();
        int n = collection.size();
        PortletParameterInfo info = null;
        for (int j = 0; j < n; ++j) {
            info = collection.get(j);
            if (info.getParamName() == null) continue;
            request.setAttribute(info.getParamName(), (Object)info.getParamValue());
        }
        request.setAttribute("containerPortlet", (Object)"true");
        return mapping.findForward(SUCC);
    }

    private void addUserMonitorInfo(Context ctx, HttpServletRequest httpRequest) {
        Locale userLocale = null;
        if (ctx != null) {
            userLocale = ctx.getLocale();
        } else {
            String defaultLanguage = httpRequest.getSession().getServletContext().getInitParameter("com.kingdee.eas.portal.defaultLanguage");
            if (defaultLanguage == null || "".equals(defaultLanguage)) {
                defaultLanguage = "L2";
            }
            userLocale = new Locale(defaultLanguage);
        }
        HttpSession session = httpRequest.getSession();
        session.setAttribute("org.apache.struts.action.LOCALE", (Object)userLocale);
        UserMonitorSessionInfo userMonitorSessionInfo = new UserMonitorSessionInfo();
        userMonitorSessionInfo.setUserMonitorState(UserMonitorStateEnum.login);
        userMonitorSessionInfo.setLastUpdateTime(new Date());
        userMonitorSessionInfo.setLastCheckTickedTime(new Date());
        userMonitorSessionInfo.setId(session.getId());
        session.setAttribute("userMonitorSessionInfo", (Object)userMonitorSessionInfo);
    }
}

