/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.biz;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.mobile.CoreReceiveMessageInfo;
import com.kingdee.eas.mobile.CoreSendMessageInfo;
import com.kingdee.eas.mobile.EmailReceiveMessageInfo;
import com.kingdee.eas.mobile.EmailSendMessageInfo;
import com.kingdee.eas.mobile.ReceiveMobileMessageInfo;
import com.kingdee.eas.mobile.SendMobileMessageInfo;
import com.kingdee.eas.mobile.biz.BizFuncParamObj;
import com.kingdee.eas.mobile.biz.BizReturnObj;
import com.kingdee.eas.mobile.biz.IBizService;
import com.kingdee.eas.mobile.biz.IMessageHandler;
import com.kingdee.eas.mobile.biz.IReplyMsgFunction;
import com.kingdee.eas.mobile.dao.DefaultMsgDAO;
import com.kingdee.eas.mobile.framework.ServerCenter;
import com.kingdee.eas.mobile.util.AppMsgUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ReplyMsgHandler
implements IMessageHandler {
    private static final Logger logger = Logger.getLogger(ReplyMsgHandler.class);

    @Override
    public CoreSendMessageInfo executeBizAction(Context ctx, UserInfo userInfo, CoreReceiveMessageInfo receiveMsgInfo) {
        logger.info((Object)("in executeBizAction \uff1a" + receiveMsgInfo.getContent()));
        String content = receiveMsgInfo.getContent();
        if (StringUtils.isEmpty((String)content)) {
            return null;
        }
        String[] contents = AppMsgUtil.getCommandParams(content.trim());
        if (contents == null || contents.length < 1) {
            return null;
        }
        String command = contents[0];
        String[] params = new String[contents.length - 1];
        for (int i = 0; i < params.length; ++i) {
            params[i] = contents[i + 1];
        }
        CoreSendMessageInfo coreSendMessageInfo = null;
        try {
            logger.info((Object)("do validateForBizFunction \uff1a" + receiveMsgInfo.getContent()));
            IReplyMsgFunction bizInstance = this.validateForBizFunction(ctx, command, params, receiveMsgInfo);
            if (bizInstance == null) {
                if (receiveMsgInfo instanceof ReceiveMobileMessageInfo) {
                    coreSendMessageInfo = new SendMobileMessageInfo();
                } else if (receiveMsgInfo instanceof EmailReceiveMessageInfo) {
                    coreSendMessageInfo = new EmailSendMessageInfo();
                }
                coreSendMessageInfo.setTitle("Reply message for Error");
                coreSendMessageInfo.setContent(ResourceBase.getString((String)"com.kingdee.eas.mobile.msg.MobileResource", (String)"byCommand", (Locale)ctx.getLocale()) + command + ResourceBase.getString((String)"com.kingdee.eas.mobile.msg.MobileResource", (String)"notFindBiz", (Locale)ctx.getLocale()));
            } else {
                logger.info((Object)("do executeBizAction \uff1a" + receiveMsgInfo.getContent()));
                coreSendMessageInfo = this.executeBizAction(ctx, bizInstance, userInfo, command, params, receiveMsgInfo);
            }
            return coreSendMessageInfo;
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)"\u5904\u7406\u56de\u590d\u77ed\u4fe1\u6267\u884c\u4e1a\u52a1\u529f\u80fd\u65f6\u53d1\u751f\u9519\u8bef\uff0c\u8f7d\u4e1a\u52a1\u529f\u80fd\u5904\u7406\u5b9e\u4f8b\u5931\u8d25\uff1a", (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)"\u5904\u7406\u56de\u590d\u77ed\u4fe1\u6267\u884c\u4e1a\u52a1\u529f\u80fd\u65f6\u53d1\u751f\u9519\u8bef\uff1a", (Throwable)e);
        }
        return coreSendMessageInfo;
    }

    private CoreSendMessageInfo executeBizAction(Context ctx, IReplyMsgFunction bizInstance, UserInfo userInfo, String command, String[] params, CoreReceiveMessageInfo receiveMsg) throws Exception {
        CoreSendMessageInfo coreSendMsgInfo = null;
        BizFuncParamObj paramObj = null;
        if (receiveMsg instanceof ReceiveMobileMessageInfo) {
            paramObj = new BizFuncParamObj(ctx, userInfo.getId().toString(), command, params, ((ReceiveMobileMessageInfo)receiveMsg).getParentMsg().getAssignID(), receiveMsg);
        } else if (receiveMsg instanceof EmailReceiveMessageInfo) {
            paramObj = new BizFuncParamObj(ctx, userInfo.getId().toString(), command, params, ((EmailReceiveMessageInfo)receiveMsg).getParentMsg().getAssignID(), receiveMsg);
        } else {
            logger.info((Object)"do executeBizAction \uff1aMessage type is not support.");
            return null;
        }
        logger.info((Object)("do beforeExecReplyAction \uff1a" + receiveMsg.getContent()));
        if (bizInstance.beforeExecReplyAction(paramObj)) {
            logger.info((Object)("do executeReplyAction \uff1a" + receiveMsg.getContent()));
            BizReturnObj returnObj = bizInstance.executeReplyAction(paramObj);
            logger.info((Object)("do afterExecReplyAction \uff1a" + receiveMsg.getContent()));
            if (bizInstance.afterExecReplyAction(paramObj, returnObj)) {
                logger.info((Object)("do afterExecReplyAction \uff1a" + receiveMsg.getContent() + "  isMustReply..."));
                if (returnObj != null && returnObj.isMustReply()) {
                    if (receiveMsg instanceof ReceiveMobileMessageInfo) {
                        coreSendMsgInfo = new SendMobileMessageInfo();
                    } else if (receiveMsg instanceof EmailReceiveMessageInfo) {
                        coreSendMsgInfo = new EmailSendMessageInfo();
                    } else {
                        logger.info((Object)"do executeBizAction \uff1aMessage type is not support.");
                        return null;
                    }
                    if (returnObj.isSucceed()) {
                        logger.info((Object)("do afterExecReplyAction \uff1a" + receiveMsg.getContent() + "  returnObj.isSucceed()."));
                        coreSendMsgInfo.setContent(returnObj.getReturnText());
                        if (StringUtils.isEmpty((String)returnObj.getTitle())) {
                            coreSendMsgInfo.setTitle("Reply message");
                        } else {
                            coreSendMsgInfo.setTitle(returnObj.getTitle());
                        }
                        if (!StringUtils.isEmpty((String)returnObj.getCustomStr())) {
                            coreSendMsgInfo.setCustomStr(returnObj.getCustomStr());
                        }
                        if (!StringUtils.isEmpty((String)returnObj.getMsgId())) {
                            coreSendMsgInfo.setMsgID(returnObj.getMsgId());
                        }
                        if (!StringUtils.isEmpty((String)returnObj.getAssignmentID())) {
                            coreSendMsgInfo.setAssignID(returnObj.getAssignmentID());
                        }
                    } else {
                        logger.info((Object)("do afterExecReplyAction \uff1a" + receiveMsg.getContent() + "  returnObj.isFail."));
                        if (!StringUtils.isEmpty((String)returnObj.getErrorText())) {
                            coreSendMsgInfo.setContent(returnObj.getErrorText());
                        }
                        if (StringUtils.isEmpty((String)returnObj.getTitle())) {
                            coreSendMsgInfo.setTitle("Reply message for Error");
                        } else {
                            coreSendMsgInfo.setTitle(returnObj.getTitle());
                        }
                    }
                    logger.info((Object)("do afterExecReplyAction \uff1a" + receiveMsg.getContent() + "  record SendBizFunction className."));
                    coreSendMsgInfo.setSendBizFunction(bizInstance.getClass().getName());
                }
            }
        }
        return coreSendMsgInfo;
    }

    private IReplyMsgFunction validateForBizFunction(Context ctx, String command, String[] params, CoreReceiveMessageInfo receiveMsg) throws Exception {
        Class<?> bizClass = null;
        Object instance = null;
        BizFuncParamObj paramObj = null;
        IReplyMsgFunction bizInstance = null;
        if (receiveMsg instanceof ReceiveMobileMessageInfo) {
            logger.info((Object)("validateForBizFunction(in handleForSendOrReplyMsg) : title = " + receiveMsg.getTitle() + "; content = " + receiveMsg.getContent()));
            if (((ReceiveMobileMessageInfo)receiveMsg).getParentMsg() != null && !StringUtils.isEmpty((String)((ReceiveMobileMessageInfo)receiveMsg).getParentMsg().getSendBizFunction())) {
                logger.info((Object)("validateForBizFunction((ReceiveMobileMessageInfo)receiveMsg).getParentMsg() != null) : title= " + receiveMsg.getTitle() + "; content= " + receiveMsg.getContent()));
                try {
                    logger.info((Object)("validateForBizFunction(in handleForSendOrReplyMsg) : title= " + receiveMsg.getTitle() + "; content= " + receiveMsg.getContent()));
                    bizClass = Class.forName(((ReceiveMobileMessageInfo)receiveMsg).getParentMsg().getSendBizFunction());
                    instance = bizClass.newInstance();
                    logger.info((Object)("validateForBizFunction(in handleForSendOrReplyMsg) : title= " + receiveMsg.getTitle() + "; content= " + receiveMsg.getContent()));
                    if (instance instanceof IReplyMsgFunction) {
                        bizInstance = instance;
                        paramObj = new BizFuncParamObj(ctx, command, params, ((ReceiveMobileMessageInfo)receiveMsg).getParentMsg().getAssignID(), receiveMsg);
                        logger.info((Object)("validateForBizFunction(instance instanceof IReplyMsgFunction) : title = " + receiveMsg.getTitle() + "; content= " + receiveMsg.getContent()));
                        if (bizInstance.validate(paramObj)) {
                            return bizInstance;
                        }
                        bizInstance = null;
                    }
                }
                catch (ClassNotFoundException e) {
                    logger.error((Object)("\u5904\u7406\u4e3b\u53d1\u77ed\u4fe1\u6267\u884c\u4e1a\u52a1\u529f\u80fd\u65f6\u53d1\u751f\u9519\u8bef,\u88c5\u8f7d\u4e1a\u52a1\u529f\u80fd\u5904\u7406\u7c7b" + ((ReceiveMobileMessageInfo)receiveMsg).getParentMsg().getSendBizFunction() + "\u5b9e\u4f8b\u5931\u8d25\uff1a"), (Throwable)e);
                }
            }
        } else if (receiveMsg instanceof EmailReceiveMessageInfo) {
            logger.info((Object)("validateForBizFunction(in handleForSendOrReplyMsg) : title = " + receiveMsg.getTitle() + "; content= " + receiveMsg.getContent()));
            if (((EmailReceiveMessageInfo)receiveMsg).getParentMsg() != null && !StringUtils.isEmpty((String)((EmailReceiveMessageInfo)receiveMsg).getParentMsg().getSendBizFunction())) {
                try {
                    logger.info((Object)("validateForBizFunction(in handleForSendOrReplyMsg) : title = " + receiveMsg.getTitle() + "; content= " + receiveMsg.getContent()));
                    bizClass = Class.forName(((EmailReceiveMessageInfo)receiveMsg).getParentMsg().getSendBizFunction());
                    instance = bizClass.newInstance();
                    logger.info((Object)("validateForBizFunction(in handleForSendOrReplyMsg) : title= " + receiveMsg.getTitle() + "; content= " + receiveMsg.getContent()));
                    if (instance instanceof IReplyMsgFunction) {
                        logger.info((Object)("validateForBizFunction(in handleForSendOrReplyMsg) : title = " + receiveMsg.getTitle() + "; content= " + receiveMsg.getContent()));
                        bizInstance = instance;
                        paramObj = new BizFuncParamObj(ctx, command, params, ((EmailReceiveMessageInfo)receiveMsg).getParentMsg().getAssignID(), receiveMsg);
                        logger.info((Object)("validateForBizFunction(in handleForSendOrReplyMsg) : title= " + receiveMsg.getTitle() + "; content= " + receiveMsg.getContent()));
                        if (bizInstance.validate(paramObj)) {
                            return bizInstance;
                        }
                        bizInstance = null;
                    }
                }
                catch (ClassNotFoundException err) {
                    logger.error((Object)("\u5904\u7406\u4e3b\u53d1\u77ed\u4fe1\u6267\u884c\u4e1a\u52a1\u529f\u80fd\u65f6\u53d1\u751f\u9519\u8bef\uff0c\u88c5\u8f7d\u4e1a\u52a1\u529f\u80fd\u5904\u7406\u7c7b" + ((EmailReceiveMessageInfo)receiveMsg).getParentMsg().getSendBizFunction() + "\u5b9e\u4f8b\u5931\u8d25\uff1a"), (Throwable)err);
                }
            }
        }
        logger.info((Object)("validateForBizFunction(in handleForSendOrReplyMsg) : title= " + receiveMsg.getTitle() + "; content= " + receiveMsg.getContent()));
        ServerCenter serverCenter = ServerCenter.getInstance(ctx);
        IBizService[] bBizServices = serverCenter.getBizService();
        logger.info((Object)("validateForBizFunction(IBizService[] bBizServices = serverCenter.getBizService()) : title= " + receiveMsg.getTitle() + "; content= " + receiveMsg.getContent()));
        if (bBizServices != null && bBizServices.length > 0) {
            logger.info((Object)("validateForBizFunction(in handleForSendOrReplyMsg) : title= " + receiveMsg.getTitle() + "; content= " + receiveMsg.getContent()));
            for (int i = 0; i < bBizServices.length; ++i) {
                if (bBizServices[i] == null || !(bBizServices[i] instanceof IReplyMsgFunction)) continue;
                logger.info((Object)("validateForBizFunction(bBizServices[i] instanceof IReplyMsgFunction) : title= " + receiveMsg.getTitle() + "; content= " + receiveMsg.getContent()));
                bizInstance = (IReplyMsgFunction)((Object)bBizServices[i]);
                if (receiveMsg instanceof ReceiveMobileMessageInfo) {
                    paramObj = new BizFuncParamObj(ctx, command, params, ((ReceiveMobileMessageInfo)receiveMsg).getParentMsg().getAssignID(), receiveMsg);
                } else if (receiveMsg instanceof EmailReceiveMessageInfo) {
                    paramObj = new BizFuncParamObj(ctx, command, params, ((EmailReceiveMessageInfo)receiveMsg).getParentMsg().getAssignID(), receiveMsg);
                }
                if (bizInstance.validate(paramObj)) {
                    return bizInstance;
                }
                bizInstance = null;
            }
        }
        logger.info((Object)("validateForBizFunction(DefaultMsgDAO.getAllBizFunctionImpClass(ctx) : title= " + receiveMsg.getTitle() + "; content= " + receiveMsg.getContent()));
        String[] classNames = DefaultMsgDAO.getAllBizFunctionImpClass(ctx);
        if (classNames == null || classNames.length == 0) {
            return null;
        }
        for (int i = 0; i < classNames.length; ++i) {
            try {
                logger.info((Object)("validateForBizFunction(Class.forName(classNames[i])) : title= " + receiveMsg.getTitle() + "; content= " + receiveMsg.getContent()));
                bizClass = Class.forName(classNames[i]);
                instance = bizClass.newInstance();
                logger.info((Object)("validateForBizFunction(bizClass.newInstance()) : title= " + receiveMsg.getTitle() + "; content= " + receiveMsg.getContent()));
                if (!(instance instanceof IReplyMsgFunction)) continue;
                logger.info((Object)("validateForBizFunction(instance instanceof IReplyMsgFunction) : title= " + receiveMsg.getTitle() + "; content= " + receiveMsg.getContent()));
                bizInstance = instance;
                if (receiveMsg instanceof ReceiveMobileMessageInfo) {
                    paramObj = new BizFuncParamObj(ctx, command, params, ((ReceiveMobileMessageInfo)receiveMsg).getParentMsg().getAssignID(), receiveMsg);
                } else if (receiveMsg instanceof EmailReceiveMessageInfo) {
                    paramObj = new BizFuncParamObj(ctx, command, params, ((EmailReceiveMessageInfo)receiveMsg).getParentMsg().getAssignID(), receiveMsg);
                }
                logger.info((Object)("validateForBizFunction(if(bizInstance.validate(paramObj))) : title= " + receiveMsg.getTitle() + "; content= " + receiveMsg.getContent()));
                if (bizInstance.validate(paramObj)) {
                    return bizInstance;
                }
                bizInstance = null;
                continue;
            }
            catch (ClassNotFoundException err) {
                logger.error((Object)("\u5904\u7406\u4e3b\u53d1\u77ed\u4fe1\u6267\u884c\u4e1a\u52a1\u529f\u80fd\u65f6\u53d1\u751f\u9519\u8bef,\u88c5\u8f7d\u4e1a\u52a1\u529f\u80fd\u5904\u7406\u7c7b" + classNames[i] + "\u5b9e\u4f8b\u5931\u8d25\uff1a"), (Throwable)err);
            }
        }
        return bizInstance;
    }
}

