/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.ControlUtilities;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.workflow.exception.AlreadyBindProcessInstanceException;
import com.kingdee.bos.workflow.exception.MatchAssignmentException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.mobile.BizFunctionCollection;
import com.kingdee.eas.mobile.BizFunctionFactory;
import com.kingdee.eas.mobile.BizFunctionInfo;
import com.kingdee.eas.mobile.BizModuleCollection;
import com.kingdee.eas.mobile.BizModuleFactory;
import com.kingdee.eas.mobile.CommandObjectInfo;
import com.kingdee.eas.mobile.IBizFunction;
import com.kingdee.eas.mobile.IBizModule;
import com.kingdee.eas.mobile.IMobileConfig;
import com.kingdee.eas.mobile.IMsgFacade;
import com.kingdee.eas.mobile.IServerEngine;
import com.kingdee.eas.mobile.IServerEngineNew;
import com.kingdee.eas.mobile.MobileConfigCollection;
import com.kingdee.eas.mobile.MobileConfigFactory;
import com.kingdee.eas.mobile.MobileConfigInfo;
import com.kingdee.eas.mobile.MobileException;
import com.kingdee.eas.mobile.MobileServerCacheMgrFacadeFactory;
import com.kingdee.eas.mobile.MsgFacadeFactory;
import com.kingdee.eas.mobile.ServerEngineNewFactory;
import com.kingdee.eas.mobile.client.AbstractBizConfigUI;
import com.kingdee.eas.mobile.framework.AbastractMobileGatewayProvider;
import com.kingdee.eas.mobile.framework.IMobileGatewayProvider;
import com.kingdee.eas.mobile.framework.KingdeeMobileGatewayProvider;
import com.kingdee.eas.mobile.framework.NewKingdeeMobileGatewayProvider;
import com.kingdee.eas.mobile.framework.WeinaduoMobileGatewayProvider;
import com.kingdee.eas.mobile.msg.BizFunction;
import com.kingdee.eas.mobile.msg.BizModuleConfig;
import com.kingdee.eas.mobile.util.MessageConstant;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.STConverter;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.JComboBox;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class BizConfigUI
extends AbstractBizConfigUI
implements KDTActiveCellListener {
    private static final String RES2 = "com.kingdee.eas.mobile.client.BizConfigUIResources";
    private static final Logger logger = Logger.getLogger(BizConfigUI.class);
    private Window window = null;
    MobileConfigInfo mobileConfigInfo = null;
    protected BizModuleConfig config;
    protected IServerEngine engine;
    protected String url;
    private IServerEngineNew serverEngineNew = null;
    private BizModuleCollection bizModules = null;
    protected KDComboBox bizModulesCB = null;
    private BizFunctionCollection[] bizFunctionCols = null;
    private KDComboBox[] bizFunctionsCB = null;
    private boolean firstLoad = true;

    public BizConfigUI() throws Exception {
        this.kDTable2.addKDTEditListener((KDTEditListener)new EditAdapter());
        this.kDTable2.getIndexColumn().getStyleAttributes().setHided(true);
        this.connectAction.setVisible(false);
        this.disConnectAction.setVisible(false);
        this.initData();
        this.initUI();
    }

    private void setFunctions(int row, int col, String className) {
        BizFunction[] functions = this.config.getBizFunction(className);
        IRow irow = this.kDTable2.getRow(row);
        ICell icell = irow.getCell(col);
        KDComboBox box = new KDComboBox();
        for (int i = 0; functions != null && i < functions.length; ++i) {
            box.addItem((Object)new FunctionItem(functions[i]));
            logger.debug((Object)functions[i].getDescription(SysContext.getSysContext().getLocale()));
        }
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JComboBox)box);
        icell.setEditor((ICellEditor)cellEditor);
    }

    private void initData() throws Exception {
        if (this.serverEngineNew == null) {
            this.serverEngineNew = ServerEngineNewFactory.getRemoteInstance();
        }
    }

    private void initUI() throws Exception {
        try {
            UIManager.setLookAndFeel("com.kingdee.bos.ctrl.swing.plaf.KingdeeLookAndFeel");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.saveAction.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.resetAction.setIcon(EASResource.getIcon((String)"imgTbtn_reset"));
        this.startAction.setIcon(EASResource.getIcon((String)"imgTbtn_startupserve"));
        this.stopAction.setIcon(EASResource.getIcon((String)"imgTbtn_stopserve"));
        this.testConnectionAction.setIcon(EASResource.getIcon((String)"imgTbtn_testappserver"));
        this.saveAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    BizConfigUI.this.saveAction_actionPerformed(arg0);
                }
                catch (Exception e) {
                    BizConfigUI.this.handUIException(e);
                }
            }
        });
        this.resetAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    BizConfigUI.this.resetAction_actionPerformed(arg0);
                }
                catch (Exception e) {
                    BizConfigUI.this.handUIException(e);
                }
            }
        });
        this.connectAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    BizConfigUI.this.connectAction_actionPerformed(arg0);
                }
                catch (Exception e) {
                    BizConfigUI.this.handUIException(e);
                }
            }
        });
        this.disConnectAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    BizConfigUI.this.disConnectAction_actionPerformed(arg0);
                }
                catch (Exception e) {
                    BizConfigUI.this.handUIException(e);
                }
            }
        });
        this.startAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    BizConfigUI.this.startAction_actionPerformed(arg0);
                }
                catch (Exception e) {
                    BizConfigUI.this.handUIException(e);
                }
            }
        });
        this.testConnectionAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    BizConfigUI.this.actionTestConnection_actionPerformed(arg0);
                }
                catch (Exception e) {
                    BizConfigUI.this.handUIException(e);
                }
            }
        });
        this.stopAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    BizConfigUI.this.stopAction_actionPerformed(arg0);
                }
                catch (Exception e) {
                    BizConfigUI.this.handUIException(e);
                }
            }
        });
        this.displayConfig();
        this.showToolBarByState();
    }

    private void displayConfig() throws Exception {
        this.loadMobileConfig();
        this.loadBizModule();
    }

    private void loadMobileConfig() throws BOSException {
        IMobileConfig iMobileConfig = MobileConfigFactory.getRemoteInstance();
        MobileConfigCollection mobileConfigs = iMobileConfig.getMobileConfigCollection();
        this.RtxType.setEnabled(false);
        this.gatewayProviderClassTextField.setEditable(false);
        if (mobileConfigs.size() > 0) {
            this.mobileConfigInfo = mobileConfigs.get(0);
            this.hostText.setText(this.mobileConfigInfo.getHost());
            this.portText.setText(this.mobileConfigInfo.getPort());
            this.gatewayProviderClassTextField.setText(this.mobileConfigInfo.getGatewayProviderClass());
            if (this.mobileConfigInfo.isKingdeeGatewayProvider()) {
                this.kingdeeGateway.setSelected(true);
                this.loginNameText.setText(SysContext.getSysContext().getDCNumber());
                this.passwordText.setText(MessageConstant.BIZINTERFACE_P);
                this.gatewayProviderClassTextField.setText(KingdeeMobileGatewayProvider.class.getName());
            } else {
                this.loginNameText.setText(this.mobileConfigInfo.getLoginName());
                this.passwordText.setText(this.mobileConfigInfo.getPassword());
                if (WeinaduoMobileGatewayProvider.class.getName().equals(this.mobileConfigInfo.getGatewayProviderClass())) {
                    this.weinaduoGateway.setSelected(true);
                } else {
                    this.customGateway.setSelected(true);
                    this.gatewayProviderClassTextField.setEditable(true);
                }
            }
            switch (this.mobileConfigInfo.getChannels()) {
                case 1: {
                    this.EmailType.setSelected(true);
                    this.RtxType.setSelected(false);
                    this.smsType.setSelected(false);
                    break;
                }
                case 2: {
                    this.EmailType.setSelected(false);
                    this.RtxType.setSelected(true);
                    this.smsType.setSelected(false);
                    break;
                }
                case 3: {
                    this.EmailType.setSelected(true);
                    this.RtxType.setSelected(true);
                    this.smsType.setSelected(false);
                    break;
                }
                case 4: {
                    this.EmailType.setSelected(false);
                    this.RtxType.setSelected(false);
                    this.smsType.setSelected(true);
                    break;
                }
                case 5: {
                    this.EmailType.setSelected(true);
                    this.RtxType.setSelected(false);
                    this.smsType.setSelected(true);
                    break;
                }
                case 6: {
                    this.EmailType.setSelected(false);
                    this.RtxType.setSelected(true);
                    this.smsType.setSelected(true);
                    break;
                }
                case 7: {
                    this.EmailType.setSelected(true);
                    this.RtxType.setSelected(true);
                    this.smsType.setSelected(true);
                    break;
                }
                default: {
                    this.EmailType.setSelected(false);
                    this.RtxType.setSelected(false);
                    this.smsType.setSelected(false);
                }
            }
        }
    }

    private void loadBizModule() throws Exception {
        this.bizModulesCB = new KDComboBox();
        IBizModule iBizModule = BizModuleFactory.getRemoteInstance();
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        viewInfo.getSelector().add(new SelectorItemInfo("BizFunction.*"));
        this.bizModules = iBizModule.getBizModuleCollection(viewInfo);
        for (int i = 0; i < this.bizModules.size(); ++i) {
            this.bizModulesCB.addItem((Object)this.bizModules.get(i).getSendModule());
        }
        if (this.bizModules.size() > 0) {
            this.bizFunctionCols = new BizFunctionCollection[this.bizModules.size()];
            this.bizFunctionsCB = new KDComboBox[this.bizModules.size()];
        }
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JComboBox)this.bizModulesCB);
        this.kDTable2.checkParsed();
        this.kDTable2.getColumn("module").setEditor((ICellEditor)cellEditor);
        this.kDTable2.removeRows();
        IBizFunction iBizFunction = BizFunctionFactory.getRemoteInstance();
        BizFunctionCollection bizFunctionCol = null;
        BizFunctionInfo bizFunctionInfo = null;
        CommandObjectInfo commandObjectInfo = null;
        IRow row = null;
        FilterInfo filterInfo = null;
        for (int i = 0; i < this.bizModules.size(); ++i) {
            viewInfo = new EntityViewInfo();
            viewInfo.getSelector().add(new SelectorItemInfo("id"));
            viewInfo.getSelector().add(new SelectorItemInfo("function"));
            viewInfo.getSelector().add(new SelectorItemInfo("implClassName"));
            viewInfo.getSelector().add(new SelectorItemInfo("commandObj.*"));
            filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("bizModule", (Object)this.bizModules.get(i).getId().toString(), CompareType.EQUALS));
            viewInfo.setFilter(filterInfo);
            viewInfo.getSorter().add(new SorterItemInfo("id"));
            bizFunctionCol = iBizFunction.getBizFunctionCollection(viewInfo);
            if (bizFunctionCol.size() <= 0) continue;
            this.bizFunctionCols[i] = bizFunctionCol;
            this.bizFunctionsCB[i] = new KDComboBox();
            for (int k = 0; k < bizFunctionCol.size(); ++k) {
                bizFunctionInfo = bizFunctionCol.get(k);
                String function = bizFunctionInfo.getFunction();
                if ("l3".equalsIgnoreCase(SysContext.getSysContext().getLocale().toString())) {
                    function = STConverter.sc2tc((String)function);
                }
                this.bizFunctionsCB[i].addItem((Object)function);
                commandObjectInfo = bizFunctionInfo.getCommandObj();
                if (commandObjectInfo == null || StringUtils.isEmpty((String)commandObjectInfo.getCmdCustomNumber())) continue;
                row = this.kDTable2.addRow();
                row.getCell("module").setValue((Object)this.bizModules.get(i).getSendModule());
                row.getCell("function").setValue((Object)function);
                row.getCell("command").setValue((Object)commandObjectInfo.getCmdCustomNumber());
            }
        }
        this.setBizFunctionCBForKDTable(this.kDTable2);
    }

    private void setBizFunctionCBForKDTable(KDTable table) {
        table.checkParsed();
        for (int i = 0; i < table.getRowCount(); ++i) {
            IRow row = table.getRow(i);
            this.setBizFunctionCBForRow(row);
        }
    }

    private void setBizFunctionCBForRow(IRow row) {
        if (this.bizFunctionCols == null || this.bizFunctionCols.length == 0) {
            return;
        }
        KDTDefaultCellEditor cellEditor = null;
        for (int i = 0; i < this.bizModules.size(); ++i) {
            if (!this.bizModules.get(i).getSendModule().equals(row.getCell("module").getValue().toString())) continue;
            cellEditor = new KDTDefaultCellEditor((JComboBox)this.bizFunctionsCB[i]);
            row.getCell("function").setEditor((ICellEditor)cellEditor);
            break;
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setButtonDefaultStyl(this.saveAction);
        this.setButtonDefaultStyl(this.resetAction);
        this.setButtonDefaultStyl(this.connectAction);
        this.setButtonDefaultStyl(this.startAction);
        this.setButtonDefaultStyl(this.stopAction);
        this.setButtonDefaultStyl(this.disConnectAction);
        this.setButtonDefaultStyl(this.displayBalanceAction);
        this.getInputMap(2).put(KeyStroke.getKeyStroke("F9"), "actionRes");
        this.getActionMap().put("actionRes", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MobileServerCacheMgrFacadeFactory.getRemoteInstance().retsetServerCache();
                    MsgBox.showInfo((String)"\u6e05\u9664\u77ed\u4fe1\u5e73\u53f0\u7f13\u5b58\u6210\u529f\uff0c\u8fde\u63a5\u5df2\u505c\u6b62");
                }
                catch (EASBizException e1) {
                    logger.error((Object)("retsetServerCache() error" + (Object)((Object)e1)));
                }
                catch (BOSException e1) {
                    logger.error((Object)("retsetServerCache() error" + (Object)((Object)e1)));
                }
            }
        });
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void activeCellChanged(KDTActiveCellEvent e) {
    }

    @Override
    protected void kDTable2_editStopped(KDTEditEvent e) throws Exception {
        KDTable table = (KDTable)e.getSource();
        IColumn col = table.getColumn(e.getColIndex());
        IRow row = table.getRow(e.getRowIndex());
        logger.debug((Object)("changeByEdit! col.getKey: " + col.getKey()));
        if (col.getKey().trim().toLowerCase().equals("module".toLowerCase()) && row.getCell(col.getKey().trim()).getValue() != null) {
            for (int j = 0; j < this.bizModules.size(); ++j) {
                if (!this.bizModules.get(j).getSendModule().equals(row.getCell(col.getKey().trim()).getValue().toString())) continue;
                row.getCell("function").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)this.bizFunctionsCB[j]));
                break;
            }
        }
    }

    protected void saveAction_actionPerformed(ActionEvent e) throws Exception {
        this.saveConfig();
    }

    private void saveConfig() throws Exception {
        char[] code;
        ControlUtilities.checkFocusAndCommit();
        boolean ok = false;
        try {
            int result = this.validateGatewayProviderClass();
            if (result == 1) {
                ok = true;
            } else if (result == 0) {
                this.alert("ClassIsNull");
            } else if (result == -1) {
                this.alert("ClassIsNotSuitable");
            }
        }
        catch (ClassNotFoundException e) {
            this.alert("ClassNotFound");
        }
        if (!ok) {
            return;
        }
        ok = false;
        try {
            ok = this.validateHost();
        }
        catch (UnknownHostException ex) {
            this.alert("unValidateAddress");
        }
        if (!ok) {
            return;
        }
        ok = this.validatePort();
        if (!ok) {
            return;
        }
        if (!this.validateBizFunction(this.kDTable2)) {
            return;
        }
        HashMap bizCommandHM = this.getBizCommandHM(this.kDTable2);
        if (this.mobileConfigInfo == null) {
            this.mobileConfigInfo = new MobileConfigInfo();
        }
        this.mobileConfigInfo.setHost(this.hostText.getText());
        this.mobileConfigInfo.setPort(this.portText.getText());
        this.mobileConfigInfo.setChannels((this.EmailType.isSelected() ? 1 : 0) + (this.RtxType.isSelected() ? 2 : 0) + (this.smsType.isSelected() ? 4 : 0));
        this.mobileConfigInfo.setGatewayProviderClass(this.gatewayProviderClassTextField.getText());
        if (!this.kingdeeGateway.isSelected()) {
            this.mobileConfigInfo.setLoginName(this.loginNameText.getText());
        }
        if ((code = this.passwordText.getPassword()) != null) {
            this.mobileConfigInfo.setPassword(String.valueOf(code));
        }
        if (!this.isStopServerEngineForSave()) {
            return;
        }
        IMsgFacade iMsgFacade = MsgFacadeFactory.getRemoteInstance();
        if (iMsgFacade.saveBizConfig(this.mobileConfigInfo, bizCommandHM)) {
            this.refreshCommandObjByTable(this.kDTable2);
            this.stopServerEngine();
            this.showToolBarByState();
            this.showMsg("SaveOK");
        } else {
            this.alert("SaveFailure");
        }
    }

    private boolean validateHost() throws UnknownHostException {
        if (this.hostText.getText() == null || this.hostText.getText().trim().length() == 0) {
            this.alert("hostNull");
            this.hostText.requestFocus();
            return false;
        }
        InetAddress.getByName(this.hostText.getText());
        return true;
    }

    private int validateGatewayProviderClass() throws ClassNotFoundException {
        if (this.gatewayProviderClassTextField.getText() == null || this.gatewayProviderClassTextField.getText().trim().length() == 0) {
            if (this.gatewayProviderClassTextField.isEditable()) {
                this.gatewayProviderClassTextField.requestFocus();
            }
            return 0;
        }
        Class<?> clazz = Class.forName(this.gatewayProviderClassTextField.getText());
        if (!IMobileGatewayProvider.class.isAssignableFrom(clazz) && !AbastractMobileGatewayProvider.class.isAssignableFrom(clazz)) {
            return -1;
        }
        return 1;
    }

    private boolean validatePort() {
        String portStr = this.portText.getText();
        if (portStr == null || "".equals(portStr)) {
            return true;
        }
        boolean success = true;
        try {
            int port = Integer.parseInt(portStr);
            if (port <= 0 || port > 65535) {
                this.alert("portRange");
                this.portText.requestFocus();
                success = false;
            }
        }
        catch (NumberFormatException ex) {
            this.alert("portError");
            this.portText.requestFocus();
            success = false;
        }
        return success;
    }

    private boolean validateBizFunction(KDTable table) {
        IRow currentRow = null;
        String command = null;
        String function = null;
        String module = null;
        IRow row = null;
        for (int i = 0; i < table.getRowCount(); ++i) {
            currentRow = table.getRow(i);
            if (currentRow.getCell("module").getValue() == null || currentRow.getCell("module").getValue().toString().trim().length() == 0) {
                logger.debug((Object)"Module Is NULL");
                this.alert("ModuleNotSelect");
                table.getSelectManager().select(i, 0);
                return false;
            }
            if (currentRow.getCell("function").getValue() == null || currentRow.getCell("function").getValue().toString().trim().length() == 0) {
                logger.debug((Object)"Function is Null");
                this.alert("FunctionNotSelect");
                table.getSelectManager().select(i, 1);
                return false;
            }
            if (currentRow.getCell("command").getValue() == null || currentRow.getCell("command").getValue().toString().trim().length() == 0) {
                logger.debug((Object)"COMMAND IS DEFINED");
                this.alert("CommandNotSetup");
                table.getSelectManager().select(i, 2);
                return false;
            }
            command = currentRow.getCell("command").getValue().toString().trim();
            char numKey = command.charAt(0);
            switch (numKey) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    logger.debug((Object)"First char of command can't be a number!");
                    this.alert("FirstCharIsNumber");
                    table.getSelectManager().select(i, 2);
                    return false;
                }
            }
            module = currentRow.getCell("module").getValue().toString().trim();
            function = currentRow.getCell("function").getValue().toString().trim();
            for (int j = i + 1; j < table.getRowCount(); ++j) {
                row = table.getRow(j);
                if (row.getCell("command").getValue() != null && command.equals(row.getCell("command").getValue().toString().trim())) {
                    logger.debug((Object)"COMMAND IS DEFINED");
                    this.alert("MutiCommand");
                    table.getSelectManager().select(j, 2);
                    return false;
                }
                if (row.getCell("module").getValue() == null || row.getCell("function").getValue() == null || !module.equals(row.getCell("module").getValue().toString().trim()) || !function.equals(row.getCell("function").getValue().toString().trim())) continue;
                logger.debug((Object)"MODULE FINCTION IS DEFINED");
                this.alert("MutiModuleAndFunction");
                table.getSelectManager().select(j, 0, j, 1);
                return false;
            }
        }
        return true;
    }

    private HashMap getBizCommandHM(KDTable table) {
        HashMap<String, String> bizCommandHM = new HashMap<String, String>();
        String command = null;
        String function = null;
        String module = null;
        IRow currentRow = null;
        block0: for (int i = 0; i < table.getRowCount(); ++i) {
            currentRow = table.getRow(i);
            command = currentRow.getCell("command").getValue().toString().trim();
            module = currentRow.getCell("module").getValue().toString().trim();
            function = currentRow.getCell("function").getValue().toString().trim();
            if ("l3".equalsIgnoreCase(SysContext.getSysContext().getLocale().toString())) {
                function = STConverter.tc2sc((String)function);
            }
            for (int j = 0; j < this.bizModules.size(); ++j) {
                if (!this.bizModules.get(j).getSendModule().equals(module)) continue;
                for (int k = 0; k < this.bizFunctionCols[j].size(); ++k) {
                    if (!this.bizFunctionCols[j].get(k).getFunction().equals(function)) continue;
                    bizCommandHM.put(this.bizFunctionCols[j].get(k).getId().toString(), command);
                    continue block0;
                }
                continue block0;
            }
        }
        return bizCommandHM;
    }

    private boolean isStopServerEngineForSave() {
        if (this.serverEngineNew == null) {
            return true;
        }
        switch (this.serverEngineNew.getEngineState().getValue()) {
            case 1: 
            case 2: {
                if (MsgBox.showConfirm2((String)EASResource.getString((String)RES2, (String)"DisconnectingNeforeSave")) != 2) break;
                return false;
            }
        }
        return true;
    }

    private void refreshCommandObjByTable(KDTable table) {
        BizFunctionCollection bizFunctionCol = null;
        BizFunctionInfo bizFunctionInfo = null;
        IRow row = null;
        String module = null;
        String function = null;
        String command = null;
        block0: for (int i = 0; i < table.getRowCount(); ++i) {
            row = table.getRow(i);
            module = row.getCell("module").getValue().toString();
            function = row.getCell("function").getValue().toString();
            if ("l3".equalsIgnoreCase(SysContext.getSysContext().getLocale().toString())) {
                function = STConverter.tc2sc((String)function);
            }
            command = row.getCell("command").getValue().toString();
            for (int j = 0; j < this.bizModules.size(); ++j) {
                if (!this.bizModules.get(j).getSendModule().equals(module)) continue;
                int k = 0;
                bizFunctionCol = this.bizFunctionCols[j];
                if (k >= bizFunctionCol.size() || !(bizFunctionInfo = bizFunctionCol.get(k)).getFunction().equals(function)) continue block0;
                bizFunctionInfo.getCommandObj().setCmdCustomNumber(command);
                continue block0;
            }
        }
    }

    private void stopServerEngine() {
        if (this.serverEngineNew == null) {
            return;
        }
        switch (this.serverEngineNew.getEngineState().getValue()) {
            case 1: 
            case 2: {
                this.serverEngineNew.stop();
                break;
            }
        }
    }

    protected void resetAction_actionPerformed(ActionEvent e) throws Exception {
        this.reset();
    }

    private void reset() throws Exception {
        this.displayConfig();
    }

    protected void startAction_actionPerformed(ActionEvent e) throws Exception {
        if (this.start()) {
            this.showMsg("StartOK");
        }
        this.showToolBarByState();
    }

    private boolean start() {
        boolean succeed = false;
        if (this.serverEngineNew == null) {
            logger.info((Object)"------mobile----BizConfigUI---serverEngineNew is null----");
            this.serverEngineNew = ServerEngineNewFactory.getRemoteInstance();
            logger.info((Object)"------mobile----BizConfigUI---serverEngineNew end----");
        }
        try {
            this.setCursorOfWair();
            logger.info((Object)"------mobile----BizConfigUI---will start connection----");
            succeed = this.serverEngineNew.start(this.mobileConfigInfo, this.bizModules, this.bizFunctionCols);
            logger.info((Object)"------mobile----BizConfigUI---start connection finish----");
        }
        catch (Exception ee) {
            this.handMobielException(ee);
        }
        finally {
            logger.info((Object)"------mobile----setCursorOfDefault st----");
            this.setCursorOfDefault();
            logger.info((Object)"------mobile----setCursorOfDefault end----");
        }
        return succeed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionTestConnection_actionPerformed(ActionEvent e) throws Exception {
        boolean succeed = false;
        try {
            this.setCursorOfWair();
            succeed = this.testConnection();
            if (succeed) {
                this.showMsg("TestConnectionOK");
            } else {
                this.alert("TestConnectionFail");
            }
        }
        catch (Exception ee) {
            this.handMobielException(ee);
        }
        finally {
            this.setCursorOfDefault();
        }
    }

    private void handMobielException(Exception ee) {
        Throwable firstCause = ee.getCause();
        if (firstCause != null) {
            Throwable secondCause = firstCause.getCause();
            if (secondCause == null) {
                secondCause = firstCause;
            }
            if (secondCause != null && MobileException.GATEWAY_USERNAME_PASSWORD_ERROR.getName().equals(secondCause.getMessage())) {
                MsgBox.showWarning((String)EASResource.getString((String)RES2, (String)"UsernameOrPasswordError"));
            } else if (secondCause != null && MobileException.GATAWAY_NO_BALANCE.getName().equals(secondCause.getMessage())) {
                MsgBox.showWarning((String)EASResource.getString((String)RES2, (String)"NoBalance"));
            } else if (secondCause != null && MobileException.USER_NOT_EXIST.getName().equals(secondCause.getMessage())) {
                MsgBox.showWarning((String)EASResource.getString((String)RES2, (String)"UserNotExist"));
            } else {
                logger.error((Object)"HandMobielException, other exception:", (Throwable)ee);
                if (secondCause instanceof ConnectException || secondCause instanceof UnknownHostException) {
                    MsgBox.showError((String)(EASResource.getString((String)RES2, (String)"ConnectException") + secondCause.getMessage()));
                } else {
                    MsgBox.showError((String)(EASResource.getString((String)RES2, (String)"ConnectException") + secondCause.getMessage()));
                }
            }
        } else {
            logger.error((Object)"HandMobielException, other exception:", (Throwable)ee);
            MsgBox.showError((String)(EASResource.getString((String)RES2, (String)"ConnectException") + ee.getMessage()));
        }
    }

    private boolean testConnection() {
        boolean succeed = false;
        if (this.serverEngineNew == null) {
            this.serverEngineNew = ServerEngineNewFactory.getRemoteInstance();
        }
        try {
            this.setCursorOfWair();
            logger.info((Object)"------mobile----BizConfigUI---testConnect start----");
            succeed = this.serverEngineNew.testConnect(this.mobileConfigInfo, this.bizModules, this.bizFunctionCols);
            logger.info((Object)"------mobile----BizConfigUI---testConnect finish----");
        }
        finally {
            this.setCursorOfDefault();
        }
        return succeed;
    }

    @Override
    protected void displayBalanceAction_actionPerformed(ActionEvent e) throws Exception {
    }

    protected void stopAction_actionPerformed(ActionEvent e) throws Exception {
        if (this.stop()) {
            this.showMsg("StopOK");
        }
        this.showToolBarByState();
    }

    private boolean stop() {
        boolean succeed = false;
        try {
            this.setCursorOfWair();
            if (this.serverEngineNew == null) {
                this.serverEngineNew = ServerEngineNewFactory.getRemoteInstance();
            }
            succeed = this.serverEngineNew.stop();
        }
        finally {
            this.setCursorOfDefault();
        }
        return succeed;
    }

    protected void exitAction_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    protected void deleteAction_actionPerformed(ActionEvent e) throws Exception {
        int activeRow = this.kDTable2.getSelectManager().getActiveRowIndex();
        if (activeRow > 0 && activeRow < this.kDTable2.getRowCount()) {
            this.kDTable2.removeRow(activeRow);
        } else {
            this.kDTable2.removeRow(this.kDTable2.getRowCount() - 1);
        }
    }

    protected void addAction_actionPerformed(ActionEvent e) throws Exception {
        this.kDTable2.addRow();
    }

    private void showToolBarByState() {
        if (this.mobileConfigInfo == null) {
            this.startAction.setEnabled(true);
            this.testConnectionAction.setEnabled(true);
            this.stopAction.setEnabled(false);
            return;
        }
        if (this.serverEngineNew == null) {
            this.startAction.setEnabled(true);
            this.testConnectionAction.setEnabled(true);
            this.stopAction.setEnabled(false);
            return;
        }
        switch (this.serverEngineNew.getEngineState().getValue()) {
            case -1: {
                this.startAction.setEnabled(true);
                this.testConnectionAction.setEnabled(true);
                this.stopAction.setEnabled(false);
                break;
            }
            case 0: {
                this.startAction.setEnabled(true);
                this.testConnectionAction.setEnabled(true);
                this.stopAction.setEnabled(false);
                break;
            }
            case 1: {
                this.startAction.setEnabled(false);
                this.testConnectionAction.setEnabled(false);
                this.stopAction.setEnabled(true);
                break;
            }
            case 2: {
                this.startAction.setEnabled(false);
                this.testConnectionAction.setEnabled(false);
                this.stopAction.setEnabled(true);
                break;
            }
            case 3: {
                this.startAction.setEnabled(true);
                this.testConnectionAction.setEnabled(true);
                this.stopAction.setEnabled(false);
            }
        }
    }

    void generated() {
        this.saveAction.setEnabled(true);
        this.resetAction.setEnabled(true);
        this.hostText.setEditable(true);
        this.portText.setEditable(true);
    }

    public void handUIException(Throwable t) {
        Throwable e = t;
        this.setCursorOfDefault();
        if (e instanceof AlreadyBindProcessInstanceException) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_BindWfInstance"));
            return;
        }
        if (e instanceof MatchAssignmentException) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_WFMatch"));
            return;
        }
        ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
    }

    public void setCursorOfDefault() {
        this.window = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (this.window == null) {
            this.window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            if (this.window == null) {
                return;
            }
        }
        this.window.setCursor(Cursor.getDefaultCursor());
        this._setCursor((Component)((Object)this), Cursor.getDefaultCursor());
        this.window = null;
    }

    private void _setCursor(Component cp, Cursor cursor) {
        cp.setCursor(cursor);
        if (cp instanceof Container) {
            Container cc = (Container)cp;
            int n = cc.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component curComponent = cc.getComponent(i);
                if (!curComponent.isFocusable()) continue;
                this._setCursor(curComponent, cursor);
            }
        }
    }

    private void alert(String key) {
        String resClassName = RES2;
        String s = EASResource.getString((String)resClassName, (String)key);
        MsgBox.showError((String)s);
    }

    private void showMsg(String key) {
        String resClassName = RES2;
        String s = EASResource.getString((String)resClassName, (String)key);
        MsgBox.showInfo((String)s);
    }

    public String getResource(String resClassName, String itemKey) {
        Locale locale = this.getLocale();
        return ResourceBase.getString((String)resClassName, (String)itemKey, (Locale)locale);
    }

    public void doLayout() {
        super.doLayout();
    }

    protected void connectAction_actionPerformed(ActionEvent e) {
    }

    protected void disConnectAction_actionPerformed(ActionEvent e) throws Exception {
        if (this.engine.getEngineState().getValue() == 2) {
            this.engine.disConnect();
        }
        this.viewToolBarByState();
    }

    private void viewToolBarByState() {
        switch (this.engine.getEngineState().getValue()) {
            case -1: 
            case 0: {
                this.startAction.setEnabled(true);
                this.connectAction.setEnabled(true);
                this.disConnectAction.setEnabled(false);
                this.stopAction.setEnabled(false);
                break;
            }
            case 1: {
                this.startAction.setEnabled(false);
                this.stopAction.setEnabled(true);
                this.connectAction.setEnabled(false);
                this.disConnectAction.setEnabled(true);
                break;
            }
            case 2: {
                this.connectAction.setEnabled(false);
                this.disConnectAction.setEnabled(true);
                this.startAction.setEnabled(false);
                this.stopAction.setEnabled(true);
                break;
            }
            case 3: {
                this.connectAction.setEnabled(true);
                this.disConnectAction.setEnabled(false);
                this.startAction.setEnabled(false);
                this.stopAction.setEnabled(true);
            }
        }
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        try {
            this.kDTable2.addRow();
        }
        catch (Exception ex) {
            logger.error((Object)"error: ", (Throwable)ex);
        }
    }

    @Override
    public void actionDeleteLine_actionPerformed(ActionEvent e) throws Exception {
        try {
            int activeRow = this.kDTable2.getSelectManager().getActiveRowIndex();
            if (activeRow > 0 && activeRow < this.kDTable2.getRowCount()) {
                this.kDTable2.removeRow(activeRow);
            } else {
                this.kDTable2.removeRow(this.kDTable2.getRowCount() - 1);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"error: ", (Throwable)ex);
        }
    }

    @Override
    public void kingdeeGateway_stateChanged(ChangeEvent e) throws Exception {
        boolean selected = this.kingdeeGateway.isSelected();
        if (selected && this.mobileConfigInfo != null && !KingdeeMobileGatewayProvider.class.getName().equals(this.mobileConfigInfo.getGatewayProviderClass())) {
            this.hostText.setText("");
            this.portText.setText("");
        }
        if (selected) {
            this.gatewayProviderClassTextField.setText(KingdeeMobileGatewayProvider.class.getName());
            this.gatewayProviderClassTextField.setEditable(false);
            if (this.hostText.getText() == null || this.hostText.getText().trim().length() == 0) {
                this.hostText.setText("127.0.0.1");
            }
            if (this.portText.getText() == null || this.portText.getText().trim().length() == 0) {
                this.portText.setText("5100");
            }
            if (this.mobileConfigInfo != null && this.mobileConfigInfo.isKingdeeGatewayProvider()) {
                this.hostText.setText(this.mobileConfigInfo.getHost());
                this.portText.setText(this.mobileConfigInfo.getPort());
                this.loginNameText.setText(SysContext.getSysContext().getDCNumber());
                this.passwordText.setText(MessageConstant.BIZINTERFACE_P);
                return;
            }
            this.hostText.setText("127.0.0.1");
            this.portText.setText("5100");
            this.loginNameText.setText(SysContext.getSysContext().getDCNumber());
            this.passwordText.setText(MessageConstant.BIZINTERFACE_P);
        }
        this.loginNameText.setEditable(!selected);
        this.passwordText.setEditable(!selected);
    }

    @Override
    protected void weinaduoGateway_stateChanged(ChangeEvent e) throws Exception {
        if (this.weinaduoGateway.isSelected()) {
            this.gatewayProviderClassTextField.setText(WeinaduoMobileGatewayProvider.class.getName());
            this.gatewayProviderClassTextField.setEditable(false);
            if (this.mobileConfigInfo != null && !this.mobileConfigInfo.isKingdeeGatewayProvider()) {
                this.hostText.setText(this.mobileConfigInfo.getHost());
                this.portText.setText(this.mobileConfigInfo.getPort());
                this.loginNameText.setText(this.mobileConfigInfo.getLoginName());
                this.passwordText.setText(this.mobileConfigInfo.getPassword());
                return;
            }
            this.hostText.setText("kingdee.weinaduo.net");
            this.portText.setText("");
            this.loginNameText.setText("");
            this.passwordText.setText("");
        }
    }

    @Override
    protected void newKingdeeGateway_stateChanged(ChangeEvent e) throws Exception {
        if (this.newKingdeeGateway.isSelected()) {
            this.gatewayProviderClassTextField.setText(NewKingdeeMobileGatewayProvider.class.getName());
            this.gatewayProviderClassTextField.setEditable(false);
            if (this.hostText.getText() == null || this.hostText.getText().trim().length() == 0) {
                this.hostText.setText("api.youshang.com");
            }
        }
    }

    @Override
    protected void customGateway_stateChanged(ChangeEvent e) throws Exception {
        if (this.customGateway.isSelected()) {
            if (KingdeeMobileGatewayProvider.class.getName().equals(this.gatewayProviderClassTextField.getText()) || WeinaduoMobileGatewayProvider.class.getName().equals(this.gatewayProviderClassTextField.getText()) || NewKingdeeMobileGatewayProvider.class.getName().equals(this.gatewayProviderClassTextField.getText())) {
                this.gatewayProviderClassTextField.setText("");
                this.hostText.setText("");
                this.portText.setText("");
            }
            this.gatewayProviderClassTextField.setEditable(true);
            this.gatewayProviderClassTextField.setEnabled(true);
        }
    }

    private class FunctionItem {
        int bizKey = -1;
        String description;

        FunctionItem(int bizKey, String description) {
            this.bizKey = bizKey;
            this.description = description;
        }

        public FunctionItem(BizFunction func) {
            this.bizKey = func.getBizKey();
            this.description = func.getDescription(SysContext.getSysContext().getLocale());
        }

        public String toString() {
            return this.description;
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof FunctionItem) {
                FunctionItem item = (FunctionItem)obj;
                if (item.bizKey == this.bizKey) {
                    return true;
                }
            }
            return false;
        }
    }

    private class ModuleItem {
        String className;
        String moduleName;

        public ModuleItem(String className, String moduleName) {
            this.className = className;
            this.moduleName = moduleName;
        }

        public String getClassName() {
            return this.className;
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof ModuleItem) {
                ModuleItem item = (ModuleItem)obj;
                if (this.className != null && this.className.equals(item.getClassName())) {
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return this.moduleName;
        }
    }

    class EditAdapter
    extends KDTEditAdapter {
        EditAdapter() {
        }

        public void editStopping(KDTEditEvent e) {
            ModuleItem item;
            String className;
            KDTable table;
            Object value;
            int currentRow = e.getRowIndex();
            int currentCol = e.getColIndex();
            if (currentCol == 0 && (value = (table = (KDTable)e.getSource()).getEditManager().getEditor().getValue()) instanceof ModuleItem && (className = (item = (ModuleItem)value).getClassName()) != null) {
                BizConfigUI.this.setFunctions(currentRow, 1, className);
            }
        }
    }
}

