/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.base.permission.client.longtime.LongTimeDialog;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.f7.CompanyBizUnitF7;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.mobile.ChargeCompanyFactory;
import com.kingdee.eas.mobile.ChargeCompanyInfo;
import com.kingdee.eas.mobile.IChargeCompany;
import com.kingdee.eas.mobile.client.AbstractChargeCompanyListUI;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JFrame;

public class ChargeCompanyListUI
extends AbstractChargeCompanyListUI {
    private FullOrgUnitCollection authorizedCUCol = null;
    private HashMap cuToChargeCompanyMap = null;

    public ChargeCompanyListUI() throws Exception {
        this.initWorkButtons();
        this.initTblMain();
    }

    private void initWorkButtons() {
        this.btnSave.setEnabled(true);
        this.btnExit.setEnabled(true);
    }

    private void initTblMain() {
        this.tblMain.checkParsed();
        this.tblMain.getColumn(0).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(1).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(2).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(3).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(5).getStyleAttributes().setLocked(true);
        this.tblMain.getSelectManager().setSelectMode(2);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initAuthorizedCUs();
        this.initTableByAuthorizedCUs();
    }

    private void initAuthorizedCUs() throws Exception {
        ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        ObjectUuidPK orgTreePK = new ObjectUuidPK("00000000-0000-0000-0000-0000000000014F2827FD");
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        this.authorizedCUCol = iPermission.getAuthorizedOrg((IObjectPK)userPK, OrgType.ControlUnit, (IObjectPK)orgTreePK, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.mobile.client.ChargeCompanyListUI"), null);
        ArrayList<String> cuList = new ArrayList<String>();
        for (int i = 0; i < this.authorizedCUCol.size(); ++i) {
            cuList.add(this.authorizedCUCol.get(i).getId().toString());
        }
        IChargeCompany iCharge = ChargeCompanyFactory.getRemoteInstance();
        this.cuToChargeCompanyMap = iCharge.getChargeCompanyColByCUs(cuList);
    }

    private void initTableByAuthorizedCUs() {
        if (this.authorizedCUCol != null) {
            this.tblMain.checkParsed();
            this.tblMain.removeRows();
            for (int i = 0; i < this.authorizedCUCol.size(); ++i) {
                FullOrgUnitInfo cuInfo = this.authorizedCUCol.get(i);
                String cuId = cuInfo.getId().toString();
                final IRow row = this.tblMain.addRow();
                row.getCell("cu.id").setValue((Object)cuId);
                row.getCell("cu.number").setValue((Object)cuInfo.getNumber());
                row.getCell("cu.name").setValue((Object)cuInfo.getName());
                final KDBizPromptBox bizCompanyPrompt = new KDBizPromptBox();
                CompanyBizUnitF7 bizCompanyF7 = new CompanyBizUnitF7((IUIObject)this);
                bizCompanyF7.disablePerm();
                bizCompanyPrompt.setSelector((KDPromptSelector)bizCompanyF7);
                bizCompanyPrompt.setDisplayFormat("$number$");
                bizCompanyPrompt.setEditFormat("$number$");
                bizCompanyPrompt.setCommitFormat("$number$");
                KDTDefaultCellEditor f7PurchaseEditor = new KDTDefaultCellEditor((IKDEditor)bizCompanyPrompt);
                row.getCell("company.number").setEditor((ICellEditor)f7PurchaseEditor);
                bizCompanyPrompt.addDataChangeListener(new DataChangeListener(){

                    public void dataChanged(DataChangeEvent eventObj) {
                        Object obj = bizCompanyPrompt.getData();
                        CompanyOrgUnitInfo companyInfo = null;
                        if (obj instanceof CompanyOrgUnitInfo) {
                            companyInfo = (CompanyOrgUnitInfo)obj;
                        }
                        if (companyInfo != null) {
                            row.getCell("company.id").setValue((Object)companyInfo.getId().toString());
                            row.getCell("company.number").setValue((Object)companyInfo.getNumber());
                            row.getCell("company.name").setValue((Object)companyInfo.getName());
                        } else if (obj == null) {
                            row.getCell("company.id").setValue(null);
                            row.getCell("company.number").setValue(null);
                            row.getCell("company.name").setValue(null);
                        }
                    }
                });
                if (!this.cuToChargeCompanyMap.containsKey(cuId)) continue;
                CompanyOrgUnitInfo companyInfo = ((ChargeCompanyInfo)this.cuToChargeCompanyMap.get(cuId)).getCompany();
                row.getCell("company.id").setValue((Object)companyInfo.getId().toString());
                row.getCell("company.number").setValue((Object)companyInfo.getNumber());
                row.getCell("company.name").setValue((Object)companyInfo.getName());
            }
        }
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        final HashMap<String, String> result = new HashMap<String, String>();
        int n = this.tblMain.getRowCount();
        for (int i = 0; i < n; ++i) {
            String cuId = (String)this.tblMain.getCell(i, 0).getValue();
            String companyId = (String)this.tblMain.getCell(i, 3).getValue();
            result.put(cuId, companyId);
        }
        Window win = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        LongTimeDialog ltd = null;
        ltd = win instanceof Frame ? new LongTimeDialog((Frame)win) : (win instanceof Dialog ? new LongTimeDialog((Dialog)win) : new LongTimeDialog((Frame)new JFrame()));
        ltd.setTitle("\u6b63\u5728\u4fdd\u5b58");
        ltd.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                try {
                    IChargeCompany iCharge = ChargeCompanyFactory.getRemoteInstance();
                    iCharge.saveChargeMapping(result);
                    MsgBox.showInfo((Component)((Object)ChargeCompanyListUI.this), (String)"\u4fdd\u5b58\u6210\u529f");
                }
                catch (Exception e) {
                    ChargeCompanyListUI.this.handleException(e);
                }
                return new Boolean(true);
            }

            public void afterExec(Object result2) throws Exception {
            }
        });
        ltd.show();
    }

    @Override
    public void actionExit_actionPerformed(ActionEvent e) throws Exception {
        super.destroyWindow();
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
    }
}

