/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.basedata.org.BizOrgAssistInfoBuilder;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.INewOrgViewFacade;
import com.kingdee.eas.basedata.org.NewOrgViewFacadeFactory;
import com.kingdee.eas.basedata.org.OrgF7InnerUtils;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.mobile.IMobileMessageAssign;
import com.kingdee.eas.mobile.MobileMessageAssignFactory;
import com.kingdee.eas.mobile.client.AbstractMobileMessageAssignListUI;
import com.kingdee.eas.mobile.client.ChargeCompanyListUI;
import com.kingdee.eas.mobile.client.MobileMessageAssignEditUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class MobileMessageAssignListUI
extends AbstractMobileMessageAssignListUI {
    private static final Logger logger = CoreUIObject.getLogger(MobileMessageAssignListUI.class);
    private static final String RESOURCE = "com.kingdee.eas.mobile.client.SmsResource";
    private static final String PERMISSION_ITEM = "bs_mobile_assignSet";

    public MobileMessageAssignListUI() throws Exception {
        this.btnAssignSet.setIcon(EASResource.getIcon((String)"imgTbtn_setting"));
        this.menuItemAssignSet.setIcon(EASResource.getIcon((String)"imgTbtn_setting"));
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                TreePath path = MobileMessageAssignListUI.this.treeMain.getSelectionPath();
                if (path != null) {
                    DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
                    OrgStructureInfo info = (OrgStructureInfo)node.getUserObject();
                    String orgId = info.getUnit().getId().toString();
                    int begin = e.getFirstRow();
                    int end = e.getLastRow();
                    for (int i = begin; i <= end; ++i) {
                        int canSendCount = 0;
                        String str = MobileMessageAssignListUI.this.tblMain.getRow(i).getCell("canSendCount").getValue().toString();
                        if (str != null && str.trim().length() != 0) {
                            canSendCount = Integer.parseInt(str);
                        }
                        if (canSendCount != 0) {
                            int sendedValue = MobileMessageAssignListUI.this.getSendedCountByUserId(MobileMessageAssignListUI.this.tblMain.getRow(i).getCell("userId").getValue().toString(), orgId);
                            MobileMessageAssignListUI.this.tblMain.getRow(i).getCell("alreadySendCount").setValue((Object)String.valueOf(sendedValue));
                            continue;
                        }
                        MobileMessageAssignListUI.this.tblMain.getRow(i).getCell("alreadySendCount").setValue((Object)"0");
                    }
                }
            }
        });
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        if (clientHanlder != null) {
            RequestContext request = new RequestContext();
            UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
            ObjectUuidPK userPK = new ObjectUuidPK(userInfo.getId().toString());
            request.put("userPK", (Object)userPK);
            ObjectUuidPK cuPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
            request.put("cuPK", (Object)cuPK);
            request.setMethodName("handleInit");
            clientHanlder.setRequestContext((Serializable)request);
        }
        return clientHanlder;
    }

    public boolean isPrepareActionQuery() {
        return true;
    }

    private int getSendedCountByUserId(String userId, String orgId) {
        try {
            IMobileMessageAssign iMessageAssign = MobileMessageAssignFactory.getRemoteInstance();
            return iMessageAssign.getSendedCountByUserId(userId, orgId);
        }
        catch (BOSException e) {
            this.handUIException(e);
            return 0;
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (!this.isLimitSendCount()) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"functioninvalid"));
            this.abort();
        }
        this.initTree();
        this.btnSetupChargeOrg.setIcon(EASResource.getIcon((String)"imgTbtn_organiselist"));
        this.menuItemSetupChargeOrg.setIcon(EASResource.getIcon((String)"imgTbtn_organiselist"));
    }

    private boolean isLimitSendCount() {
        try {
            ObjectUuidPK pk = new ObjectUuidPK(SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
            String paramValue = ParamManager.getParamValue(null, (IObjectPK)pk, (String)"MobileSendLimit");
            return Boolean.valueOf(paramValue);
        }
        catch (Exception e) {
            logger.error((Object)"\u53d6MobileSendLimit\u53c2\u6570\u51fa\u9519", (Throwable)e);
            return false;
        }
    }

    private void initTree() throws Exception {
        BizOrgAssistInfoBuilder builder = new BizOrgAssistInfoBuilder(OrgViewType.CTRLUNIT, null).setNeedAddOrgRange(true);
        UserType type = SysContext.getSysContext().getCurrentUserInfo().getType();
        if (type != UserType.SYSTEM) {
            StringBuffer sql = new StringBuffer();
            ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
            FullOrgUnitCollection fullCol = PermissionFactory.getRemoteInstance().getAuthorizedOrg((IObjectPK)userPK, OrgType.ControlUnit, null, PERMISSION_ITEM);
            builder.setNeedAddOrgRange(false);
            if (fullCol != null && fullCol.size() > 0) {
                StringBuilder displayOrgIds = new StringBuilder("'" + fullCol.get(0).getId().toString() + "'");
                for (int i = 1; i < fullCol.size(); ++i) {
                    displayOrgIds.append(",'").append(fullCol.get(i).getId().toString()).append("'");
                }
                sql.append("\"BASEUNIT\"").append(".FID IN (").append((CharSequence)displayOrgIds).append(")");
                builder.setExtraFilters(sql.toString());
            }
        }
        INewOrgViewFacade facade = NewOrgViewFacadeFactory.getRemoteInstance();
        List orgCol = facade.getViewDirectChildNodesByMultiCondition(null, builder);
        DefaultKingdeeTreeNode root = this.insertNodeIntoRoot(null, orgCol);
        ((OrgStructureInfo)root.getUserObject()).put("alreadyLoad", (Object)true);
        this.treeMain.setModel((TreeModel)new DefaultTreeModel((TreeNode)root){

            @Override
            public boolean isLeaf(Object node) {
                OrgStructureInfo info = (OrgStructureInfo)((DefaultKingdeeTreeNode)node).getUserObject();
                return info == null || info.isIsLeaf();
            }
        });
        this.treeMain.setRootVisible(true);
        this.treeMain.setShowsRootHandles(true);
        this.treeMain.setSelectionNode(root);
        this.treeMain.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                DefaultKingdeeTreeNode tmp = (DefaultKingdeeTreeNode)event.getPath().getLastPathComponent();
                if (tmp == null) {
                    return;
                }
                try {
                    MobileMessageAssignListUI.this.loadNode(tmp);
                }
                catch (Exception e) {
                    logger.error((Object)"error", (Throwable)e);
                    MobileMessageAssignListUI.this.handUIException(e);
                }
            }
        });
    }

    private DefaultKingdeeTreeNode insertNodeIntoRoot(DefaultKingdeeTreeNode root, List orgCol) {
        int firstFlag = 0;
        if (root == null) {
            root = new DefaultKingdeeTreeNode(orgCol.get(0));
            firstFlag = 1;
        }
        for (int i = firstFlag; i < orgCol.size(); ++i) {
            OrgStructureInfo info = (OrgStructureInfo)orgCol.get(i);
            KDTreeNode treeNode = new KDTreeNode((Object)info);
            root.add((MutableTreeNode)treeNode);
        }
        return root;
    }

    private void loadNode(DefaultKingdeeTreeNode tmp) throws Exception {
        OrgStructureInfo unitinfo;
        if (tmp != null && tmp.getUserObject() != null && (unitinfo = (OrgStructureInfo)tmp.getUserObject()).get("alreadyLoad") == null) {
            BizOrgAssistInfoBuilder builder = new BizOrgAssistInfoBuilder(OrgViewType.CTRLUNIT, null).setNeedAddOrgRange(true);
            UserType type = SysContext.getSysContext().getCurrentUserInfo().getType();
            if (type != UserType.SYSTEM) {
                StringBuffer sql = new StringBuffer();
                sql.append("\"BASEUNIT\"").append(".FID IN (").append("to_dosql").append(")");
                builder.setNeedAddOrgRange(false).setExtraFilters(sql.toString());
            }
            INewOrgViewFacade facade = NewOrgViewFacadeFactory.getRemoteInstance();
            List orgCol = facade.getViewDirectChildNodesByMultiCondition(unitinfo, builder);
            this.insertNodeIntoRoot(tmp, orgCol);
            unitinfo.put("alreadyLoad", (Object)true);
        }
    }

    private DefaultKingdeeTreeNode getEnabledTreeNode(DefaultKingdeeTreeNode root) {
        if (!OrgF7InnerUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)root)) {
            return root;
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            DefaultKingdeeTreeNode enabledNode = this.getEnabledTreeNode(node);
            if (enabledNode == null) continue;
            return enabledNode;
        }
        return null;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.refresh();
    }

    private void refresh() throws Exception {
        TreePath path = this.treeMain.getSelectionPath();
        if (path != null) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
            if (OrgF7InnerUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)node)) {
                MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"currentusernoperm"));
                return;
            }
            IMobileMessageAssign mma = MobileMessageAssignFactory.getRemoteInstance();
            OrgStructureInfo info = (OrgStructureInfo)node.getUserObject();
            String cuId = info.getUnit().getId().toString();
            mma.initCUAssignInfo(cuId);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("cuId", (Object)cuId, CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("orgId", (Object)cuId, CompareType.EQUALS));
            filterInfo.setMaskString("#0  and #1");
            view.setFilter(filterInfo);
            this.mainQuery = view;
            this.setTheFirstFillData(true);
            this.tblMain.removeRows();
            int rows = this.tblMain.getRowCount();
            if (rows != 0) {
                this.tblMain.getSelectManager().select(0, 0);
            }
        }
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filterInfo = new FilterInfo();
        TreePath path = this.treeMain.getSelectionPath();
        if (path == null) {
            return filterInfo;
        }
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        OrgStructureInfo info = (OrgStructureInfo)node.getUserObject();
        String cuId = info.getUnit().getId().toString();
        filterInfo.getFilterItems().add(new FilterItemInfo("cuId", (Object)cuId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("orgId", (Object)cuId, CompareType.EQUALS));
        filterInfo.setMaskString("#0 and #1");
        return filterInfo;
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList != null && MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"delSetConfirm")) == 0) {
            String[] idArray = new String[idList.size()];
            for (int i = 0; i < idList.size(); ++i) {
                idArray[i] = (String)idList.get(i);
            }
            int size = this.tblMain.getSelectManager().size();
            StringBuffer userNames = new StringBuffer();
            for (int i = 0; i < size; ++i) {
                KDTSelectBlock sb = this.tblMain.getSelectManager().get(i);
                for (int j = sb.getTop(); j <= sb.getBottom(); ++j) {
                    Object object = this.tblMain.getRow(j).getCell("userName").getValue();
                    if (object == null) continue;
                    if (userNames.length() == 0) {
                        userNames.append(object.toString());
                        continue;
                    }
                    userNames.append(", ");
                    userNames.append(object.toString());
                }
            }
            String cuId = null;
            String cuName = null;
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeMain.getLastSelectedPathComponent();
            if (node != null) {
                OrgStructureInfo structInfo = (OrgStructureInfo)node.getUserObject();
                FullOrgUnitInfo unitInfo = structInfo.getUnit();
                cuId = unitInfo.getId().toString();
                cuName = unitInfo.getName();
            }
            StringBuffer noticeBf = new StringBuffer();
            noticeBf.append(EASResource.getString((String)RESOURCE, (String)"clearuser"));
            noticeBf.append(userNames.toString());
            noticeBf.append(EASResource.getString((String)RESOURCE, (String)"inorg"));
            noticeBf.append(cuName);
            noticeBf.append(EASResource.getString((String)RESOURCE, (String)"msginfo"));
            IMobileMessageAssign iMobileAssign = MobileMessageAssignFactory.getRemoteInstance();
            boolean result = iMobileAssign.deleteAssign(idArray, cuId, noticeBf.toString());
            if (result) {
                this.refresh();
            }
        }
    }

    @Override
    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        this.refresh();
    }

    @Override
    public void assignSet_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int size = this.tblMain.getSelectManager().size();
        HashMap<String, String> setedUserMap = new HashMap<String, String>();
        HashMap<String, String> unsetUserMap = new HashMap<String, String>();
        StringBuffer userNamesBuf = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            KDTSelectBlock sb = this.tblMain.getSelectManager().get(i);
            for (int j = sb.getTop(); j <= sb.getBottom(); ++j) {
                Object userName = this.tblMain.getRow(j).getCell("userName").getValue();
                if (userName != null) {
                    if (userNamesBuf.length() == 0) {
                        userNamesBuf.append(userName.toString());
                    } else {
                        userNamesBuf.append(", ");
                        userNamesBuf.append(userName.toString());
                    }
                }
                String userId = this.tblMain.getRow(j).getCell("userId").getValue().toString();
                Object assignId = this.tblMain.getRow(j).getCell("assignId").getValue();
                if (assignId == null) {
                    unsetUserMap.put(userId, "");
                    continue;
                }
                setedUserMap.put(userId, "");
            }
        }
        if (setedUserMap.size() > 0 || unsetUserMap.size() > 0) {
            int i;
            Object[] tempArray;
            UIContext uiContext = new UIContext((Object)this);
            String cuId = null;
            String cuName = null;
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeMain.getLastSelectedPathComponent();
            if (node != null) {
                OrgStructureInfo structInfo = (OrgStructureInfo)node.getUserObject();
                FullOrgUnitInfo unitInfo = structInfo.getUnit();
                cuId = unitInfo.getId().toString();
                cuName = unitInfo.getName();
            }
            uiContext.put((Object)"cuId", cuId);
            StringBuffer logInfoBuf = new StringBuffer();
            logInfoBuf.append(EASResource.getString((String)RESOURCE, (String)"settinguser"));
            logInfoBuf.append(userNamesBuf.toString());
            logInfoBuf.append(EASResource.getString((String)RESOURCE, (String)"inorg"));
            logInfoBuf.append(cuName);
            logInfoBuf.append(EASResource.getString((String)RESOURCE, (String)"msginfo"));
            uiContext.put((Object)"logInfo", (Object)logInfoBuf.toString());
            if (setedUserMap.size() > 0) {
                String[] setedIdArray = new String[setedUserMap.size()];
                tempArray = setedUserMap.keySet().toArray();
                for (i = 0; i < tempArray.length; ++i) {
                    setedIdArray[i] = (String)tempArray[i];
                }
                uiContext.put((Object)"setedUserIds", (Object)setedIdArray);
            }
            if (unsetUserMap.size() > 0) {
                String[] unsetIdArray = new String[unsetUserMap.size()];
                tempArray = unsetUserMap.keySet().toArray();
                for (i = 0; i < tempArray.length; ++i) {
                    unsetIdArray[i] = (String)tempArray[i];
                }
                uiContext.put((Object)"unsetUserIds", (Object)unsetIdArray);
            }
            IUIWindow uiWindow = null;
            try {
                uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(MobileMessageAssignEditUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
                uiWindow.show();
                MobileMessageAssignEditUI ui = (MobileMessageAssignEditUI)uiWindow.getUIObject();
                if (!ui.isCancel()) {
                    this.refresh();
                }
            }
            catch (UIException e1) {
                this.handleException((Exception)((Object)e1));
            }
        }
    }

    @Override
    public void actionSetupChargeOrg_actionPerformed(ActionEvent e) throws Exception {
        block2: {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"Owner", (Object)this);
            IUIFactory uiFactory = null;
            IUIWindow curDialog = null;
            try {
                uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
                curDialog = uiFactory.create(ChargeCompanyListUI.class.getName(), (Map)uiContext);
                curDialog.show();
            }
            catch (Throwable ex) {
                if (!(ex instanceof Exception)) break block2;
                this.handleException((Exception)ex);
            }
        }
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"userName"};
        return locateNames;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.ControlUnit;
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        return new ObjectUuidPK(SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
    }

    protected String getKeyFieldName() {
        return "userId";
    }
}

