/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDScrollBar;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.commonquery.client.DataObject;
import com.kingdee.eas.base.commonquery.client.EntityTreePromptDialog;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.mobile.DataTypeEnum;
import com.kingdee.eas.mobile.MobileException;
import com.kingdee.eas.mobile.MobileMessageFormatCollection;
import com.kingdee.eas.mobile.MobileMessageFormatFactory;
import com.kingdee.eas.mobile.MobileMessageFormatInfo;
import com.kingdee.eas.mobile.client.AbstractMobileMessageFormatUI;
import com.kingdee.eas.mobile.util.MobileUtil;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JScrollBar;

public class MobileMessageFormatUI
extends AbstractMobileMessageFormatUI {
    public static final String BOS_OBJECT_TYPE = "BOS_OBJECT_TYPE";
    private static final String RESOURCE_NAME = "com.kingdee.eas.mobile.client.SmsResource";
    private EntityObjectInfo entity;
    private BOSObjectType bosType;

    public MobileMessageFormatUI() throws Exception {
        this.btnRemoveLine.setToolTipText(this.btnRemoveLine.getText());
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initEntity();
        this.initTable();
        this.loadMessageFormat();
    }

    private void initEntity() {
        this.bosType = (BOSObjectType)this.getUIContext().get(BOS_OBJECT_TYPE);
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        this.entity = loader.getEntity(this.bosType);
    }

    private void initTable() {
        this.addTableListener();
        this.fieldTable.getLayoutManager().setVerticalScrollBar((JScrollBar)new KDScrollBar(1));
        this.fieldTable.getLayoutManager().setHorizonScrollBar((JScrollBar)new KDScrollBar(0));
    }

    private void addTableListener() {
        this.fieldTable.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                try {
                    MobileMessageFormatUI.this.onMouseClicked(e);
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
        this.fieldTable.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                Object selectedValue = e.getOldValue();
                Object newValue = e.getValue();
                if (selectedValue != null && selectedValue.equals(newValue)) {
                    return;
                }
                if (selectedValue != null && selectedValue instanceof DataObject) {
                    String fieldAlias = ((DataObject)selectedValue).getName();
                    String format = (String)MobileMessageFormatUI.this.mltMessageFormat.getSelectedItemData();
                    if (format.indexOf("{" + fieldAlias + "}") != -1) {
                        MsgBox.showInfo((Component)((Object)MobileMessageFormatUI.this), (String)EASResource.getString((String)MobileMessageFormatUI.RESOURCE_NAME, (String)"CANT_DELETE_HAS_USED"));
                        int rowIndex = MobileMessageFormatUI.this.fieldTable.getSelectManager().getActiveRowIndex();
                        IRow selectedRow = MobileMessageFormatUI.this.fieldTable.getRow(rowIndex);
                        selectedRow.getCell(0).setValue(selectedValue);
                        return;
                    }
                }
            }
        });
    }

    private void onMouseClicked(KDTMouseEvent e) throws Exception {
        int columnIndex = e.getColIndex();
        int rowIndex = e.getRowIndex();
        if (rowIndex >= 0 && e.getType() == 1) {
            switch (columnIndex) {
                case 0: {
                    KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((IKDEditor)this.getEntityTreePromptBox());
                    this.fieldTable.getRow(rowIndex).getCell(0).setEditor((ICellEditor)cellEditor);
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
            }
        }
    }

    private KDPromptBox getEntityTreePromptBox() {
        Window window = ComponentUtil.getOwnerWindow((Component)((Object)this));
        EntityTreePromptDialog entityTreePromptDialog = null;
        entityTreePromptDialog = window instanceof Frame ? new EntityTreePromptDialog((Frame)window, EASResource.getString((String)RESOURCE_NAME, (String)"FIELD_SELECT") + " -- " + this.getEntityAlias(this.entity), true, this.entity, null, false, true) : (window instanceof Dialog ? new EntityTreePromptDialog((Dialog)window, EASResource.getString((String)RESOURCE_NAME, (String)"FIELD_SELECT") + " -- " + this.getEntityAlias(this.entity), true, this.entity, null, false, true) : new EntityTreePromptDialog((Frame)null, EASResource.getString((String)RESOURCE_NAME, (String)"FIELD_SELECT") + " -- " + this.getEntityAlias(this.entity), true, this.entity, null, false, true));
        final KDPromptBox entityTreePromptBox = new KDPromptBox();
        entityTreePromptBox.setEditable(false);
        entityTreePromptBox.setSelector((KDPromptSelector)entityTreePromptDialog);
        entityTreePromptBox.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                Object value = eventObj.getNewValue();
                if (value != null && value instanceof DataObject) {
                    DataObject data = (DataObject)value;
                    int rowIndex = MobileMessageFormatUI.this.fieldTable.getSelectManager().getActiveRowIndex();
                    IRow selectedRow = MobileMessageFormatUI.this.fieldTable.getRow(rowIndex);
                    if (selectedRow != null) {
                        selectedRow.getCell(1).setValue((Object)MobileMessageFormatUI.this.getDataTypeOfField(data));
                    }
                } else {
                    entityTreePromptBox.setDataBySelector();
                    return;
                }
            }
        });
        return entityTreePromptBox;
    }

    private String getEntityAlias(EntityObjectInfo entity) {
        String alias = entity.getAlias();
        if (StringUtils.isEmpty((String)alias)) {
            return entity.getName();
        }
        return alias;
    }

    private void loadMessageFormat() throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("user.id", (Object)SysContext.getSysContext().getCurrentUserInfo().getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("bosType", (Object)this.bosType.toString()));
        viewInfo.setFilter(filterInfo);
        viewInfo.getSorter().add(new SorterItemInfo("index"));
        MobileMessageFormatCollection formatCol = MobileMessageFormatFactory.getRemoteInstance().getMobileMessageFormatCollection(viewInfo);
        this.fieldTable.checkParsed();
        this.fieldTable.removeRows();
        for (int i = 0; i < formatCol.size(); ++i) {
            MobileMessageFormatInfo formatInfo = formatCol.get(i);
            int fIndex = formatInfo.getIndex();
            if (fIndex == 0) {
                this.mltMessageFormat.setSelectedItemData((Object)this.decodeMessageFormat(formatCol, formatInfo.getFormat()));
                continue;
            }
            DataObject data = new DataObject();
            data.setValue(formatInfo.getFieldName());
            data.setName(formatInfo.getFieldAlias());
            data.setExtendValue(formatInfo.getFieldEntityPK());
            IRow row = this.fieldTable.addRow();
            row.getCell(0).setValue((Object)data);
            row.getCell(1).setValue((Object)this.getDataTypeOfField(data));
        }
    }

    private DataTypeEnum getDataTypeOfField(DataObject data) {
        PropertyInfo propertyInfo;
        String fieldEntityPK = data.getExtendValue();
        String fieldName = data.getValue();
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        EntityObjectInfo fieldEntity = loader.getEntity((IMetaDataPK)new MetaDataPK(fieldEntityPK));
        int index = fieldName.lastIndexOf(46);
        if (index != -1) {
            fieldName = fieldName.substring(index + 1);
        }
        if ((propertyInfo = fieldEntity.getPropertyByName(fieldName)) instanceof OwnPropertyInfo) {
            OwnPropertyInfo ownPropertyInfo = (OwnPropertyInfo)propertyInfo;
            DataType dataType = ownPropertyInfo.getDataType();
            return MobileUtil.getDataTypeEnumByBOSDataType(dataType);
        }
        return null;
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        this.fieldTable.addRow();
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.fieldTable.getSelectManager().size() == 0 || this.fieldTable.getSelectManager().getActiveRowIndex() <= -1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_NAME, (String)"PLEASE_SELECT_DELETE_ROW"));
            return;
        }
        int rowIndex = this.fieldTable.getSelectManager().getActiveRowIndex();
        IRow selectedRow = this.fieldTable.getRow(rowIndex);
        Object selectedValue = selectedRow.getCell(0).getValue();
        if (selectedValue != null && selectedValue instanceof DataObject) {
            String fieldAlias = ((DataObject)selectedValue).getName();
            String format = (String)this.mltMessageFormat.getSelectedItemData();
            if (format.indexOf("{" + fieldAlias + "}") != -1) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_NAME, (String)"CANT_DELETE_HAS_USED"));
                return;
            }
        }
        this.fieldTable.removeRow(rowIndex);
    }

    @Override
    public void actionAdd_actionPerformed(ActionEvent e) throws Exception {
        if (this.fieldTable.getSelectManager().size() == 0 || this.fieldTable.getSelectManager().getActiveRowIndex() <= -1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_NAME, (String)"PLEASE_SELECT_ADD_ROW"));
            return;
        }
        int rowIndex = this.fieldTable.getSelectManager().getActiveRowIndex();
        IRow selectedRow = this.fieldTable.getRow(rowIndex);
        Object selectedValue = selectedRow.getCell(0).getValue();
        if (selectedValue == null || !(selectedValue instanceof DataObject)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_NAME, (String)"FIELD_CANT_BE_NULL"));
            return;
        }
        String fieldAlias = ((DataObject)selectedValue).getName();
        String format = (String)this.mltMessageFormat.getSelectedItemData();
        format = !StringUtils.isEmpty((String)format) ? format + "{" + fieldAlias + "}" : "{" + fieldAlias + "}";
        this.mltMessageFormat.setSelectedLanguage(new LanguageInfo(SysContext.getSysContext().getLocale()));
        this.mltMessageFormat.setSelectedItemData((Object)format);
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.fieldTable.getSelectManager().size() == 0 || this.fieldTable.getSelectManager().getActiveRowIndex() <= -1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_NAME, (String)"PLEASE_SELECT_DELETE_ROW"));
            return;
        }
        int rowIndex = this.fieldTable.getSelectManager().getActiveRowIndex();
        IRow selectedRow = this.fieldTable.getRow(rowIndex);
        Object selectedValue = selectedRow.getCell(0).getValue();
        if (selectedValue != null && selectedValue instanceof DataObject) {
            String fieldAlias = ((DataObject)selectedValue).getName();
            String format = (String)this.mltMessageFormat.getSelectedItemData();
            String matchedStr = "{" + fieldAlias + "}";
            StringBuffer replacedFormat = new StringBuffer();
            int index = format.indexOf(matchedStr);
            while (index != -1) {
                replacedFormat.append(format.substring(0, index));
                format = format.substring(index + matchedStr.length());
                index = format.indexOf(matchedStr);
            }
            if (!StringUtils.isEmpty((String)format)) {
                replacedFormat.append(format);
            }
            this.mltMessageFormat.setSelectedLanguage(new LanguageInfo(SysContext.getSysContext().getLocale()));
            this.mltMessageFormat.setSelectedItemData((Object)replacedFormat.toString());
        }
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        String format = (String)this.mltMessageFormat.getSelectedItemData();
        if (StringUtils.isEmpty((String)format)) {
            String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            String bosType = this.bosType.toString();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("user.id", (Object)userId));
            filterInfo.getFilterItems().add(new FilterItemInfo("bosType", (Object)bosType));
            MobileMessageFormatFactory.getRemoteInstance().delete(filterInfo);
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_NAME, (String)"SAVE_SUCCEED"));
            return;
        }
        this.checkIsLegalMessageFormat(format);
        MobileMessageFormatCollection formatCol = new MobileMessageFormatCollection();
        MobileMessageFormatInfo formatInfo = new MobileMessageFormatInfo();
        formatInfo.setBosType(this.bosType.toString());
        formatInfo.setEntityName(this.entity.getName());
        formatInfo.setIndex(0);
        String savedFormat = this.encodeMessageFormat(format);
        formatInfo.setFormat(savedFormat);
        formatCol.add(formatInfo);
        for (int i = 0; i < this.fieldTable.getRowCount(); ++i) {
            Object value = this.fieldTable.getRow(i).getCell(0).getValue();
            if (value == null) continue;
            DataObject data = (DataObject)value;
            String fieldName = data.getValue();
            boolean found = false;
            for (int j = 0; j < formatCol.size(); ++j) {
                if (!fieldName.equals(formatCol.get(j).getFieldName())) continue;
                found = true;
            }
            if (found) continue;
            formatInfo = new MobileMessageFormatInfo();
            formatInfo.setBosType(this.bosType.toString());
            formatInfo.setEntityName(this.entity.getName());
            formatInfo.setFieldName(fieldName);
            formatInfo.setFieldAlias(data.getName());
            formatInfo.setFieldEntityPK(data.getExtendValue());
            formatInfo.setIndex(i + 1);
            formatCol.add(formatInfo);
        }
        MobileMessageFormatFactory.getRemoteInstance().updateFormat(formatCol);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_NAME, (String)"SAVE_SUCCEED"));
        this.loadMessageFormat();
    }

    private void checkIsLegalMessageFormat(String format) throws Exception {
        boolean findLeft = false;
        for (int i = 0; i < format.length(); ++i) {
            char c = format.charAt(i);
            if (c == '{') {
                if (findLeft) {
                    throw new MobileException(MobileException.ILLEGAL_MESSAGE_FORMAT);
                }
                findLeft = true;
                continue;
            }
            if (c != '}') continue;
            if (!findLeft) {
                throw new MobileException(MobileException.ILLEGAL_MESSAGE_FORMAT);
            }
            findLeft = false;
        }
        if (findLeft) {
            throw new MobileException(MobileException.ILLEGAL_MESSAGE_FORMAT);
        }
    }

    private String encodeMessageFormat(String format) throws Exception {
        StringBuffer encodedFormat = new StringBuffer();
        while (!StringUtils.isEmpty((String)format)) {
            int leftIndex = format.indexOf(123);
            if (leftIndex != -1) {
                int rightIndex = format.indexOf(125);
                String fieldAlias = format.substring(leftIndex + 1, rightIndex);
                boolean found = false;
                int fIndex = 0;
                int hasDataIndex = 0;
                for (int i = 0; i < this.fieldTable.getRowCount(); ++i) {
                    Object value = this.fieldTable.getRow(i).getCell(0).getValue();
                    if (value == null) continue;
                    ++hasDataIndex;
                    DataObject data = (DataObject)value;
                    if (!fieldAlias.equals(data.getName())) continue;
                    found = true;
                    fIndex = hasDataIndex;
                    break;
                }
                encodedFormat.append(format.substring(0, leftIndex));
                if (!found) {
                    throw new MobileException(MobileException.ILLEGAL_MESSAGE_FORMAT);
                }
                encodedFormat.append("{").append(fIndex).append("}");
                format = format.substring(rightIndex + 1);
                continue;
            }
            encodedFormat.append(format);
            format = null;
        }
        return encodedFormat.toString();
    }

    private String decodeMessageFormat(MobileMessageFormatCollection formatCol, String format) throws Exception {
        StringBuffer decodedFormat = new StringBuffer();
        while (!StringUtils.isEmpty((String)format)) {
            int leftIndex = format.indexOf(123);
            if (leftIndex != -1) {
                int rightIndex = format.indexOf(125);
                String indexStr = format.substring(leftIndex + 1, rightIndex);
                int fIndex = 0;
                try {
                    fIndex = new Integer(indexStr);
                }
                catch (NumberFormatException e) {
                    throw new MobileException(MobileException.ILLEGAL_MESSAGE_FORMAT);
                }
                if (fIndex <= 0) {
                    throw new MobileException(MobileException.ILLEGAL_MESSAGE_FORMAT);
                }
                String fieldAlias = formatCol.get(fIndex) == null ? "" : formatCol.get(fIndex).getFieldAlias();
                decodedFormat.append(format.substring(0, leftIndex));
                decodedFormat.append("{").append(fieldAlias).append("}");
                format = format.substring(rightIndex + 1);
                continue;
            }
            decodedFormat.append(format);
            format = null;
        }
        return decodedFormat.toString();
    }
}

