/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.client;

import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.mobile.BizFunctionInfo;
import com.kingdee.eas.mobile.IMobileMessageQuerySchema;
import com.kingdee.eas.mobile.MobileException;
import com.kingdee.eas.mobile.MobileMessageQuerySchemaCollection;
import com.kingdee.eas.mobile.MobileMessageQuerySchemaFactory;
import com.kingdee.eas.mobile.MobileMessageQuerySchemaInfo;
import com.kingdee.eas.mobile.client.AbstractMobileQueryUI;
import com.kingdee.eas.mobile.client.MobileQueryPanel;
import com.kingdee.eas.mobile.util.MobileUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.util.HashMap;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class MobileQueryUI
extends AbstractMobileQueryUI {
    public static final String USER_ID = "userID";
    public static final String FUNCTION_ID = "functionID";
    public static final String QUERY_SCHEMA_CLASS_NAME = "queryPanelClassName";
    private String userID = null;
    private String functionID = null;
    private String queryPanelClassName = null;
    private MobileQueryPanel mobileQueryPanel = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
        this.btnAddNew.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.btnEdit.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
        this.btnRemove.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
    }

    protected void init() throws Exception {
        this.userID = (String)this.getUIContext().get(USER_ID);
        this.functionID = (String)this.getUIContext().get(FUNCTION_ID);
        this.queryPanelClassName = (String)this.getUIContext().get(QUERY_SCHEMA_CLASS_NAME);
        this.mobileQueryPanel = (MobileQueryPanel)Class.forName(this.queryPanelClassName).newInstance();
        this.mobileQueryPanel.init();
        this.mobileQueryPanel.initUIContentLayout();
        this.mobileQueryPanel.setBounds(new Rectangle(5, 15, 300, 235));
        this.queryPanel.add((Component)((Object)this.mobileQueryPanel), (Object)new KDLayout.Constraints(5, 15, 300, 235, 15));
        this.initTree();
    }

    protected void initTree() throws Exception {
        IMobileMessageQuerySchema iSchema = MobileMessageQuerySchemaFactory.getRemoteInstance();
        MobileMessageQuerySchemaCollection schemaCol = iSchema.getSchemaByUserAndFunction(this.userID, this.functionID);
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode();
        if (schemaCol != null && schemaCol.size() > 0) {
            DefaultKingdeeTreeNode node = null;
            for (int i = 0; i < schemaCol.size(); ++i) {
                MobileMessageQuerySchemaInfo schemaInfo = schemaCol.get(i);
                node = new DefaultKingdeeTreeNode((Object)schemaInfo);
                root.add((MutableTreeNode)node);
            }
        }
        DefaultTreeModel treeModel = new DefaultTreeModel((TreeNode)root);
        this.schemaTree.setModel((TreeModel)treeModel);
        this.schemaTree.setRootVisible(false);
        this.setOprtState(OprtState.ADDNEW);
        if (root.getChildCount() > 0) {
            this.schemaTree.setSelectionNode((DefaultKingdeeTreeNode)root.getChildAt(0));
        }
    }

    @Override
    protected void schemaTree_valueChanged(TreeSelectionEvent e) throws Exception {
        this.onClickTree();
    }

    @Override
    protected void schemaTree_focusGained(FocusEvent e) throws Exception {
        this.onClickTree();
    }

    protected void onClickTree() throws Exception {
        DefaultKingdeeTreeNode selectedNode = this.getSelectedTreeNode();
        if (selectedNode != null && selectedNode.getUserObject() != null) {
            MobileMessageQuerySchemaInfo schemaInfo = (MobileMessageQuerySchemaInfo)selectedNode.getUserObject();
            this.txtShortCut.setText(schemaInfo.getNumber());
            this.checkDefault.setSelected(schemaInfo.isIsDefault());
            HashMap map = MobileUtil.parseQueryCondition(schemaInfo.getQueryCondition(), this.mobileQueryPanel.getKeySequence());
            this.mobileQueryPanel.loadQueryConditions(map);
            this.setOprtState(OprtState.EDIT);
            this.btnRemove.setEnabled(true);
        }
    }

    public DefaultKingdeeTreeNode getSelectedTreeNode() {
        return (DefaultKingdeeTreeNode)this.schemaTree.getLastSelectedPathComponent();
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.setOprtState(OprtState.ADDNEW);
        this.clear();
        this.txtShortCut.requestFocusInWindow();
        this.btnRemove.setEnabled(false);
    }

    private void clear() throws Exception {
        this.txtShortCut.setText(null);
        this.checkDefault.setSelected(false);
        this.mobileQueryPanel.clear();
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")) == 0) {
            DefaultKingdeeTreeNode selectedNode = this.getSelectedTreeNode();
            MobileMessageQuerySchemaInfo schemaInfo = (MobileMessageQuerySchemaInfo)selectedNode.getUserObject();
            IMobileMessageQuerySchema iSchema = MobileMessageQuerySchemaFactory.getRemoteInstance();
            iSchema.delete((IObjectPK)new ObjectUuidPK(schemaInfo.getId()));
            this.initTree();
        }
    }

    public void checkSelected() {
        DefaultKingdeeTreeNode selectedNode = this.getSelectedTreeNode();
        if (selectedNode == null) {
            MsgBox.showWarning((Component)((Object)this), (String)this.getResource("PLEASE_SELECT_A_SCHEMA"));
            SysUtil.abort();
        }
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.verify();
        MobileMessageQuerySchemaInfo schemaInfo = null;
        if (this.getOprtState() == OprtState.ADDNEW) {
            schemaInfo = new MobileMessageQuerySchemaInfo();
            UserInfo userInfo = new UserInfo();
            userInfo.setId(BOSUuid.read((String)this.userID));
            schemaInfo.setUser(userInfo);
            BizFunctionInfo functionInfo = new BizFunctionInfo();
            functionInfo.setId(BOSUuid.read((String)this.functionID));
            schemaInfo.setBizFunction(functionInfo);
        } else {
            DefaultKingdeeTreeNode selectedNode = this.getSelectedTreeNode();
            schemaInfo = (MobileMessageQuerySchemaInfo)((MobileMessageQuerySchemaInfo)selectedNode.getUserObject()).clone();
        }
        schemaInfo.setNumber(this.txtShortCut.getText());
        schemaInfo.setIsDefault(this.checkDefault.isSelected());
        HashMap map = this.mobileQueryPanel.getQueryConditions();
        String condition = MobileUtil.generateQueryCondition(map, this.mobileQueryPanel.getKeySequence());
        schemaInfo.setQueryCondition(condition);
        IMobileMessageQuerySchema iSchema = MobileMessageQuerySchemaFactory.getRemoteInstance();
        iSchema.submitSchemaInfo((IObjectValue)schemaInfo);
        MsgBox.showInfo((String)this.getResource("SAVE_SUCCESS"));
        this.initTree();
        this.locateToSpecifiedSchema(schemaInfo);
        this.setOprtState(OprtState.EDIT);
        this.btnRemove.setEnabled(true);
    }

    private void verify() throws Exception {
        if (StringUtils.isEmpty((String)this.txtShortCut.getText())) {
            throw new MobileException(MobileException.SCHEMA_NUMBER_CANT_BE_NULL);
        }
        this.mobileQueryPanel.verify();
    }

    private void locateToSpecifiedSchema(MobileMessageQuerySchemaInfo schemaInfo) {
        TreeModel model = this.schemaTree.getModel();
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)model.getRoot();
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            MobileMessageQuerySchemaInfo nodeInfo = (MobileMessageQuerySchemaInfo)node.getUserObject();
            if (!schemaInfo.getNumber().equals(nodeInfo.getNumber())) continue;
            this.schemaTree.setSelectionNode(node);
            return;
        }
    }

    private String getResource(String itemKey) {
        String resClassName = "com.kingdee.eas.mobile.client.UserConfigUIResources";
        return EASResource.getString((String)resClassName, (String)itemKey);
    }
}

