/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.client;

import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.IAttachment;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.ComplexAttachmentInfo;
import com.kingdee.eas.base.attachment.common.ComplexAttachmentInfoSelector;
import com.kingdee.eas.base.attachment.common.SimpleAttachmentInfo;
import com.kingdee.eas.base.attachment.util.FileGetter;
import com.kingdee.eas.base.attachment.util.StringUtil4File;
import com.kingdee.eas.base.attachment.util.VariousAttachmentInfoMaker;
import com.kingdee.eas.base.message.EmailInfo;
import com.kingdee.eas.base.message.IMessageCenter;
import com.kingdee.eas.base.message.MessageCenterFactory;
import com.kingdee.eas.base.receiver.BasReleaseInfo;
import com.kingdee.eas.base.receiver.IReceiversFacade;
import com.kingdee.eas.base.receiver.ReceiversFacadeFactory;
import com.kingdee.eas.base.receiver.util.MessageInputUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mobile.client.AbstractSendEmailUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SendEmailUI
extends AbstractSendEmailUI {
    private String resource = "com.kingdee.eas.base.message.client.MessageCenter";
    private static final Logger logger = Logger.getLogger(SendEmailUI.class);
    private Map map = new HashMap();
    protected IUIWindow currOrgTreeDialog;
    Map ctx = new HashMap();
    private final int DEFAULTATTACHS = 9;
    private BOSUuid emailBosID;
    private static final long serialVersionUID = 3247896926679380322L;
    private BasReleaseInfo receiverInfo = null;
    private BasReleaseInfo senderInfo = null;
    private MessageInputUtils miu1 = new MessageInputUtils();
    private MessageInputUtils miu2 = new MessageInputUtils();
    public static String RECEIVER_INFO = "receiverInfo";

    public SendEmailUI() throws Exception {
        this.getUIContext().put("receivers", "");
        this.getUIContext().put("receivers_sec", "");
        this.getUIContext().put("checkLicense", "true");
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.txtReceiver1.setRequired(true);
        if (this.receiverInfo == null) {
            this.receiverInfo = new BasReleaseInfo();
        }
        this.miu1.initData(this.txtReceiver1, this.receiverInfo);
        this.miu1.setUserPhoneOrMail(true);
        if (this.senderInfo == null) {
            this.senderInfo = new BasReleaseInfo();
        }
        this.miu2.initData(this.txtReceiver2, this.senderInfo);
        this.miu2.setUserPhoneOrMail(true);
        if (this.email == null) {
            this.email = new EmailInfo();
        }
        this.emailBosID = this.email.getId();
        if (this.emailBosID == null) {
            this.emailBosID = BOSUuid.create((BOSObjectType)this.email.getBOSType());
        }
        this.ctx.put("All_Admins", "YES");
        Object obj = this.getUIContext().get("attachs");
        if (obj != null && obj instanceof File[]) {
            File[] attachs = (File[])obj;
            int num = attachs.length;
            for (int i = 0; i < num; ++i) {
                this.map.put(attachs[i].getName(), attachs[i]);
            }
        }
        this.initAttachmentPanel();
        this.btnSendEmail.setIcon(EASResource.getIcon((String)"imgTbtn_send"));
        this.scrollEmailContent();
    }

    private void scrollEmailContent() {
        KDScrollPane kDScrollPane1 = new KDScrollPane();
        kDScrollPane1.setName("kDScrollPane1");
        kDScrollPane1.setAutoscrolls(true);
        kDScrollPane1.setBounds(new Rectangle(10, 155, 581, 234));
        this.add((Component)kDScrollPane1, null);
        kDScrollPane1.getViewport().add((Component)this.kdEmailContent, null);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    public void loadRcrAndRcr_sec() {
        String receivers = this.txtReceiver1.getText().trim();
        if (!receivers.equals("")) {
            String subStr = receivers.substring(receivers.length() - 1);
            if (subStr.equals(";")) {
                this.txtReceiver1.setText(receivers + this.getUIContext().get("receivers").toString());
            } else {
                this.txtReceiver1.setText(receivers + ";" + this.getUIContext().get("receivers").toString());
            }
        } else {
            this.txtReceiver1.setText(this.getUIContext().get("receivers").toString());
        }
        String receivers_sec = this.txtReceiver2.getText().trim();
        if (!receivers_sec.equals("")) {
            String subStr = receivers_sec.substring(receivers_sec.length() - 1);
            if (subStr.equals(";")) {
                this.txtReceiver2.setText(receivers_sec + this.getUIContext().get("receivers_sec").toString());
            } else {
                this.txtReceiver2.setText(receivers_sec + ";" + this.getUIContext().get("receivers_sec").toString());
            }
        } else {
            this.txtReceiver2.setText(this.getUIContext().get("receivers_sec").toString());
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionAddAttachment_actionPerformed(ActionEvent e) throws Exception {
        AttachmentManagerFactory.getClientManager().showAttachmentListUIByBoID(this.emailBosID.toString(), (Object)this);
        this.initAttachmentPanel();
    }

    @Override
    protected void btnReceiver1_actionPerformed(ActionEvent e) throws Exception {
        this.miu1.showReceiverUI((Object)this);
    }

    @Override
    protected void btnReceiver2_actionPerformed(ActionEvent e) throws Exception {
        this.miu2.showReceiverUI((Object)this);
    }

    public String filter(String str1, String str2) {
        int i;
        String[] strArray1 = str1.split(";");
        String[] strArray2 = str2.split(";");
        HashMap hashMap = new HashMap();
        int size = strArray1.length;
        for (i = 0; i < size; ++i) {
            hashMap.put(strArray1[i], null);
        }
        size = strArray2.length;
        for (i = 0; i < size; ++i) {
            hashMap.containsKey(strArray2[i]);
            hashMap.remove(strArray2[i]);
        }
        Iterator ids = hashMap.keySet().iterator();
        str1 = "";
        while (ids.hasNext()) {
            str1 = str1 + (String)ids.next() + ";";
        }
        return str1;
    }

    private String getNoMailPerson(Set set) {
        Object[] ob = null;
        if (set != null) {
            ob = set.toArray();
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ob.length; ++i) {
            if (ob[i] == null) continue;
            sb.append(ob[i]).append(",");
        }
        String str = "";
        if (sb.toString().length() > 0) {
            str = sb.toString().substring(0, sb.toString().length() - 1);
        }
        return str;
    }

    private String getMail(Set set) {
        Object[] ob = null;
        if (set != null) {
            ob = set.toArray();
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ob.length; ++i) {
            sb.append(ob[i]).append(";");
        }
        return sb.toString();
    }

    @Override
    public void actionSendEmail_actionPerformed(ActionEvent e) throws Exception {
        String emailContent;
        IMessageCenter messageCenter = MessageCenterFactory.getRemoteInstance();
        String txtReceiver1 = this.txtReceiver1.getText().trim();
        String txtReceiver2 = this.txtReceiver1.getText().trim();
        if (StringUtils.isEmpty((String)txtReceiver1) && StringUtils.isEmpty((String)txtReceiver2)) {
            MsgBox.showInfo((String)EASResource.getString((String)this.resource, (String)"mailrecnotnull"));
            this.txtReceiver1.requestFocus();
            return;
        }
        if (this.receiverInfo.get("receiver") == null || this.receiverInfo.get("receiver").toString().length() < 5) {
            MsgBox.showInfo((String)EASResource.getString((String)this.resource, (String)"mailrecnotnull"));
            this.txtReceiver1.requestFocus();
            return;
        }
        Iterator itr = this.map.keySet().iterator();
        while (itr.hasNext()) {
            this.addAttachFromOrg((File)this.map.get(itr.next()));
        }
        this.map.clear();
        String[] attachmentIDs = AttachmentManagerFactory.getClientManager().getAttachmentIDsByBoID(this.emailBosID.toString());
        String emailTitle = this.kdEmailTitle.getText();
        if (emailTitle == null || emailTitle.equals("")) {
            emailTitle = "";
        }
        if ((emailContent = this.kdEmailContent.getText()) == null || emailContent.equals("")) {
            emailContent = "";
        }
        IReceiversFacade irf = ReceiversFacadeFactory.getRemoteInstance();
        Set reSet1 = irf.getHaveNoMail(this.receiverInfo);
        Set reSet2 = irf.getHaveNoMail(this.senderInfo);
        String str1 = this.getNoMailPerson(reSet1);
        String str2 = this.getNoMailPerson(reSet2);
        if (!StringUtils.isEmpty((String)str1)) {
            MsgBox.showInfo((String)(EASResource.getString((String)this.resource, (String)"mail_rec_1_null_mail") + " " + str1));
        }
        if (!StringUtils.isEmpty((String)str2)) {
            MsgBox.showInfo((String)(EASResource.getString((String)this.resource, (String)"mail_rec_2_null_mail") + " " + str2));
        }
        String receiver1 = this.getMail(irf.getMailByReleaseInfo(this.receiverInfo)) + this.getMail(this.miu1.getPhoneNumberOrMail());
        String receiver2 = this.getMail(irf.getMailByReleaseInfo(this.senderInfo)) + this.getMail(this.miu2.getPhoneNumberOrMail());
        try {
            if (!(StringUtils.isEmpty((String)receiver1) && StringUtils.isEmpty((String)receiver2) || !messageCenter.sendEmail(emailTitle, emailContent, receiver1, receiver2, attachmentIDs))) {
                MsgBox.showInfo((String)EASResource.getString((String)this.resource, (String)"send_success"));
                this.getUIWindow().close();
            }
        }
        catch (EASBizException ex) {
            MsgBox.showInfo((String)EASResource.getString((String)this.resource, (String)"connection_error"));
        }
    }

    private void addAttachFromOrg(File file) throws Exception {
        String fullname = file.getName();
        String mainname = StringUtil4File.getMainFileName((String)fullname);
        String extname = StringUtil4File.getExtendedFileName((String)fullname);
        byte[] content = FileGetter.getBytesFromFile((File)file);
        SimpleAttachmentInfo sai = new SimpleAttachmentInfo();
        sai.setMainName(mainname);
        sai.setExtName(extname);
        sai.setContent(content);
        IAttachment attachment = AttachmentFactory.getRemoteInstance();
        AttachmentInfo attachmentInfo = VariousAttachmentInfoMaker.makeAttachmentInfo((IAttachment)attachment, (String)this.emailBosID.toString(), (SimpleAttachmentInfo)sai);
        attachment.addnew(attachmentInfo).toString();
    }

    private void initAttachmentPanel() {
        int i;
        String fileName;
        KDLabelContainer lalName;
        int n = 0;
        ComplexAttachmentInfo[] attachInfos = null;
        try {
            String[] attachIDs = AttachmentManagerFactory.getClientManager().getAttachmentIDsByBoID(this.emailBosID.toString());
            n = attachIDs.length;
            attachInfos = new ComplexAttachmentInfo[n];
            ComplexAttachmentInfoSelector cais = new ComplexAttachmentInfoSelector();
            cais.needMainName();
            cais.needExtName();
            cais.needID();
            for (int i2 = 0; i2 < n; ++i2) {
                attachInfos[i2] = AttachmentManagerFactory.getClientManager().getComplexAttachmentInfo(attachIDs[i2], cais);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.kdEmailAttachmentPanel.setLayout((LayoutManager)new FlowLayout(0));
        this.kdEmailAttachmentPanel.removeAll();
        int num = this.map.size();
        if (num != 0) {
            Iterator itr = this.map.keySet().iterator();
            int i3 = 0;
            while (itr.hasNext()) {
                lalName = new KDLabelContainer();
                String tempFileName = itr.next().toString();
                fileName = i3 + 1 + "." + tempFileName;
                lalName.setMaximumSize(new Dimension(fileName.length() * 8, 19));
                lalName.setPreferredSize(new Dimension(fileName.length() * 8, 19));
                lalName.setName(tempFileName);
                lalName.setBoundLabelText(fileName);
                lalName.setBoundLabelLength(fileName.length() * 2);
                lalName.setBoundLabelUnderline(true);
                lalName.getBoundLabel().addMouseListener(new MyMouseListener((Component)((Object)this)));
                this.kdEmailAttachmentPanel.add((Component)lalName);
                ++i3;
            }
        }
        for (i = 0; i < n; ++i) {
            lalName = new KDLabelContainer();
            fileName = num + i + 1 + "." + attachInfos[i].getMainName();
            if (!StringUtils.isEmpty((String)attachInfos[i].getExtName())) {
                fileName = fileName + "." + attachInfos[i].getExtName();
            }
            lalName.setMaximumSize(new Dimension(fileName.length() * 8, 19));
            lalName.setPreferredSize(new Dimension(fileName.length() * 8, 19));
            lalName.setName(attachInfos[i].getId());
            lalName.setToolTipText(attachInfos[i].getMainName() + " " + attachInfos[i].getDescription());
            lalName.setBoundLabelText(fileName);
            lalName.setBoundLabelLength(fileName.length() * 2);
            lalName.setBoundLabelUnderline(true);
            lalName.getBoundLabel().addMouseListener(new MyMouseListener((Component)((Object)this)));
            this.kdEmailAttachmentPanel.add((Component)lalName);
        }
        for (i = n; i < 9; ++i) {
            lalName = new KDLabelContainer();
            this.kdEmailAttachmentPanel.add((Component)lalName);
        }
        this.kdEmailAttachmentPanel.revalidate();
    }

    private void _setCursor(Component cp, Cursor cursor) {
        cp.setCursor(cursor);
        if (cp instanceof Container) {
            Container cc = (Container)cp;
            int n = cc.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component curComponent = cc.getComponent(i);
                if (!curComponent.isFocusable()) continue;
                this._setCursor(curComponent, cursor);
            }
        }
    }

    class MyMouseListener
    extends MouseAdapter {
        Component owner;

        public MyMouseListener(Component owner) {
            this.owner = owner;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            SendEmailUI.this._setCursor(this.owner, Cursor.getPredefinedCursor(12));
        }

        @Override
        public void mouseExited(MouseEvent e) {
            SendEmailUI.this._setCursor(this.owner, Cursor.getPredefinedCursor(0));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseClicked(MouseEvent e) {
            SendEmailUI.this._setCursor(this.owner, Cursor.getPredefinedCursor(3));
            try {
                if (e.getButton() == 1 && e.getComponent() != null) {
                    KDLabelContainer con = null;
                    if (e.getComponent() instanceof KDLabelContainer) {
                        con = (KDLabelContainer)e.getComponent();
                    } else if (e.getComponent().getParent() instanceof KDLabelContainer) {
                        con = (KDLabelContainer)e.getComponent().getParent();
                    }
                    if (con != null) {
                        StringBuffer fileName = new StringBuffer();
                        if (SendEmailUI.this.map.keySet().contains(con.getName())) {
                            File memoryFile = (File)SendEmailUI.this.map.get(con.getName());
                            fileName.append("start /d \"");
                            fileName.append(memoryFile.getParent());
                            fileName.append("\" ");
                            fileName.append(memoryFile.getName());
                        } else {
                            fileName.append("start ");
                            fileName.append(AttachmentManagerFactory.getClientManager().downloadAttachment(con.getName()));
                        }
                        File batCommandFile = File.createTempFile("temp", ".bat");
                        FileWriter writer = new FileWriter(batCommandFile);
                        writer.write(fileName.toString());
                        writer.close();
                        Runtime.getRuntime().exec(batCommandFile.getPath());
                    }
                }
            }
            catch (Exception es) {
                es.printStackTrace();
            }
            finally {
                SendEmailUI.this._setCursor(this.owner, Cursor.getPredefinedCursor(0));
            }
        }
    }
}

