/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.client;

import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.ctrl.swing.MultiLangItem;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.message.MsgPriority;
import com.kingdee.eas.base.message.client.ReceiversListUI;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.receiver.BasReceiverInfo;
import com.kingdee.eas.base.receiver.BasReleaseInfo;
import com.kingdee.eas.base.receiver.ReceiverConstant;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mobile.ISendMessageSchema;
import com.kingdee.eas.mobile.MobileException;
import com.kingdee.eas.mobile.SendMessageSchemaFactory;
import com.kingdee.eas.mobile.SendMessageSchemaInfo;
import com.kingdee.eas.mobile.client.AbstractSendMessageSchemaUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class SendMessageSchemaUI
extends AbstractSendMessageSchemaUI {
    private String resource = "com.kingdee.eas.mobile.client.SmsResource";
    public static final String SCHEMA_NUMBER = "number";
    public static final String IS_MODEL_UI = "is_model_ui";
    public static final String SCHEMA_CONTENT = "content";
    public static final String INIT_RECEIVER = "init_receiver";
    public static final String INIT_RECEIVER_COLLECTION = "init_receiver_col";
    private String content = null;
    private String initReceivers = null;
    private UserCollection initReceiverCol = null;
    public static final String MESSAGE_PRIORITY = "Priority";
    private MsgPriority priority = MsgPriority.MIDDLE;
    private BasReleaseInfo receiverInfo = null;

    public SendMessageSchemaUI() throws Exception {
        this.btnSend.setIcon(EASResource.getIcon((String)"imgTbtn_send"));
    }

    public void onLoad() throws Exception {
        Boolean isModelUI = (Boolean)this.getUIContext().get(IS_MODEL_UI);
        if (isModelUI != null && isModelUI.booleanValue()) {
            this.editData = (SendMessageSchemaInfo)this.createNewData();
            this.setOprtState(OprtState.ADDNEW);
            this.btnAddNew.setVisible(false);
            this.btnEdit.setVisible(false);
            this.labelNumber.setVisible(false);
            this.labelName.setVisible(false);
            this.txtNumber.setVisible(false);
            this.langName.setVisible(false);
            this.btnSubmit.setVisible(false);
            Object o = this.getUIContext().get(MESSAGE_PRIORITY);
            if (o != null && o instanceof MsgPriority) {
                this.priority = (MsgPriority)o;
            }
            this.content = (String)this.getUIContext().get(SCHEMA_CONTENT);
            if (!StringUtils.isEmpty((String)this.content)) {
                int n = this.langContent.getItemCount();
                for (int i = 0; i < n; ++i) {
                    MultiLangItem mli = (MultiLangItem)this.langContent.getItemAt(i);
                    mli.setData((Object)this.content);
                }
                this.langContent.setSelectedLanguage(new LanguageInfo(SysContext.getSysContext().getLocale()));
                this.langContent.setSelectedItemData((Object)this.content);
            }
            this.initReceiverCol = (UserCollection)this.getUIContext().get(INIT_RECEIVER_COLLECTION);
            if (this.initReceiverCol != null) {
                StringBuffer buf = new StringBuffer();
                for (int i = 0; i < this.initReceiverCol.size(); ++i) {
                    if (buf.length() != 0) {
                        buf.append(",");
                    }
                    buf.append(this.initReceiverCol.get(i).getName());
                }
                this.initReceivers = buf.toString();
            } else {
                String userIds;
                this.initReceivers = (String)this.getUIContext().get(INIT_RECEIVER);
                if (!StringUtils.isEmpty((String)this.initReceivers) && !StringUtils.isEmpty((String)(userIds = SendMessageSchemaFactory.getRemoteInstance().getUserIdsByNames(this.initReceivers)))) {
                    String[] tempNames = this.initReceivers.trim().replace(';', ',').split(",");
                    String[] tempIds = userIds.split(",");
                    if (tempIds.length > 0) {
                        this.initReceiverCol = new UserCollection();
                        for (int i = 0; i < tempIds.length; ++i) {
                            UserInfo tempUserInfo = new UserInfo();
                            tempUserInfo.setId(BOSUuid.read((String)tempIds[i]));
                            tempUserInfo.setName(tempNames[i]);
                            this.initReceiverCol.add(tempUserInfo);
                        }
                    }
                }
            }
        } else {
            this.btnSend.setVisible(false);
        }
        super.onLoad();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            int i;
            this.txtNumber.setText(null);
            int n = this.langName.getItemCount();
            for (i = 0; i < n; ++i) {
                ((MultiLangItem)this.langName.getItemAt(i)).setData(null);
            }
            this.langName.setSelectedItemData(null);
            this.chkMessage.setSelected(false);
            this.chkSMS.setSelected(false);
            this.chkEmail.setSelected(false);
            this.txtReceivers.setText(this.initReceivers);
            n = this.langContent.getItemCount();
            for (i = 0; i < n; ++i) {
                ((MultiLangItem)this.langContent.getItemAt(i)).setData((Object)this.content);
            }
            this.langContent.setSelectedItemData((Object)this.content);
        } else {
            MultiLangItem mli;
            int i;
            this.txtNumber.setText(this.editData.getNumber());
            int n = this.langName.getItemCount();
            for (i = 0; i < n; ++i) {
                mli = (MultiLangItem)this.langName.getItemAt(i);
                mli.setData((Object)this.editData.getName(mli.getLang().getLocale()));
            }
            this.langName.setSelectedLanguage(new LanguageInfo(SysContext.getSysContext().getLocale()));
            this.langName.setSelectedItemData((Object)this.editData.getName());
            this.chkMessage.setSelected(this.editData.isIsMessage());
            this.chkSMS.setSelected(this.editData.isIsSMS());
            this.chkEmail.setSelected(this.editData.isIsEmail());
            this.txtReceivers.setText(this.editData.getReceiver());
            n = this.langContent.getItemCount();
            for (i = 0; i < n; ++i) {
                mli = (MultiLangItem)this.langContent.getItemAt(i);
                mli.setData((Object)this.editData.getContent(mli.getLang().getLocale()));
            }
            this.langContent.setSelectedLanguage(new LanguageInfo(SysContext.getSysContext().getLocale()));
            this.langContent.setSelectedItemData((Object)this.editData.getContent());
        }
    }

    @Override
    public void storeFields() {
        Locale locale;
        MultiLangItem mli;
        int i;
        super.storeFields();
        if (this.editData == null) {
            return;
        }
        this.editData.setNumber(this.txtNumber.getText());
        int n = this.langName.getItemCount();
        for (i = 0; i < n; ++i) {
            mli = (MultiLangItem)this.langName.getItemAt(i);
            locale = mli.getLang().getLocale();
            String name = mli.getData().toString();
            this.editData.setName(name, locale);
        }
        this.editData.setIsMessage(this.chkMessage.isSelected());
        this.editData.setIsSMS(this.chkSMS.isSelected());
        this.editData.setIsEmail(this.chkEmail.isSelected());
        this.editData.setReceiver(this.txtReceivers.getText());
        n = this.langContent.getItemCount();
        for (i = 0; i < n; ++i) {
            mli = (MultiLangItem)this.langContent.getItemAt(i);
            locale = mli.getLang().getLocale();
            String content = mli.getData().toString();
            this.editData.setContent(content, locale);
        }
        this.editData.setMsgPriority(this.priority);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (StringUtils.isEmpty((String)this.editData.getNumber())) {
            this.txtNumber.requestFocusInWindow();
            throw new MobileException(MobileException.NUMBER_CANT_BE_NULL);
        }
        if (StringUtils.isEmpty((String)this.editData.getName())) {
            this.langName.requestFocusInWindow();
            throw new MobileException(MobileException.NAME_CANT_BE_NULL);
        }
        if (!(this.editData.isIsMessage() || this.editData.isIsSMS() || this.editData.isIsMessage())) {
            throw new MobileException(MobileException.SELECT_SEND_TYPE);
        }
        if (StringUtils.isEmpty((String)this.editData.getReceiver())) {
            this.txtReceivers.requestFocusInWindow();
            throw new MobileException(MobileException.RECEIVERS_CANT_BE_NULL);
        }
        if (StringUtils.isEmpty((String)this.editData.getContent())) {
            this.langContent.requestFocusInWindow();
            throw new MobileException(MobileException.CONTENT_CANT_BE_NULL);
        }
    }

    @Override
    protected void btnReceiver_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        if (this.receiverInfo == null) {
            this.receiverInfo = new BasReleaseInfo();
            if (this.initReceiverCol != null && this.initReceiverCol.size() > 0) {
                for (int i = 0; i < this.initReceiverCol.size(); ++i) {
                    BasReceiverInfo rptReceiverInfo = new BasReceiverInfo();
                    rptReceiverInfo.setIsShow(true);
                    rptReceiverInfo.setType("1");
                    rptReceiverInfo.setDesc(this.initReceiverCol.get(i).getName());
                    rptReceiverInfo.setValue(this.initReceiverCol.get(i).getId().toString());
                    this.receiverInfo.getReceiver().add(rptReceiverInfo);
                }
            }
        }
        uiContext.put((Object)ReceiverConstant.RECEIVER_INFO, (Object)this.receiverInfo);
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create(ReceiversListUI.class.getName(), (Map)uiContext, null, null);
        ReceiversListUI receiversListUI = (ReceiversListUI)window.getUIObject();
        receiversListUI.setTextFieldReceivers(this.txtReceivers);
        window.show();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkPhoneNumberAndEmail();
        super.actionSubmit_actionPerformed(e);
    }

    @Override
    public void actionSend_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        if (!(this.editData.isIsMessage() || this.editData.isIsSMS() || this.editData.isIsEmail())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resource, (String)"select_send_mode"));
            return;
        }
        this.checkPhoneNumberAndEmail();
        HashMap result = null;
        try {
            result = SendMessageSchemaFactory.getRemoteInstance().sendMessage(this.editData);
            boolean msgResult = (Boolean)result.get("Message");
            boolean smsResult = (Boolean)result.get("SMS");
            boolean emailResult = (Boolean)result.get("Email");
            StringBuffer resultMsg = new StringBuffer();
            if (this.chkMessage.isSelected()) {
                resultMsg.append(EASResource.getString((String)this.resource, (String)"sendmessage"));
                if (msgResult) {
                    resultMsg.append(EASResource.getString((String)this.resource, (String)"succeed"));
                } else {
                    resultMsg.append(EASResource.getString((String)this.resource, (String)"unsuccessful"));
                }
            }
            if (this.chkSMS.isSelected()) {
                resultMsg.append(EASResource.getString((String)this.resource, (String)"sendmobilemessage"));
                if (smsResult) {
                    resultMsg.append(EASResource.getString((String)this.resource, (String)"succeed"));
                } else {
                    resultMsg.append(EASResource.getString((String)this.resource, (String)"unsuccessful"));
                }
            }
            if (this.chkEmail.isSelected()) {
                resultMsg.append(EASResource.getString((String)this.resource, (String)"sendmail"));
                if (emailResult) {
                    resultMsg.append(EASResource.getString((String)this.resource, (String)"succeed"));
                } else {
                    resultMsg.append(EASResource.getString((String)this.resource, (String)"unsuccessful"));
                }
            }
            MsgBox.showInfo((Component)((Object)this), (String)resultMsg.toString());
        }
        catch (Exception ex) {
            if (ex instanceof EASBizException) {
                this.handUIException(ex);
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resource, (String)"sendMsgResult"));
                return;
            }
            ex.printStackTrace();
        }
    }

    private void checkPhoneNumberAndEmail() throws Exception {
        ISendMessageSchema iSchema = SendMessageSchemaFactory.getRemoteInstance();
        String personNames1 = null;
        if (this.chkSMS.isSelected()) {
            personNames1 = iSchema.checkPhoneNumberExists(this.txtReceivers.getText());
        }
        String personNames2 = null;
        if (this.chkEmail.isSelected()) {
            personNames2 = iSchema.checkEmailExists(this.txtReceivers.getText());
        }
        StringBuffer hintMsg = new StringBuffer();
        if (!StringUtils.isEmpty((String)personNames1)) {
            hintMsg.append(EASResource.getString((String)this.resource, (String)"receivers_notcell") + " " + personNames1);
        }
        if (!StringUtils.isEmpty((String)personNames2)) {
            if (hintMsg.length() > 0) {
                hintMsg.append(";");
            }
            hintMsg.append(EASResource.getString((String)this.resource, (String)"receivers_notmail") + " " + personNames2);
        }
        if (hintMsg.length() > 0) {
            hintMsg.append(EASResource.getString((String)this.resource, (String)"save_send_or_not"));
        }
        if (hintMsg.length() > 0 && MsgBox.showConfirm2((Component)((Object)this), (String)hintMsg.toString()) != 0) {
            this.abort();
        }
    }

    public boolean isModify() {
        Boolean isModelUI = (Boolean)this.getUIContext().get(IS_MODEL_UI);
        if (isModelUI != null && isModelUI.booleanValue()) {
            return false;
        }
        return super.isModify();
    }

    protected IObjectValue createNewData() {
        return new SendMessageSchemaInfo();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return SendMessageSchemaFactory.getRemoteInstance();
    }
}

