/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.ControlUtilities;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationCollection;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.job.client.ProcessSchedulePlan;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.client.UIConfig;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.workflow.EASWfServiceClient;
import com.kingdee.eas.mobile.BizFunctionCollection;
import com.kingdee.eas.mobile.BizFunctionFactory;
import com.kingdee.eas.mobile.BizFunctionInfo;
import com.kingdee.eas.mobile.CustomCMDShortCutCollection;
import com.kingdee.eas.mobile.CustomCMDShortCutFactory;
import com.kingdee.eas.mobile.CustomCMDShortCutInfo;
import com.kingdee.eas.mobile.IBizFunction;
import com.kingdee.eas.mobile.ICustomCMDShortCut;
import com.kingdee.eas.mobile.IMessageReceiveUser;
import com.kingdee.eas.mobile.IMessageSubscript;
import com.kingdee.eas.mobile.IMobileMessageQuerySchema;
import com.kingdee.eas.mobile.IMsgFacade;
import com.kingdee.eas.mobile.IUserMessageConfig;
import com.kingdee.eas.mobile.MessageReceiveUserCollection;
import com.kingdee.eas.mobile.MessageReceiveUserFactory;
import com.kingdee.eas.mobile.MessageReceiveUserInfo;
import com.kingdee.eas.mobile.MessageSubscriptCollection;
import com.kingdee.eas.mobile.MessageSubscriptFactory;
import com.kingdee.eas.mobile.MessageSubscriptInfo;
import com.kingdee.eas.mobile.MobileMessageQuerySchemaFactory;
import com.kingdee.eas.mobile.MobileMessageQuerySchemaInfo;
import com.kingdee.eas.mobile.MsgFacadeFactory;
import com.kingdee.eas.mobile.UserMessageConfigCollection;
import com.kingdee.eas.mobile.UserMessageConfigFactory;
import com.kingdee.eas.mobile.UserMessageConfigInfo;
import com.kingdee.eas.mobile.client.AbstractUserConfigUI;
import com.kingdee.eas.mobile.client.MobileQueryUI;
import com.kingdee.eas.mobile.msg.BizModuleConfig;
import com.kingdee.eas.mobile.msg.UserCommandInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.STConverter;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class UserConfigUI
extends AbstractUserConfigUI
implements ChangeListener {
    private ResourceBundleHelper uiResHelper;
    private static final String[] SHORTCUTS_VALUE = new String[]{" ", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
    private final KDComboBox SHORTCUTS = new KDComboBox((Object[])SHORTCUTS_VALUE);
    private String userId = null;
    UserInfo userInfo = null;
    private PersonInfo personInfo = null;
    private UserCollection userCol = null;
    private UserInfo receiveUserInfo = null;
    private UserMessageConfigInfo userMsgConfigInfo = null;
    private BizFunctionCollection bizFunctionCol = null;
    private CustomCMDShortCutCollection cCMDShortCutCol = null;
    private MessageSubscriptCollection messageSubscriptCol = null;
    BizModuleConfig bizConfig;
    UserCommandInfo[] commandInfo;
    private EASWfServiceClient workflowClient;

    public UserConfigUI() throws Exception {
        this.saveBt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    UserConfigUI.this.saveBt_actionPerformed(e);
                }
                catch (Exception ex) {
                    UserConfigUI.this.handUIException(ex);
                }
            }
        });
        this.resetBt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    UserConfigUI.this.resetBt_actionPerformed(e);
                }
                catch (Exception ex) {
                    UserConfigUI.this.handUIException(ex);
                }
            }
        });
        try {
            this.initData();
            this.initUI();
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        if (clientHanlder != null) {
            RequestContext request = new RequestContext();
            String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            request.put("userId", (Object)userId);
            clientHanlder.setRequestContext((Serializable)request);
        }
        return clientHanlder;
    }

    protected void saveBt_actionPerformed(ActionEvent e) throws Exception {
        ControlUtilities.checkFocusAndCommit();
        if (this.personInfo != null) {
            if (!this.validateShortCut()) {
                String msg = this.getResource("error_shortCut");
                MsgBox.showError((String)msg);
                return;
            }
            this.fillDataForSave();
            this.saveConfig();
            this.showMsg("saveOK");
        } else {
            this.alert("NoPerson");
        }
    }

    private boolean validateShortCut() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < this.kDTable1.getRowCount(); ++i) {
            IRow iRow = this.kDTable1.getRow(i);
            String shortCut = (String)iRow.getCell("shortCut").getValue();
            if (shortCut == null || shortCut.trim().length() <= 0) continue;
            if (map.containsKey(shortCut)) {
                return false;
            }
            map.put(shortCut, shortCut);
        }
        return true;
    }

    private void fillDataForSave() {
        this.personInfo.setEmail(this.txtEmail.getText());
        this.personInfo.setRtx(this.txtRtx.getText());
        this.personInfo.setCell(this.txtMobile.getText());
        if (this.userMsgConfigInfo != null) {
            this.userMsgConfigInfo.setReceiveCommon((this.Email0.isSelected() ? 1 : 0) + (this.rtx0.isSelected() ? 2 : 0) + (this.mobile0.isSelected() ? 4 : 0));
            this.userMsgConfigInfo.setReceiveImportant((this.Email1.isSelected() ? 1 : 0) + (this.rtx1.isSelected() ? 2 : 0) + (this.mobile1.isSelected() ? 4 : 0));
        }
        IRow row = null;
        Object functionObj = null;
        Object shortCutObj = null;
        CustomCMDShortCutInfo shortCutInfo = null;
        BizFunctionInfo bizFunctionInfo = null;
        UserInfo theUserInfo = null;
        CustomCMDShortCutCollection newCMDShortCutCol = new CustomCMDShortCutCollection();
        block0: for (int i = 0; i < this.kDTable1.getRowCount(); ++i) {
            row = this.kDTable1.getRow(i);
            functionObj = row.getCell("function").getValue();
            shortCutObj = row.getCell("shortCut").getValue();
            if (functionObj == null || shortCutObj == null || StringUtils.isEmpty((String)shortCutObj.toString())) continue;
            for (int j = 0; j < this.bizFunctionCol.size(); ++j) {
                if ("l3".equalsIgnoreCase(SysContext.getSysContext().getLocale().toString())) {
                    functionObj = STConverter.tc2sc((String)functionObj.toString());
                }
                if (!functionObj.toString().equals(this.bizFunctionCol.get(j).getFunction())) continue;
                bizFunctionInfo = new BizFunctionInfo();
                bizFunctionInfo.setId(BOSUuid.read((String)this.bizFunctionCol.get(j).getId().toString()));
                theUserInfo = new UserInfo();
                theUserInfo.setId(BOSUuid.read((String)this.userId));
                shortCutInfo = new CustomCMDShortCutInfo();
                shortCutInfo.setUser(theUserInfo);
                shortCutInfo.setBizFunction(bizFunctionInfo);
                shortCutInfo.setShortCut(shortCutObj.toString().charAt(0));
                newCMDShortCutCol.add(shortCutInfo);
                continue block0;
            }
        }
        if (newCMDShortCutCol.size() > 0) {
            this.cCMDShortCutCol.clear();
            this.cCMDShortCutCol.addCollection(newCMDShortCutCol);
        }
    }

    private void saveConfig() {
        try {
            IMsgFacade iMsgFacade = MsgFacadeFactory.getRemoteInstance();
            iMsgFacade.saveUserConfig(this.userId, this.personInfo, this.userMsgConfigInfo, this.cCMDShortCutCol);
            IMessageReceiveUser iReceive = MessageReceiveUserFactory.getRemoteInstance();
            MessageReceiveUserInfo info = new MessageReceiveUserInfo();
            info.setPerson(this.personInfo);
            info.setUser((UserInfo)this.comboReceiveUser.getSelectedItem());
            iReceive.addnew(info);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    protected void resetBt_actionPerformed(ActionEvent e) throws Exception {
        this.initData();
        this.initUI();
    }

    private void initData() throws Exception {
        this.userInfo = SysContext.getSysContext().getCurrentUserInfo();
        this.userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        if (!StringUtils.isEmpty((String)this.userId)) {
            this.personInfo = this.getPersonByUserId(this.userId);
            if (this.personInfo == null) {
                return;
            }
        } else {
            return;
        }
        this.userCol = this.getUserColByPersonId(this.personInfo.getId().toString());
        this.receiveUserInfo = this.getReceiveUser(this.personInfo.getId().toString());
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("userId", (Object)this.userId, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        IUserMessageConfig iUserMessageConfig = UserMessageConfigFactory.getRemoteInstance();
        UserMessageConfigCollection userMsgConfigCol = iUserMessageConfig.getUserMessageConfigCollection(viewInfo);
        if (userMsgConfigCol != null && userMsgConfigCol.size() > 0) {
            this.userMsgConfigInfo = userMsgConfigCol.get(0);
        } else {
            this.userMsgConfigInfo = new UserMessageConfigInfo();
            this.userMsgConfigInfo.setUserId(this.userId);
            this.userMsgConfigInfo.setReceiveCommon(7);
            this.userMsgConfigInfo.setReceiveImportant(7);
        }
        viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("function"));
        viewInfo.getSelector().add(new SelectorItemInfo("queryPanelClassName"));
        viewInfo.getSelector().add(new SelectorItemInfo("bizModule.*"));
        viewInfo.getSorter().add(new SorterItemInfo("bizModule.id"));
        viewInfo.getSorter().add(new SorterItemInfo("implClassName"));
        viewInfo.getSorter().add(new SorterItemInfo("function"));
        IBizFunction iBizFunction = BizFunctionFactory.getRemoteInstance();
        this.bizFunctionCol = iBizFunction.getBizFunctionCollection(viewInfo);
        viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("user", (Object)this.userId, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        ICustomCMDShortCut iCustomCMDShortCut = CustomCMDShortCutFactory.getRemoteInstance();
        this.cCMDShortCutCol = iCustomCMDShortCut.getCustomCMDShortCutCollection(viewInfo);
        viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("user", (Object)this.userId, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        IMessageSubscript iMessageSubscript = MessageSubscriptFactory.getRemoteInstance();
        this.messageSubscriptCol = iMessageSubscript.getMessageSubscriptCollection(viewInfo);
    }

    private PersonInfo getPersonByUserId(String userId) throws BOSException {
        PersonInfo personInfo = null;
        if (!StringUtils.isEmpty((String)userId)) {
            UserInfo userInfo = null;
            IUser iUser = UserFactory.getRemoteInstance();
            try {
                userInfo = iUser.getUserInfo((IObjectPK)new ObjectUuidPK(userId));
                if (userInfo != null && userInfo.getPerson() != null) {
                    IPerson iPerson = PersonFactory.getRemoteInstance();
                    personInfo = iPerson.getPersonInfo((IObjectPK)new ObjectUuidPK(userInfo.getPerson().getId().toString()));
                }
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
        }
        return personInfo;
    }

    private UserCollection getUserColByPersonId(String personId) throws BOSException {
        UserCollection userCol = null;
        if (!StringUtils.isEmpty((String)personId)) {
            IUser iUser = UserFactory.getRemoteInstance();
            userCol = iUser.getUserCollection("SELECT * WHERE person = '" + personId + "'");
        }
        return userCol;
    }

    private UserInfo getReceiveUser(String personId) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)personId)) {
            IMessageReceiveUser iReceive = MessageReceiveUserFactory.getRemoteInstance();
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.getSelector().add(new SelectorItemInfo("*"));
            viewInfo.getSelector().add(new SelectorItemInfo("user.*"));
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("person", (Object)personId));
            viewInfo.setFilter(filterInfo);
            MessageReceiveUserCollection receiveUserCol = iReceive.getMessageReceiveUserCollection(viewInfo);
            if (receiveUserCol.size() > 0) {
                return receiveUserCol.get(0).getUser();
            }
        }
        return null;
    }

    private void initUI() {
        try {
            UIManager.setLookAndFeel("com.kingdee.bos.ctrl.swing.plaf.KingdeeLookAndFeel");
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.saveBt.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.resetBt.setIcon(EASResource.getIcon((String)"imgTbtn_reset"));
        this.btnSchema.setIcon(EASResource.getIcon((String)"imgTbtn_duizsetting"));
        this.btnFormat.setIcon(EASResource.getIcon((String)"imgTbtn_modifyformat"));
        this.btnSubscribe.setIcon(EASResource.getIcon((String)"imgTbtn_savecollate"));
        this.btnUnsubscrible.setIcon(EASResource.getIcon((String)"imgTbtn_cancelcollate"));
        this.uiResHelper = new ResourceBundleHelper("com.kingdee.eas.mobile.client.UserConfigUIResources");
        this.localComboBox.removeAllItems();
        this.localComboBox.addItem((Object)this.uiResHelper.getString("local_us"));
        this.localComboBox.addItem((Object)this.uiResHelper.getString("local_zh_cn"));
        this.localComboBox.addItem((Object)this.uiResHelper.getString("local_zh_tw"));
        this.localComboBox.setVisible(false);
        this.kDLabelContainer3.setVisible(false);
        this.kDTable1.checkParsed();
        this.kDTable1.getColumn("module").getStyleAttributes().setLocked(true);
        this.kDTable1.getColumn("function").getStyleAttributes().setLocked(true);
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JComboBox)this.SHORTCUTS);
        this.kDTable1.getColumn("shortCut").setEditor((ICellEditor)cellEditor);
        if (this.userCol != null) {
            this.comboReceiveUser.removeAllItems();
            DefaultComboBoxModel<UserInfo> model = new DefaultComboBoxModel<UserInfo>();
            for (int i = 0; i < this.userCol.size(); ++i) {
                model.addElement(this.userCol.get(i));
            }
            this.comboReceiveUser.setModel(model);
        }
        this.initUIByData();
    }

    private void initUIByData() {
        this.txtRtx.setEnabled(false);
        if (StringUtils.isEmpty((String)this.userId) || this.personInfo == null) {
            this.txtEmail.setEnabled(false);
            this.txtMobile.setEnabled(false);
            this.txtRtx.setEnabled(false);
            this.localComboBox.setEnabled(false);
            this.saveBt.setEnabled(false);
            this.resetBt.setEnabled(false);
            this.Email0.setEnabled(false);
            this.Email1.setEnabled(false);
            this.rtx0.setEnabled(false);
            this.rtx1.setEnabled(false);
            this.mobile0.setEnabled(false);
            this.mobile1.setEnabled(false);
            this.Email0.setSelected(true);
            this.Email1.setSelected(true);
            this.rtx0.setSelected(true);
            this.rtx1.setSelected(true);
            this.mobile0.setSelected(true);
            this.mobile1.setSelected(true);
            this.comboReceiveUser.setEnabled(false);
            this.comboReceiveUser.setSelectedItem(null);
            this.alert("noPerson");
            return;
        }
        this.txtMobile.setText(this.personInfo.getCell());
        this.txtRtx.setText(this.personInfo.getRtx());
        this.txtEmail.setText(this.personInfo.getEmail());
        if (this.userMsgConfigInfo == null) {
            this.userMsgConfigInfo = new UserMessageConfigInfo();
            this.userMsgConfigInfo.setReceiveCommon(7);
            this.userMsgConfigInfo.setReceiveImportant(7);
        }
        switch (this.userMsgConfigInfo.getReceiveImportant()) {
            case 1: {
                this.Email1.setSelected(true);
                this.rtx1.setSelected(false);
                this.mobile1.setSelected(false);
                break;
            }
            case 2: {
                this.Email1.setSelected(false);
                this.rtx1.setSelected(true);
                this.mobile1.setSelected(false);
                break;
            }
            case 3: {
                this.Email1.setSelected(true);
                this.rtx1.setSelected(true);
                this.mobile1.setSelected(false);
                break;
            }
            case 4: {
                this.Email1.setSelected(false);
                this.rtx1.setSelected(false);
                this.mobile1.setSelected(true);
                break;
            }
            case 5: {
                this.Email1.setSelected(true);
                this.rtx1.setSelected(false);
                this.mobile1.setSelected(true);
                break;
            }
            case 6: {
                this.Email1.setSelected(false);
                this.rtx1.setSelected(true);
                this.mobile1.setSelected(true);
                break;
            }
            case 7: {
                this.Email1.setSelected(true);
                this.rtx1.setSelected(true);
                this.mobile1.setSelected(true);
                break;
            }
            default: {
                this.Email1.setSelected(false);
                this.rtx1.setSelected(false);
                this.mobile1.setSelected(false);
            }
        }
        switch (this.userMsgConfigInfo.getReceiveCommon()) {
            case 1: {
                this.Email0.setSelected(true);
                this.rtx0.setSelected(false);
                this.mobile0.setSelected(false);
                break;
            }
            case 2: {
                this.Email0.setSelected(false);
                this.rtx0.setSelected(true);
                this.mobile0.setSelected(false);
                break;
            }
            case 3: {
                this.Email0.setSelected(true);
                this.rtx0.setSelected(true);
                this.mobile0.setSelected(false);
                break;
            }
            case 4: {
                this.Email0.setSelected(false);
                this.rtx0.setSelected(false);
                this.mobile0.setSelected(true);
                break;
            }
            case 5: {
                this.Email0.setSelected(true);
                this.rtx0.setSelected(false);
                this.mobile0.setSelected(true);
                break;
            }
            case 6: {
                this.Email0.setSelected(false);
                this.rtx0.setSelected(true);
                this.mobile0.setSelected(true);
                break;
            }
            case 7: {
                this.Email0.setSelected(true);
                this.rtx0.setSelected(true);
                this.mobile0.setSelected(true);
                break;
            }
            default: {
                this.Email0.setSelected(false);
                this.rtx0.setSelected(false);
                this.mobile0.setSelected(false);
            }
        }
        if (this.receiveUserInfo != null) {
            this.comboReceiveUser.setSelectedItem((Object)this.receiveUserInfo);
        } else {
            this.comboReceiveUser.setSelectedItem((Object)this.userInfo);
        }
        this.kDTable1.removeRows();
        BizFunctionInfo bizFunctionInfo = null;
        IRow row = null;
        block18: for (int i = 0; i < this.bizFunctionCol.size(); ++i) {
            int j;
            bizFunctionInfo = this.bizFunctionCol.get(i);
            row = this.kDTable1.addRow();
            String module = bizFunctionInfo.getBizModule().getSendModule();
            if ("l3".equalsIgnoreCase(SysContext.getSysContext().getLocale().toString())) {
                module = STConverter.sc2tc((String)module);
            }
            row.getCell("module").setValue((Object)module);
            String function = bizFunctionInfo.getFunction();
            if ("l3".equalsIgnoreCase(SysContext.getSysContext().getLocale().toString())) {
                function = STConverter.sc2tc((String)function);
            }
            row.getCell("function").setValue((Object)function);
            for (j = 0; j < this.cCMDShortCutCol.size(); ++j) {
                if (!bizFunctionInfo.getId().toString().equals(this.cCMDShortCutCol.get(j).getBizFunction().getId().toString())) continue;
                row.getCell("shortCut").setValue((Object)(this.cCMDShortCutCol.get(j).getShortCut() + ""));
                break;
            }
            row.getCell("isSubscript").setValue((Object)new Boolean(false));
            for (j = 0; j < this.messageSubscriptCol.size(); ++j) {
                if (!bizFunctionInfo.getId().toString().equals(this.messageSubscriptCol.get(j).getBizFunction().getId().toString())) continue;
                row.getCell("isSubscript").setValue((Object)new Boolean(true));
                row.getCell("subscriptCycle").setValue((Object)this.messageSubscriptCol.get(j).getSubscriptCycle());
                row.getCell("jobProcessDefID").setValue((Object)this.messageSubscriptCol.get(j).getProcessDefID().toString());
                continue block18;
            }
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnTest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    IMessageSubscript iSubscript = MessageSubscriptFactory.getRemoteInstance();
                    iSubscript.execMessageSubscript("BycOwwEVEADgAAgHwKgS3AbrWng=");
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.btnTest.setVisible(false);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionSchema_actionPerformed(ActionEvent e) throws Exception {
        block3: {
            this.checkSelected();
            BizFunctionInfo functionInfo = this.getSelectedFunctionInfo();
            if (functionInfo == null || StringUtils.isEmpty((String)functionInfo.getQueryPanelClassName())) {
                this.alert("NO_QUERY_PANEL_CLASS");
                return;
            }
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"Owner", (Object)this);
            uiContext.put((Object)"userID", (Object)SysContext.getSysContext().getCurrentUserInfo().getId().toString());
            uiContext.put((Object)"functionID", (Object)functionInfo.getId().toString());
            uiContext.put((Object)"queryPanelClassName", (Object)functionInfo.getQueryPanelClassName());
            IUIFactory uiFactory = null;
            IUIWindow curDialog = null;
            try {
                uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
                curDialog = uiFactory.create(MobileQueryUI.class.getName(), (Map)uiContext);
                curDialog.show();
            }
            catch (Throwable ex) {
                if (!(ex instanceof Exception)) break block3;
                this.handleException((Exception)ex);
            }
        }
    }

    @Override
    protected void kDTable1_tableSelectChanged(KDTSelectEvent e) throws Exception {
        IRow row = this.kDTable1.getRow(this.kDTable1.getSelectManager().getActiveRowIndex());
        if (row != null) {
            boolean isSubscript = (Boolean)row.getCell("isSubscript").getValue();
            if (isSubscript) {
                this.btnUnsubscrible.setEnabled(true);
            } else {
                this.btnUnsubscrible.setEnabled(false);
            }
        }
    }

    private EASWfServiceClient getWorkflowClient() throws Exception {
        if (this.workflowClient == null) {
            this.workflowClient = new EASWfServiceClient();
            this.workflowClient.init(UIConfig.getUrl(), SysContext.getSysContext().getSessionID());
        }
        return this.workflowClient;
    }

    private FunctionObjectInfo getForewarnFunction() {
        MetaDataPK functionPK = new MetaDataPK("com.kingdee.eas.mobile.MessageSubscriptFunction");
        FunctionObjectInfo function = MetaDataLoaderFactory.getRemoteMetaDataLoader().getFunction((IMetaDataPK)functionPK);
        return function;
    }

    @Override
    public void actionSubscrible_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        boolean allowSubscript = false;
        IRow row = this.kDTable1.getRow(this.kDTable1.getSelectManager().getActiveRowIndex());
        Object functionObj = row.getCell("function").getValue();
        if ("l3".equalsIgnoreCase(SysContext.getSysContext().getLocale().toString())) {
            functionObj = STConverter.tc2sc((String)functionObj.toString());
        }
        String functionID = null;
        BizFunctionInfo functionInfo = null;
        for (int j = 0; j < this.bizFunctionCol.size(); ++j) {
            String tempFunctionID;
            if (!functionObj.toString().equals(this.bizFunctionCol.get(j).getFunction()) || !this.hasDefaultSchema(tempFunctionID = this.bizFunctionCol.get(j).getId().toString())) continue;
            functionInfo = this.bizFunctionCol.get(j);
            functionID = tempFunctionID;
            allowSubscript = true;
            break;
        }
        if (!allowSubscript) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.mobile.client.SmsResource", (String)"thismodlehavenoselect"));
            return;
        }
        String schedule = (String)row.getCell("subscriptCycle").getValue();
        if (!StringUtils.isEmpty((String)(schedule = ProcessSchedulePlan.open((Object)this, (String)schedule, (boolean)true)))) {
            MessageSubscriptInfo subscriptInfo = new MessageSubscriptInfo();
            String jobProcessDefID = null;
            for (int i = 0; i < this.messageSubscriptCol.size(); ++i) {
                MessageSubscriptInfo info = this.messageSubscriptCol.get(i);
                if (!info.getBizFunction().getId().toString().equals(functionID)) continue;
                subscriptInfo = info;
                jobProcessDefID = info.getProcessDefID().toString();
                break;
            }
            subscriptInfo.setSubscriptCycle(schedule);
            IMessageSubscript iSubscript = MessageSubscriptFactory.getRemoteInstance();
            if (jobProcessDefID != null) {
                iSubscript.update((IObjectPK)new ObjectUuidPK(subscriptInfo.getId().toString()), subscriptInfo);
                this.getWorkflowClient().updateProcessSchedule(jobProcessDefID, schedule);
                this.getWorkflowClient().setProcessDefEnable(jobProcessDefID, true);
            } else {
                subscriptInfo.setUser(this.userInfo);
                subscriptInfo.setBizFunction(functionInfo);
                IObjectPK subscriptPK = iSubscript.addnew(subscriptInfo);
                FunctionObjectInfo function = this.getForewarnFunction();
                OperationCollection operationCol = function.getOperation();
                OperationInfo operation = null;
                for (int i = 0; i < operationCol.size(); ++i) {
                    if (!operationCol.get(i).getName().equalsIgnoreCase("execMessageSubscript")) continue;
                    operation = operationCol.get(i);
                    break;
                }
                HashMap<String, String> jobContext = new HashMap<String, String>();
                jobContext.put("subscriptID", subscriptPK.toString());
                jobProcessDefID = this.getWorkflowClient().createJobProcessDef("messageSubscript_" + this.userInfo.getNumber() + "_" + functionObj.toString(), function, operation, jobContext, schedule, SysContext.getSysContext().getLocale());
                this.getWorkflowClient().setProcessDefEnable(jobProcessDefID, true);
                subscriptInfo.setId(BOSUuid.read((String)subscriptPK.toString()));
                subscriptInfo.setProcessDefID(BOSUuid.read((String)jobProcessDefID));
                iSubscript.update(subscriptPK, subscriptInfo);
                this.messageSubscriptCol.add(subscriptInfo);
            }
            row.getCell("isSubscript").setValue((Object)new Boolean(true));
            row.getCell("subscriptCycle").setValue((Object)schedule);
            row.getCell("jobProcessDefID").setValue((Object)jobProcessDefID);
            this.btnUnsubscrible.setEnabled(true);
        }
    }

    private boolean hasDefaultSchema(String functionID) throws Exception {
        IMobileMessageQuerySchema iQuerySchema = MobileMessageQuerySchemaFactory.getRemoteInstance();
        MobileMessageQuerySchemaInfo info = iQuerySchema.getDefaultSchemaByUserAndFunction(this.userId, functionID);
        return info != null;
    }

    @Override
    public void actionUnsubscrible_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        IRow row = this.kDTable1.getRow(this.kDTable1.getSelectManager().getActiveRowIndex());
        Object functionObj = row.getCell("function").getValue();
        if ("l3".equalsIgnoreCase(SysContext.getSysContext().getLocale().toString())) {
            functionObj = STConverter.tc2sc((String)functionObj.toString());
        }
        String functionID = null;
        for (int j = 0; j < this.bizFunctionCol.size(); ++j) {
            if (!functionObj.toString().equals(this.bizFunctionCol.get(j).getFunction())) continue;
            functionID = this.bizFunctionCol.get(j).getId().toString();
        }
        String subscriptID = null;
        MessageSubscriptInfo subscriptInfo = null;
        for (int j = 0; j < this.messageSubscriptCol.size(); ++j) {
            if (!this.messageSubscriptCol.get(j).getBizFunction().getId().toString().equals(functionID)) continue;
            subscriptInfo = this.messageSubscriptCol.get(j);
            subscriptID = subscriptInfo.getId().toString();
            this.messageSubscriptCol.remove(subscriptInfo);
        }
        if (subscriptID != null) {
            IMessageSubscript iSubscript = MessageSubscriptFactory.getRemoteInstance();
            iSubscript.delete((IObjectPK)new ObjectUuidPK(subscriptID));
        }
        String jobProcessDefID = (String)row.getCell("jobProcessDefID").getValue();
        this.getWorkflowClient().setProcessDefEnable(jobProcessDefID, false);
        row.getCell("isSubscript").setValue((Object)new Boolean(false));
        row.getCell("subscriptCycle").setValue(null);
        row.getCell("jobProcessDefID").setValue(null);
        this.btnUnsubscrible.setEnabled(false);
    }

    public void checkSelected() {
        if (this.kDTable1.getRowCount() == 0 || this.kDTable1.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    private BizFunctionInfo getSelectedFunctionInfo() throws Exception {
        IRow row = this.kDTable1.getRow(this.kDTable1.getSelectManager().getActiveRowIndex());
        String function = (String)row.getCell("function").getValue();
        if ("l3".equalsIgnoreCase(SysContext.getSysContext().getLocale().toString())) {
            function = STConverter.tc2sc((String)function);
        }
        for (int i = 0; i < this.bizFunctionCol.size(); ++i) {
            BizFunctionInfo functionInfo = this.bizFunctionCol.get(i);
            if (!function.equals(functionInfo.getFunction())) continue;
            return functionInfo;
        }
        return null;
    }

    private void alert(String key) {
        String s = this.getResource(key);
        MsgBox.showError((String)s);
    }

    private void showMsg(String key) {
        String s = this.getResource(key);
        MsgBox.showInfo((String)s);
    }

    private String getResource(String itemKey) {
        String resClassName = "com.kingdee.eas.mobile.client.UserConfigUIResources";
        return EASResource.getString((String)resClassName, (String)itemKey);
    }

    public void doLayout() {
        super.doLayout();
        int width = this.kDContainer1.getWidth();
        int columnNums = this.kDTable1.getColumnCount();
        for (int i = 0; i < columnNums; ++i) {
            int perWidth = width / columnNums;
            this.kDTable1.getColumn(i).setWidth(perWidth);
        }
    }

    protected void exitBt_actionPerformed(ActionEvent e) throws Exception {
        this.onExitClick();
    }

    private void onExitClick() {
        this.getUIWindow().close();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.Email0 && this.Email0.isSelected()) {
            this.Email1.setSelected(false);
        }
        if (e.getSource() == this.Email1 && this.Email1.isSelected()) {
            this.Email0.setSelected(false);
        }
        if (e.getSource() == this.rtx1 && this.rtx1.isSelected()) {
            this.rtx0.setSelected(false);
        }
        if (e.getSource() == this.rtx0 && this.rtx0.isSelected()) {
            this.rtx1.setSelected(false);
        }
        if (e.getSource() == this.mobile0 && this.mobile0.isSelected()) {
            this.mobile1.setSelected(false);
        }
        if (e.getSource() == this.mobile1 && this.mobile1.isSelected()) {
            this.mobile0.setSelected(false);
        }
    }
}

