/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.convert;

import com.kingdee.eas.framework.report.util.RptConditionManager;
import com.kingdee.eas.mobile.convert.ConvertUtil;
import com.kingdee.eas.mobile.convert.DecodeException;
import com.kingdee.eas.mobile.convert.EncodeException;
import com.kingdee.eas.mobile.convert.ObjectArrayXMLConvert;
import com.kingdee.eas.mobile.convert.util.EmptyUtil;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class ComponentStatusXMLConvert {
    public boolean canProcess(Class<?> clazz) {
        return RptConditionManager.ComponentStatus.class.isAssignableFrom(clazz);
    }

    public Element encode(Object obj) throws EncodeException {
        RptConditionManager.ComponentStatus componentStatus = (RptConditionManager.ComponentStatus)obj;
        Element root = DocumentHelper.createElement((String)"value");
        root.addElement("name").addText(componentStatus.getName());
        root.addElement("enabled").addText(String.valueOf(componentStatus.isEnabled()));
        Object value = componentStatus.getValue();
        if (EmptyUtil.isEmpty(value)) {
            return root;
        }
        root.addElement("valueType").addText(value.getClass().getName());
        if (new ObjectArrayXMLConvert().canProcess(value.getClass())) {
            ObjectArrayXMLConvert convert = new ObjectArrayXMLConvert();
            root.add(convert.encode(value));
        } else {
            root.addElement("value").addText(ConvertUtil.encode(value));
        }
        return root;
    }

    public Object decode(Element root) throws DecodeException {
        RptConditionManager.ComponentStatus componentStatus = new RptConditionManager.ComponentStatus();
        try {
            componentStatus.setName(root.elementText("name"));
            componentStatus.setEnabled(Boolean.valueOf(root.elementText("enabled")).booleanValue());
            String valueType = root.elementText("valueType");
            if (EmptyUtil.isEmpty(valueType)) {
                return componentStatus;
            }
            Class<?> clazz = Class.forName(valueType);
            if (new ObjectArrayXMLConvert().canProcess(clazz)) {
                ObjectArrayXMLConvert convert = new ObjectArrayXMLConvert();
                componentStatus.setValue(convert.decode(root.element("value")));
            } else {
                componentStatus.setValue(ConvertUtil.decode(clazz, root.elementText("value")));
            }
            return componentStatus;
        }
        catch (Exception e) {
            throw new DecodeException("RptParams\u89e3\u7801\u9519\u8bef\uff01", e);
        }
    }
}

