/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.convert;

import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mobile.convert.ConvertUtil;
import com.kingdee.eas.mobile.convert.DecodeException;
import com.kingdee.eas.mobile.convert.EncodeException;
import com.kingdee.eas.mobile.convert.util.EmptyUtil;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class ObjectArrayXMLConvert {
    public boolean canProcess(Class<?> clazz) {
        return clazz.getName().equals("[Ljava.lang.Object;");
    }

    public Element encode(Object obj) throws EncodeException {
        Element root = DocumentHelper.createElement((String)"value");
        Object[] objs = (Object[])obj;
        if (EmptyUtil.isEmpty(objs)) {
            return root;
        }
        if (objs[0] instanceof CoreBaseInfo) {
            CoreBaseInfo[] coreBaseInfoArray = this.convert2CoreBaseInfoArray(objs);
            root.addElement("type").addText(coreBaseInfoArray.getClass().getName());
            root.addElement("value").addText(ConvertUtil.encode(coreBaseInfoArray));
        }
        return root;
    }

    private CoreBaseInfo[] convert2CoreBaseInfoArray(Object[] objs) {
        CoreBaseInfo[] coreBaseInfos = new CoreBaseInfo[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            coreBaseInfos[i] = (CoreBaseInfo)objs[i];
        }
        return coreBaseInfos;
    }

    public Object decode(Element root) throws DecodeException {
        try {
            String type = root.elementText("type");
            if (type == null) {
                return new Object[0];
            }
            Class<?> clazzObj = Class.forName(type);
            return ConvertUtil.decode(clazzObj, root.elementText("value"));
        }
        catch (Exception e) {
            throw new DecodeException("RptParams\u89e3\u7801\u9519\u8bef\uff01", e);
        }
    }
}

