/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.msg.client;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mobile.msg.SendUserMsgFactory;
import com.kingdee.eas.mobile.msg.SendUserMsgInfo;
import com.kingdee.eas.mobile.msg.client.AbstractMySmsUI;
import com.kingdee.eas.mobile.msg.client.CreateSendUserMsgException;
import com.kingdee.util.Uuid;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;

public class MySmsUI
extends AbstractMySmsUI {
    String userid = SysContext.getSysContext().getCurrentUserInfo().getId().toString();

    public MySmsUI() throws Exception {
        this.initUI();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void initUI() {
        this.actionSave.setVisible(false);
        this.actionCancel.setVisible(false);
        this.actionAbout.setVisible(false);
        this.actionCancelCancel.setVisible(false);
        this.actionCopy.setVisible(false);
        this.actionFirst.setVisible(false);
        this.actionHelp.setVisible(false);
        this.actionLast.setVisible(false);
        this.actionNext.setVisible(false);
        this.actionOnLoad.setVisible(false);
        this.actionPageSetup.setVisible(false);
        this.actionPre.setVisible(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.actionSubmit.setVisible(false);
    }

    public void verifyInput(ActionEvent e) throws CreateSendUserMsgException {
        String address = this.genAddress();
        if (address == null || address.trim().length() == 0) {
            throw new CreateSendUserMsgException(CreateSendUserMsgException.NUMBERISNULL);
        }
        String[] numbers = address.split(",");
        int length = numbers.length;
        ArrayList errorNumbers = new ArrayList(length);
        for (int i = 0; i < numbers.length; ++i) {
            String number = numbers[i];
            if (number == null || number.trim().equals("")) continue;
            this.verifyNumber(number);
        }
        if (length > 11) {
            throw new CreateSendUserMsgException(CreateSendUserMsgException.TOOMANYNUMBER);
        }
        if (errorNumbers.size() > 0) {
            throw new CreateSendUserMsgException(CreateSendUserMsgException.NUMBERERROR, errorNumbers.toArray(new String[0]));
        }
        String msg = this.areaTitle.getText();
        if (msg == null || msg.trim().equals("")) {
            throw new CreateSendUserMsgException(CreateSendUserMsgException.CONTENTISNULL);
        }
        if (msg.trim().length() > 200) {
            throw new CreateSendUserMsgException(CreateSendUserMsgException.TOOLONGMSGTITLE);
        }
    }

    private void verifyNumber(String number) throws CreateSendUserMsgException {
        if ((number = number.trim()).startsWith("13")) {
            if (number.length() != 11) {
                throw new CreateSendUserMsgException(CreateSendUserMsgException.NUMBERERROR, new String[]{number});
            }
            for (int i = 0; i < 11; ++i) {
                if (number.charAt(i) >= '0' && number.charAt(i) <= '9') continue;
                throw new CreateSendUserMsgException(CreateSendUserMsgException.NUMBERERROR, new String[]{number});
            }
            return;
        }
        if (number.startsWith("8613")) {
            if (number.length() != 13) {
                throw new CreateSendUserMsgException(CreateSendUserMsgException.NUMBERERROR, new String[]{number});
            }
            for (int i = 0; i < 13; ++i) {
                if (number.charAt(i) >= '0' && number.charAt(i) <= '9') continue;
                throw new CreateSendUserMsgException(CreateSendUserMsgException.NUMBERERROR, new String[]{number});
            }
            return;
        }
        throw new CreateSendUserMsgException(CreateSendUserMsgException.NUMBERERROR, new String[]{number});
    }

    private String genAddress() {
        StringBuffer buf = new StringBuffer(140);
        String address = this.txtAddress.getText();
        if (address != null) {
            buf.append(address);
        }
        return buf.toString();
    }

    protected IObjectValue createNewData() {
        if (this.editData == null) {
            this.editData = new SendUserMsgInfo();
            this.editData.setUserid(this.userid);
            this.editData.setPriority(3);
            this.editData.setMsgId(Uuid.create().toString());
            String numbers = this.genAddress();
            this.editData.setAddress(numbers);
            this.editData.setTitle(this.areaTitle.getText());
            this.editData.setCreateTime(new Timestamp(new Date().getTime()));
            this.editData.setMsgType(1);
            this.editData.setSented(false);
            if (this.chkRevertible.isSelected()) {
                this.editData.setRevertible(true);
            } else {
                this.editData.setRevertible(false);
            }
        }
        return this.editData;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return SendUserMsgFactory.getRemoteInstance();
    }

    @Override
    protected void confirmBt_actionPerformed(ActionEvent e) throws Exception {
        this.actionSubmit_actionPerformed(e);
    }

    @Override
    protected void canCelBt_actionPerformed(ActionEvent e) throws Exception {
        this.actionExitCurrent_actionPerformed(e);
    }
}

