/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.msg.framework;

import com.kingdee.bos.message.common.KDMessage;
import com.kingdee.bos.message.common.KDMessageAddress;
import com.kingdee.bos.message.common.KDMimeType;
import com.kingdee.eas.mobile.msg.framework.MessageModifier;
import com.kingdee.util.Configuration;
import com.kingdee.util.ConfigurationItem;
import org.apache.log4j.Logger;

public class DefaultMessageModifier
extends MessageModifier {
    private static final Logger logger = Logger.getLogger(DefaultMessageModifier.class);
    private static final String EMAIL = "mp:mail";
    private static final String SMS = "mp:sms";
    private static final char SPLIT_CHAR = ' ';
    private static final int MAX_CHARAS_PER_LINE = 200;

    @Override
    public KDMessage modifier(KDMessage message) {
        KDMessageAddress[] receivers = message.getReceivers();
        if (receivers == null || receivers[0] == null) {
            return message;
        }
        String msgType = receivers[0].getDeviceName();
        boolean isRevertible = message.isRevertible();
        if (receivers == null || receivers.length == 0) {
            return message;
        }
        if (EMAIL.equalsIgnoreCase(msgType)) {
            String txtBody = message.getContent();
            StringBuffer buf = new StringBuffer();
            if (txtBody != null) {
                buf.append(DefaultMessageModifier.format(txtBody));
            }
            Configuration config = Configuration.getInstance();
            ConfigurationItem sln = config.getConfigItem("PortalInfo");
            logger.info((Object)"-----DefaultMessageModifier----");
            if (isRevertible && sln != null) {
                String isAppend = sln.getProperty("isAppendOtherNotice");
                if (isAppend != null && isAppend.trim().equalsIgnoreCase("false")) {
                    logger.info((Object)"-----isAppend-false----");
                } else {
                    logger.info((Object)"-----isAppend-true----");
                    buf.append("\r\n \u76f4\u63a5\u56de\u590d\u8be5\u90ae\u4ef6\uff0c\u90ae\u4ef6\u6b63\u6587\u683c\u5f0f:Y/N \u610f\u89c1");
                    if (sln != null) {
                        String url = sln.getProperty("host");
                        String port = sln.getProperty("port");
                        if (url != null && port != null && url.trim().length() > 1 && port.trim().length() > 1) {
                            String contentURI = "http://" + url + ":" + port + "/index.jsp?redirectTo=SYS_MC";
                            buf.append("\r\n\u6216\u8005\u70b9\u51fb<a href='").append(contentURI).append("'>").append(contentURI).append("</a>");
                        }
                    }
                }
            }
            message.setContent(buf.toString());
        } else if (SMS.equalsIgnoreCase(receivers[0].getDeviceName()) && message.isRevertible()) {
            String title = message.getTitle();
            if (title == null) {
                return message;
            }
            StringBuffer buf = new StringBuffer(title);
            buf.append("\u56de\u590d\u683c\u5f0f:Y/N \u610f\u89c1");
            message.setTitle(buf.toString());
        }
        message.setMimeType(KDMimeType.HTML);
        return message;
    }

    private static final String format(String txt) {
        StringBuffer buf = new StringBuffer();
        int length = txt.length();
        int pos = 0;
        while (pos < length) {
            int start = 0;
            int end = 0;
            boolean isMatched = false;
            for (int i = 0; (i < 200 || isMatched) && pos < length; ++pos, ++i) {
                char c = txt.charAt(pos);
                switch (c) {
                    case '\r': {
                        start = i;
                        isMatched = true;
                        break;
                    }
                    case '\n': {
                        end = i;
                        break;
                    }
                    default: {
                        buf.append(c);
                    }
                }
                if (i - start > 1) {
                    isMatched = false;
                }
                if (end - start == 1) break;
            }
            buf.append("\r\n");
        }
        return buf.toString();
    }

    public static void main(String[] args) {
        String s = "\u4f60\u597d\r\n   \u4eb2\u7231\u7684XX,\u5f88\u4e45\u4e0d\u89c1\uff0c\u751a\u4e3a\u60f3\u5ff5!\r\n\u4ee5\u524d\u7684\u65e5\u5b50\u54c8\u54c8\u54c8\u54c8\u54c8\u54c8\u54c8\u54c8\u771f\u6709\u4e59\u70ef\u662f\u7801\u4e8b\u7684\u6e05\u95f2\u54c8\u54c8\u54c8\u54c8\u54c8\u54c8\u54c8\u54c8\u54c8\u6d12\u6d12\u6d12\u6d12\u6d12\u6d12\u6d12\u6d12\u6d12\u6d12\u6d12\u6d12\u6d12\u6d12\u6d12\u6d12\u6d12\u6d12\u6d12\u6d12\u6d12\u6d12\u6d12\r\n\u54c8\u54c8\u54c8\u54c8\u54c8\u54c8";
        System.out.println(s);
        System.out.println(DefaultMessageModifier.format(s));
    }
}

