/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.msg.ormrpc;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.Context;
import com.kingdee.bos.orm.ORMCoreException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.mobile.UserInfo;
import com.kingdee.eas.mobile.dao.DBHelper;
import com.kingdee.eas.mobile.dao.UserInfoDao;
import com.kingdee.eas.mobile.msg.IUserConfig;
import com.kingdee.eas.mobile.msg.UserCommandInfo;
import com.kingdee.eas.mobile.msg.dao.DaoFactory;
import java.sql.Connection;
import org.apache.log4j.Logger;

public class UserConfig
extends AbstractBOSObject
implements IUserConfig {
    private Logger logger = Logger.getLogger(UserConfig.class);

    public UserConfig() {
        super.registerInterface(IUserConfig.class, (Object)this);
    }

    public UserConfig(Context context) {
        super(context);
        super.registerInterface(IUserConfig.class, (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveUser(UserInfo userinfo, UserCommandInfo[] shotCuts) throws ORMCoreException {
        Context ctx = this.getContext();
        boolean success = false;
        Connection con = null;
        try {
            con = DBHelper.getConnection(ctx);
            boolean statue = con.getAutoCommit();
            con.setAutoCommit(false);
            try {
                success = DaoFactory.getUserInfoDao().saveUser(userinfo, shotCuts, con, ctx.getAIS());
                con.commit();
            }
            catch (Exception ex) {
                con.rollback();
            }
            con.setAutoCommit(statue);
        }
        catch (Exception ex) {
            this.logger.error((Object)ex.getMessage());
        }
        finally {
            DBHelper.cleanup(con);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserCommandInfo[] getUserCommands(String userid) throws ORMCoreException {
        Context ctx = this.getContext();
        UserCommandInfo[] infos = new UserCommandInfo[]{};
        Connection con = null;
        try {
            con = DBHelper.getConnection(ctx);
            infos = DaoFactory.getUserInfoDao().getUserCommands(userid, ctx.getAIS(), con);
        }
        catch (Exception exception) {
        }
        finally {
            DBHelper.cleanup(con);
        }
        return infos;
    }

    public BOSObjectType getType() {
        return IUserConfig.BOSTYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserInfo getUserInfo(String userid) throws ORMCoreException {
        this.logger.info((Object)("getUserUserInfo:" + userid));
        UserInfoDao dao = DaoFactory.getUserInfoDao();
        UserInfo info = new UserInfo();
        Connection con = null;
        try {
            con = DBHelper.getConnection(this.getContext());
            info = dao.getUserInfo(userid, con, true);
        }
        catch (Exception ex) {
            this.logger.error((Object)ex.getMessage());
        }
        finally {
            DBHelper.cleanup(con);
        }
        return info;
    }
}

