/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.cust.client;

import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import javax.swing.Icon;
import javax.swing.tree.MutableTreeNode;

public class WFOrgTreeUtil {
    private static final Icon groupIcon = EASResource.getIcon((String)"imgTree_group");
    private static final Icon companyIcon = EASResource.getIcon((String)"imgTree_company");
    private static final Icon folderIcon = EASResource.getIcon((String)"imgTree_folder_leaf");
    static MetaDataPK queryPK = MetaDataPK.create((String)"com.kingdee.eas.basedata.org.app.NewAdminTreeQuery");
    static IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);

    public static KDTreeNode buildOrgTree(String rootId) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        if (rootId == null) {
            fi.getFilterItems().add(new FilterItemInfo("parent.id is null"));
            fi.getFilterItems().add(new FilterItemInfo("Level = 2"));
            fi.setMaskString("#0 or #1");
        } else {
            fi.getFilterItems().add(new FilterItemInfo("id = '" + rootId + "' "));
            fi.getFilterItems().add(new FilterItemInfo("parent.id = '" + rootId + "' "));
            fi.setMaskString("#0 or #1");
        }
        viewInfo.setFilter(fi);
        queryExcu.setObjectView(viewInfo);
        IRowSet rows = queryExcu.executeQuery();
        KDTreeNode rootTreeNode = WFOrgTreeUtil.buildTreeNodeByRowSet(null, rows);
        return rootTreeNode;
    }

    private static KDTreeNode buildTreeNodeByRowSet(KDTreeNode rootTreeNode, IRowSet rows) throws Exception {
        if (rows == null) {
            return null;
        }
        KDTreeNode subTreeNode = null;
        AdminOrgUnitInfo adminInfo = null;
        rows.beforeFirst();
        while (rows.next()) {
            adminInfo = WFOrgTreeUtil.createAdminUnitInfo(rows);
            if (rootTreeNode == null) {
                rootTreeNode = new KDTreeNode((Object)adminInfo);
                rootTreeNode.setCustomIcon(groupIcon);
                rootTreeNode.setVirtual(true);
                continue;
            }
            subTreeNode = new KDTreeNode((Object)adminInfo);
            if (!adminInfo.isIsLeaf()) {
                subTreeNode.setVirtual(true);
                subTreeNode.add((MutableTreeNode)new KDTreeNode((Object)""));
                subTreeNode.setCustomIcon(companyIcon);
            } else {
                subTreeNode.setCustomIcon(folderIcon);
            }
            rootTreeNode.add((MutableTreeNode)subTreeNode);
        }
        return rootTreeNode;
    }

    private static AdminOrgUnitInfo createAdminUnitInfo(IRowSet row) throws Exception {
        AdminOrgUnitInfo adminInfo = new AdminOrgUnitInfo();
        adminInfo.setId(BOSUuid.read((String)row.getString("ID")));
        adminInfo.setName(row.getString("Name"));
        adminInfo.setLongNumber(row.getString("LongNumber"));
        adminInfo.setIsLeaf(row.getBoolean("IsLeaf"));
        adminInfo.setLevel(row.getInt("Level"));
        adminInfo.setNumber(row.getString("number"));
        adminInfo.setDisplayName(row.getString("displayName"));
        AdminOrgUnitInfo parentInfo = new AdminOrgUnitInfo();
        if (StringUtils.isEmpty((String)row.getString("parent.id"))) {
            parentInfo = null;
        } else {
            parentInfo.setId(BOSUuid.read((String)row.getString("parent.id")));
        }
        adminInfo.setParent(parentInfo);
        return adminInfo;
    }

    public static void buildChildNode(KDTreeNode parentNode) throws Exception {
        if (parentNode.isVirtual()) {
            parentNode.setVirtual(false);
            parentNode.removeAllChildren();
            if (!(parentNode.getUserObject() instanceof AdminOrgUnitInfo)) {
                return;
            }
            AdminOrgUnitInfo adminInfo = (AdminOrgUnitInfo)parentNode.getUserObject();
            String parentid = adminInfo.getId().toString();
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            if (parentid == null || "".equals(parentid)) {
                return;
            }
            fi.getFilterItems().add(new FilterItemInfo("parent.id = '" + parentid + "' "));
            viewInfo.setFilter(fi);
            queryExcu.setObjectView(viewInfo);
            IRowSet rows = queryExcu.executeQuery();
            WFOrgTreeUtil.buildTreeNodeByRowSet(parentNode, rows);
        }
    }
}

