/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.cust.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.workflow.cust.WFRoleType;
import com.kingdee.bos.workflow.cust.client.AbstractWFPersonRoleQueryUI;
import com.kingdee.bos.workflow.cust.client.WFRoleListUI;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.person.client.PersonPromptBox;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public class WFPersonRoleQueryUI
extends AbstractWFPersonRoleQueryUI {
    private static final Logger logger = CoreUIObject.getLogger(WFPersonRoleQueryUI.class);
    private static String resClassName = "com.kingdee.bos.workflow.cust.WFRoleResource";

    public WFPersonRoleQueryUI() throws Exception {
        this.tblMain.setEnabled(false);
        this.tblMain.checkParsed();
        this.actionViewRole.setEnabled(true);
        this.tblMain.getSelectManager().setSelectMode(2);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.personF7.setSelector((KDPromptSelector)new PersonPromptBox());
    }

    @Override
    public void actionQueryPerson_actionPerformed(ActionEvent e) throws Exception {
        Object personObject = this.personF7.getValue();
        this.tblMain.removeRows();
        if (personObject != null && !StringUtils.isEmpty((String)personObject.toString())) {
            IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.bos.workflow.cust.app", "WFRoleQuery"));
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            if (personObject instanceof PersonInfo) {
                PersonInfo person = (PersonInfo)personObject;
                String personId = person.getId().toString();
                filterInfo.getFilterItems().add(new FilterItemInfo("id in (select froleid from T_WFR_PERSONROLE where FPSERSONID='" + personId + "' or fdelepersonid='" + personId + "')"));
                filterInfo.getFilterItems().add(new FilterItemInfo("id in (select froleid from T_WFR_POSITIONROLE role inner join T_ORG_PositionMember pm on role.fpositionId=pm.fpositionId where pm.fpersonId='" + personId + "' or role.fdelepersonId='" + personId + "')"));
                filterInfo.setMaskString("#0 or #1");
            } else if (personObject instanceof String) {
                String object = "%" + (String)personObject + "%";
                filterInfo.getFilterItems().add(new FilterItemInfo("PersonEntrys.PersonID.number", (Object)object, CompareType.LIKE));
                filterInfo.getFilterItems().add(new FilterItemInfo("PersonEntrys.DelePersonID.number", (Object)object, CompareType.LIKE));
                filterInfo.getFilterItems().add(new FilterItemInfo("PositionEntrys.DelePersonID.number", (Object)object, CompareType.LIKE));
                filterInfo.setMaskString("(#0 or #1 or #2)");
            }
            viewInfo.setFilter(filterInfo);
            exec.setObjectView(viewInfo);
            IRowSet rs = exec.executeQuery();
            ArrayList<String> ids = new ArrayList<String>();
            while (rs.next()) {
                String id = rs.getString("id");
                if (ids.contains(id)) continue;
                ids.add(id);
                IRow row = this.tblMain.addRow();
                row.getCell("id").setValue((Object)id);
                row.getCell("number").setValue((Object)rs.getString("number"));
                row.getCell("roleName").setValue((Object)rs.getString("roleName"));
                switch (rs.getInt("RoleType")) {
                    case 2: {
                        row.getCell("roleType").setValue((Object)WFRoleType.ORGROLE);
                        break;
                    }
                    case 0: {
                        row.getCell("roleType").setValue((Object)WFRoleType.PERSONROLE);
                        break;
                    }
                    case 1: {
                        row.getCell("roleType").setValue((Object)WFRoleType.POSITIONROLE);
                        break;
                    }
                }
            }
        } else {
            MsgBox.showWarning((String)EASResource.getString((String)resClassName, (String)"query_person"));
            SysUtil.abort();
        }
    }

    @Override
    public void actionViewRole_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        Map context = this.getUIContext();
        Object objectUI = context.get("Owner");
        if (objectUI == null || !(objectUI instanceof WFRoleListUI)) {
            throw new Exception("context.get(Owner)\u4e3a\u7a7a\u6216\u4e0d\u662fWFRoleListUI\uff0c\u5f02\u5e38\u64cd\u4f5c");
        }
        WFRoleListUI listUI = (WFRoleListUI)((Object)objectUI);
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        listUI.viewRole(e, row.getCell("id").getValue().toString(), (WFRoleType)((Object)row.getCell("roleType").getValue()));
    }

    public void checkSelected() {
        if (this.tblMain.getRowCount() == 0) {
            MsgBox.showWarning((String)EASResource.getString((String)resClassName, (String)"queryPersonNotFound"));
            SysUtil.abort();
        } else if (this.tblMain.getSelectManager().size() == 0) {
            MsgBox.showWarning((String)EASResource.getString((String)resClassName, (String)"selectTip"));
            SysUtil.abort();
        } else if (this.tblMain.getSelectManager().size() > 1) {
            MsgBox.showWarning((String)EASResource.getString((String)resClassName, (String)"selectOnlyOne"));
            SysUtil.abort();
        }
    }

    public Dimension preferredSize() {
        Dimension newSize = super.preferredSize();
        newSize.width = (int)this.getBounds().getWidth();
        newSize.height = (int)this.getBounds().getHeight();
        return newSize;
    }
}

