/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.cust.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.databinding.DataBinder;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.workflow.cust.WFRoleGroupEntrysInfo;
import com.kingdee.bos.workflow.cust.WFRoleGroupFactory;
import com.kingdee.bos.workflow.cust.WFRoleGroupInfo;
import com.kingdee.bos.workflow.cust.WFRoleInfo;
import com.kingdee.bos.workflow.cust.client.AbstractWFRoleGroupEditUI;
import com.kingdee.bos.workflow.cust.client.WFRoleClientUtils;
import com.kingdee.bos.workflow.cust.client.WFRoleF7PromptBox;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.multiDetail.DetailPanel;
import com.kingdee.eas.framework.client.multiDetail.HMDUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class WFRoleGroupEditUI
extends AbstractWFRoleGroupEditUI {
    private static final Logger logger = CoreUIObject.getLogger(WFRoleGroupEditUI.class);
    protected DetailPanel kdtEntrys_detailPanel = null;
    private static String resClassName = "com.kingdee.bos.workflow.cust.WFRoleResource";

    protected IObjectValue createNewData() {
        WFRoleGroupInfo objectValue = new WFRoleGroupInfo();
        return objectValue;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return WFRoleGroupFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        this.kdtEntrys_detailPanel = (DetailPanel)HMDUtils.buildDetail((CoreUI)this, (DataBinder)this.dataBinder, (KDTable)this.kdtEntrys, (AbstractObjectValue)new WFRoleGroupEntrysInfo(), null, (boolean)false);
        this.add((Component)this.kdtEntrys_detailPanel, new KDLayout.Constraints(10, 110, 750, 415, 15));
        this.kdtEntrys.checkParsed();
        super.onLoad();
        this.initEditAndRemoveBtn();
        KDTSortManager sortManager = new KDTSortManager(this.kdtEntrys);
        sortManager.setSortAuto(true);
        sortManager.setClickCount(1);
        for (int i = 0; i < this.kdtEntrys.getColumnCount(); ++i) {
            this.kdtEntrys.getColumn(i).setSortable(true);
        }
    }

    public void initEditAndRemoveBtn() {
        if (this.editData.getCreator() == null) {
            return;
        }
        if (this.editData.getCreator().getId().equals((Object)SysContext.getSysContext().getCurrentUserInfo().getId()) || SysContext.getSysContext().getCurrentUserInfo().getId().toString().equals(WFRoleClientUtils.ADMINISTRATOR)) {
            this.actionEdit.setEnabled(true);
            this.actionRemove.setEnabled(true);
        } else {
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(false);
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        this.runByOnShowAfter();
    }

    public void runByOnShowAfter() throws BOSException, EASBizException, Exception {
        KDBizPromptBox roleF7 = new KDBizPromptBox();
        roleF7.setSelector((KDPromptSelector)new WFRoleF7PromptBox());
        this.kdtEntrys.getColumn("role").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)roleF7));
        roleF7.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                KDBizPromptBox F7 = (KDBizPromptBox)e.getSource();
                KDTSelectBlock selected = WFRoleGroupEditUI.this.kdtEntrys.getSelectManager().get();
                if (selected == null) {
                    return;
                }
                int selectedRow = selected.getBeginRow();
                WFRoleInfo info = null;
                if (F7.getValue() instanceof WFRoleInfo[]) {
                    info = ((WFRoleInfo[])F7.getValue())[0];
                } else if (F7.getValue() instanceof WFRoleInfo) {
                    info = (WFRoleInfo)F7.getValue();
                }
                for (int i = 0; i < WFRoleGroupEditUI.this.kdtEntrys.getRowCount(); ++i) {
                    if (i == selectedRow) continue;
                    IRow row = WFRoleGroupEditUI.this.kdtEntrys.getRow(i);
                    if (info == null || row.getCell("role").getValue() == null || !info.getId().equals((Object)((WFRoleInfo)row.getCell("role").getValue()).getId())) continue;
                    MsgBox.showWarning((String)EASResource.getString((String)resClassName, (String)"roleExistInFenlu"));
                    F7.setValue(null);
                    info = null;
                }
                if (selectedRow >= 0) {
                    ICell cell1 = WFRoleGroupEditUI.this.kdtEntrys.getRow(selectedRow).getCell("number");
                    ICell cell2 = WFRoleGroupEditUI.this.kdtEntrys.getRow(selectedRow).getCell("roleType");
                    ICell cell3 = WFRoleGroupEditUI.this.kdtEntrys.getRow(selectedRow).getCell("roleState");
                    if (info != null) {
                        if (cell1 != null) {
                            cell1.setValue((Object)info.getNumber());
                        }
                        if (cell2 != null) {
                            cell2.setValue((Object)info.getRoleType());
                        }
                        if (cell3 != null) {
                            cell3.setValue((Object)info.getState());
                        }
                    } else {
                        if (cell1 != null) {
                            cell1.setValue(null);
                        }
                        if (cell2 != null) {
                            cell2.setValue(null);
                        }
                        if (cell3 != null) {
                            cell3.setValue(null);
                        }
                    }
                }
            }
        });
    }

    @Override
    public void loadFields() {
        this.dataBinder.registerBinding("entrys.RoleID", WFRoleInfo.class, (Component)this.kdtEntrys, "role.text");
        this.setAutoNumberByOrg("NONE");
        super.loadFields();
        for (int i = 0; i < this.kdtEntrys.getRowCount(); ++i) {
            WFRoleInfo info;
            ICell cell = this.kdtEntrys.getRow(i).getCell("role");
            if (cell == null || (info = (WFRoleInfo)cell.getValue()) == null) continue;
            ICell cell1 = this.kdtEntrys.getRow(i).getCell("number");
            ICell cell2 = this.kdtEntrys.getRow(i).getCell("roleType");
            ICell cell3 = this.kdtEntrys.getRow(i).getCell("roleState");
            if (cell1 != null) {
                cell1.setValue((Object)info.getNumber());
            }
            if (cell2 != null) {
                cell2.setValue((Object)info.getRoleType());
            }
            if (cell3 == null) continue;
            cell3.setValue((Object)info.getState());
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("entrys.RoleID.id"));
        sic.add(new SelectorItemInfo("entrys.RoleID.RoleName"));
        sic.add(new SelectorItemInfo("entrys.RoleID.RoleType"));
        sic.add(new SelectorItemInfo("entrys.RoleID.number"));
        sic.add(new SelectorItemInfo("entrys.RoleID.state"));
        sic.add(new SelectorItemInfo("creator"));
        return sic;
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        if (this.txtNumber.getText().trim().length() == 0) {
            MsgBox.showWarning((String)EASResource.getString((String)resClassName, (String)"roleGrNumIsNotNull"));
            SysUtil.abort();
        }
        if (this.txtName.getText().trim().length() == 0) {
            MsgBox.showWarning((String)EASResource.getString((String)resClassName, (String)"roleGrNameIsNotNull"));
            SysUtil.abort();
        }
        if (this.kdtEntrys.getRowCount() == 0) {
            MsgBox.showWarning((String)EASResource.getString((String)resClassName, (String)"fenLuIsNotNull"));
            SysUtil.abort();
        }
        for (int i = 0; i < this.kdtEntrys.getRowCount(); ++i) {
            ICell cell = this.kdtEntrys.getRow(i).getCell("role");
            if (cell.getValue() == null) {
                MsgBox.showWarning((String)EASResource.getString((String)resClassName, (String)"roleIsNotNull"));
                SysUtil.abort();
            }
            if ((cell = this.kdtEntrys.getRow(i).getCell("number")).getValue() != null) continue;
            MsgBox.showWarning((String)EASResource.getString((String)resClassName, (String)"roleNumIsNotNull"));
            SysUtil.abort();
        }
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.bos.workflow.cust.app", "WFRoleGroupQuery"));
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)this.txtNumber.getText()));
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)this.editData.getId(), CompareType.NOTEQUALS));
        viewInfo.setFilter(filterInfo);
        exec.setObjectView(viewInfo);
        int count = exec.getRowCount();
        if (count > 0) {
            MsgBox.showWarning((String)EASResource.getString((String)resClassName, (String)"roleGrNumIsExist"));
            SysUtil.abort();
        }
    }

    protected void setAutoNumberByOrg(String orgType) {
        if (this.editData == null) {
            return;
        }
        if (this.editData.getNumber() == null) {
            try {
                String companyID = null;
                if (!StringUtils.isEmpty((String)orgType) && !"NONE".equalsIgnoreCase(orgType) && SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)orgType)) != null) {
                    companyID = SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)orgType)).getString("id");
                } else if (SysContext.getSysContext().getCurrentOrgUnit() != null) {
                    companyID = SysContext.getSysContext().getCurrentOrgUnit().getString("id");
                }
                ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
                if (iCodingRuleManager.isExist((IObjectValue)this.editData, companyID)) {
                    if (iCodingRuleManager.isAddView((IObjectValue)this.editData, companyID)) {
                        this.editData.setNumber(iCodingRuleManager.getNumber((IObjectValue)this.editData, companyID));
                    }
                    this.txtNumber.setEnabled(false);
                }
            }
            catch (Exception e) {
                this.handUIException(e);
                this.oldData = this.editData;
                SysUtil.abort();
            }
        } else if (this.editData.getNumber().trim().length() > 0) {
            this.txtNumber.setText(this.editData.getNumber());
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (WFRoleClientUtils.checkRoleInProc(this.editData.getId().toString())) {
            MsgBox.showWarning((String)EASResource.getString((String)resClassName, (String)"groupRefInProc"));
            SysUtil.abort();
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.editData.getId().toString());
        if (WFRoleClientUtils.checkRoleGroupInStartScheme(list).size() != 0) {
            MsgBox.showWarning((String)EASResource.getString((String)resClassName, (String)"groupQuotedBySS"));
            SysUtil.abort();
        }
        super.actionRemove_actionPerformed(e);
    }

    protected void showSaveSuccess() {
        String msg = null;
        String msg_Next = null;
        String res = null;
        String res2 = null;
        Object[] objs = null;
        res = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_TemporarilySave_OK_New");
        objs = new Object[]{this.getClassAlise()};
        msg = MessageFormat.format(res, objs);
        msg = msg.replace(EASResource.getString((String)resClassName, (String)"hold"), EASResource.getString((String)resClassName, (String)"save"));
        this.setMessageText(msg);
        res2 = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Edit_New");
        msg_Next = MessageFormat.format(res2, objs);
        this.setNextMessageText(msg_Next);
        this.setShowMessagePolicy(0);
        this.setIsShowTextOnly(false);
        this.showMessage();
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        this.editData.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        super.actionCopy_actionPerformed(e);
    }
}

