/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.cm.client;

import com.kingdee.bos.ctrl.extendcontrols.ext.FilterInfoProducerFactory;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.extendcontrols.ext.OrgUnitFilterInfoProducer;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.uiframe.client.UIModelDialog;
import com.kingdee.eas.base.uiframe.client.UINewFrame;
import com.kingdee.eas.basedata.cm.CostItemException;
import com.kingdee.eas.basedata.cm.CostItemFactory;
import com.kingdee.eas.basedata.cm.CostItemInfo;
import com.kingdee.eas.basedata.cm.ICostItem;
import com.kingdee.eas.basedata.cm.client.AbstractCostItemEditUI;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.math.BigDecimal;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class CostItemEditUI
extends AbstractCostItemEditUI {
    private static final long serialVersionUID = 4681390305367855623L;
    private final String nullstring = "";
    KDTree treeMain = null;
    CostItemInfo parent = null;

    public void onShow() throws Exception {
        super.onShow();
        this.menuBar.setEnabled(true);
        this.menuBar.setVisible(true);
        this.setResizble(false, this.uiWindow);
    }

    private void setResizble(boolean b, IUIWindow uiWindow) {
        if (uiWindow == null) {
            return;
        }
        Window win = SwingUtilities.getWindowAncestor((JComponent)uiWindow.getUIObject());
        if (win instanceof UINewFrame) {
            ((UINewFrame)win).setResizable(false);
        } else if (win instanceof UIModelDialog) {
            ((UIModelDialog)win).setResizable(false);
        }
    }

    protected void txtCostItemCode_focusLost(FocusEvent e) throws Exception {
        super.txtCostItemCode_focusLost(e);
        String code = this.txtCostItemCode.getStringValue();
        if (code == null) {
            return;
        }
    }

    public void storeFields() {
        super.storeFields();
    }

    protected IObjectValue createNewData() {
        CostItemInfo newinfo = new CostItemInfo();
        newinfo.setDeletedStatus(DeletedStatusEnum.NORMAL);
        CompanyOrgUnitInfo companyOrg = SysContext.getSysContext().getCurrentFIUnit();
        if (!companyOrg.isIsBizUnit()) {
            companyOrg = null;
        }
        newinfo.setCompanyOrgUnit(companyOrg);
        return newinfo;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        OrgUnitFilterInfoProducer oufip = (OrgUnitFilterInfoProducer)FilterInfoProducerFactory.getOrgUnitFilterInfoProducer((OrgType)OrgType.Company);
        oufip.getModel().setIsCUFilter(true);
        this.prmtcompanyOrgUnit.setFilterInfoProducer((IFilterInfoProducer)oufip);
        this.treeMain = (KDTree)this.getUIContext().get("tree");
        this.storeFields();
        super.initOldData((IObjectValue)this.editData);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CostItemFactory.getRemoteInstance();
    }

    private void setCopyEnabled(boolean isEnabled) {
        this.btnCopy.setEnabled(isEnabled);
        this.menuItemCopy.setEnabled(isEnabled);
        this.actionCopy.setEnabled(isEnabled);
    }

    private void setAddNewEnabled(boolean isEnabled) {
        this.btnAddNew.setEnabled(isEnabled);
        this.menuItemAddNew.setEnabled(isEnabled);
        this.actionAddNew.setEnabled(isEnabled);
        this.btnSubmit.setEnabled(isEnabled);
        this.menuItemSubmit.setEnabled(isEnabled);
        this.actionSubmit.setEnabled(isEnabled);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.txtCostItemCode.setEnabled(false);
        this.txtCostItemName.setEnabled(true);
        this.comboCostItemType.setEnabled(true);
        this.kDBizMultiLangArea1.setEnabled(true);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (!this.editData.isIsLeaf()) {
            super.handUIExceptionAndAbort((Exception)((Object)new CostItemException(CostItemException.EXC_ITEM_NOT_LEAF_DEL)));
        }
        super.actionRemove_actionPerformed(e);
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        if (this.prmtcompanyOrgUnit.getValue() == null) {
            this.prmtcompanyOrgUnit.requestFocus();
            super.handUIExceptionAndAbort((Exception)((Object)new CostItemException(CostItemException.EXC_ITEM_COMPANY_NULL)));
        }
        if (this.txtCostItemCode.getText().equals(this.nullstring)) {
            this.txtCostItemCode.requestFocus();
            super.handUIExceptionAndAbort((Exception)((Object)new CostItemException(CostItemException.EXC_ITEM_CODE_NULL)));
        }
        if (this.txtCostItemName.getText().equals(this.nullstring)) {
            this.txtCostItemName.requestFocus();
            super.handUIExceptionAndAbort((Exception)((Object)new CostItemException(CostItemException.EXC_ITEM_NAME_NULL)));
        }
        if (this.comboCostItemType.getSelectedItem() == null) {
            this.comboCostItemType.requestFocus();
            super.handUIExceptionAndAbort((Exception)((Object)new CostItemException(CostItemException.EXC_ITEM_TYPE_NULL)));
        }
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        CostItemInfo parent = this.editData.getParent();
        String longNumber = this.editData.getLongNumber();
        int level = this.editData.getLevel();
        super.actionCopy_actionPerformed(e);
        this.txtCostItemCode.setText(this.nullstring);
        this.txtCostItemName.setText(this.nullstring);
        this.kDCheckBox1.setSelected(false);
        if (parent != null && parent.getId() != null) {
            this.txtParentID.setText(parent.getId().toString());
        }
        this.txtLongNumber.setText(longNumber);
        this.txtLevel.setText(BigDecimal.valueOf(level).toString());
    }

    public void loadFields() {
        Object o;
        if (this.getOprtState().equalsIgnoreCase("ADDNEW") && this.editData.getCompanyOrgUnit() == null && (o = this.getUIContext().get("ParentNode")) != null) {
            CompanyOrgUnitInfo companyOrgUnitInfo = null;
            ObjectStringPK pk = new ObjectStringPK(((CostItemInfo)o).getId().toString());
            try {
                ICostItem iCostItem = CostItemFactory.getRemoteInstance();
                ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance();
                companyOrgUnitInfo = iCostItem.getCostItemInfo((IObjectPK)pk).getCompanyOrgUnit();
                pk = new ObjectStringPK(companyOrgUnitInfo.getId().toString());
                companyOrgUnitInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)pk);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.editData.setCompanyOrgUnit(companyOrgUnitInfo);
        }
        super.loadFields();
        if (this.getOprtState().equalsIgnoreCase("ADDNEW")) {
            this.txtCostItemCode.setEnabled(true);
            this.comboCostItemType.setSelectedIndex(0);
        } else {
            this.txtCostItemCode.setEnabled(false);
        }
        if (this.editData.getParent() == null) {
            this.setCopyEnabled(false);
        } else {
            this.setCopyEnabled(true);
        }
        if (this.editData == null || this.editData.getId() == null) {
            this.setCopyEnabled(false);
        }
        this.storeFields();
        super.initOldData((IObjectValue)this.editData);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getParent() == null) {
            Object o = this.getUIContext().get("parent");
            if (o instanceof CostItemInfo) {
                this.parent = (CostItemInfo)o;
                this.editData.setParent(this.parent);
            } else {
                String id = this.txtParentID.getText();
                if (id != null && id.length() != 0) {
                    ICostItem costItem = CostItemFactory.getRemoteInstance();
                    this.parent = costItem.getCostItemInfo((IObjectPK)new ObjectStringPK(id));
                    this.editData.setParent(this.parent);
                }
            }
        }
        super.actionSubmit_actionPerformed(e);
        ICostItem iCostItem = CostItemFactory.getRemoteInstance();
        if (!this.getOprtState().equals(OprtState.ADDNEW)) {
            this.refreshModifyTreeNode(this.treeMain, iCostItem.getCostItemInfo((IObjectPK)new ObjectUuidPK(this.editData.getId())));
        }
        if (this.editData.getParent() == null) {
            this.setAddNewEnabled(false);
        }
        this.storeFields();
        super.initOldData((IObjectValue)this.editData);
    }

    private void refreshModifyTreeNode(KDTree tree, CostItemInfo modifyInfo) {
        if (tree == null) {
            return;
        }
        DefaultKingdeeTreeNode mNode = null;
        DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
        DefaultKingdeeTreeNode selectNode = this.getSelectTreeNode(tree);
        if (selectNode != null) {
            CostItemInfo selectInfo = (CostItemInfo)selectNode.getUserObject();
            mNode = modifyInfo.getId().equals((Object)selectInfo.getId()) ? selectNode : this.getModifyTreeNode(selectNode, modifyInfo);
        }
        if (mNode != null) {
            mNode.setText(modifyInfo.toString());
            mNode.setUserObject((Object)modifyInfo);
            treeModel.reload((TreeNode)mNode);
            tree.expandPath(new TreePath(mNode.getPath()));
            tree.setSelectionNode(mNode);
        }
    }

    private DefaultKingdeeTreeNode getSelectTreeNode(KDTree tree) {
        TreePath path;
        DefaultKingdeeTreeNode selectNode = null;
        if (tree != null && (path = tree.getSelectionPath()) != null) {
            selectNode = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        }
        return selectNode;
    }

    private DefaultKingdeeTreeNode getModifyTreeNode(DefaultKingdeeTreeNode selectNode, CostItemInfo info) {
        for (int i = 0; i < selectNode.getChildCount(); ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)selectNode.getChildAt(i);
            BOSUuid unitId = ((CostItemInfo)node.getUserObject()).getId();
            if (info.getId().equals((Object)unitId)) {
                return node;
            }
            this.getModifyTreeNode(node, info);
        }
        return null;
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        this.storeFields();
        super.initOldData((IObjectValue)this.editData);
    }

    public boolean isModify() {
        if (this.btnSubmit.isEnabled()) {
            return super.isModify();
        }
        return false;
    }
}

