/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.cm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.basedata.cm.CostItemEnum;
import com.kingdee.eas.basedata.cm.CostItemException;
import com.kingdee.eas.basedata.cm.CostItemFactory;
import com.kingdee.eas.basedata.cm.CostItemInfo;
import com.kingdee.eas.basedata.cm.ICostItem;
import com.kingdee.eas.basedata.cm.client.AbstractCostItemListUI;
import com.kingdee.eas.basedata.cm.client.CMCommonQueryProcessor;
import com.kingdee.eas.basedata.cm.client.CostItemEditUI;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.common.client.UIFactoryName;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.client.F7Render;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class CostItemListUI
extends AbstractCostItemListUI
implements KDPromptSelector {
    private static final Logger logger = CoreUIObject.getLogger((Class)CostItemListUI.class);
    private static final String RESOURCE_FILE_NAME = "com.kingdee.eas.basedata.cm.client.PBResource";
    private CommonQueryDialog dialog = null;
    private boolean initialized = false;
    private boolean isF7Use;
    private boolean isOnlyShowLeaf = true;
    private int deletedStatus = 1;
    private CompanyOrgUnitInfo companyOrgUnitInfo = null;
    private CostItemEnum costItemType = null;
    private CompareType costItemCompareType = CompareType.EQUALS;
    private F7Render f7Delegate;
    private boolean isRedirect = false;
    private boolean isTreeValueChangedFirst = true;

    public CostItemListUI() throws Exception {
    }

    public CostItemListUI(CompanyOrgUnitInfo companyOrgUnitInfo, boolean isOnlyShowLeaf) throws Exception {
        this();
        this.companyOrgUnitInfo = companyOrgUnitInfo;
        this.isOnlyShowLeaf = isOnlyShowLeaf;
    }

    public CostItemListUI(CompanyOrgUnitInfo companyOrgUnitInfo, boolean isOnlyShowLeaf, int deleteStatus) throws Exception {
        this();
        this.companyOrgUnitInfo = companyOrgUnitInfo;
        this.isOnlyShowLeaf = isOnlyShowLeaf;
        this.deletedStatus = deleteStatus;
    }

    public CostItemListUI(CompanyOrgUnitInfo companyOrgUnitInfo, boolean isOnlyShowLeaf, CostItemEnum costItemType) throws Exception {
        this();
        this.companyOrgUnitInfo = companyOrgUnitInfo;
        this.isOnlyShowLeaf = isOnlyShowLeaf;
        this.costItemType = costItemType;
    }

    public CostItemListUI(CompanyOrgUnitInfo companyOrgUnitInfo, boolean isOnlyShowLeaf, CostItemEnum costItemType, CompareType costItemCompareType, int deleteStatus) throws Exception {
        this();
        this.companyOrgUnitInfo = companyOrgUnitInfo;
        this.isOnlyShowLeaf = isOnlyShowLeaf;
        this.costItemType = costItemType;
        this.costItemCompareType = costItemCompareType;
        this.deletedStatus = deleteStatus;
    }

    public CostItemListUI(HashMap ctx) throws Exception {
        this.isF7Use = true;
        this.f7Delegate = new F7Render((ListUI)this, (Map)ctx);
        this.f7Delegate.init();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        ArrayList selectblock = this.tblMain.getSelectManager().getBlocks();
        for (int i = 0; i < selectblock.size(); ++i) {
            KDTSelectBlock temb = (KDTSelectBlock)selectblock.get(i);
            if (temb == null) continue;
            int rx = temb.getBeginRow();
            int ry = temb.getEndRow();
            for (int j = rx; j <= ry; ++j) {
                if (((Boolean)this.tblMain.getRow(j).getCell("isLeaf").getValue()).booleanValue()) continue;
                super.handUIExceptionAndAbort((Exception)((Object)new CostItemException(CostItemException.EXC_ITEM_NOT_LEAF_DEL)));
            }
        }
        super.actionRemove_actionPerformed(e);
        this.initTree();
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.dialog != null) {
            return this.dialog;
        }
        this.dialog = super.initCommonQueryDialog();
        CMCommonQueryProcessor cmcq = new CMCommonQueryProcessor();
        cmcq.set("id", "CostItemListUI");
        cmcq.set("companyOrg", SysContext.getSysContext().getCurrentFIUnit());
        this.dialog.setProcessor((IProcessor)cmcq);
        return this.dialog;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.actionRefresh_actionPerformed(e);
        this.treeMain_valueChanged(null);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        super.actionView_actionPerformed(e);
        this.actionRefresh_actionPerformed(e);
        this.treeMain_valueChanged(null);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.doUnApprove();
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.doApprove();
    }

    private void doApprove() throws Exception {
        ICostItem info = CostItemFactory.getRemoteInstance();
        super.checkSelected();
        String pkid = this.getSelectedKeyValue();
        ObjectUuidPK pk = new ObjectUuidPK(pkid);
        CostItemInfo counteryInfo = info.getCostItemInfo((IObjectPK)pk);
        if (counteryInfo.getDeletedStatus() == DeletedStatusEnum.DELETED) {
            info.cancelCancel((IObjectPK)pk, (CoreBaseInfo)counteryInfo);
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE_FILE_NAME, (String)"enableSuccessed"));
        }
        this.refreshList();
        this.tblMain.getCell(this.tblMain.getSelectManager().get().getTop(), "deletedStatus").setValue((Object)DeletedStatusEnum.NORMAL);
    }

    private void doUnApprove() throws Exception {
        ICostItem info = CostItemFactory.getRemoteInstance();
        super.checkSelected();
        String pkid = this.getSelectedKeyValue();
        ObjectUuidPK pk = new ObjectUuidPK(pkid);
        CostItemInfo counteryInfo = info.getCostItemInfo((IObjectPK)pk);
        if (counteryInfo.getDeletedStatus() == DeletedStatusEnum.NORMAL) {
            info.cancel((IObjectPK)pk, (CoreBaseInfo)counteryInfo);
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE_FILE_NAME, (String)"disableSuccessed"));
        }
        this.refreshList();
        this.tblMain.getCell(this.tblMain.getSelectManager().get().getTop(), "deletedStatus").setValue((Object)DeletedStatusEnum.DELETED);
    }

    protected String getEditUIName() {
        return CostItemEditUI.class.getName();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        DefaultKingdeeTreeNode selectNode;
        FilterInfo filter = new FilterInfo();
        TreePath path = this.treeMain.getSelectionPath();
        if (path != null && (selectNode = (DefaultKingdeeTreeNode)path.getLastPathComponent()) != null && selectNode.getUserObject() != null) {
            CostItemInfo selectInfo = (CostItemInfo)selectNode.getUserObject();
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)selectInfo.getLongNumber(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(selectInfo.getLongNumber() + "!%"), CompareType.LIKE));
            filter.setMaskString("(#0 or #1)");
        }
        if (this.isF7Use) {
            if (this.isOnlyShowLeaf) {
                FilterInfo filter1 = new FilterInfo();
                String isLeaf = "1";
                isLeaf = this.isOnlyShowLeaf ? "1" : "0";
                filter1.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)isLeaf, CompareType.EQUALS));
                try {
                    filter.mergeFilter(filter1, "and");
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (this.deletedStatus != -1) {
                FilterInfo filter2 = new FilterInfo();
                filter2.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)Integer.toString(this.deletedStatus), CompareType.EQUALS));
                try {
                    filter.mergeFilter(filter2, "and");
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (this.companyOrgUnitInfo != null) {
                FilterInfo filter3 = new FilterInfo();
                filter3.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)this.companyOrgUnitInfo.getId().toString(), CompareType.EQUALS));
                try {
                    filter.mergeFilter(filter3, "and");
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (this.costItemType != null) {
                FilterInfo filter4 = new FilterInfo();
                filter4.getFilterItems().add(new FilterItemInfo("costItemType", (Object)this.costItemType.getValue(), this.costItemCompareType));
                try {
                    filter.mergeFilter(filter4, "and");
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return filter;
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return CostItemFactory.getRemoteInstance();
    }

    public void initTree() throws Exception {
        CtrlUnitInfo cu = SysContext.getSysContext().getCurrentCtrlUnit();
        String cuID = cu.getId().toString();
        if (cu == null) {
            throw new CostItemException(CostItemException.MUST_ENTER_CU);
        }
        ICostItem iCostItem = CostItemFactory.getRemoteInstance();
        String companyOrgUnitID = null;
        if (this.companyOrgUnitInfo != null) {
            companyOrgUnitID = this.companyOrgUnitInfo.getId().toString();
        }
        IRowSet rows = iCostItem.buildTreeRowSetByCUFilter(cuID, companyOrgUnitID);
        DefaultKingdeeTreeNode root = CostItemListUI.buildOUTreeByRowSet(rows);
        this.treeMain.setModel((TreeModel)new DefaultTreeModel((TreeNode)root));
        this.treeMain.setRootVisible(true);
        this.treeMain.setShowsRootHandles(true);
        this.treeMain.setSelectionNode(root);
        if (root == null) {
            this.treeMain_valueChanged(null);
        }
    }

    public static DefaultKingdeeTreeNode buildOUTreeByRowSet(IRowSet rowset) throws BOSException {
        if (rowset == null) {
            return null;
        }
        if (rowset.size() == 0) {
            return null;
        }
        DefaultKingdeeTreeNode rootTreeNode = null;
        HashMap<String, DefaultKingdeeTreeNode> nodeMap = new HashMap<String, DefaultKingdeeTreeNode>();
        try {
            while (rowset.next()) {
                String parentID;
                CostItemInfo costItemInfo = CostItemListUI.createCostItemInfo(rowset);
                if (rootTreeNode == null) {
                    rootTreeNode = new DefaultKingdeeTreeNode((Object)costItemInfo);
                    nodeMap.put(costItemInfo.getId().toString(), rootTreeNode);
                    continue;
                }
                DefaultKingdeeTreeNode subTreeNode = new DefaultKingdeeTreeNode((Object)costItemInfo);
                if (costItemInfo.getParent() != null && costItemInfo.getParent().getId() != null && nodeMap.containsKey(parentID = costItemInfo.getParent().getId().toString())) {
                    ((DefaultKingdeeTreeNode)nodeMap.get(parentID)).add((MutableTreeNode)subTreeNode);
                }
                nodeMap.put(costItemInfo.getId().toString(), subTreeNode);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return rootTreeNode;
    }

    private static CostItemInfo createCostItemInfo(IRowSet row) throws SQLException {
        CostItemInfo costItemInfo = new CostItemInfo();
        costItemInfo.setId(BOSUuid.read((String)row.getString("id")));
        costItemInfo.setNumber(row.getString("number"));
        costItemInfo.setName(row.getString("name"));
        costItemInfo.setDescription(row.getString("description"));
        costItemInfo.setLevel(row.getInt("level1"));
        costItemInfo.setLongNumber(row.getString("longNumber"));
        costItemInfo.setIsLeaf(row.getBoolean("isLeaf"));
        String parentId = row.getString("parentID");
        if (parentId != null) {
            CostItemInfo parentInfo = new CostItemInfo();
            parentInfo.setId(BOSUuid.read((String)parentId));
            costItemInfo.setParent(parentInfo);
        }
        return costItemInfo;
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.initTree();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        Object o;
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)this.treeMain.getLastSelectedPathComponent();
        if (treeNode == null) {
            // empty if block
        }
        super.actionAddNew_actionPerformed(e);
        CostItemInfo info = null;
        if (treeNode != null && (o = treeNode.getUserObject()) instanceof CostItemInfo) {
            info = (CostItemInfo)o;
        }
        String id = null;
        if (info != null && info.getId() != null) {
            id = info.getId().toString();
        }
        this.initTree();
        DefaultKingdeeTreeNode selectedNode = this.searchTreeNodeById((DefaultKingdeeTreeNode)this.treeMain.getModel().getRoot(), id);
        if (selectedNode != null) {
            this.treeMain.expandPath(new TreePath(selectedNode.getPath()));
            this.treeMain.setSelectionNode(selectedNode);
            this.onTblMainSelected();
        }
    }

    private DefaultKingdeeTreeNode searchTreeNodeById(DefaultKingdeeTreeNode root, String id) {
        if (root == null) {
            return null;
        }
        if (id == null) {
            return null;
        }
        if (root.getUserObject() == null) {
            return null;
        }
        String rootId = ((CostItemInfo)root.getUserObject()).getId().toString();
        if (id.equals(rootId)) {
            return root;
        }
        int childCount = root.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            DefaultKingdeeTreeNode node = this.searchTreeNodeById((DefaultKingdeeTreeNode)root.getChildAt(i), id);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        if (this.isRedirect) {
            this.isRedirect = false;
            return;
        }
        TreePath path = this.treeMain.getSelectionPath();
        if (path != null) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = this.getDefaultFilterForQuery();
            viewInfo.getSorter().add(new SorterItemInfo("longNumber"));
            viewInfo.setFilter(filter);
            if (!this.initialized) {
                if (this.mainQuery != null && this.mainQuery.getFilter() != null) {
                    filter.mergeFilter(this.mainQuery.getFilter(), "and");
                }
                this.initialized = true;
            }
            this.mainQuery = viewInfo;
        } else {
            this.mainQuery = null;
        }
        this.tblMain.removeRows();
        this.isTreeValueChangedFirst = true;
        int rows = this.tblMain.getRowCount();
        if (rows != 0) {
            this.tblMain.getSelectManager().select(0, 0);
        }
    }

    public void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        if (this.isTreeValueChangedFirst) {
            this.setVisibleStatus();
            this.isTreeValueChangedFirst = false;
        } else {
            this.onTblMainSelected();
        }
    }

    private void onTblMainSelected() {
        if (this.tblMain.getRowCount() == 0) {
            return;
        }
        this.setVisibleStatus();
        KDTSelectBlock block = this.tblMain.getSelectManager().get();
        if (block != null) {
            DefaultKingdeeTreeNode node;
            String id = (String)this.tblMain.getCell(block.getBeginRow(), "id").getValue();
            TreeModel treeModel = this.treeMain.getModel();
            if (treeModel != null && treeModel.getRoot() != null && (node = this.redirectFromTableToTree(id, (DefaultKingdeeTreeNode)treeModel.getRoot())) != null) {
                this.isRedirect = true;
                this.treeMain.setSelectionNode(node);
            }
        }
    }

    private void setVisibleStatus() {
        if (this.tblMain.getRowCount() == 0) {
            return;
        }
        this.menuItemEdit.setVisible(this.btnEdit.isVisible());
        this.menuItemRemove.setVisible(this.btnRemove.isVisible());
        this.btnEdit.setEnabled(this.btnEdit.isVisible());
        this.btnRemove.setEnabled(this.btnRemove.isVisible());
        this.menuItemEdit.setEnabled(this.menuItemEdit.isVisible());
        this.menuItemRemove.setEnabled(this.menuItemRemove.isVisible());
    }

    private DefaultKingdeeTreeNode redirectFromTableToTree(String id, DefaultKingdeeTreeNode root) {
        if (root == null) {
            return null;
        }
        if (root.getUserObject() != null && root.getUserObject() instanceof FullOrgUnitInfo && id.equals(((FullOrgUnitInfo)root.getUserObject()).getId().toString())) {
            return root;
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultKingdeeTreeNode node = this.redirectFromTableToTree(id, (DefaultKingdeeTreeNode)root.getChildAt(i));
            if (node == null) continue;
            return node;
        }
        return null;
    }

    protected void refresh(ActionEvent e) throws Exception {
    }

    protected String getEditUIModal() {
        return UIFactoryName.MODEL;
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        DefaultKingdeeTreeNode selectNode;
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)"tree", (Object)this.treeMain);
        TreePath path = this.treeMain.getSelectionPath();
        if (path != null && (selectNode = (DefaultKingdeeTreeNode)path.getLastPathComponent()) != null && selectNode.getUserObject() != null) {
            CostItemInfo selectInfo = (CostItemInfo)selectNode.getUserObject();
            uiContext.put((Object)"parent", (Object)selectInfo.getParent());
        }
    }

    public void setF7Use(boolean isF7Use, HashMap ctx) {
        this.isF7Use = isF7Use;
        if (isF7Use) {
            try {
                this.setPreferredSize(new Dimension(700, 400));
                this.setButtonsVisible(false);
                if (ctx == null) {
                    ctx = new HashMap();
                }
                this.f7Delegate = new F7Render((ListUI)this, ctx);
                this.f7Delegate.init();
                this.initLayout();
            }
            catch (Exception e) {
                e.printStackTrace();
                SysUtil.abort();
            }
        }
    }

    private void setButtonsVisible(boolean isVisible) {
        this.btnAddNew.setVisible(isVisible);
        this.btnEdit.setVisible(isVisible);
        this.btnRemove.setVisible(isVisible);
        this.btnCancel.setVisible(isVisible);
        this.btnCancelCancel.setVisible(isVisible);
        this.btnPrint.setVisible(isVisible);
        this.btnPrintPreview.setVisible(isVisible);
        this.btnQuery.setVisible(isVisible);
        this.btnLocate.setVisible(isVisible);
        this.menuBar.setVisible(isVisible);
        this.menuBar.setEnabled(isVisible);
    }

    public void show() {
        if (this.isF7Use) {
            this.f7Delegate.show();
        } else {
            super.show();
        }
    }

    protected boolean isIgnoreCUFilter() {
        if (this.isF7Use) {
            return !this.f7Delegate.isF7HasCuDefaultFilter();
        }
        return super.isIgnoreCUFilter();
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor f7QueryExecutor;
        if (this.isF7Use && this.mainQueryPK.equals(queryPK) && (f7QueryExecutor = this.f7Delegate.getF7QueryExecutor(queryPK, viewInfo)) != null) {
            return f7QueryExecutor;
        }
        return super.getQueryExecutor(queryPK, viewInfo);
    }

    protected void beforeExcutQuery(EntityViewInfo queryFilter) {
        super.beforeExcutQuery(queryFilter);
        if (this.isF7Use) {
            this.f7Delegate.mergeF7Filter(queryFilter);
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2 && this.isF7Use) {
            this.f7Delegate.actionConfirm();
        } else {
            if (e.getType() == 1) {
                this.onTblMainSelected();
            }
            super.tblMain_tableClicked(e);
        }
    }

    public boolean isCanceled() {
        return this.f7Delegate.isF7Cancel();
    }

    public Object getData() {
        return this.f7Delegate.getF7Data();
    }

    public boolean isOnlyShowLeaf() {
        return this.isOnlyShowLeaf;
    }

    public void setOnlyShowLeaf(boolean isOnlyShowLeaf) {
        this.isOnlyShowLeaf = isOnlyShowLeaf;
    }

    public CompanyOrgUnitInfo getCompanyOrgUnitInfo() {
        return this.companyOrgUnitInfo;
    }

    public void setCompanyOrgUnitInfo(CompanyOrgUnitInfo companyOrgUnitInfo) {
        this.companyOrgUnitInfo = companyOrgUnitInfo;
    }
}

