/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.cm.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.cm.CostItemEnum;
import com.kingdee.eas.basedata.cm.IMaterialCostItemRelation;
import com.kingdee.eas.basedata.cm.MaterialCostItemRelationCheckResult;
import com.kingdee.eas.basedata.cm.MaterialCostItemRelationException;
import com.kingdee.eas.basedata.cm.MaterialCostItemRelationFactory;
import com.kingdee.eas.basedata.cm.MaterialCostItemRelationInfo;
import com.kingdee.eas.basedata.cm.MaterialCostItemRelationMaterialInfo;
import com.kingdee.eas.basedata.cm.client.AbstractMaterialCostItemRelationEditUI;
import com.kingdee.eas.basedata.cm.client.f7Utils.CostItemHelper;
import com.kingdee.eas.basedata.cm.util.BDUtils;
import com.kingdee.eas.basedata.cm.util.BdCMClientHelper;
import com.kingdee.eas.basedata.cm.util.MultiBaseDataAdapter;
import com.kingdee.eas.basedata.cm.util.MultiBaseDataManager;
import com.kingdee.eas.basedata.cm.util.MultiMaterialProcessor;
import com.kingdee.eas.basedata.cm.util.client.BDClientUtils;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.multiDetail.DetailPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class MaterialCostItemRelationEditUI
extends AbstractMaterialCostItemRelationEditUI {
    private static final Logger logger = CoreUIObject.getLogger((Class)MaterialCostItemRelationEditUI.class);
    private static final String ENTRY_FIELD_MATERIAL = "material";
    Component[] entryButtons = null;
    DetailPanel panel = null;

    protected ICoreBase getBizInterface() throws Exception {
        return MaterialCostItemRelationFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        MaterialCostItemRelationInfo objectValue = new MaterialCostItemRelationInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        CompanyOrgUnitInfo companyOrg = SysContext.getSysContext().getCurrentFIUnit();
        if (!companyOrg.isIsBizUnit()) {
            companyOrg = (CompanyOrgUnitInfo)this.getBizOrgUnitInfo();
        }
        objectValue.setCompanyOrgUnit(companyOrg);
        return objectValue;
    }

    protected OrgUnitInfo getBizOrgUnitInfo() {
        String addNewPermItemName = null;
        OrgType orgType = this.getMainBizOrgType();
        return BDClientUtils.getBizOrgUnitInfo(addNewPermItemName, orgType, this.getMainOrgContext());
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnSave.setVisible(false);
        this.menuBiz.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.btnCancel.setVisible(false);
        if ("ADDNEW".equals(this.getOprtState())) {
            this.addLine();
        }
        OrgUnitInfo mainOrgInfo = (OrgUnitInfo)this.getMainOrgContext().get((Object)this.getMainBizOrgType());
        MultiBaseDataManager mbdm = new MultiBaseDataManager();
        MultiMaterialProcessor mmp = MultiMaterialProcessor.getInstance((Component)((Object)this), this.kdtMaterial, ENTRY_FIELD_MATERIAL, this.getMainBizOrgType(), mainOrgInfo, false, false);
        mmp.setAutoFilledColumnName(0, "materialName");
        mmp.setAutoFilledColumnName(1, "model");
        mbdm.addProcessor(mmp);
        mbdm.addAfterInsertEntryListener(new MultiBaseDataAdapter(){

            public void loadEntryFields(MultiMaterialProcessor mmp, KDTable table, int rowIdx) throws Exception {
            }
        });
        mbdm.registerMultiBaseDataF7();
        Container c = this.kdtMaterial.getParent().getParent();
        if (c instanceof DetailPanel) {
            this.panel = (DetailPanel)this.kdtMaterial.getParent().getParent();
            Component[] components = this.panel.getComponents();
            Component component = components[0];
            if (component instanceof KDPanel) {
                KDPanel kdPanel = (KDPanel)component;
                Component[] components1 = kdPanel.getComponents();
                this.entryButtons = new Component[3];
                int count = components1.length;
                for (int i = 0; i < count; ++i) {
                    this.entryButtons[i] = components1[i];
                }
            }
        }
        if ("ADDNEW".equals(this.getOprtState()) || "EDIT".equals(this.getOprtState())) {
            this.setEntryButtonsEnabled(this.entryButtons, true);
        } else {
            this.setEntryButtonsEnabled(this.entryButtons, false);
        }
        CostItemHelper.setCostItemF7((CoreUI)this, (KDPromptBox)this.prmtcostItem, (KDPromptBox)this.prmtcompanyOrgUnit, CostItemEnum.STUFF);
        BDUtils.setBizOrgF7ByType(this.prmtcompanyOrgUnit, OrgType.Company);
        Object o = this.prmtcompanyOrgUnit.getValue();
        if (o instanceof CompanyOrgUnitInfo) {
            BdCMClientHelper.filterCostCenter(this.prmtcostCenter, (CompanyOrgUnitInfo)o);
        }
        this.storeFields();
        this.setDataObject((IObjectValue)this.editData);
    }

    private void setEntryButtonsEnabled(Component[] buttons, boolean isEnabled) {
        if (buttons != null) {
            int count = buttons.length;
            for (int i = 0; i < count; ++i) {
                buttons[i].setEnabled(isEnabled);
            }
        }
        this.menuItemAddLine.setEnabled(isEnabled);
        this.menuItemInsertLine.setEnabled(isEnabled);
        this.menuItemRemoveLine.setEnabled(isEnabled);
        this.btnAddLine.setEnabled(isEnabled);
        this.btnInsertLine.setEnabled(isEnabled);
        this.btnRemoveLine.setEnabled(isEnabled);
        this.kdtMaterial.setEditable(isEnabled);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        if ("ADDNEW".equals(this.getOprtState())) {
            this.addLine();
        }
    }

    private void addLine() {
        if (this.kdtMaterial.getRowCount() == 0) {
            MaterialCostItemRelationMaterialInfo materialData = new MaterialCostItemRelationMaterialInfo();
            IRow row = this.kdtMaterial.addRow();
            this.dataBinder.loadLineFields(this.kdtMaterial, row, (IObjectValue)materialData);
        }
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        super.setFieldsNull(newData);
        MaterialCostItemRelationInfo info = (MaterialCostItemRelationInfo)newData;
        info.setId(null);
        info.setNumber(null);
        info.setName(null);
        info.setCostItem(null);
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        if (this.prmtcompanyOrgUnit.getValue() == null) {
            this.prmtcompanyOrgUnit.requestFocus();
            super.handUIExceptionAndAbort((Exception)((Object)new MaterialCostItemRelationException(MaterialCostItemRelationException.NULL_COMPANYORGUNIT)));
        }
        if (this.prmtcostItem.getValue() == null) {
            this.prmtcostItem.requestFocus();
            super.handUIExceptionAndAbort((Exception)((Object)new MaterialCostItemRelationException(MaterialCostItemRelationException.NULL_COSTITEM)));
        }
        if (this.kdtMaterial.getRowCount() == 0) {
            super.handUIExceptionAndAbort((Exception)((Object)new MaterialCostItemRelationException(MaterialCostItemRelationException.NOT_ENTRY)));
        }
        this.checkEntryRequiredItem();
        this.checkEntryDupItem();
        this.checkMaterial();
    }

    private void checkEntryDupItem() throws Exception {
        IRow row1 = null;
        IRow row2 = null;
        String materialID1 = null;
        String materialID2 = null;
        Object o1 = null;
        Object o2 = null;
        int size1 = this.kdtMaterial.getRowCount();
        for (int i = 0; i < size1; ++i) {
            row1 = this.kdtMaterial.getRow(i);
            o1 = row1.getCell(ENTRY_FIELD_MATERIAL).getValue();
            if (!(o1 instanceof MaterialInfo)) continue;
            materialID1 = ((MaterialInfo)o1).getId().toString();
            int size2 = this.kdtMaterial.getRowCount();
            for (int j = i + 1; j < size2; ++j) {
                row2 = this.kdtMaterial.getRow(j);
                o2 = row2.getCell(ENTRY_FIELD_MATERIAL).getValue();
                if (!(o2 instanceof MaterialInfo) || !materialID1.equals(materialID2 = ((MaterialInfo)o2).getId().toString())) continue;
                this.kdtMaterial.getEditManager().editCellAt(i, this.kdtMaterial.getColumnIndex(ENTRY_FIELD_MATERIAL));
                throw new MaterialCostItemRelationException(MaterialCostItemRelationException.SAME_MATERIAL, new Object[]{new Integer(i + 1), new Integer(j + 1)});
            }
        }
    }

    private void checkEntryRequiredItem() throws Exception {
        int size = this.kdtMaterial.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row = this.kdtMaterial.getRow(i);
            if (row.getCell(ENTRY_FIELD_MATERIAL).getValue() != null) continue;
            this.kdtMaterial.getEditManager().editCellAt(i, this.kdtMaterial.getColumnIndex(ENTRY_FIELD_MATERIAL));
            throw new MaterialCostItemRelationException(MaterialCostItemRelationException.NULL_MATERIAL, new Object[]{new Integer(i + 1)});
        }
    }

    private void checkMaterial() throws Exception {
        Object o = null;
        String ID = null;
        String companyOrgUnitID = null;
        String costCenterID = null;
        String companyOrgUnitName = null;
        String costCenterName = null;
        if (this.editData != null && this.editData.getId() != null) {
            ID = this.editData.getId().toString();
        }
        if ((o = this.prmtcompanyOrgUnit.getValue()) instanceof CompanyOrgUnitInfo) {
            companyOrgUnitID = ((CompanyOrgUnitInfo)o).getId().toString();
            companyOrgUnitName = ((CompanyOrgUnitInfo)o).getName();
        }
        if ((o = this.prmtcostCenter.getValue()) instanceof CostCenterOrgUnitInfo) {
            costCenterID = ((CostCenterOrgUnitInfo)o).getId().toString();
            costCenterName = ((CostCenterOrgUnitInfo)o).getName();
        }
        ArrayList<String> materialList = new ArrayList<String>();
        int count = this.kdtMaterial.getRowCount();
        for (int i = 0; i < count; ++i) {
            o = this.kdtMaterial.getRow(i).getCell(ENTRY_FIELD_MATERIAL).getValue();
            if (!(o instanceof MaterialInfo)) continue;
            materialList.add(((MaterialInfo)o).getId().toString());
        }
        String[] materials = new String[materialList.size()];
        materialList.toArray(materials);
        IMaterialCostItemRelation iMaterialCostItemRelation = MaterialCostItemRelationFactory.getRemoteInstance();
        MaterialCostItemRelationCheckResult checkResult = iMaterialCostItemRelation.checkMaterial(ID, companyOrgUnitID, costCenterID, materials);
        Boolean[] checkResultList = checkResult.getCheckResult();
        String unCheckedRow = null;
        int firstUnCheckedRow = 0;
        int count2 = checkResultList.length;
        for (int i = 0; i < count2; ++i) {
            if (checkResultList[i].booleanValue()) continue;
            if (unCheckedRow == null) {
                unCheckedRow = Integer.toString(i + 1);
                firstUnCheckedRow = i;
                continue;
            }
            unCheckedRow = unCheckedRow + "," + Integer.toString(i + 1);
        }
        if (unCheckedRow != null) {
            this.kdtMaterial.getEditManager().editCellAt(firstUnCheckedRow, this.kdtMaterial.getColumnIndex(ENTRY_FIELD_MATERIAL));
            if (costCenterID == null) {
                throw new MaterialCostItemRelationException(MaterialCostItemRelationException.DUP_MATERIAL_CC, new Object[]{companyOrgUnitName, unCheckedRow});
            }
            throw new MaterialCostItemRelationException(MaterialCostItemRelationException.DUP_MATERIAL_CCC, new Object[]{companyOrgUnitName, costCenterName, unCheckedRow});
        }
    }

    public void loadFields() {
        super.loadFields();
        BDUtils.setBizOrgF7ByType(this.prmtcompanyOrgUnit, OrgType.Company);
        if ("ADDNEW".equals(this.getOprtState()) || "EDIT".equals(this.getOprtState())) {
            this.setEntryButtonsEnabled(this.entryButtons, true);
        } else {
            this.setEntryButtonsEnabled(this.entryButtons, false);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        if ("ADDNEW".equals(this.getOprtState()) || "EDIT".equals(this.getOprtState())) {
            this.setEntryButtonsEnabled(this.entryButtons, true);
        } else {
            this.setEntryButtonsEnabled(this.entryButtons, false);
        }
    }

    public void prmtcompanyOrgUnit_dataChanged(DataChangeEvent e) {
        if (this.prmtcompanyOrgUnit.getData() != null) {
            Object o;
            CostItemHelper.setCostItemF7((CoreUI)this, (KDPromptBox)this.prmtcostItem, (KDPromptBox)this.prmtcompanyOrgUnit, CostItemEnum.STUFF);
            BdCMClientHelper.filterCostCenter(this.prmtcostCenter, (CompanyOrgUnitInfo)this.prmtcompanyOrgUnit.getValue());
            CompanyOrgUnitInfo companyOrgUnitInfo = null;
            if (this.prmtcompanyOrgUnit != null && (o = this.prmtcompanyOrgUnit.getValue()) instanceof CompanyOrgUnitInfo) {
                companyOrgUnitInfo = (CompanyOrgUnitInfo)o;
            }
            CostItemHelper.setFilter((KDPromptBox)this.prmtcostItem, companyOrgUnitInfo, true, CostItemEnum.STUFF, CompareType.EQUALS, 1);
        }
    }

    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        this.panel.actionAddnewLine_actionPerformed(e);
    }

    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        this.panel.actionInsertLine_actionPerformed(e);
    }

    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        try {
            this.panel.actionRemoveLine_actionPerformed(e);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

