/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.cm.client;

import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.cm.StandardFeeRateFactory;
import com.kingdee.eas.basedata.cm.StandardFeeRateInfo;
import com.kingdee.eas.basedata.cm.client.AbstractStandardFeeRateEditUI;
import com.kingdee.eas.basedata.cm.util.BDUtils;
import com.kingdee.eas.basedata.cm.util.BdCMClientHelper;
import com.kingdee.eas.basedata.cm.util.client.BDClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.EventListener;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class StandardFeeRateEditUI
extends AbstractStandardFeeRateEditUI {
    private static final Logger logger = CoreUIObject.getLogger((Class)StandardFeeRateEditUI.class);
    public static final String STFSOURCE_PATH = "com.kingdee.eas.basedata.cm.client.SfrResource";
    public static final String STFSOURCE_PATH1 = "com.kingdee.eas.basedata.cm.client.PBResource";

    public void loadFields() {
        EventListener[] prmtCompanyListners = this.prmtcompany.getListeners(DataChangeListener.class);
        BDClientUtils.removeDataChangeListeners((JComponent)this.prmtcompany);
        super.loadFields();
        BDClientUtils.addDataChangeListeners((JComponent)this.prmtcompany, prmtCompanyListners);
        BDUtils.setBizOrgF7ByType(this.prmtcompany, OrgType.Company);
        BdCMClientHelper.filterCostCenter(this.prmtadminOrgUnit, (CompanyOrgUnitInfo)this.prmtcompany.getValue());
        this.description.setMaxLength(255);
        if (this.prmtcompany.getData() != null) {
            BDClientUtils.filterCostObject(this.prmtcostObject, (CompanyOrgUnitInfo)this.prmtcompany.getData());
        }
    }

    public void prmtcompany_dataChanged(DataChangeEvent e) {
        if (this.prmtcompany.getData() != null) {
            BdCMClientHelper.filterCostCenter(this.prmtadminOrgUnit, (CompanyOrgUnitInfo)this.prmtcompany.getValue());
        }
    }

    public void onLoad() throws Exception {
        this.txtstdPayRate.setPrecision(4);
        this.txtvarientMakeFee.setPrecision(4);
        this.txtfixMakeFee.setPrecision(4);
        super.onLoad();
        if (this.prmtcompany.getValue() != null) {
            CurrencyInfo baseCurrency = ((CompanyOrgUnitInfo)this.prmtcompany.getValue()).getBaseCurrency();
            ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
            baseCurrency = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(baseCurrency.getId()));
            int precision = baseCurrency.getPrecision();
            this.setPrecision(precision);
        }
    }

    protected void prmtCompany_dataChanged(DataChangeEvent e) throws Exception {
        if (e.getNewValue() instanceof CompanyOrgUnitInfo && e.getNewValue() != e.getOldValue()) {
            CurrencyInfo baseCurrency = ((CompanyOrgUnitInfo)e.getNewValue()).getBaseCurrency();
            ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
            baseCurrency = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(baseCurrency.getId()));
            int precision = baseCurrency.getPrecision();
            this.setPrecision(precision);
        }
    }

    public void setPrecision(int precision) {
        this.txtfixMakeFee.setPrecision(precision);
    }

    public void onShow() throws Exception {
        BDClientUtils.setResizble(false, this.uiWindow);
        this.txtvarientMakeFee.setBoundLabelLength(130);
        this.prmtcompany.setRequired(true);
        this.prmtadminOrgUnit.setRequired(true);
        this.prmtcostObject.setRequired(true);
        this.txtfixMakeFee.setRequired(true);
        this.txtstdOutput.setRequired(true);
        this.txtstdPayRate.setRequired(true);
        this.txtstdWorkHour.setRequired(true);
        this.txtvarientMakeFee.setRequired(true);
        this.txtfixMakeFee.setHorizontalAlignment(4);
        this.txtfixMakeFee.setNegatived(false);
        this.txtstdOutput.setHorizontalAlignment(4);
        this.txtstdOutput.setNegatived(false);
        this.txtstdPayRate.setHorizontalAlignment(4);
        this.txtstdPayRate.setNegatived(false);
        this.txtstdWorkHour.setHorizontalAlignment(4);
        this.txtstdWorkHour.setNegatived(false);
        this.txtvarientMakeFee.setHorizontalAlignment(4);
        this.txtvarientMakeFee.setNegatived(false);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkValidDataForSubmit();
        super.actionSubmit_actionPerformed(e);
    }

    public void checkValidDataForSubmit() throws Exception {
        if (this.prmtcompany.getValue() == null || "".equals(this.prmtcompany.getValue())) {
            this.prmtcompany.requestFocus();
            MsgBox.showInfo((String)EASResource.getString((String)STFSOURCE_PATH, (String)"Company_Is_Null"));
            SysUtil.abort();
        }
        if (this.prmtadminOrgUnit.getValue() == null) {
            this.prmtadminOrgUnit.requestFocus();
            MsgBox.showInfo((String)EASResource.getString((String)STFSOURCE_PATH, (String)"AdminOrg_Is_Null"));
            SysUtil.abort();
        }
        if (this.prmtcostObject.getValue() == null) {
            this.prmtcostObject.requestFocus();
            MsgBox.showInfo((String)EASResource.getString((String)STFSOURCE_PATH, (String)"CostObject_Is_Null"));
            SysUtil.abort();
        }
        if (this.txtstdWorkHour.getText() == null || "".equals(this.txtstdWorkHour.getText())) {
            this.txtstdWorkHour.requestFocus();
            MsgBox.showInfo((String)EASResource.getString((String)STFSOURCE_PATH, (String)"StdWorkHour_Is_Null"));
            SysUtil.abort();
        }
        if (this.txtstdPayRate.getText() == null || "".equals(this.txtstdPayRate.getText())) {
            this.txtstdPayRate.requestFocus();
            MsgBox.showInfo((String)EASResource.getString((String)STFSOURCE_PATH, (String)"stdPayRate_Is_Null"));
            SysUtil.abort();
        }
        if (this.txtstdOutput.getText() == null || "".equals(this.txtstdOutput.getText())) {
            this.txtstdOutput.requestFocus();
            MsgBox.showInfo((String)EASResource.getString((String)STFSOURCE_PATH, (String)"StdOutput_Is_Null"));
            SysUtil.abort();
        }
        if (this.txtvarientMakeFee.getText() == null || "".equals(this.txtvarientMakeFee.getText())) {
            this.txtvarientMakeFee.requestFocus();
            MsgBox.showInfo((String)EASResource.getString((String)STFSOURCE_PATH, (String)"varientMakeFee_Is_Null"));
            SysUtil.abort();
        }
        if (this.txtfixMakeFee.getText() == null || "".equals(this.txtfixMakeFee.getText())) {
            this.txtfixMakeFee.requestFocus();
            MsgBox.showInfo((String)EASResource.getString((String)STFSOURCE_PATH, (String)"fixMakeFee_Is_Null"));
            SysUtil.abort();
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return StandardFeeRateFactory.getRemoteInstance();
    }

    public void txtvarientMakeFee_dataChanged(DataChangeEvent e) {
        if (e.getNewValue() != null && (((BigDecimal)e.getNewValue()).floatValue() < 0.0f || ((BigDecimal)e.getNewValue()).floatValue() > 100.0f)) {
            this.txtvarientMakeFee.setValue((Object)new BigDecimal("0.0000"));
            this.txtvarientMakeFee.requestFocus();
            MsgBox.showInfo((String)EASResource.getString((String)STFSOURCE_PATH1, (String)"COVALUE"));
        }
    }

    protected IObjectValue createNewData() {
        StandardFeeRateInfo objectValue = new StandardFeeRateInfo();
        CompanyOrgUnitInfo com = SysContext.getSysContext().getCurrentFIUnit();
        objectValue.setCompany((CompanyOrgUnitInfo)(com.isIsBizUnit() ? com : null));
        objectValue.setStdOutput(SysConstant.BIGZERO);
        objectValue.setStdPayRate(SysConstant.BIGZERO);
        objectValue.setStdWorkHour(SysConstant.BIGZERO);
        objectValue.setVarientMakeFee(SysConstant.BIGZERO);
        objectValue.setFixMakeFee(SysConstant.BIGZERO);
        return objectValue;
    }
}

