/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.cm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.CodingRuleUtils;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.cm.IWork;
import com.kingdee.eas.basedata.cm.WorkFactory;
import com.kingdee.eas.basedata.cm.WorkInfo;
import com.kingdee.eas.basedata.cm.client.AbstractWorkEditUI;
import com.kingdee.eas.basedata.cm.util.BDUtils;
import com.kingdee.eas.basedata.cm.util.BdCMClientHelper;
import com.kingdee.eas.basedata.cm.util.client.BDClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.util.BaseException;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class WorkEditUI
extends AbstractWorkEditUI {
    public static final int PRECISION_FOUR = 4;
    private static final Logger logger = CoreUIObject.getLogger((Class)WorkEditUI.class);
    private HashMap codingRuleAttr = null;

    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.editData.getCU() == null) {
            this.editData.setCU(WorkEditUI.getRootCU());
        }
        BDUtils.setBizOrgF7ByType(this.prmtCompany, OrgType.Company);
        this.txtUnitCost.setHorizontalAlignment(4);
        this.txtQuotiety.setHorizontalAlignment(4);
    }

    protected void setNumTextField() {
        try {
            if (((Boolean)this.codingRuleAttr.get("isExist")).booleanValue()) {
                this.txtNumber.setEnabled(false);
            } else {
                this.txtNumber.setEnabled(true);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    protected void setAutoNumberByOrg(String orgType) {
        try {
            if (!this.isAutoNumber()) {
                return;
            }
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
        if (StringUtils.isEmpty((String)this.editData.getNumber())) {
            String sysNumber = null;
            if (this.editData.getCU() == null) {
                this.editData.setCU(WorkEditUI.getRootCU());
            }
            try {
                String orgId = SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)orgType)).getString("id");
                if (!StringUtils.isEmpty((String)orgType) && !"NONE".equalsIgnoreCase(orgType) && orgId != null) {
                    sysNumber = CodingRuleUtils.getNumberByClient((IObjectValue)this.editData, (String)orgId);
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            if (sysNumber != null && sysNumber.trim().length() > 0) {
                this.editData.setNumber(sysNumber);
                this.txtNumber.setText(sysNumber);
                BDClientUtils.setNumberEnabledByCodeRule((IObjectValue)this.editData, this.dataBinder);
            } else {
                BDClientUtils.setNumberEnabledByCodeRule((IObjectValue)this.editData, this.dataBinder);
            }
        }
    }

    public static CtrlUnitInfo getRootCU() {
        CtrlUnitInfo rootCU = new CtrlUnitInfo();
        rootCU.setId(BOSUuid.read((String)"00000000-0000-0000-0000-000000000000CCE7AED4"));
        return rootCU;
    }

    protected boolean isAutoNumber() throws Exception {
        if (this.codingRuleAttr != null) {
            return (Boolean)this.codingRuleAttr.get("isAddView") != false || (Boolean)this.codingRuleAttr.get("isAddViewBreak") != false;
        }
        return false;
    }

    protected HashMap getCodingRuleAttr(WorkInfo aSCMBillBaseInfo) throws EASBizException, BOSException {
        CodingRuleInfo codeinfo;
        String strCompanyID = null;
        if (this.editData.getCompany() != null) {
            strCompanyID = this.editData.getCompany().getId().toString();
        }
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        HashMap<String, Boolean> hs = new HashMap<String, Boolean>();
        boolean isExist = false;
        boolean isAddView = false;
        boolean isAddViewBreak = false;
        if (iCodingRuleManager.isExist((IObjectValue)aSCMBillBaseInfo, strCompanyID)) {
            isExist = true;
            if (iCodingRuleManager.isAddView((IObjectValue)aSCMBillBaseInfo, strCompanyID)) {
                isAddView = true;
            }
        }
        if (iCodingRuleManager.isExist((IObjectValue)aSCMBillBaseInfo, strCompanyID) && (codeinfo = iCodingRuleManager.getCodingRule((IObjectValue)aSCMBillBaseInfo, strCompanyID)).isIsAddView()) {
            String number = iCodingRuleManager.readNumber((IObjectValue)aSCMBillBaseInfo, strCompanyID);
            isAddViewBreak = true;
        }
        hs.put("isExist", isExist);
        hs.put("isAddView", isAddView);
        hs.put("isAddViewBreak", isAddViewBreak);
        return hs;
    }

    public void isAddViewAndNeverBreak(WorkInfo aSCMBillBaseInfo) throws EASBizException, BOSException {
        CodingRuleInfo codeinfo;
        ICodingRuleManager iCodingRuleManager;
        String strCompanyID = null;
        if (this.editData.getCompany() != null) {
            strCompanyID = this.editData.getCompany().getId().toString();
        }
        if ((iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance()).isExist((IObjectValue)aSCMBillBaseInfo, strCompanyID) && (codeinfo = iCodingRuleManager.getCodingRule((IObjectValue)aSCMBillBaseInfo, strCompanyID)).isIsAddView()) {
            String number = iCodingRuleManager.readNumber((IObjectValue)aSCMBillBaseInfo, strCompanyID);
            this.txtNumber.setText(number);
        }
    }

    protected void removeByPK(IObjectPK pk) throws Exception {
        WorkInfo editData = this.editData;
        super.removeByPK(pk);
    }

    protected void recycleNumberByOrg(IObjectValue editData, String orgType, String number) {
        if (!StringUtils.isEmpty((String)number)) {
            try {
                ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
                iCodingRuleManager.recycleNumber(editData, orgType, number);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    public void loadFields() {
        super.loadFields();
        try {
            this.codingRuleAttr = this.getCodingRuleAttr(this.editData);
        }
        catch (EASBizException e1) {
            this.handUIException(e1);
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
        if ("EDIT".equals(this.getOprtState())) {
            this.txtNumber.setEnabled(false);
        } else if ("ADDNEW".equals(this.getOprtState())) {
            this.setNumTextField();
        }
        this.setAutoNumberByOrg("Company");
        BdCMClientHelper.filterCostCenter(this.prmtAdminOrgUnit, (CompanyOrgUnitInfo)this.prmtCompany.getValue());
        this.initEntryPrecisionForEdit();
        this.setOprtState(this.getOprtState());
        this.storeFields();
        super.initOldData((IObjectValue)this.editData);
    }

    public void setOprtState(String oprtType) {
        super.setOprtState(oprtType);
        if ("ADDNEW".equals(this.getOprtState())) {
            this.setCtrlForAddnew();
        } else if ("EDIT".equals(this.getOprtState())) {
            this.setCtrlForEdit();
        }
    }

    private void setCtrlForEdit() {
        if (this.editData == null) {
            return;
        }
        this.setCtrlForAddnew();
        this.txtNumber.setEnabled(false);
        try {
            IWork iwork = WorkFactory.getRemoteInstance();
            iwork.isReferenced((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        }
        catch (BaseException ex) {
            this.prmtCompany.setEnabled(false);
            this.txtUnitCost.setEnabled(false);
            this.prmtCostItem.setEnabled(false);
            this.prmtAdminOrgUnit.setEnabled(false);
            this.prmtUnit.setEnabled(false);
            this.txtQuotiety.setEnabled(false);
            this.txtName.setEnabled(true);
            this.kDBizMultiLangArea1.setEnabled(true);
        }
    }

    private void setCtrlForAddnew() {
        this.prmtCompany.setEnabled(true);
        this.txtUnitCost.setEnabled(true);
        this.prmtCostItem.setEnabled(true);
        this.prmtAdminOrgUnit.setEnabled(true);
        this.prmtUnit.setEnabled(true);
        this.txtQuotiety.setEnabled(true);
        this.txtName.setEnabled(true);
        this.kDBizMultiLangArea1.setEnabled(true);
    }

    private void initEntryPrecisionForEdit() {
        if (this.prmtCompany.getData() instanceof CompanyOrgUnitInfo) {
            CurrencyInfo baseCurrency = ((CompanyOrgUnitInfo)this.prmtCompany.getData()).getBaseCurrency();
            try {
                ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
                baseCurrency = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(baseCurrency.getId()));
            }
            catch (EASBizException e) {
                super.handleException((Exception)((Object)e));
            }
            catch (BOSException e) {
                super.handleException((Exception)((Object)e));
            }
            this.txtUnitCost.setPrecision(baseCurrency.getPrecision());
            this.txtUnitCost.setNegatived(false);
            this.txtUnitCost.setSupportedEmpty(true);
            this.txtUnitCost.setRemoveingZeroInDispaly(false);
            this.txtQuotiety.setMaximumValue((Comparable)new BigDecimal("100.00"));
            this.txtQuotiety.setMinimumValue((Comparable)SysConstant.BIGZERO);
        }
    }

    public void onShow() throws Exception {
        BDClientUtils.setResizble(false, this.uiWindow);
        Component[] comps = new Component[]{this.btnSave, this.btnAttachment, this.btnPrint, this.btnPrintPreview, this.separatorFW1, this.btnCancelCancel, this.btnCancel, this.menuBiz};
        BDClientUtils.setVisible(false, comps);
        super.onShow();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.setCtrlForAddnew();
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
        this.setCtrlForAddnew();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.txtNumber.setEnabled(false);
        this.setCtrlForEdit();
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        this.txtNumber.setEnabled(false);
    }

    protected IObjectValue createNewData() {
        WorkInfo info = new WorkInfo();
        CompanyOrgUnitInfo com = SysContext.getSysContext().getCurrentFIUnit();
        info.setCompany((CompanyOrgUnitInfo)(com.isIsBizUnit() ? com : null));
        info.setDept(SysContext.getSysContext().getCurrentCostUnit());
        info.setUnitCost(SysConstant.BIGZERO);
        info.setQuotiety(SysConstant.BIGZERO);
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return WorkFactory.getRemoteInstance();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        if (!((Boolean)this.codingRuleAttr.get("isExist")).booleanValue()) {
            BDClientUtils.verifyTextFieldInput(this.txtNumber, this.lblNumber.getBoundLabelText());
        }
        BDClientUtils.verifyMutilTextFieldInput(this.txtName, this.lblName.getBoundLabelText());
        BDClientUtils.verifyNumFieldInput(this.txtUnitCost, this.lblUnitCost.getBoundLabelText());
        BDClientUtils.verifyNumFieldInput(this.txtQuotiety, this.lblQuotiety.getBoundLabelText());
        BDClientUtils.verifyF7Input((KDPromptBox)this.prmtCompany, this.lblCompany.getBoundLabelText());
        BDClientUtils.verifyF7Input((KDPromptBox)this.prmtUnit, this.lblUnit.getBoundLabelText());
        BDClientUtils.verifyF7Input((KDPromptBox)this.prmtAdminOrgUnit, this.lblAdminOrgUnit.getBoundLabelText());
    }

    protected void prmtCompany_dataChanged(DataChangeEvent e) throws Exception {
        if (e.getNewValue() instanceof CompanyOrgUnitInfo && e.getNewValue() != e.getOldValue()) {
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)e.getNewValue();
            CurrencyInfo baseCurrency = company.getBaseCurrency();
            ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
            baseCurrency = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(baseCurrency.getId()));
            this.txtUnitCost.setPrecision(baseCurrency.getPrecision());
            BdCMClientHelper.filterCostCenter(this.prmtAdminOrgUnit, (CompanyOrgUnitInfo)this.prmtCompany.getValue());
        }
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
        this.setOprtState(this.getOprtState());
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
        this.setOprtState(this.getOprtState());
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
        this.setOprtState(this.getOprtState());
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
        this.setOprtState(this.getOprtState());
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
        this.setOprtState(this.getOprtState());
    }
}

