/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.cm.util.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.appframework.databinding.DataBinder;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangArea;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.MultiLangItem;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.client.UIModelDialog;
import com.kingdee.eas.base.uiframe.client.UINewFrame;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.cm.DistributionTypeEnum;
import com.kingdee.eas.basedata.cm.util.BDUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.enums.IntEnum;
import java.awt.Component;
import java.awt.Window;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import sun.misc.Compare;
import sun.misc.Sort;

public abstract class BDClientUtils {
    public static String getString(String key) {
        return EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.sale.client.SaleResource", (String)key);
    }

    public static void filterF7(KDBizPromptBox f7, String fieldName, IntEnum compareValue) {
        EntityViewInfo view = null;
        view = f7.getEntityViewInfo() == null ? new EntityViewInfo() : f7.getEntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(fieldName, (Object)new Integer(compareValue.getValue()), CompareType.EQUALS));
        view.setFilter(filter);
        f7.setEntityViewInfo(view);
    }

    public static void checkPeriod(PeriodInfo periodinfo, CompanyOrgUnitInfo companyinfo) {
        if (companyinfo != null && periodinfo != null) {
            try {
                ISystemStatusCtrol ctrol = SystemStatusCtrolFactory.getRemoteInstance();
                PeriodInfo currenctPeriod = ctrol.getCacheCurrentPeriod(38, companyinfo.getId().toString());
                int year = periodinfo.getPeriodYear();
                int number = periodinfo.getPeriodNumber();
                int currentyear = currenctPeriod.getPeriodYear();
                int currentnumber = currenctPeriod.getPeriodNumber();
                if (year == 0) {
                    String periodid = periodinfo.getId().toString();
                    periodinfo = PeriodFactory.getRemoteInstance().getPeriodInfo((IObjectPK)new ObjectStringPK(periodid));
                    year = periodinfo.getPeriodYear();
                    number = periodinfo.getPeriodNumber();
                }
                if (!BDUtils.isBig(currentyear, currentnumber, year, number)) {
                    MsgBox.showInfo((String)"\u4e0d\u5141\u8bb8\u4fee\u6539\u7ed3\u8d26\u524d\u671f\u95f4\u7684\u6570\u636e!");
                    SysUtil.abort();
                }
            }
            catch (Exception e) {
                SysUtil.abort();
            }
        }
    }

    public static void setResizble(boolean b, IUIWindow uiWindow) {
        if (uiWindow == null) {
            return;
        }
        Window win = SwingUtilities.getWindowAncestor((JComponent)uiWindow.getUIObject());
        if (win instanceof UINewFrame) {
            ((UINewFrame)win).setResizable(false);
        } else if (win instanceof UIModelDialog) {
            ((UIModelDialog)win).setResizable(false);
        }
    }

    public static void filterPeriod(EntityViewInfo ev) {
        FilterItemCollection filters = ev.getFilter().getFilterItems();
        int n = filters.size();
        for (int i = 0; i < n; ++i) {
            FilterItemInfo filterItem = filters.get(i);
            if (!"calculatePeriod".equals(filterItem.getPropertyName()) && !"customcalculatePeriod".equals(filterItem.getPropertyName())) continue;
            String oldArg = String.valueOf(filterItem.getCompareValue());
            filters.remove(filterItem);
            FilterItemInfo item = new FilterItemInfo();
            item.setPropertyName("number");
            item.setCompareType(CompareType.EQUALS);
            item.setCompareValue((Object)oldArg);
            filters.add(item);
            break;
        }
    }

    public static void setNumberEnabledByCodeRule(IObjectValue caller, DataBinder dataBinder) {
        boolean isModifiable = false;
        boolean isExist = false;
        try {
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            String orgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
            isExist = iCodingRuleManager.isExist(caller, orgID);
            if (isExist) {
                isModifiable = iCodingRuleManager.isModifiable(caller, orgID);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        Component txtNumber = dataBinder.getComponetByField("number");
        if (txtNumber != null) {
            boolean isEnabled = !isExist || isModifiable;
            txtNumber.setEnabled(isEnabled);
        }
        if (txtNumber.isEnabled()) {
            txtNumber.requestFocus();
        }
    }

    public static void showCannotBeEmptyMsg(String fieldName) {
        String msg = BDClientUtils.getString("FieldCannotEmpty");
        MsgBox.showInfo((String)MessageFormat.format(msg, fieldName));
        SysUtil.abort();
    }

    public static void verifyTextFieldInput(KDTextField txt, String fieldName) {
        if (txt.getText().trim().length() == 0 || txt.getText() == null) {
            txt.requestFocus();
            txt.requestFocusInWindow();
            BDClientUtils.showCannotBeEmptyMsg(fieldName);
        }
    }

    public static void verifyMutilTextFieldInput(KDBizMultiLangBox txt, String fieldName) {
        if (txt.getSelectedItem() == null || ((MultiLangItem)txt.getSelectedItem()).getData().toString().length() == 0) {
            txt.requestFocus();
            BDClientUtils.showCannotBeEmptyMsg(fieldName);
        }
    }

    public static void verifyMutilAreaFieldInput(KDBizMultiLangArea txt, String fieldName) {
        if (txt.getSelectedItem() == null || ((MultiLangItem)txt.getSelectedItem()).getData().toString().length() == 0) {
            txt.requestFocus();
            BDClientUtils.showCannotBeEmptyMsg(fieldName);
        }
    }

    public static void verifyNumFieldInput(KDFormattedTextField txt, String fieldName) {
        if (txt.getText().trim().length() == 0 || txt.getText() == null) {
            txt.requestFocus();
            BDClientUtils.showCannotBeEmptyMsg(fieldName);
        }
    }

    public static void verifyF7Input(KDPromptBox box, String fieldName) {
        if (box.getText().trim().length() == 0 || box.getText() == null) {
            box.requestFocus();
            BDClientUtils.showCannotBeEmptyMsg(fieldName);
        }
    }

    public static void verifyComboInput(KDComboBox box, String fieldName) {
        if (box.getSelectedIndex() < 0) {
            box.requestFocus();
            BDClientUtils.showCannotBeEmptyMsg(fieldName);
        }
    }

    public static void setVisible(boolean b, Component[] comps) {
        if (comps == null) {
            return;
        }
        for (int i = 0; i < comps.length; ++i) {
            comps[i].setVisible(b);
        }
    }

    public static void removeDataChangeListeners(JComponent owner) {
        EventListener[] listeners;
        if (owner != null && ((listeners = owner.getListeners(DataChangeListener.class)) != null || listeners.length > 0)) {
            EventListener event = null;
            int size = listeners.length;
            for (int i = 0; i < size; ++i) {
                event = listeners[i];
                if (event == null || !(event instanceof DataChangeListener) || !(owner instanceof IKDEditor)) continue;
                ((IKDEditor)owner).removeDataChangeListener((DataChangeListener)event);
            }
        }
    }

    public static void removeKDTEditListeners(KDTable owner) {
        EventListener[] listeners;
        if (owner != null && ((listeners = owner.getListeners(KDTEditListener.class)) != null || listeners.length > 0)) {
            EventListener event = null;
            int size = listeners.length;
            for (int i = 0; i < size; ++i) {
                event = listeners[i];
                if (event == null || !(event instanceof KDTEditListener)) continue;
                owner.removeKDTEditListener((KDTEditListener)event);
            }
        }
    }

    public static void addDataChangeListeners(JComponent owner, EventListener[] listeners) {
        if (owner == null || listeners == null || listeners.length < 0) {
            SysUtil.abort();
            return;
        }
        EventListener event = null;
        int size = listeners.length;
        for (int i = 0; i < size; ++i) {
            event = listeners[i];
            if (event == null || !(event instanceof DataChangeListener) || !(owner instanceof IKDEditor)) continue;
            ((IKDEditor)owner).addDataChangeListener((DataChangeListener)event);
        }
    }

    public static void addKDTEditListeners(KDTable owner, EventListener[] listeners) {
        if (owner == null || listeners == null || listeners.length < 0) {
            SysUtil.abort();
            return;
        }
        EventListener event = null;
        int size = listeners.length;
        for (int i = 0; i < size; ++i) {
            event = listeners[i];
            if (event == null || !(event instanceof KDTEditListener)) continue;
            owner.addKDTEditListener((KDTEditListener)event);
        }
    }

    public static void filterF7(KDBizPromptBox f7, String fieldName, Object compareValue) {
        EntityViewInfo view = null;
        view = f7.getEntityViewInfo() == null ? new EntityViewInfo() : f7.getEntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(fieldName, compareValue, CompareType.EQUALS));
        view.setFilter(filter);
        f7.setEntityViewInfo(view);
    }

    public static void filterCostObject(KDBizPromptBox f7, CompanyOrgUnitInfo com) {
        BDClientUtils.filterF7(f7, "company.id", com.getId().toString());
    }

    public static void filterSuperior(KDBizPromptBox f7, CostCenterOrgUnitInfo node) {
        BDClientUtils.filterF7(f7, "parent", node.getId().toString());
    }

    public static void filterEnum(KDComboBox combox, String fieldProperty, String flag) {
        DistributionTypeEnum[] type = null;
        DefaultComboBoxModel<DistributionTypeEnum> model = null;
        if ("AssistProDeptFeeAssWorkListUI".equals(flag)) {
            type = new DistributionTypeEnum[]{DistributionTypeEnum.ACTUALFINISHOUTPUT, DistributionTypeEnum.ACTUALTOTALMANHOUR, DistributionTypeEnum.EQUIVALENT, DistributionTypeEnum.WORKRADIO};
            model = new DefaultComboBoxModel<DistributionTypeEnum>(type);
            combox.setModel(model);
            return;
        }
        if ("DeptCommonDistListUI".equals(flag)) {
            type = new DistributionTypeEnum[]{DistributionTypeEnum.ACTUALFINISHOUTPUT, DistributionTypeEnum.TOTALPUTINTOOUTPUT, DistributionTypeEnum.ACTUALTOTALMANHOUR, DistributionTypeEnum.EQUIVALENT};
            model = new DefaultComboBoxModel<DistributionTypeEnum>(type);
            combox.setModel(model);
            return;
        }
        if ("UnderwareFeeAsListUI".equals(flag)) {
            type = new DistributionTypeEnum[]{DistributionTypeEnum.NOTDISTRIBUTION, DistributionTypeEnum.BEGINYEAR, DistributionTypeEnum.FINISHPRODUCT, DistributionTypeEnum.EQUIVALENT};
            model = new DefaultComboBoxModel<DistributionTypeEnum>(type);
            combox.setModel(model);
            return;
        }
        if ("DeptIndirectFeeWorkListUI".equals(flag)) {
            type = new DistributionTypeEnum[]{DistributionTypeEnum.ACTUALFINISHOUTPUT, DistributionTypeEnum.ACTUALTOTALMANHOUR, DistributionTypeEnum.TOTALPUTINTOOUTPUT, DistributionTypeEnum.EQUIVALENT};
            model = new DefaultComboBoxModel<DistributionTypeEnum>(type);
            combox.setModel(model);
            return;
        }
        if ("CostItemParameterListUI".equals(flag) && "deptDistribute".equals(fieldProperty)) {
            type = new DistributionTypeEnum[]{DistributionTypeEnum.ACTUALFINISHOUTPUT, DistributionTypeEnum.ACTUALTOTALMANHOUR, DistributionTypeEnum.TOTALPUTINTOOUTPUT};
            model = new DefaultComboBoxModel<DistributionTypeEnum>(type);
            combox.setModel(model);
            return;
        }
        if ("Dep_ProductFeeListUI".equals(flag) && "entrys.dep_prdu_dstrbt".equals(fieldProperty)) {
            type = new DistributionTypeEnum[]{DistributionTypeEnum.ACTUALFINISHOUTPUT, DistributionTypeEnum.ACTUALTOTALMANHOUR, DistributionTypeEnum.EQUIVALENT, DistributionTypeEnum.TOTALPUTINTOOUTPUT};
            model = new DefaultComboBoxModel<DistributionTypeEnum>(type);
            combox.setModel(model);
            return;
        }
        if ("CommFeeDisWorkListUI".equals(flag) && "assignSta".equals(fieldProperty)) {
            type = new DistributionTypeEnum[]{DistributionTypeEnum.ACTUALFINISHOUTPUT, DistributionTypeEnum.ACTUALTOTALMANHOUR, DistributionTypeEnum.EQUIVALENT, DistributionTypeEnum.TOTALPUTINTOOUTPUT};
            model = new DefaultComboBoxModel<DistributionTypeEnum>(type);
            combox.setModel(model);
            return;
        }
        if ("amongDeptDistri".equals(fieldProperty)) {
            type = new DistributionTypeEnum[]{DistributionTypeEnum.ACTUALFINISHOUTPUT, DistributionTypeEnum.ACTUALTOTALMANHOUR, DistributionTypeEnum.TOTALPUTINTOOUTPUT};
            model = new DefaultComboBoxModel<DistributionTypeEnum>(type);
            combox.setModel(model);
        } else if ("deptDistribute".equals(fieldProperty)) {
            type = new DistributionTypeEnum[]{DistributionTypeEnum.ACTUALFINISHOUTPUT, DistributionTypeEnum.ACTUALTOTALMANHOUR};
            model = new DefaultComboBoxModel<DistributionTypeEnum>(type);
            combox.setModel(model);
        } else if ("assistProduct".equals(fieldProperty) || "assistDistribute".equals(fieldProperty)) {
            type = new DistributionTypeEnum[]{DistributionTypeEnum.ACTUALFINISHOUTPUT, DistributionTypeEnum.ACTUALTOTALMANHOUR};
            model = new DefaultComboBoxModel<DistributionTypeEnum>(type);
            combox.setModel(model);
        } else if ("onProducing".equals(fieldProperty)) {
            type = new DistributionTypeEnum[]{DistributionTypeEnum.NOTDISTRIBUTION, DistributionTypeEnum.BEGINYEAR, DistributionTypeEnum.FINISHPRODUCT, DistributionTypeEnum.EQUIVALENT};
            model = new DefaultComboBoxModel<DistributionTypeEnum>(type);
            combox.setModel(model);
        } else if ("produceDistribute".equals(fieldProperty)) {
            type = new DistributionTypeEnum[]{DistributionTypeEnum.ACTUALFINISHOUTPUT, DistributionTypeEnum.EQUIVALENT, DistributionTypeEnum.NOTDISTRIBUTION};
            model = new DefaultComboBoxModel<DistributionTypeEnum>(type);
            combox.setModel(model);
        } else if ("goodsDistribute".equals(fieldProperty)) {
            type = new DistributionTypeEnum[]{DistributionTypeEnum.ACTUALFINISHOUTPUT, DistributionTypeEnum.ACTUALTOTALMANHOUR, DistributionTypeEnum.EQUIVALENT, DistributionTypeEnum.TOTALPUTINTOOUTPUT};
            model = new DefaultComboBoxModel<DistributionTypeEnum>(type);
            combox.setModel(model);
        } else if ("entrys.dep_prdu_dstrbt".equals(fieldProperty)) {
            type = new DistributionTypeEnum[]{DistributionTypeEnum.WORKRADIO};
            model = new DefaultComboBoxModel<DistributionTypeEnum>(type);
            combox.setModel(model);
        }
    }

    public static void filterCompanyOrgForPeriod(KDBizPromptBox prmt, String periodTypeID) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)periodTypeID, CompareType.EQUALS));
        if (prmt.getEntityViewInfo() != null) {
            try {
                prmt.getEntityViewInfo().getFilter().mergeFilter(filter, "and");
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        } else {
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(filter);
            prmt.setEntityViewInfo(view);
        }
    }

    public static void filterCompanyOrgForPeriod(KDBizPromptBox prmt, CompanyOrgUnitInfo orgInfo) {
        if (orgInfo == null) {
            throw new IllegalArgumentException("CompanyOrgUnit is NULL !");
        }
        BDClientUtils.filterCompanyOrgForPeriod(prmt, orgInfo.getAccountPeriodType().getId().toString());
    }

    public static OrgUnitInfo getBizOrgUnitInfo(String addNewPermItemName, OrgType orgType, Context mainOrgContext) {
        if (addNewPermItemName == null || mainOrgContext == null) {
            return null;
        }
        OrgUnitInfo orgUnitInfo = (OrgUnitInfo)mainOrgContext.get((Object)orgType);
        OrgUnitInfo retOrgUnitInfo = null;
        retOrgUnitInfo = BDClientUtils.getBizOrgUnit(SysContext.getSysContext().getCurrentUserInfo(), orgType, addNewPermItemName, orgUnitInfo);
        return retOrgUnitInfo;
    }

    public static OrgUnitInfo getBizOrgUnit(UserInfo userInfo, OrgType orgType, String permissionItem, OrgUnitInfo orgUnitInfo) {
        if (orgUnitInfo == null) {
            return null;
        }
        OrgUnitInfo bizSaleOrgUnitInfo = null;
        if (orgUnitInfo.getBoolean("isBizUnit")) {
            bizSaleOrgUnitInfo = orgUnitInfo;
        } else {
            try {
                OrgUnitInfo[] mainOrgs = null;
                FullOrgUnitCollection collection = BDClientUtils.getAuthOrgByPermItem((IObjectPK)new ObjectStringPK(userInfo.getId().toString()), orgType, permissionItem);
                mainOrgs = SCMGroupClientUtils.getOrgUnitInfosByType((FullOrgUnitCollection)collection, (OrgType)orgType);
                if (mainOrgs == null) {
                    mainOrgs = new OrgUnitInfo[]{};
                    return null;
                }
                if (mainOrgs.length > 0) {
                    mainOrgs = (OrgUnitInfo[])BDClientUtils.sortDataByNumber((DataBaseInfo[])mainOrgs, true);
                }
                bizSaleOrgUnitInfo = mainOrgs[0];
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return bizSaleOrgUnitInfo;
    }

    public static DataBaseInfo[] sortDataByNumber(DataBaseInfo[] datas, boolean isAsc) {
        if (datas == null || datas.length < 2) {
            return datas;
        }
        class DataCompare
        implements Compare {
            private boolean isAsc = true;

            public DataCompare(boolean isAsc) {
                this.isAsc = isAsc;
            }

            public int doCompare(Object arg0, Object arg1) {
                return this.isAsc ? ((DataBaseInfo)arg0).getNumber().compareTo(((DataBaseInfo)arg1).getNumber()) : ((DataBaseInfo)arg1).getNumber().compareTo(((DataBaseInfo)arg0).getNumber());
            }
        }
        Sort.quicksort((Object[])datas, (Compare)new DataCompare(isAsc));
        return datas;
    }

    public static FullOrgUnitCollection getAuthOrgByPermItem(IObjectPK user, OrgType orgType, String permItem) throws BOSException, EASBizException {
        FullOrgUnitCollection result = null;
        IPermission permission = PermissionFactory.getRemoteInstance();
        CtrlUnitInfo cu = SysContext.getSysContext().getCurrentCtrlUnit();
        ObjectUuidPK cuPk = null;
        if (cu != null) {
            cuPk = new ObjectUuidPK(cu.getId());
        }
        result = permission.getAuthorizedOrgOfIncludeSubCU((IObjectPK)cuPk, user, orgType, null, permItem);
        return result;
    }

    public static String[] getSelectRowFieldValue(KDTable kdtTable, String fieldname) {
        if (!BDClientUtils.isSelectRow(kdtTable)) {
            return null;
        }
        KDTSelectManager sm = kdtTable.getSelectManager();
        int blockCount = sm.size();
        int keyField = kdtTable.getColumnIndex(fieldname);
        ArrayList<String> retList = new ArrayList<String>();
        Object value = null;
        for (int i = 0; i < blockCount; ++i) {
            KDTSelectBlock block = sm.get(i);
            int bottom = block.getBottom();
            for (int j = block.getTop(); j <= bottom; ++j) {
                IRow row = kdtTable.getRow(j);
                value = row.getCell(keyField).getValue();
                if (value == null || value.toString().trim().length() == 0) continue;
                String retStr = value.toString();
                retList.add(retStr);
            }
        }
        retList.trimToSize();
        if (retList.size() == 0) {
            return null;
        }
        String[] retStrs = new String[retList.size()];
        retStrs = retList.toArray(retStrs);
        return retStrs;
    }

    public static boolean isSelectRow(KDTable kdtTable) {
        KDTSelectManager sm = kdtTable.getSelectManager();
        return sm.size() > 0;
    }
}

