/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.framework;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.IBOSObject;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.framework.ControlTypeUtilCommon;
import com.kingdee.eas.basedata.framework.DataBaseDException;
import com.kingdee.eas.basedata.framework.IDataBaseD;
import com.kingdee.eas.basedata.framework.IOrgDataBaseDInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;

public class DataBaseDUtil {
    private static final String ADMIN_ENTITY = "com.kingdee.eas.basedata.org.app.AdminOrgUnit";
    private static final String COMPANY_ENTITY = "com.kingdee.eas.basedata.org.app.CompanyOrgUnit";
    private static final String SALE_ENTITY = "com.kingdee.eas.basedata.org.app.SaleOrgUnit";
    private static final String PURCHASE_ENTITY = "com.kingdee.eas.basedata.org.app.PurchaseOrgUnit";
    private static final String STORAGE_ENTITY = "com.kingdee.eas.basedata.org.app.StorageOrgUnit";
    private static final String COST_ENTITY = "com.kingdee.eas.basedata.org.app.CostCenterOrgUnit";
    private static final String PROFIT_ENTITY = "com.kingdee.eas.basedata.org.app.ProfitCenterOrgUnit";
    private static final String UNION_ENTITY = "com.kingdee.eas.basedata.org.app.UnionGroupOrgUnit";
    private static final String CU_ENTITY = "com.kingdee.eas.basedata.org.app.CtrlUnit";

    public static String getOrgPropertyName(EntityObjectInfo entity) throws EASBizException {
        String className = entity.getObjectValueClass();
        IOrgDataBaseDInfo orgDataBaseDInfo = null;
        try {
            Class<?> valueClass = Class.forName(className);
            orgDataBaseDInfo = (IOrgDataBaseDInfo)valueClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new DataBaseDException(DataBaseDException.GET_ORGDATABASEDINFO_FAIL);
        }
        catch (InstantiationException e) {
            throw new DataBaseDException(DataBaseDException.GET_ORGDATABASEDINFO_FAIL);
        }
        catch (IllegalAccessException e) {
            throw new DataBaseDException(DataBaseDException.GET_ORGDATABASEDINFO_FAIL);
        }
        return orgDataBaseDInfo.getOrgPropertyName();
    }

    public static OrgType getOrgType(EntityObjectInfo entity) throws EASBizException {
        String orgPropertyName = DataBaseDUtil.getOrgPropertyName(entity);
        LinkPropertyInfo orgPropertyInfo = (LinkPropertyInfo)entity.getPropertyByName(orgPropertyName, true);
        String orgEntityName = orgPropertyInfo.getRelationship().getSupplierObject().getFullName();
        if (ADMIN_ENTITY.equals(orgEntityName)) {
            return OrgType.Admin;
        }
        if (COMPANY_ENTITY.equals(orgEntityName)) {
            return OrgType.Company;
        }
        if (SALE_ENTITY.equals(orgEntityName)) {
            return OrgType.Sale;
        }
        if (PURCHASE_ENTITY.equals(orgEntityName)) {
            return OrgType.Purchase;
        }
        if (STORAGE_ENTITY.equals(orgEntityName)) {
            return OrgType.Admin;
        }
        if (COST_ENTITY.equals(orgEntityName)) {
            return OrgType.CostCenter;
        }
        if (PROFIT_ENTITY.equals(orgEntityName)) {
            return OrgType.ProfitCenter;
        }
        if (UNION_ENTITY.equals(orgEntityName)) {
            return OrgType.UnionDebt;
        }
        if (CU_ENTITY.equals(orgEntityName)) {
            return OrgType.ControlUnit;
        }
        throw new IllegalArgumentException(" orgInfo is error.");
    }

    public static boolean isMatchOrgType(FullOrgUnitInfo assignCU, OrgType orgType) {
        if (OrgType.Admin.equals((Object)orgType)) {
            return assignCU.isIsAdminOrgUnit();
        }
        if (OrgType.Admin.equals((Object)orgType)) {
            return assignCU.isIsCompanyOrgUnit();
        }
        if (OrgType.Sale.equals((Object)orgType)) {
            return assignCU.isIsSaleOrgUnit();
        }
        if (OrgType.Purchase.equals((Object)orgType)) {
            return assignCU.isIsPurchaseOrgUnit();
        }
        if (OrgType.Storage.equals((Object)orgType)) {
            return assignCU.isIsStorageOrgUnit();
        }
        if (OrgType.CostCenter.equals((Object)orgType)) {
            return assignCU.isIsCostOrgUnit();
        }
        if (OrgType.ProfitCenter.equals((Object)orgType)) {
            return assignCU.isIsProfitOrgUnit();
        }
        if (OrgType.UnionDebt.equals((Object)orgType)) {
            return assignCU.isIsUnion();
        }
        if (OrgType.ControlUnit.equals((Object)orgType)) {
            return assignCU.isIsCU();
        }
        return false;
    }

    public static FilterInfo getDatabaseDFilter(Context ctx, BOSObjectType bosType, IObjectPK[] ctrlUnitPKs, String idFieldName, String adminCUFieldName) throws BOSException, EASBizException {
        IBOSObject ibo;
        if (ctx == null) {
            Class<?> model;
            String businessInterface = ControlTypeUtilCommon.getBusinessInterface(ctx, bosType);
            try {
                model = Class.forName(businessInterface);
            }
            catch (ClassNotFoundException e) {
                throw new BOSException("can't find " + businessInterface, (Throwable)e);
            }
            ibo = BOSObjectFactory.createRemoteBOSObject((BOSObjectType)bosType, model);
        } else {
            ibo = BOSObjectFactory.getLocalBOSObjectFactory((Context)ctx).createBOSObject(bosType);
        }
        IDataBaseD idbd = (IDataBaseD)ibo;
        return idbd.getDatabaseDFilter(ctrlUnitPKs, idFieldName, adminCUFieldName);
    }
}

