/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.framework.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.basedata.framework.client.IBatchProcess;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.util.ExceptionMessageUtility;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class ClientBatchProcess
implements IBatchProcess {
    public static final String RES = "com.kingdee.eas.basedata.framework.DataBaseDResources";
    private ListUI ui;
    private ItemAction action;
    private KDTable table;
    private String keyField;
    private String dispField;

    public ClientBatchProcess() {
        this.keyField = "id";
        this.dispField = "name";
    }

    public ClientBatchProcess(ListUI ui, ItemAction action, KDTable table, String keyField, String dispField) {
        this.ui = ui;
        this.action = action;
        this.table = table;
        this.keyField = keyField;
        this.dispField = dispField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.checkSelected(this.table);
        List rows = this.getSelectedRows(this.table, this.keyField);
        int size = rows.size();
        ArrayList<String> errorMsg = new ArrayList<String>();
        IRow row = null;
        for (int i = 0; i < size; ++i) {
            row = (IRow)rows.get(i);
            try {
                this.doProcess(row);
                continue;
            }
            catch (Exception exp) {
                String msg = ExceptionMessageUtility.getMessage((Throwable)exp);
                String[] disps = this.dispField.split("[+]");
                String name = "";
                for (int k = 0; k < disps.length; ++k) {
                    name = name + row.getCell(disps[k]).getValue();
                }
                errorMsg.add(name + msg);
                continue;
            }
            finally {
                System.out.println(i + "/" + size);
            }
        }
        if (errorMsg.size() == 0) {
            ClientBatchProcess.showSuccessMessage((CoreUI)this.ui, this.action, size);
        } else if (errorMsg.size() == 1 && size == 1) {
            StringBuffer errorDetail = new StringBuffer();
            for (int i = 0; i < errorMsg.size(); ++i) {
                errorDetail.append(errorMsg.get(i));
                errorDetail.append("\n");
            }
            MsgBox.showError((Component)this.ui, (String)errorDetail.toString());
        } else {
            String msg = MessageFormat.format(EASResource.getString((String)RES, (String)"errorTitle"), this.action.getValue("Name"), new Integer(size - errorMsg.size()), new Integer(errorMsg.size()));
            StringBuffer errorDetail = new StringBuffer();
            for (int i = 0; i < errorMsg.size(); ++i) {
                errorDetail.append(errorMsg.get(i));
                errorDetail.append("\n");
            }
            MsgBox.showDetailAndOK((Component)this.ui, (String)msg, (String)errorDetail.toString(), (int)8188);
        }
        if (size - errorMsg.size() > 0) {
            this.doOKfinish();
        }
    }

    @Override
    public void doOKfinish() {
        int top = this.table.getSelectManager().get(0).getTop();
        this.table.refresh();
        this.table.getSelectManager().select(top, -1);
    }

    public static void showSuccessMessage(CoreUI ui, ItemAction action, int successCounts) {
        String msg = MessageFormat.format(EASResource.getString((String)RES, (String)"successCounts"), action.getValue("Name"), new Integer(successCounts));
        ui.setMessageText(msg);
        ui.showMessage();
    }

    protected List getSelectedRows(KDTable tblMain, String keyField) {
        ArrayList<IRow> rows = new ArrayList<IRow>();
        KDTSelectBlock selectBlock = null;
        int size = tblMain.getSelectManager().size();
        HashSet<Object> set = new HashSet<Object>();
        for (int i = 0; i < size; ++i) {
            selectBlock = tblMain.getSelectManager().get(i);
            for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
                IRow row = tblMain.getRow(j);
                Object key = row.getCell(keyField).getValue();
                if (set.contains(key)) continue;
                set.add(key);
                rows.add(row);
            }
        }
        return rows;
    }

    protected void checkSelected(KDTable tblMain) {
        if (tblMain.getRowCount() == 0 || tblMain.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)this.ui, (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    @Override
    public void doProcess(IRow row) throws Exception {
    }

    public String getKeyField() {
        return this.keyField;
    }

    public void setKeyField(String keyField) {
        this.keyField = keyField;
    }

    public String getDispField() {
        return this.dispField;
    }

    public void setDispField(String dispField) {
        this.dispField = dispField;
    }

    public ItemAction getAction() {
        return this.action;
    }

    public void setAction(ItemAction action) {
        this.action = action;
    }

    public KDTable getTable() {
        return this.table;
    }

    public void setTable(KDTable table) {
        this.table = table;
    }

    public ListUI getUi() {
        return this.ui;
    }

    public void setUi(ListUI ui) {
        this.ui = ui;
    }
}

